/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.business;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.form.FormDataModel;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportService {
    private static final Log LOGGER = LogFactory.getLog(ImportService.class);

    public static void addRow(JSONObject importData, ImportBillData billData, Map<String, Map<String, Object>> comboItems, EntryImportContext importContext) {
        IDataModel model = importContext.getFormView().getModel();
        String entryKey = importContext.getEntryKey();
        int rowNumber = model.createNewEntryRow(entryKey);
        for (Map.Entry<String, IDataEntityProperty> next : importContext.getEntryAllFields().entrySet()) {
            IDataEntityProperty field = next.getValue();
            Object val = ImportService.getFieldValue(next.getKey(), comboItems, importData, field, billData, importContext);
            if (field instanceof LargeTextProp) {
                Map result = (Map)val;
                if (result == null) continue;
                result.entrySet().forEach(item -> model.setValue((String)item.getKey(), item.getValue(), rowNumber));
                continue;
            }
            if (val == null) continue;
            if (field instanceof DateTimeProp) {
                try {
                    val = HIESUtil.tranImptDateTimeProp((Object)val, (IDataEntityProperty)field, (DynamicObject)model.getDataEntity());
                }
                catch (ParseException e) {
                    LOGGER.error("tranImptDateTimeProp_key:" + next.getKey(), (Throwable)e);
                }
            }
            model.setValue(next.getKey(), val, rowNumber);
        }
        DynamicObject entryEntity = null;
        entryEntity = model instanceof FormDataModel ? ((FormDataModel)model).getEntryEntity(entryKey, rowNumber) : ((BillModel)model).getEntryEntity(entryKey, rowNumber);
        entryEntity.getDataEntityState().setBizChanged(true);
        entryEntity.getDataEntityState().setBizChangeFlags(new long[]{1L});
    }

    public static void updateRow(List<DynamicObject> updateDynObjs, JSONObject importData, EntryImportContext importContext, ImportBillData billData, Map<String, Map<String, Object>> comboItems) {
        IDataModel model = importContext.getFormView().getModel();
        updateDynObjs.forEach(updateDynObj -> {
            int rowNumber = updateDynObj.getInt("seq") - 1;
            for (Map.Entry<String, IDataEntityProperty> next : importContext.getEntryAllFields().entrySet()) {
                IDataEntityProperty field = next.getValue();
                Object val = ImportService.getFieldValue(next.getKey(), comboItems, importData, field, billData, importContext);
                if (!ObjectUtils.isEmpty((Object)val)) {
                    if (field instanceof LargeTextProp) {
                        Map result = (Map)val;
                        if (result == null) continue;
                        result.entrySet().forEach(item -> model.setValue((String)item.getKey(), item.getValue(), rowNumber));
                        continue;
                    }
                    if (field instanceof DateTimeProp) {
                        try {
                            val = HIESUtil.tranImptDateTimeProp((Object)val, (IDataEntityProperty)field, (DynamicObject)model.getDataEntity());
                        }
                        catch (ParseException e) {
                            LOGGER.error("tranImptDateTimeProp_key:" + next.getKey(), (Throwable)e);
                        }
                    }
                    model.setValue(next.getKey(), val, rowNumber);
                    continue;
                }
                if (!importData.containsKey((Object)next.getKey())) continue;
                model.setValue(next.getKey(), null, rowNumber);
            }
        });
    }

    private static Object getFieldValue(String fieldName, Map<String, Map<String, Object>> comboItems, JSONObject importData, IDataEntityProperty field, ImportBillData billData, EntryImportContext importContext) {
        Object fieldData = importData.get((Object)fieldName);
        if (fieldData == null) {
            if (field instanceof TimeProp) {
                return "-1";
            }
            return null;
        }
        Object returnVal = null;
        if (field instanceof ComboProp) {
            if (!comboItems.isEmpty() && comboItems.containsKey(field.getName())) {
                Map<String, Object> fieldVal = comboItems.get(field.getName());
                String comboVal = fieldData.toString();
                if (comboVal.contains("\uff0c")) {
                    List<String> list = ImportService.getComboValue(fieldVal, comboVal, "\uff0c", billData, fieldName, importContext);
                    returnVal = String.join((CharSequence)",", list);
                } else if (comboVal.contains(",")) {
                    List<String> list = ImportService.getComboValue(fieldVal, comboVal, ",", billData, fieldName, importContext);
                    returnVal = String.join((CharSequence)",", list);
                } else {
                    returnVal = fieldVal.get(fieldData);
                    if (ObjectUtils.isEmpty((Object)returnVal)) {
                        String cell = importContext.getCellIndexOfEntities().get(fieldName);
                        String msg = String.format(ResManager.loadKDString((String)"%1$s\u5217\u503c%2$s\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)HiesEntryRes.EntryImportStarter_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), cell, fieldData);
                        importContext.getImportLog().writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), msg);
                    }
                }
            }
        } else if (field instanceof MulBasedataProp) {
            Object[] objArray;
            returnVal = objArray = ((JSONArray)fieldData).stream().filter(ele -> ((JSONObject)ele).containsKey((Object)"id")).map(ele -> ((JSONObject)ele).get((Object)"id")).collect(Collectors.toList()).toArray();
        } else if (field instanceof BasedataProp) {
            returnVal = ((JSONObject)fieldData).get((Object)"id");
        } else if (field instanceof RefBillProp) {
            returnVal = ((JSONObject)fieldData).get((Object)"id");
        } else if (field instanceof TimeProp) {
            LocalTime localTime = (LocalTime)fieldData;
            returnVal = localTime.getHour() * 60 * 60 + localTime.getMinute() * 60 + localTime.getSecond();
        } else if (field instanceof LargeTextProp) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            result.put(fieldName, fieldData);
            Object fieldDataTag = importData.get((Object)(fieldName + "_tag"));
            result.put(fieldName + "_tag", fieldDataTag);
            returnVal = result;
        } else if (field instanceof AdminDivisionProp) {
            String temp = (String)fieldData;
            String[] split = StringUtils.split((String)temp, (String)"##");
            if (split.length == 2) {
                returnVal = split[1];
            }
        } else {
            returnVal = fieldData;
        }
        return returnVal;
    }

    public static List<String> getComboValue(Map<String, Object> fieldVal, String comboVal, String dot, ImportBillData billData, String fieldName, EntryImportContext importContext) {
        String[] split;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)fieldVal.size());
        for (String str : split = comboVal.split(dot)) {
            String val = (String)fieldVal.get(str);
            if (Objects.nonNull(val)) {
                list.add(val);
                continue;
            }
            String cell = importContext.getCellIndexOfEntities().get(fieldName);
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5217\u503c%2$s\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)HiesEntryRes.EntryImportStarter_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), cell, str);
            importContext.getImportLog().writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), msg);
        }
        return list;
    }
}

