/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.business.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.microsoft.schemas.vml.CTShape;
import com.microsoft.schemas.vml.CTTextbox;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IExportEntryPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.business.export.F7BdWriteFormat;
import kd.hr.hies.business.impt.GenImportTplHeaderWriter;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.SensitiveFiledUtil;
import kd.hr.impt.business.template.ExcelTemplateGenerate;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.template.EntryExcelGenerateHelper;
import kd.hrmp.hies.entry.business.template.ExcelWriter;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.dto.FieldHeaderWriterFormat;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.EntryBaseAfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.EntryBaseBeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.BeforeWriteDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.UserEntryExportPluginEngine;
import kd.hrmp.hies.entry.common.plugin.impt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.core.init.EntryExportContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class EntryExcelCurrentTplGenerator
extends ExcelWriter {
    private static final Log LOGGER = LogFactory.getLog(EntryExcelCurrentTplGenerator.class);
    private IFormView parentView;
    private SXSSFSheet sheet;
    private SXSSFSheet dropdownSheet;
    private List<KeyValue> fieldCaptions;
    private String fileName;
    private IHRAppCache cache;
    private EntryExportContext entryExportContext;
    private ExportSheetStyle exportSheetStyle;
    private String entryKey;
    private String entityId;
    private String entryName;
    private String appIdPkid;
    private Map<String, IDataEntityProperty> fields;
    private FieldControlRules fieldControlRules;
    private SensitiveArgs sensitiveArgs;
    private Map<String, Object> mapParam;
    private HasPermOrgResult hasPermOrg;
    private DynamicObject sysparam;
    private int maxShowNum;
    private int rowNum = 0;
    private int rowCount = 0;

    public EntryExcelCurrentTplGenerator(String entryName, List<KeyValue> fieldCaptions, int startRowNun, boolean forList, String entityId, String fileName, IFormView parentView, String appId) {
        if (!forList) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u6682\u65f6\u4e0d\u652f\u6301\u878d\u5408\u5217\u5bfc\u51fa\u3002", (String)HiesEntryRes.EntryExcelCurrentTplGenerator_0.resId(), (String)"bos-export", (Object[])new Object[0]));
        }
        String sheetName = HIESUtil.getLegalSheetName((String)entryName, null);
        this.parentView = parentView;
        this.sheet = this.wb.createSheet(sheetName);
        this.entryName = entryName;
        this.entityId = entityId;
        this.appIdPkid = DataValidateServiceHelper.getPermAppIdPkid((String)appId, (String)entityId, (boolean)true);
        this.dropdownSheet = this.wb.createSheet(sheetName + "DDM");
        this.fieldCaptions = fieldCaptions;
        this.rowNum = startRowNun;
        this.fileName = fileName;
        this.cache = HRAppCache.get((String)"hies");
        this.sysparam = ExportEntryDataHelper.getSysparam();
        this.maxShowNum = this.sysparam.getInt("maxshownum");
        this.fieldControlRules = SensitiveFiledUtil.getFieldControlRulesByForm((String)this.appIdPkid, (String)entityId);
        this.sensitiveArgs = new SensitiveArgs((Object)this);
    }

    private static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (StringUtils.isBlank((CharSequence)tip)) {
            return;
        }
        SXSSFDrawing pp = sheet.createDrawingPatriarch();
        Comment comment = pp.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, colSeq, rowSeq, colSeq, rowSeq));
        comment.setString((RichTextString)new XSSFRichTextString(tip));
        cell.setCellComment(comment);
        XSSFVMLDrawing vmlDrawing = sheet.getVMLDrawing(false);
        CTShape commentShape = vmlDrawing.findCommentShape(rowSeq, colSeq);
        CTTextbox textBox = commentShape.getTextboxArray()[0];
        textBox.setStyle(textBox.getStyle() + ";mso-fit-shape-to-text:t");
    }

    public SXSSFWorkbook getWb() {
        return this.wb;
    }

    public HasPermOrgResult getHasPermOrg() {
        return this.hasPermOrg;
    }

    public void setHasPermOrg(HasPermOrgResult hasPermOrg) {
        this.hasPermOrg = hasPermOrg;
    }

    public Map<String, Object> getMapParam() {
        return this.mapParam;
    }

    public void setMapParam(Map<String, Object> mapParam) {
        this.mapParam = mapParam;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public SXSSFSheet getSheet() {
        return this.sheet;
    }

    public ExportSheetStyle getExportSheetStyle() {
        return this.exportSheetStyle;
    }

    public void setExportSheetStyle(ExportSheetStyle exportSheetStyle) {
        this.exportSheetStyle = exportSheetStyle;
    }

    public EntryExportContext getEntryExpStarter() {
        return this.entryExportContext;
    }

    public void setEntryExpStarter(EntryExportContext entryExportContext) {
        this.entryExportContext = entryExportContext;
    }

    public Map<String, Object> genExportExcel(String entryKey, Map<String, Object> customParams, IFormView view) throws Exception {
        try {
            return this.generateExportExcelFile(entryKey, customParams, view);
        }
        catch (Throwable e) {
            this.wb.dispose();
            throw e;
        }
    }

    private Map<String, Object> generateExportExcelFile(String entryKey, Map<String, Object> customParams, IFormView view) throws Exception {
        this.initFields();
        this.genHeader(entryKey, customParams, null, view);
        this.setDropdownSheet(this.entryExportContext.getDefaultBaseinfoformat(), this.entryExportContext.getF7formatCfg(), view, "current");
        int startIndex = 0;
        int total = view.getModel().getEntryRowCount(entryKey);
        int row = 0;
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        if (grid.getEntryState().getSelectedRows().length > 0) {
            row = grid.getEntryState().getSelectedRows().length;
        }
        DynamicObject[] entryEntity = null;
        if (row > 0 && row <= total) {
            DynamicObject[] data = grid.getEntryData().getDataEntitys();
            int[] sel = grid.getEntryState().getSelectedRows();
            ArrayList lst = Lists.newArrayListWithExpectedSize((int)sel.length);
            for (int idx : sel) {
                DynamicObject dy = data[idx];
                lst.add(dy);
            }
            entryEntity = lst.toArray(new DynamicObject[0]);
        } else {
            entryEntity = view.getModel().getEntryEntity(entryKey, startIndex, row);
        }
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>(2);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(entryEntity.length);
        int totalCount = entryEntity.length;
        for (int idx = 0; idx < entryEntity.length; ++idx) {
            ++this.rowNum;
            DynamicObject obj = entryEntity[idx];
            HashMap rowMap = Maps.newHashMapWithExpectedSize((int)this.fields.size());
            rowMap.put("obj", obj);
            rowMap.put("rowNum", this.rowNum);
            String taskCachePath1 = MethodUtil.getTaskCachePath((String)this.entryExportContext.getTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"status");
            String status = (String)this.cache.get(taskCachePath1, String.class);
            if (HRStringUtils.equals((String)"stop", (String)status)) break;
            if (idx % 20 == 0) {
                int progress = idx * 100 / totalCount;
                statusMap.put("progress", progress);
                String taskCachePath = MethodUtil.getTaskCachePath((String)this.entryExportContext.getTaskId(), (String)ImportCacheKeyType.EXPORT, (String)"processing");
                this.cache.put(taskCachePath, statusMap);
            }
            DataEntityPropertyCollection properties = obj.getDynamicObjectType().getProperties();
            HashMap cellsMap = Maps.newHashMapWithExpectedSize((int)this.fields.size());
            for (int i = 0; i < this.fieldCaptions.size(); ++i) {
                KeyValue colInfo = this.fieldCaptions.get(i);
                if (colInfo.value instanceof KeyValue) {
                    List level2KeyValue = (List)((KeyValue)colInfo.value).value;
                    for (KeyValue level2Kv : level2KeyValue) {
                        Object value = level2Kv.value;
                        if (value instanceof KeyValue) {
                            List level3KeyValue = (List)((KeyValue)value).value;
                            for (KeyValue level3Kv : level3KeyValue) {
                                Map<String, Object> convertData = EntryExcelGenerateHelper.convertData(obj, level3Kv.key, level3Kv.seq, properties, this.exportSheetStyle, this.fieldControlRules, this.sensitiveArgs, this.entityId, this.entryExportContext);
                                cellsMap.put(level3Kv.key, convertData);
                            }
                            continue;
                        }
                        Map<String, Object> convertData = EntryExcelGenerateHelper.convertData(obj, level2Kv.key, level2Kv.seq, properties, this.exportSheetStyle, this.fieldControlRules, this.sensitiveArgs, this.entityId, this.entryExportContext);
                        cellsMap.put(level2Kv.key, convertData);
                    }
                    continue;
                }
                Map<String, Object> convertData = EntryExcelGenerateHelper.convertData(obj, colInfo.key, colInfo.seq, properties, this.exportSheetStyle, this.fieldControlRules, this.sensitiveArgs, this.entityId, this.entryExportContext);
                cellsMap.put(colInfo.key, convertData);
            }
            rowMap.put("cells", cellsMap);
            rows.add(rowMap);
        }
        BeforeWriteDataEventArgs args = new BeforeWriteDataEventArgs(this.entryExportContext);
        args.setRows(rows);
        UserEntryExportPluginEngine.fireUserPluginEvent(this.entryExportContext, "beforeWriteData", (EntryAbstractEventArgs)args);
        rows.forEach(row0 -> {
            Integer rowNum = (Integer)row0.get("rowNum");
            SXSSFRow erow = EntryExcelCurrentTplGenerator.getRow(this.sheet, rowNum);
            Map cellsMap = (Map)row0.get("cells");
            cellsMap.values().forEach(cells -> this.writeDataCell(erow, (Map)cells));
        });
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        this.wb.setSheetHidden(this.wb.getSheetIndex((Sheet)this.dropdownSheet), true);
        CTWorksheet ctSheet = this.wb.getXSSFWorkbook().getSheet(this.sheet.getSheetName()).getCTWorksheet();
        this.processDisplayBdSheets(this.getEntryExpStarter().getDisplayBdSheets());
        ctSheet.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel((int)EntryExcelGenerateHelper.statisticsColumnCount(this.fieldCaptions)) + this.sheet.getPhysicalNumberOfRows());
        String url = this.saveExcelFile(this.fileName, this.entryExportContext.getRc());
        result.put("total", totalCount);
        result.put("url", url);
        return result;
    }

    public String generateEntryImportExcelTemplate(String entryKey, Map<String, Object> customParams, IFormView parentView, IExportEntryPlugin plugin, String defaultBaseinfoformat, Set<String> displayBdSheets, Map<String, String> f7formatCfg) throws IOException {
        this.initFields();
        this.genHeader(entryKey, customParams, plugin, parentView);
        this.setDropdownSheet(defaultBaseinfoformat, f7formatCfg, parentView, "current");
        this.wb.setSheetHidden(this.wb.getSheetIndex((Sheet)this.dropdownSheet), true);
        CTWorksheet ctSheet = this.wb.getXSSFWorkbook().getSheet(this.sheet.getSheetName()).getCTWorksheet();
        this.processDisplayBdSheets(displayBdSheets);
        ctSheet.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel((int)EntryExcelGenerateHelper.statisticsColumnCount(this.fieldCaptions)) + this.sheet.getPhysicalNumberOfRows());
        return this.saveExcelFile(this.fileName, this.entryExportContext.getRc());
    }

    private void processDisplayBdSheets(Set<String> displayBdSheets) {
        if (ObjectUtils.isEmpty(displayBdSheets)) {
            return;
        }
        for (String fieldStr : displayBdSheets) {
            IDataEntityProperty property = this.fields.get(fieldStr);
            if (!(property instanceof BasedataProp) || property instanceof ItemClassProp) continue;
            BasedataProp baseProp = (BasedataProp)property;
            F7BdWriteFormat f7BdWriteFormat = new F7BdWriteFormat();
            f7BdWriteFormat.setSheetName(baseProp.getDisplayName().getLocaleValue());
            f7BdWriteFormat.setNumber(baseProp.getName());
            f7BdWriteFormat.setBaseEntityId(baseProp.getBaseEntityId());
            Map propText = MethodUtil.getBdNumberNameText((IDataEntityProperty)baseProp);
            f7BdWriteFormat.setHeadNameText((String)propText.get("name"));
            f7BdWriteFormat.setHeadNumberText((String)propText.get("number"));
            this.buildBaseDataForSheet(baseProp.getBaseEntityId(), (IDataEntityProperty)baseProp, this.mapParam, this.hasPermOrg, f7BdWriteFormat, this.parentView, "current");
            GenImportTplHeaderWriter.writeHeaderForBaseDataF7((SXSSFWorkbook)this.wb, (String)"", (F7BdWriteFormat)f7BdWriteFormat, (ExportSheetStyle)this.exportSheetStyle);
        }
    }

    private void buildBaseDataForSheet(String baseEntityId, IDataEntityProperty prop, Map<String, Object> mapParam, HasPermOrgResult hasPermOrg, F7BdWriteFormat f7BdWriteFormat, IFormView view, String tplType) {
        DynamicObject[] dynamicObjects;
        EntryBaseBeforeQueryRefBdEventArgs args;
        QFilter f7BdCondQFilter;
        String numberField;
        Map bdMainProp = MethodUtil.getBdMainProp((String)baseEntityId);
        String source = (String)mapParam.get("source");
        String extParam = (String)mapParam.get("extParam");
        String nameField = null;
        boolean isHrPersonField = false;
        if (prop instanceof IQueryProp) {
            isHrPersonField = true;
            Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)baseEntityId);
            nameField = (String)hrPersonMainProp.get("name");
            numberField = (String)hrPersonMainProp.get("number");
        } else {
            nameField = (String)bdMainProp.get("name");
            numberField = (String)bdMainProp.get("number");
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityId);
        HashSet<String> fields = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)nameField)) {
            fields.add(nameField);
        }
        if (StringUtils.isNotEmpty((CharSequence)numberField)) {
            fields.add(numberField);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("1", "=", (Object)1));
        QFilter f7BdAuthQFilter = DataValidateServiceHelper.getF7BdQFilter((String)this.entityId, (String)this.appIdPkid, (IDataEntityProperty)prop, (HasPermOrgResult)hasPermOrg, (Map)bdMainProp);
        if (!ObjectUtils.isEmpty((Object)f7BdAuthQFilter)) {
            qFilterList.add(f7BdAuthQFilter);
        }
        if (!ObjectUtils.isEmpty((Object)(f7BdCondQFilter = MethodUtil.getF7BdCondQFilter((String)this.entityId, (IDataEntityProperty)prop)))) {
            qFilterList.add(f7BdCondQFilter);
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        List userPlugins = (List)mapParam.get("userPlugins");
        if (OprType.EXPORT.getValue().equalsIgnoreCase(source)) {
            args = new kd.hrmp.hies.entry.common.plugin.expt.BeforeQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args.setBaseDataName(baseEntityId);
            args.setFieldId(prop.getName());
            args.setFilters(qFilters);
            args.setSelectFields(fields);
            args.setSource("sheetList");
            UserEntryExportPluginEngine.fireUserPluginEvent(userPlugins, "beforeQueryRefBd", (EntryAbstractEventArgs)args);
        } else {
            args = new BeforeQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args.setBaseDataName(baseEntityId);
            args.setFieldId(prop.getName());
            args.setFilters(qFilters);
            args.setSelectFields(fields);
            args.setSource("sheetList");
            HREntryImpPluginEngine.fireImptPluginEvent(userPlugins, "beforeQueryRefBd", (EntryAbstractEventArgs)args);
        }
        String selectFields = String.join((CharSequence)",", fields);
        MethodUtil.printQfilters((QFilter[])qFilters, (String)("getBaseDataFromDB_" + baseEntityId + "_filter"));
        LOGGER.info("buildBaseDataForSheet.selectFields:{} ", (Object)selectFields);
        int count = helper.count(baseEntityId, qFilters);
        if (StringUtils.isNotEmpty((CharSequence)selectFields)) {
            DynamicObjectCollection collection;
            String orderBys = args.getOrderbys();
            if (count > 10000) {
                if (StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(".")) {
                    Set clearMultLevelOrderBys = Arrays.stream(orderBys.split(",")).filter(item -> !item.contains(".")).collect(Collectors.toSet());
                    orderBys = String.join((CharSequence)",", clearMultLevelOrderBys);
                    args.setOrderbys(orderBys);
                }
                collection = QueryServiceHelper.query((String)helper.getEntityName(), (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)100000);
                dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
            } else if (StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(".")) {
                dynamicObjects = helper.query(selectFields, qFilters, orderBys);
            } else {
                collection = helper.queryOriginalCollection(selectFields, qFilters, orderBys);
                dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
            }
        } else {
            dynamicObjects = (DynamicObject[])new DynamicObjectCollection().toArray((Object[])new DynamicObject[0]);
        }
        LOGGER.info("buildBaseDataForSheet.baseEntityId:{} count:{}", (Object)baseEntityId, (Object)dynamicObjects.length);
        EntryBaseAfterQueryRefBdEventArgs args2 = null;
        if (OprType.EXPORT.getValue().equalsIgnoreCase(source)) {
            args2 = new kd.hrmp.hies.entry.common.plugin.expt.AfterQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args2.setBaseDataName(baseEntityId);
            args2.setDatas(dynamicObjects);
            args2.setSource("sheetList");
            UserEntryExportPluginEngine.fireUserPluginEvent(userPlugins, "AfterQueryRefBd", (EntryAbstractEventArgs)args2);
        } else {
            args2 = new AfterQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args2.setBaseDataName(baseEntityId);
            args2.setDatas(dynamicObjects);
            args2.setSource("sheetList");
            HREntryImpPluginEngine.fireImptPluginEvent(userPlugins, "AfterQueryRefBd", (EntryAbstractEventArgs)args2);
        }
        if (args2 != null) {
            dynamicObjects = args2.getDatas();
        }
        if (dynamicObjects == null) {
            dynamicObjects = new DynamicObject[]{};
        }
        ArrayList<String> numbers = new ArrayList<String>(dynamicObjects.length);
        ArrayList<String> names = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject item2 : dynamicObjects) {
            String numberValue = "";
            String nameValue = "";
            if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                numberValue = item2.getString(numberField);
            }
            if (StringUtils.isNotEmpty((CharSequence)nameField)) {
                nameValue = item2.getString(nameField);
            }
            numbers.add(numberValue);
            names.add(nameValue);
        }
        f7BdWriteFormat.setNumberValList(numbers);
        f7BdWriteFormat.setNameValList(names);
    }

    private void genHeader(String entryKey, Map<String, Object> customParams, IExportEntryPlugin plugin, IFormView formView) {
        EntryExcelGenerateHelper.setDefaultColumnStyle(this.sheet, this.fieldCaptions, this.entityId, this.exportSheetStyle);
        SXSSFRow entityRow = ExcelWriter.getRow(this.sheet, 0);
        SXSSFRow entryRow = ExcelUtil.getRow((SXSSFSheet)this.sheet, (int)1);
        SXSSFRow commentRow = ExcelUtil.getRow((SXSSFSheet)this.sheet, (int)2);
        ExportEntryDataHelper.creatHeaderCell(customParams.get("ListName") + " # " + customParams.get("formId"), this.exportSheetStyle.getTplCodeRowTextStyle(), this.sheet, entityRow, 0);
        ExportEntryDataHelper.creatHeaderCell(ResManager.loadKDString((String)"\u65b0\u589e\u5e76\u66f4\u65b0", (String)HiesEntryRes.EntryExcelCurrentTplGenerator_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), this.exportSheetStyle.getTplCodeRowTextStyle(), this.sheet, entityRow, 1);
        String rowName = this.entryName + "#" + entryKey;
        ExportEntryDataHelper.creatHeaderCell(rowName, this.wb.createCellStyle(), this.sheet, entryRow, 0);
        String tip = ResManager.loadKDString((String)"\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)HiesEntryRes.EntryExcelCurrentTplGenerator_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
        ExportEntryDataHelper.creatHeaderCell(tip + "\n", this.exportSheetStyle.getTextHighLightStyle(), this.sheet, commentRow, 0);
        SXSSFRow nameRow = this.createFieldNamesRow(this.fieldCaptions, 3);
        HashMap titleRowMergedRegionInfo = Maps.newHashMapWithExpectedSize((int)this.fieldCaptions.size());
        this.createFieldTitleRow(this.fieldCaptions, 4, titleRowMergedRegionInfo);
        for (Map.Entry entry : titleRowMergedRegionInfo.entrySet()) {
            int rowIndex = (Integer)entry.getValue();
            int col = (Integer)entry.getKey();
            if (this.rowCount - rowIndex <= 0) continue;
            this.addMergedRegion(rowIndex, this.rowCount, col, col);
        }
    }

    private void setDropdownSheet(String defaultBaseinfoformat, Map<String, String> f7formatCfg, IFormView view, String tplType) {
        HashSet bdSet = Sets.newHashSetWithExpectedSize((int)this.fields.size());
        for (KeyValue kv : this.fieldCaptions) {
            if (kv.key.contains("_id")) continue;
            if (kv.value instanceof KeyValue) {
                List values = (List)((KeyValue)kv.value).value;
                for (KeyValue kvk : values) {
                    this.setField(this.fields, kvk, bdSet, defaultBaseinfoformat, f7formatCfg, view, tplType);
                }
                continue;
            }
            this.setField(this.fields, kv, bdSet, defaultBaseinfoformat, f7formatCfg, view, tplType);
        }
    }

    private void setField(Map<String, IDataEntityProperty> fields, KeyValue kv, Set<String> bdSet, String defaultBaseinfoformat, Map<String, String> f7formatCfg, IFormView view, String tplType) {
        IDataEntityProperty field;
        String key = kv.key;
        if (key.contains(".")) {
            key = key.substring(0, key.indexOf(46));
        }
        if ((field = fields.get(key)) instanceof ItemClassProp) {
            return;
        }
        if (field instanceof BasedataProp) {
            if (!bdSet.add(key)) {
                return;
            }
            String baseinfoformat = f7formatCfg.getOrDefault(key, defaultBaseinfoformat);
            this.setBaseDataDropdown(field, kv, baseinfoformat, view, tplType);
        } else if (field instanceof ComboProp) {
            this.setCombo(field, kv);
        } else if (field instanceof BooleanProp) {
            this.setBoolean(kv);
        }
    }

    private void setBoolean(KeyValue kv) {
        ArrayList inputValuesList = Lists.newArrayListWithExpectedSize((int)2);
        inputValuesList.add(ResManager.loadKDString((String)"\u662f", (String)HiesEntryRes.EntryExcelCurrentTplGenerator_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
        inputValuesList.add(ResManager.loadKDString((String)"\u5426", (String)HiesEntryRes.EntryExcelCurrentTplGenerator_4.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
        this.createDropDownSheet(inputValuesList, kv.seq);
    }

    private Map<String, List<String>> setBaseDataDropdown(IDataEntityProperty prop, KeyValue kv, String baseinfoformat, IFormView view, String tplType) {
        DynamicObject[] dynamicObjects;
        EntryBaseBeforeQueryRefBdEventArgs args;
        QFilter f7BdCondQFilter;
        String numberField;
        String nameField;
        HashMap ret = Maps.newHashMapWithExpectedSize((int)3);
        BasedataProp bd = (BasedataProp)prop;
        String baseEntityId = bd.getBaseEntityId();
        String source = (String)this.mapParam.get("source");
        String extParam = (String)this.mapParam.get("extParam");
        Map bdMainProp = MethodUtil.getBdMainProp((String)baseEntityId);
        if (prop instanceof IQueryProp) {
            Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)baseEntityId);
            nameField = (String)hrPersonMainProp.get("name");
            numberField = (String)hrPersonMainProp.get("number");
        } else {
            nameField = (String)bdMainProp.get("name");
            numberField = (String)bdMainProp.get("number");
        }
        if (StringUtils.isEmpty((CharSequence)numberField) && StringUtils.isEmpty((CharSequence)nameField)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashSet<String> fields = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)numberField)) {
            fields.add(numberField);
        }
        if (StringUtils.isNotEmpty((CharSequence)nameField)) {
            fields.add(nameField);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("1", "=", (Object)1));
        QFilter f7BdAuthQFilter = DataValidateServiceHelper.getF7BdQFilter((String)this.entityId, (String)this.appIdPkid, (IDataEntityProperty)prop, (HasPermOrgResult)this.hasPermOrg, (Map)bdMainProp);
        if (!ObjectUtils.isEmpty((Object)f7BdAuthQFilter)) {
            qFilterList.add(f7BdAuthQFilter);
        }
        if (!ObjectUtils.isEmpty((Object)(f7BdCondQFilter = MethodUtil.getF7BdCondQFilter((String)this.entityId, (IDataEntityProperty)prop)))) {
            qFilterList.add(f7BdCondQFilter);
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        List userPlugins = (List)this.mapParam.get("userPlugins");
        if (OprType.EXPORT.getValue().equalsIgnoreCase(source)) {
            args = new kd.hrmp.hies.entry.common.plugin.expt.BeforeQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args.setBaseDataName(baseEntityId);
            args.setFieldId(prop.getName());
            args.setFilters(qFilters);
            args.setSelectFields(fields);
            args.setSource("dropdownList");
            UserEntryExportPluginEngine.fireUserPluginEvent(userPlugins, "beforeQueryRefBd", (EntryAbstractEventArgs)args);
        } else {
            args = new BeforeQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args.setBaseDataName(baseEntityId);
            args.setFieldId(prop.getName());
            args.setFilters(qFilters);
            args.setSelectFields(fields);
            args.setSource("dropdownList");
            HREntryImpPluginEngine.fireImptPluginEvent(userPlugins, "beforeQueryRefBd", (EntryAbstractEventArgs)args);
        }
        if (args.getFilters() != null) {
            qFilters = args.getFilters();
        }
        String selectFields = String.join((CharSequence)",", args.getSelectFields());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityId);
        MethodUtil.printQfilters((QFilter[])qFilters, (String)("getBaseDataFromDB_" + baseEntityId + "_filter"));
        LOGGER.info("setBaseDataDropdown.selectFields:{}", (Object)selectFields);
        int count = helper.count(baseEntityId, qFilters);
        if (count > 10000) {
            return ret;
        }
        if (StringUtils.isNotEmpty((CharSequence)selectFields)) {
            DynamicObjectCollection collection;
            String orderBys = args.getOrderbys();
            if (count > 10000) {
                if (StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(".")) {
                    Set clearMultLevelOrderBys = Arrays.stream(orderBys.split(",")).filter(item -> !item.contains(".")).collect(Collectors.toSet());
                    orderBys = String.join((CharSequence)",", clearMultLevelOrderBys);
                    args.setOrderbys(orderBys);
                }
                collection = QueryServiceHelper.query((String)helper.getEntityName(), (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)100000);
                dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
            } else if (StringUtils.isNotBlank((CharSequence)orderBys) && orderBys.contains(".")) {
                dynamicObjects = helper.query(selectFields, qFilters, orderBys);
            } else {
                collection = helper.queryOriginalCollection(selectFields, qFilters, orderBys);
                dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
            }
        } else {
            dynamicObjects = (DynamicObject[])new DynamicObjectCollection().toArray((Object[])new DynamicObject[0]);
        }
        LOGGER.info("setBaseDataDropdown.entityId:{} count:{}", (Object)baseEntityId, (Object)dynamicObjects.length);
        EntryBaseAfterQueryRefBdEventArgs args2 = null;
        if (OprType.EXPORT.getValue().equalsIgnoreCase(source)) {
            args2 = new kd.hrmp.hies.entry.common.plugin.expt.AfterQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args2.setBaseDataName(baseEntityId);
            args2.setDatas(dynamicObjects);
            args2.setSource("dropdownList");
            UserEntryExportPluginEngine.fireUserPluginEvent(userPlugins, "AfterQueryRefBd", (EntryAbstractEventArgs)args2);
        } else {
            args2 = new AfterQueryRefBdEventArgs(extParam, this.entityId, this.entryKey, view, tplType);
            args2.setBaseDataName(baseEntityId);
            args2.setDatas(dynamicObjects);
            args2.setSource("dropdownList");
            HREntryImpPluginEngine.fireImptPluginEvent(userPlugins, "AfterQueryRefBd", (EntryAbstractEventArgs)args2);
        }
        if (ObjectUtils.isEmpty((Object)((Object)args2))) {
            LOGGER.error("tmpltype is null, mapParam:{}", this.mapParam);
            return ret;
        }
        if (args2 != null) {
            dynamicObjects = args2.getDatas();
            args2.setDatas(null);
        }
        if (dynamicObjects == null) {
            dynamicObjects = new DynamicObject[]{};
        }
        if (dynamicObjects.length > this.maxShowNum) {
            return ret;
        }
        ArrayList numbers = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        ArrayList names = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        ArrayList number_names = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            if ("number_name".equalsIgnoreCase(baseinfoformat)) {
                number_names.add(dy.getString(numberField) + "##" + dy.getString(nameField));
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                numbers.add(dy.getString(numberField));
            }
            if (!StringUtils.isNotEmpty((CharSequence)nameField)) continue;
            names.add(dy.getString(nameField));
        }
        dynamicObjects = null;
        if ("number_name".equalsIgnoreCase(baseinfoformat)) {
            ret.put("number_name", number_names);
        } else if ("number".equalsIgnoreCase(baseinfoformat)) {
            if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                ret.put(numberField, numbers);
            }
            if (StringUtils.isNotEmpty((CharSequence)nameField)) {
                ret.put(nameField, names);
            }
        } else if ("name".equalsIgnoreCase(baseinfoformat)) {
            ret.put(nameField, names);
        }
        int index = kv.seq;
        if ("number_name".equalsIgnoreCase(baseinfoformat)) {
            this.createDropDownSheet(number_names, index);
        } else if ("number".equalsIgnoreCase(baseinfoformat)) {
            if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                this.createDropDownSheet(numbers, index);
                ++index;
            }
            if (StringUtils.isNotEmpty((CharSequence)nameField)) {
                this.createDropDownSheet(names, index);
            }
        } else if ("name".equalsIgnoreCase(baseinfoformat)) {
            this.createDropDownSheet(names, index);
        }
        return ret;
    }

    private void createDropDownSheet(List<String> inputValuesList, int offSet) {
        if (CollectionUtils.isEmpty(inputValuesList)) {
            return;
        }
        Iterator<String> iterator = inputValuesList.iterator();
        int size = inputValuesList.size();
        int index = 0;
        while (iterator.hasNext()) {
            String next = iterator.next();
            ExcelUtil.getRow((SXSSFSheet)this.dropdownSheet, (int)index).createCell(offSet).setCellValue(next);
            iterator.remove();
            ++index;
        }
        String formatString = this.dropdownSheet.getSheetName() + "!$%s$%d:$%s$%d";
        String currColLabel = GenImportTplHeaderWriter.getColumnLabel((int)(offSet + 1));
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        int firstRow = this.rowNum;
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, 10000, offSet, offSet);
        String strFormula = String.format(formatString, currColLabel, 1, currColLabel, size);
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        this.sheet.addValidationData(dataValidation);
    }

    private void setCombo(IDataEntityProperty field, KeyValue kv) {
        ComboProp comboProp = (ComboProp)field;
        List vales = comboProp.getComboItems();
        ArrayList inputValuesList = Lists.newArrayListWithExpectedSize((int)vales.size());
        for (ValueMapItem vale : vales) {
            inputValuesList.add(vale.getName().getLocaleValue());
        }
        if (!(field instanceof MulComboProp)) {
            this.createDropDownSheet(inputValuesList, kv.seq);
        }
    }

    private void initFields() {
        this.fields = ExportEntryDataHelper.getEntryAllField(this.parentView, this.entryKey);
    }

    private void writeDataCell(SXSSFRow row, Map<String, Object> rowMap) {
        String val = (String)rowMap.get("val");
        SXSSFCell cell = EntryExcelGenerateHelper.createCell(row, (Integer)rowMap.get("seq"), (CellStyle)rowMap.get("style"));
        if (StringUtils.isNotBlank((CharSequence)val) && "Y".equals(rowMap.get("isNumber"))) {
            try {
                cell.setCellValue(new BigDecimal(val).doubleValue());
                return;
            }
            catch (Exception ex) {
                LOGGER.warn("tran BigDecimal fail", (Throwable)ex);
            }
        }
        cell.setCellValue(val);
    }

    private SXSSFRow createFieldNamesRow(List<KeyValue> captionList, int rowIndex) {
        SXSSFRow row = ExcelWriter.getRow(this.sheet, rowIndex);
        for (int i = 0; i < captionList.size(); ++i) {
            KeyValue colInfo = captionList.get(i);
            if (colInfo.value instanceof KeyValue) {
                this.createFieldNamesRow((List)((KeyValue)colInfo.value).value, rowIndex);
                continue;
            }
            String key = colInfo.key;
            ExportEntryDataHelper.creatHeaderCell(key, this.exportSheetStyle.getTextStyle(), this.sheet, row, colInfo.seq);
        }
        return row;
    }

    private int[] createFieldTitleRow(List<KeyValue> captions, int rowIndex, Map<Integer, Integer> titleRowMergedRegionInfo) {
        int[] tempColInfo = new int[]{1, 0};
        SXSSFRow row = ExcelWriter.getRow(this.sheet, rowIndex);
        for (int i = 0; i < captions.size(); ++i) {
            KeyValue colInfo = captions.get(i);
            FieldHeaderWriterFormat format = (FieldHeaderWriterFormat)colInfo.extend[0];
            if (!(colInfo.value instanceof KeyValue)) {
                titleRowMergedRegionInfo.put(colInfo.seq, rowIndex);
                SXSSFCell cell = ExportEntryDataHelper.creatHeaderCell((String)colInfo.value, format.isMustInput() && this.exportSheetStyle.isTitleRowDefaultStyle() ? this.exportSheetStyle.getTitleMustInputStyle() : this.exportSheetStyle.getGlobalHeadCellStyle(), this.sheet, row, colInfo.seq);
                EntryExcelCurrentTplGenerator.bindCellTip(this.sheet, cell, colInfo.seq, rowIndex, format.getComment());
                tempColInfo[1] = tempColInfo[1] + 1;
                continue;
            }
            ExportEntryDataHelper.creatHeaderCell(((KeyValue)colInfo.value).key, format.isMustInput() && this.exportSheetStyle.isTitleRowDefaultStyle() ? this.exportSheetStyle.getTitleMustInputStyle() : this.exportSheetStyle.getGlobalHeadCellStyle(), this.sheet, row, colInfo.seq);
            int col = colInfo.seq;
            int[] subTempColInfo = this.createFieldTitleRow((List)((KeyValue)colInfo.value).value, rowIndex + 1, titleRowMergedRegionInfo);
            if (tempColInfo[0] < subTempColInfo[0] + 1) {
                tempColInfo[0] = subTempColInfo[0] + 1;
            }
            tempColInfo[1] = tempColInfo[1] + subTempColInfo[1];
            if (subTempColInfo[1] <= 1) continue;
            this.addMergedRegion(rowIndex, rowIndex, col, col + Math.max(0, subTempColInfo[1] - 1));
        }
        if (this.rowCount < rowIndex) {
            this.rowCount = rowIndex;
        }
        return tempColInfo;
    }

    private void addMergedRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.sheet.addMergedRegion(cellRange);
        SXSSFCell cell = this.sheet.getRow(firstRow).getCell(firstCol);
        CellStyle cellstyle = cell.getCellStyle();
        cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellstyle.setAlignment(HorizontalAlignment.CENTER);
        int colStart = cellRange.getFirstColumn();
        Row titleRow = CellUtil.getRow((int)firstRow, (Sheet)this.sheet);
        Cell cellUp = titleRow.getCell(colStart);
        String val = cellUp.getStringCellValue();
        CellStyle cellStyle = cellUp.getCellStyle();
        Row row = CellUtil.getRow((int)lastRow, (Sheet)this.sheet);
        cell = row.createCell(firstCol);
        cell.setCellValue(val);
        cell.setCellStyle(cellStyle);
    }
}

