/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.business.template;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.SensitiveFiledUtil;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.dto.FieldHeaderWriterFormat;
import kd.hrmp.hies.entry.common.util.EntryExportUtil;
import kd.hrmp.hies.entry.core.init.EntryExportContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class EntryExcelGenerateHelper {
    public static boolean isEmptyVal(IDataEntityProperty field, String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return true;
        }
        if (field instanceof DecimalProp && Double.parseDouble(val) == 0.0) {
            return true;
        }
        return (field instanceof IntegerProp || field instanceof BigIntProp) && Long.parseLong(val) == 0L;
    }

    public static Map<String, Object> convertData(DynamicObject obj, String key, int seq, DataEntityPropertyCollection properties, ExportSheetStyle styles, FieldControlRules fieldControlRules, SensitiveArgs sensitiveArgs, String entityId, EntryExportContext exportContext) throws ParseException {
        IDataEntityProperty field;
        Map<Object, Object> cell = Maps.newHashMapWithExpectedSize((int)3);
        String levelOneKey = key;
        if (key.contains(".")) {
            levelOneKey = key.substring(0, key.indexOf(46));
            field = (IDataEntityProperty)properties.get((Object)levelOneKey);
        } else {
            field = (IDataEntityProperty)properties.get((Object)key);
        }
        CellStyle style = styles.getContentTextStyle(entityId, levelOneKey);
        cell.put("val", "");
        cell.put("style", style);
        cell.put("seq", seq);
        if (field instanceof IQueryProp) {
            key = EntryExcelGenerateHelper.getHrPersonFieldKey(key, field);
        }
        if (properties.containsKey((Object)levelOneKey) || key.endsWith("_id")) {
            DynamicObject currencyDyn;
            String controlPropName;
            int relScale = 2;
            if (field instanceof PriceProp) {
                controlPropName = ((DecimalProp)field).getControlPropName();
                if (properties.containsKey((Object)controlPropName)) {
                    DynamicObject currencyDyn2 = obj.getDynamicObject(controlPropName);
                    if (ObjectUtils.isNotEmpty((Object)currencyDyn2)) {
                        relScale = currencyDyn2.getInt("priceprecision");
                    }
                } else {
                    relScale = 4;
                }
            } else if (field instanceof AmountProp && properties.containsKey((Object)(controlPropName = ((DecimalProp)field).getControlPropName())) && ObjectUtils.isNotEmpty((Object)(currencyDyn = obj.getDynamicObject(controlPropName)))) {
                relScale = currencyDyn.getInt("amtprecision");
            }
            Map<String, Object> vl = EntryExcelGenerateHelper.formatValue(styles, entityId, exportContext, fieldControlRules, sensitiveArgs, obj, field, key, relScale);
            vl.put("seq", seq);
            if (!EntryExcelGenerateHelper.isEmptyVal(field, (String)vl.get("val"))) {
                cell = vl;
            }
        }
        return cell;
    }

    public static String getHrPersonFieldKey(String key, Object prop) {
        String baseEntityId = ((IQueryProp)prop).getBaseEntityId();
        if ("hrpi_depempf7query".equalsIgnoreCase(baseEntityId) || "hrpi_employeef7query".equalsIgnoreCase(baseEntityId)) {
            String[] split = key.split("\\.");
            if (split.length >= 2) {
                if ("name".equalsIgnoreCase(split[1])) {
                    key = split[0] + ".person.name";
                } else if ("number".equalsIgnoreCase(split[1])) {
                    key = split[0] + ".person.number";
                }
            } else {
                return key;
            }
        }
        return key;
    }

    public static Map<String, Object> formatValue(ExportSheetStyle exportSheetStyle, String entityId, EntryExportContext exportContext, FieldControlRules fieldControlRules, SensitiveArgs sensitiveArgs, DynamicObject obj, IDataEntityProperty field, String key, int relScale) throws ParseException {
        Date date;
        String baseinfoformat;
        CellStyle style;
        String val = "";
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        String fieldName = key;
        int index = fieldName.indexOf(46);
        if (index > 0) {
            fieldName = fieldName.substring(0, index);
        }
        if (key.endsWith("_id")) {
            long id;
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            String tmpId = "id";
            if (!obj.containsProperty("id")) {
                tmpId = key.replace("_", ".");
            }
            if ((id = obj.getLong(tmpId)) > 0L) {
                val = String.valueOf(id);
            }
        } else if (field instanceof RefBillProp) {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            DynamicObject bill = obj.getDynamicObject(field);
            val = bill.getString("billno");
        } else if (field instanceof BasedataProp) {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            baseinfoformat = EntryExportUtil.getF7ExptBaseDataFormat(exportContext, MethodUtil.getLevelOneKey((String)key));
            val = baseinfoformat.equalsIgnoreCase("number_name") ? EntryExcelGenerateHelper.getNUMBER_NAMEBasedataValue(obj.getDynamicObject(field), field) : obj.getString(key);
        } else if (field instanceof MulBasedataProp) {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            baseinfoformat = EntryExportUtil.getF7ExptBaseDataFormat(exportContext, MethodUtil.getLevelOneKey((String)key));
            if (key.contains(".")) {
                String lastKey = MethodUtil.getLastKey((String)key);
                key = MethodUtil.getLevelOneKey((String)key);
                if ("name".equalsIgnoreCase(lastKey)) {
                    baseinfoformat = "name";
                } else if ("number".equalsIgnoreCase(lastKey)) {
                    baseinfoformat = "number";
                }
            }
            Object dataObj = obj.get(key);
            MulBasedataDynamicObjectCollection dynamicObjects = (MulBasedataDynamicObjectCollection)dataObj;
            ArrayList<String> temp = new ArrayList<String>(dynamicObjects.size());
            for (DynamicObject dy : dynamicObjects) {
                DynamicObject dynamicObject = (DynamicObject)dy.get(1);
                temp.add(EntryExcelGenerateHelper.assembleBasedataDisplayName(dynamicObject, field, baseinfoformat));
            }
            val = String.join((CharSequence)",", temp);
        } else if (field instanceof ComboProp) {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            Map<String, String> kvMap = EntryExcelGenerateHelper.getComboKeyValue(field);
            String tempval = obj.getString(key);
            if (StringUtils.isNotEmpty((CharSequence)tempval)) {
                CharSequence[] split = StringUtils.split((String)tempval, (String)",");
                for (int i = 0; i < split.length; ++i) {
                    split[i] = kvMap.get(split[i]);
                }
                val = String.join((CharSequence)",", split);
            }
        } else if (field instanceof TimeProp) {
            style = exportSheetStyle.getContentTimeStyle(entityId, fieldName);
            val = EntryExcelGenerateHelper.formatTimeStr(obj.getInt(key));
            if (StringUtils.isNotEmpty((CharSequence)val)) {
                val = HRDateTimeUtils.format((Date)new SimpleDateFormat("HH:mm:ss").parse(EntryExcelGenerateHelper.formatTimeStr(obj.getInt(key))), (String)style.getDataFormatString());
            }
        } else if (field instanceof IntegerProp || field instanceof BigIntProp) {
            if (field instanceof BasedataProp) {
                style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
                val = obj.get(key).toString();
            } else {
                boolean decimalTooBig;
                FieldProp fieldProp = (FieldProp)field;
                String tempval = String.valueOf(obj.get(key));
                boolean isZero = "0".equals(tempval);
                HashMap dataMap = Maps.newHashMap();
                dataMap.put("isZero", "N");
                style = exportSheetStyle.getContentDecimalStyle(entityId, fieldName, (Map)dataMap);
                boolean zeroShow = fieldProp.isZeroShow();
                if (zeroShow || !"0".equals(tempval)) {
                    val = tempval;
                }
                if (decimalTooBig = ListDataExporter.isDecimalTooBig((String)val)) {
                    String dataFormatString = style.getDataFormatString();
                    if ("General".equals(dataFormatString)) {
                        dataFormatString = "#";
                    }
                    if (dataFormatString.equals("#,##0")) {
                        dataFormatString = "#";
                    }
                    style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
                    val = exportSheetStyle.parseDecimal(dataFormatString, new BigDecimal(val));
                } else {
                    String displayFormatString = exportSheetStyle.getDisplayFormatString(entityId, fieldName);
                    boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
                    if (displayFormatStrExist) {
                        if (!isZero) {
                            val = exportSheetStyle.parseDecimal(displayFormatString, new BigDecimal(val));
                        }
                    } else {
                        map.put("isNumber", "Y");
                    }
                }
            }
        } else if (field instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)field;
            BigDecimal dataVal = (BigDecimal)obj.get(key);
            boolean isZero = "0".equals(dataVal.stripTrailingZeros().toString());
            HashMap dataMap = Maps.newHashMap();
            dataMap.put("isZero", "N");
            int scale = field instanceof AmountProp || field instanceof PriceProp ? relScale : decimalProp.getScale();
            dataMap.put("scale", scale);
            String displayFormatString = exportSheetStyle.getDisplayFormatString(entityId, fieldName);
            boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
            style = exportSheetStyle.getContentDecimalStyle(entityId, fieldName, (Map)dataMap);
            boolean zeroShow = decimalProp.isZeroShow();
            if (isZero) {
                if (zeroShow) {
                    val = "0";
                }
                if (!displayFormatStrExist) {
                    map.put("isNumber", "Y");
                }
            } else if (displayFormatStrExist) {
                style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
                int dotInx = displayFormatString.indexOf(".");
                if (dotInx < 0) {
                    displayFormatString = displayFormatString.concat(".00").replaceAll("\\.00", scale > 0 ? String.format(".%0" + scale + "d", 0) : "");
                } else {
                    int length = displayFormatString.length();
                    int scaleCur = length - dotInx - 1;
                    if (scaleCur > scale) {
                        displayFormatString = displayFormatString.substring(0, length - (scaleCur - scale));
                    }
                }
                String parseDecimalVal = exportSheetStyle.parseDecimal(displayFormatString, dataVal);
                if (exportSheetStyle.getNoDisplayScaleZero(entityId, fieldName) && parseDecimalVal.indexOf(".") > 0) {
                    parseDecimalVal = parseDecimalVal.replaceAll("0+?$", "");
                    parseDecimalVal = parseDecimalVal.replaceAll("[.]$", "");
                }
                val = parseDecimalVal;
            } else if (ListDataExporter.isDecimalTooBig((String)dataVal.toString())) {
                String dataFormatString = style.getDataFormatString();
                if (dataFormatString.startsWith("#,##0.")) {
                    dataFormatString = dataFormatString.substring(4);
                }
                style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
                String parseDecimalVal = exportSheetStyle.parseDecimal(dataFormatString, dataVal);
                if (exportSheetStyle.getNoDisplayScaleZero(entityId, fieldName) && parseDecimalVal.indexOf(".") > 0) {
                    parseDecimalVal = parseDecimalVal.replaceAll("0+?$", "");
                    parseDecimalVal = parseDecimalVal.replaceAll("[.]$", "");
                }
                val = parseDecimalVal;
            } else {
                int scaleCur;
                String parseDecimalVal = exportSheetStyle.parseDecimal(style.getDataFormatString(), dataVal);
                dataVal = new BigDecimal(parseDecimalVal.replaceAll(",", ""));
                if (exportSheetStyle.getNoDisplayScaleZero(entityId, fieldName) && (scaleCur = (dataVal = dataVal.stripTrailingZeros()).scale()) < scale) {
                    dataMap.put("scale", scaleCur);
                    style = exportSheetStyle.getContentDecimalStyle(entityId, fieldName, (Map)dataMap);
                }
                map.put("isNumber", "Y");
                val = dataVal.toPlainString();
            }
        } else if (field instanceof MuliLangTextProp) {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            val = obj.getString(key);
        } else if (field instanceof DateProp) {
            String mask;
            date = obj.getDate(key);
            String displayFormatString = exportSheetStyle.getDisplayFormatString(entityId, fieldName);
            boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
            if (displayFormatStrExist) {
                style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
                if (Objects.nonNull(date)) {
                    val = HRDateTimeUtils.format((Date)obj.getDate(key), (String)displayFormatString);
                }
            } else {
                style = exportSheetStyle.getContentDateStyle(entityId, fieldName);
                if (Objects.nonNull(date)) {
                    val = HRDateTimeUtils.format((Date)obj.getDate(key), (String)style.getDataFormatString());
                }
            }
            if ("yyyy".equalsIgnoreCase(mask = exportSheetStyle.getMask(entityId, fieldName))) {
                style = exportSheetStyle.getContentDecimalStyle(entityId, fieldName, "#");
                map.put("isNumber", "Y");
            }
        } else if (field instanceof DateTimeProp) {
            String mask;
            date = obj.getDate(key);
            date = HIESUtil.tranExptDateTimeProp((Date)date, (DateTimeProp)((DateTimeProp)field), (DynamicObject)obj);
            String displayFormatString = exportSheetStyle.getDisplayFormatString(entityId, fieldName);
            boolean displayFormatStrExist = StringUtils.isNotBlank((CharSequence)displayFormatString);
            if (displayFormatStrExist) {
                style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
                if (Objects.nonNull(date)) {
                    val = HRDateTimeUtils.format((Date)date, (String)displayFormatString);
                }
            } else {
                style = exportSheetStyle.getContentDatetimeStyle(entityId, fieldName);
                if (Objects.nonNull(date)) {
                    val = HRDateTimeUtils.format((Date)date, (String)style.getDataFormatString());
                }
            }
            if ("yyyy".equalsIgnoreCase(mask = exportSheetStyle.getMask(entityId, fieldName))) {
                style = exportSheetStyle.getContentDecimalStyle(entityId, fieldName, "#");
                map.put("isNumber", "Y");
            }
        } else if (field instanceof BooleanProp) {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            val = Boolean.TRUE.equals(obj.getBoolean(key)) ? ResManager.loadKDString((String)"\u662f", (String)HiesEntryRes.EntryExcelGenerateHelper_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)HiesEntryRes.EntryExcelGenerateHelper_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
        } else {
            style = exportSheetStyle.getContentTextStyle(entityId, fieldName);
            val = obj.getString(key);
        }
        if (!StringUtils.isBlank((CharSequence)val)) {
            String mainOrg = exportContext.getFormView().getModel().getDataEntityType().getMainOrg();
            long mainOrgId = 0L;
            if (StringUtils.isNotBlank((CharSequence)mainOrg) && EntryExcelGenerateHelper.containsMainOrg(mainOrg, obj)) {
                mainOrgId = (Long)obj.getDynamicObject(mainOrg).getPkValue();
            }
            FieldControlRule fieldControlRule = SensitiveFiledUtil.getFieldControlRule((long)mainOrgId, (FieldControlRules)fieldControlRules);
            boolean canExport = SensitiveFiledUtil.isCanExport((FieldControlRule)fieldControlRule, (String)key);
            ListField listField = new ListField(key);
            listField.setSrcFieldProp(field);
            KeyValue kv = new KeyValue(key, (Object)val);
            val = (String)SensitiveFiledUtil.tryDeSensitiveValue((DynamicObject)obj, (KeyValue)kv, (ListField)listField, (Object)val, (boolean)canExport, (SensitiveArgs)sensitiveArgs, (String)entityId);
            map.put("val", val);
        }
        map.put("style", style);
        map.put("val", val);
        return map;
    }

    private static boolean containsMainOrg(String mainOrg, DynamicObject row) {
        IDataEntityType dataEntityType = row.getDataEntityType();
        return dataEntityType.getProperties().containsKey((Object)mainOrg) && row.getDynamicObject(mainOrg) != null;
    }

    private static String getNUMBER_NAMEBasedataValue(DynamicObject dy, IDataEntityProperty field) {
        if (ObjectUtils.isEmpty((Object)dy)) {
            return "";
        }
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)field).getComplexType();
        Map bdMainProp = null;
        bdMainProp = field instanceof IQueryProp ? MethodUtil.getHRPersonMainProp((String)type.getName()) : MethodUtil.getBdMainProp((String)type.getName());
        String nameField = (String)bdMainProp.get("name");
        String numberField = (String)bdMainProp.get("number");
        String valtemp = dy.getString(numberField) + "##" + dy.getString(nameField);
        return valtemp;
    }

    private static String assembleBasedataDisplayName(DynamicObject dy, IDataEntityProperty field, String baseinfoformat) {
        if (ObjectUtils.isEmpty((Object)dy)) {
            return "";
        }
        String valtemp = "";
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)field).getComplexType();
        Map bdMainProp = null;
        bdMainProp = field instanceof IQueryProp ? MethodUtil.getHRPersonMainProp((String)type.getName()) : MethodUtil.getBdMainProp((String)type.getName());
        String nameField = (String)bdMainProp.get("name");
        String numberField = (String)bdMainProp.get("number");
        switch (baseinfoformat) {
            case "name": {
                valtemp = dy.getString(nameField);
                break;
            }
            case "number": {
                valtemp = dy.getString(numberField);
                break;
            }
            case "number_name": {
                valtemp = dy.getString(numberField) + "##" + dy.getString(nameField);
                break;
            }
        }
        return valtemp;
    }

    private static String formatTimeStr(int time) {
        if (time < 0) {
            return null;
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    private static Map<String, String> getComboKeyValue(IDataEntityProperty field) {
        ComboProp comboProp = (ComboProp)field;
        List vales = comboProp.getComboItems();
        HashMap item = Maps.newHashMapWithExpectedSize((int)vales.size());
        for (ValueMapItem vale : vales) {
            item.put(vale.getValue(), vale.getName().getLocaleValue());
        }
        return item;
    }

    public static int statisticsColumnCount(List<KeyValue> captionList) {
        int totalCount = 0;
        for (int i = 0; i < captionList.size(); ++i) {
            KeyValue colInfo = captionList.get(i);
            if (colInfo.value instanceof KeyValue) {
                totalCount += EntryExcelGenerateHelper.statisticsColumnCount((List)((KeyValue)colInfo.value).value);
                continue;
            }
            ++totalCount;
        }
        return totalCount;
    }

    public static SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    public static void setDefaultColumnStyle(SXSSFSheet sheet, List<KeyValue> captionList, String entityId, ExportSheetStyle exportSheetStyle) {
        for (int i = 0; i < captionList.size(); ++i) {
            KeyValue colInfo = captionList.get(i);
            if (colInfo.value instanceof KeyValue) {
                EntryExcelGenerateHelper.setDefaultColumnStyle(sheet, (List)((KeyValue)colInfo.value).value, entityId, exportSheetStyle);
                continue;
            }
            EntryExcelGenerateHelper.setDcStyle(sheet, colInfo, entityId, exportSheetStyle);
        }
    }

    private static void setDcStyle(SXSSFSheet sheet, KeyValue colInfo, String mainEntityName, ExportSheetStyle exportSheetStyle) {
        FieldHeaderWriterFormat format = (FieldHeaderWriterFormat)colInfo.extend[0];
        IDataEntityProperty property = format.getProp();
        if (ObjectUtils.isEmpty((Object)property)) {
            sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getTextStyle());
            return;
        }
        String fieldName = property.getName();
        if (fieldName.endsWith(".id")) {
            fieldName = fieldName.replaceAll("\\.id", "_id");
        }
        if (property instanceof DateProp) {
            String mask = exportSheetStyle.getMask(mainEntityName, fieldName);
            if ("yyyy".equalsIgnoreCase(mask)) {
                sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDefContentDecimalStyle(mainEntityName, fieldName, "#"));
            } else {
                sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDefContentDateStyle(mainEntityName, fieldName));
            }
        } else if (property instanceof DateTimeProp) {
            String mask = exportSheetStyle.getMask(mainEntityName, fieldName);
            if ("yyyy".equalsIgnoreCase(mask)) {
                sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDefContentDecimalStyle(mainEntityName, fieldName, "#"));
            } else {
                sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDefContentDatetimeStyle(mainEntityName, fieldName));
            }
        } else if (property instanceof TimeProp) {
            sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDateCusStyle("time", mainEntityName, fieldName));
        } else if (property instanceof DecimalProp) {
            HashMap dataMap = Maps.newHashMap();
            dataMap.put("scale", ((DecimalProp)property).getScale());
            sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDefContentDecimalStyle(mainEntityName, fieldName, (Map)dataMap));
        } else {
            sheet.setDefaultColumnStyle(colInfo.seq.intValue(), exportSheetStyle.getDefContentTextStyle(mainEntityName, fieldName));
        }
    }
}

