/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.plugin.expt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.AfterInitContextArgs;
import kd.hrmp.hies.entry.common.plugin.expt.AfterInitContextDto;
import kd.hrmp.hies.entry.common.plugin.expt.AfterLoadUserPluginEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.BeforeWriteDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.HREntryExportPlugin;
import kd.hrmp.hies.entry.core.init.EntryExportContext;

public class UserEntryExportPluginEngine {
    private static Log log = LogFactory.getLog(UserEntryExportPluginEngine.class);
    private static Map<String, BiConsumer<List<HREntryExportPlugin>, EntryAbstractEventArgs>> actionMappings = new HashMap<String, BiConsumer<List<HREntryExportPlugin>, EntryAbstractEventArgs>>(){
        private static final long serialVersionUID = 5376674423517533044L;
        {
            this.put("afterLoadUserPlugin", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.afterLoadUserPlugin((AfterLoadUserPluginEventArgs)((Object)params))));
            this.put("afterInitContext", (plugins, params) -> {
                for (HREntryExportPlugin userImportPlugin : plugins) {
                    AfterInitContextDto dto = (AfterInitContextDto)((Object)params);
                    AfterInitContextArgs args = new AfterInitContextArgs(dto.getContext());
                    args.setFileName(dto.getContext().getDownLoadFileName());
                    args.setF7formatCfg(dto.getContext().getF7formatCfg());
                    userImportPlugin.afterInitContext(args);
                    dto.getContext().setDownLoadFileName(args.getFileName());
                    dto.getContext().setDisplayBdSheets(args.getDisplayBdSheets());
                    dto.getContext().setF7formatCfg(args.getF7formatCfg());
                }
            });
            this.put("beforeCreateHeaderColumn", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeCreateHeaderColumn((BeforeCreateHeaderColumnEventArgs)((Object)params))));
            this.put("beforeQueryRefBd", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeQueryRefBd((BeforeQueryRefBdEventArgs)((Object)params))));
            this.put("AfterQueryRefBd", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.afterQueryRefBd((AfterQueryRefBdEventArgs)((Object)params))));
            this.put("beforeWriteData", (plugins, params) -> plugins.forEach((? super T userExportPlugin) -> userExportPlugin.beforeWriteData((BeforeWriteDataEventArgs)((Object)params))));
        }
    };

    public static void fireUserPluginEvent(EntryExportContext exportStart, String eventMethod, EntryAbstractEventArgs params) {
        List<HREntryExportPlugin> userPluginInstances = exportStart.getUserPluginInstances();
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        actionMappings.get(eventMethod).accept(userPluginInstances, params);
    }

    public static void fireUserPluginEvent(List<HREntryExportPlugin> userPluginInstances, String eventMethod, EntryAbstractEventArgs params) {
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        actionMappings.get(eventMethod).accept(userPluginInstances, params);
        long spense = System.currentTimeMillis() - start;
        if (spense > 100L) {
            log.info("fireUserPluginEvent_expense:" + spense);
        }
    }
}

