/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.plugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hies.common.util.HIESUtil;
import kd.hrmp.hies.entry.business.DefaultEntryImportPluginService;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterLoadUserPluginEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;

public class UserEntryImportPluginUtil {
    private static final Log logger = LogFactory.getLog(UserEntryImportPluginUtil.class);

    public static List<HREntryImportPlugin> getHREntryImportPlugin(String opPlugins, String tplPlugins, String extParams, ConcurrentHashMap<String, Object> customParams, String entityId, String entryKey, IFormView formView, IDataModel dataModel, String tplType) {
        List<String> defaultPlugins = DefaultEntryImportPluginService.getDefaultPlugins(entityId);
        logger.info("getHREntryImportPlugin_entityId:{} defaultPlugins:{} opPlugins:{} tplPlugins:{}", new Object[]{entityId, defaultPlugins, opPlugins, tplPlugins});
        List<HREntryImportPlugin> userPluginInstances = UserEntryImportPluginUtil.initEntryPlugin(HIESUtil.getGlobalPlugins(), defaultPlugins, opPlugins, tplPlugins, HREntryImportPlugin.class);
        if (CollectionUtils.isNotEmpty(userPluginInstances)) {
            List<HREntryImportPlugin> copyUserPluginInstances = userPluginInstances.stream().collect(Collectors.toList());
            AfterLoadUserPluginEventArgs args = new AfterLoadUserPluginEventArgs(extParams, customParams, entityId, entryKey, formView, dataModel, tplType);
            args.setUserPlugin(userPluginInstances);
            HREntryImpPluginEngine.fireImptPluginEvent(copyUserPluginInstances, "afterLoadUserPlugin", (EntryAbstractEventArgs)args);
        }
        return userPluginInstances;
    }

    private static <T> List<T> initEntryPlugin(String globalPlugins, List<String> defaultPlugins, String opPlugins, String tplPlugins, Class<T> cls) {
        JSONArray jsonArray;
        LinkedList userPluginInstances = new LinkedList();
        LinkedList userPluginClassList = new LinkedList();
        if (StringUtils.isNotEmpty((CharSequence)globalPlugins)) {
            jsonArray = JSONObject.parseArray((String)globalPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserEntryImportPluginUtil.setEntryPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (CollectionUtils.isNotEmpty(defaultPlugins)) {
            defaultPlugins.forEach(classPath -> UserEntryImportPluginUtil.setEntryPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (StringUtils.isNotEmpty((CharSequence)opPlugins)) {
            Arrays.stream(opPlugins.split(",")).distinct().forEach(classPath -> UserEntryImportPluginUtil.setEntryPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        if (StringUtils.isNotEmpty((CharSequence)tplPlugins)) {
            jsonArray = JSONObject.parseArray((String)tplPlugins);
            jsonArray.stream().map(obj -> (JSONObject)obj).filter(jsonObject -> jsonObject.getBooleanValue("Enabled")).map(jsonObject -> jsonObject.getString("ClassName")).distinct().forEach(classPath -> UserEntryImportPluginUtil.setEntryPluginInstance(userPluginInstances, userPluginClassList, classPath, cls));
        }
        return userPluginInstances;
    }

    private static <T> void setEntryPluginInstance(List<T> userPluginInstances, List<String> userPluginClassList, String classPath, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return;
        }
        if (userPluginClassList.contains(classPath)) {
            return;
        }
        userPluginClassList.add(classPath);
        try {
            Object instance = TypesContainer.createInstance((String)classPath);
            if (cls.getSimpleName().equalsIgnoreCase(HREntryImportPlugin.class.getSimpleName()) && instance instanceof HREntryImportPlugin) {
                userPluginInstances.add(instance);
            }
        }
        catch (Throwable ex) {
            logger.error("setPluginInstances {} createInstance error.", (Object)classPath, (Object)ex);
        }
    }
}

