/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.common.util;

import java.time.LocalDate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.core.init.EntryExportContext;
import org.apache.commons.lang3.StringUtils;

public class EntryExportUtil {
    public static String getF7ExptBaseDataFormat(EntryExportContext exportContext, String key) {
        DynamicObject fieldDy;
        String baseDataFormat = exportContext.getDefaultBaseinfoformat();
        baseDataFormat = exportContext.getTplType().equals("config") ? (StringUtils.isBlank((CharSequence)(fieldDy = exportContext.getTplFieldConfig().get(key)).getString("imptattr")) ? "number" : fieldDy.getString("imptattr")) : exportContext.getF7formatCfg().getOrDefault(key, exportContext.getDefaultBaseinfoformat());
        return baseDataFormat;
    }

    public static String getExptFileName(String tplType, String sheetName, String entityName, String tplName, String tplpkid, boolean isTpldown) {
        String downLoadFileName = "";
        if (isTpldown) {
            downLoadFileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)HiesEntryRes.EntryExcelCfgTplGenerator_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
        }
        if (tplType.equals("config")) {
            LocalDate now = LocalDate.now();
            if (StringUtils.isEmpty((CharSequence)tplName)) {
                DynamicObject templateData = EntryTemplateConfService.load(tplpkid);
                tplName = templateData.getString("name");
            }
            downLoadFileName = downLoadFileName + tplName.concat("_").concat(String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth()));
            downLoadFileName = HIESConstant.SpecCharPattern.matcher(downLoadFileName).replaceAll("");
        } else {
            downLoadFileName = downLoadFileName + entityName + "_" + sheetName;
        }
        return downLoadFileName;
    }
}

