/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.init;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportLog;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextDto;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.common.plugin.impt.UserEntryImportPluginUtil;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.init.EntryImportStarter;
import org.apache.commons.lang3.StringUtils;

public class EntryExcelImportTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(EntryExcelImportTask.class);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        EntryImportContext importContext = new EntryImportContext();
        importContext.setTaskid(this.taskId);
        EntryImportStarter importStart = new EntryImportStarter(importContext);
        try {
            this.initImportContext(importStart, map);
            importStart.start();
        }
        catch (Throwable e) {
            LOGGER.error("EntryExcelImportTask_recievered_Exception", e);
            try {
                importStart.end(true, true, e);
            }
            catch (Exception ee) {
                LOGGER.error((Throwable)ee);
            }
            throw new KDException(new ErrorCode("001", "BigExcelImportTask_start failed."), "", e);
        }
        finally {
            importContext.getExtOption().put("userEndTime", System.currentTimeMillis());
            this.feedbackProgress(100);
        }
    }

    private void initImportContext(EntryImportStarter importStart, Map<String, Object> map) {
        Object sourceRc;
        EntryImportContext importContext = importStart.getImportContext();
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        if (sysparam != null) {
            String setNullIdentify = sysparam.getString("setnullparam");
            importContext.setSetNullIdentify(setNullIdentify);
        }
        if ((sourceRc = map.remove("requestContext")) instanceof RequestContext) {
            RequestContext.set((RequestContext)((RequestContext)sourceRc));
        } else {
            RequestContext.set((RequestContext)((RequestContext)JSONObject.parseObject((String)sourceRc.toString(), RequestContext.class)));
        }
        MethodUtil.syncRequestTraceId((Object)RequestContext.get());
        LOGGER.info("BigExcelImportTask_started!trace_id={}", (Object)RequestContext.get().getTraceId());
        LOGGER.info("EntryExcelImportTask_execute(),map:{}", map);
        importContext.setRc(RequestContext.get());
        importContext.setImportLog(new ImportLog());
        importContext.setExtOption(this.initExtOption(map));
        importContext.setTaskid(this.taskId);
        String tplpkid = (String)map.get("tplpkid");
        if (StringUtils.isNotEmpty((CharSequence)tplpkid)) {
            importContext.setTplPkid(Long.parseLong(tplpkid));
            importContext.setTpl(EntryTemplateConfService.load(importContext.getTplPkid()));
            importContext.setTplFieldConfig(EntryTemplateConfService.getTplFieldConfig(importContext.getTpl()));
            importContext.setTplType("config");
            String mainentityuniqueval = importContext.getTpl().getString("mainentityuniqueval");
            if (StringUtils.isNotEmpty((CharSequence)mainentityuniqueval)) {
                Object[] split = StringUtils.split((String)mainentityuniqueval, (String)",");
                importContext.setUniqueFields(MethodUtil.arrayToList((Object[])split));
            }
        } else {
            importContext.getUniqueFields().add("id");
        }
        importContext.setOrgMap((Map)map.get("orgMap"));
        importContext.setEntryKey((String)map.get("entryKey"));
        importContext.setAppId((String)map.get("appId"));
        importContext.setServiceAppId((String)map.get("ServiceAppId"));
        importContext.setMainFormId((String)map.get("formId"));
        importContext.setPageId((String)map.get("pageId"));
        Object fileSize = map.get("fileSize");
        importContext.setFileSize(Long.valueOf(String.valueOf(fileSize)));
        importContext.setFilePath((String)map.get("fileUrl"));
        importContext.setFileLocalPath((String)map.get("fileLocalUrl"));
        importContext.setFileName((String)map.get("fileName"));
        importContext.setTotalRowCount((Integer)map.get("totalRow"));
        importContext.setDefaultBaseinfoformat((String)map.get("defaultBaseinfoFormat"));
        importContext.setFileType(importContext.getFilePath().substring(importContext.getFilePath().lastIndexOf(".")));
        importContext.setEntityType(MetadataServiceHelper.getDataEntityType((String)importContext.getMainFormId()));
        importContext.setTask(this);
        importContext.setFormView(this.initFormView((String)map.get("pageId"), (String)map.get("formId")));
        importContext.setStartRowNum((Integer)map.get("startRowNum"));
        importContext.setCaptions((List)map.get("entryHeader"));
        importContext.setEntryName((String)map.get("entryName"));
        importContext.setEffectSheetNames(JSONObject.parseArray((String)((String)map.get("effectSheetNames")), String.class));
        importContext.setSheetName(importContext.getEffectSheetNames().get(0));
        importContext.setBdFieldMainPropName(ExportEntryDataHelper.getEntryBdMainProp(importContext.getFormView(), importContext.getEntryKey()));
        LOGGER.info("BigExcelImportTask_BdFieldMainPropName:{}", importContext.getBdFieldMainPropName());
        importContext.setEntryAllFields(ExportEntryDataHelper.getEntryAllField(importContext.getFormView(), importContext.getEntryKey()));
        this.initUserPlugin(importContext, (String)map.get("importPlugin"));
        AfterInitContextDto dto = new AfterInitContextDto(importContext);
        HREntryImpPluginEngine.fireImptPluginEvent(importStart, "afterInitContext", (EntryAbstractEventArgs)dto);
    }

    private IFormView initFormView(String pageId, String mainFormId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            view = HIESUtil.createEntityFormView((String)mainFormId);
        }
        IFormController srv = (IFormController)view.getService(IFormController.class);
        srv.registerListener();
        return view;
    }

    private Map<String, Object> initExtOption(Map<String, Object> map) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        option.put("userStartTime", map.get("userStartTime"));
        option.put("extParam", JSONObject.parse((String)((String)map.get("extParam"))));
        option.put("submitOP", "save");
        return option;
    }

    private void initUserPlugin(EntryImportContext entryImportContext, String oPlugins) {
        String tplPlugins = null;
        if (entryImportContext.getTpl() != null) {
            tplPlugins = entryImportContext.getTpl().getString("plugin");
        }
        List<HREntryImportPlugin> hrImportPlugin = UserEntryImportPluginUtil.getHREntryImportPlugin(oPlugins, tplPlugins, (String)entryImportContext.getExtOption().get("extParam"), entryImportContext.getCustomParams(), entryImportContext.getEntityType().getName(), entryImportContext.getEntryKey(), entryImportContext.getFormView(), entryImportContext.getFormView().getModel(), entryImportContext.getTplType());
        entryImportContext.setUserPluginInstances(hrImportPlugin);
    }
}

