/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.template.EntryExcelCfgTplGenerator;
import kd.hrmp.hies.entry.business.template.EntryExcelCurrentTplGenerator;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.AfterInitContextDto;
import kd.hrmp.hies.entry.common.plugin.expt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.expt.HREntryExportPlugin;
import kd.hrmp.hies.entry.common.plugin.expt.UserEntryExportPluginEngine;
import kd.hrmp.hies.entry.common.plugin.expt.UserEntryExportPluginUtil;
import kd.hrmp.hies.entry.core.init.EntryExportContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EntryExportStarter {
    private static final Log LOGGER = LogFactory.getLog(EntryExportStarter.class);
    private EntryExportContext entryExportContext;

    public EntryExportStarter(EntryExportContext context) {
        this.entryExportContext = context;
    }

    public void initContext(Map<String, Object> params) {
        Object sourceRc = params.remove("requestContext");
        LOGGER.info("startExportExcel_params:" + JSONObject.toJSONString(params));
        if (sourceRc instanceof RequestContext) {
            RequestContext.set((RequestContext)((RequestContext)sourceRc));
        } else {
            RequestContext.set((RequestContext)((RequestContext)JSONObject.parseObject((String)sourceRc.toString(), RequestContext.class)));
        }
        this.entryExportContext.setRc(RequestContext.get());
        MethodUtil.syncRequestTraceId((Object)RequestContext.get());
        this.entryExportContext.setTotalRow((Integer)params.get("totalRow"));
        IFormView iFormView = MethodUtil.initFormView((String)((String)params.get("pageId")));
        this.entryExportContext.setPageParams((Map)JSONObject.parseObject((String)((String)params.get("customParams")), Map.class));
        this.entryExportContext.setEntityId((String)this.entryExportContext.getPageParams().get("formId"));
        this.entryExportContext.setEntryKey((String)params.get("entryKey"));
        this.entryExportContext.setFormView(iFormView);
        this.entryExportContext.setAppId(iFormView.getFormShowParameter().getAppId());
        this.entryExportContext.setServiceAppId((String)this.entryExportContext.getCustomParams().get("ServiceAppId"));
        this.entryExportContext.setTaskId((String)params.get("taskPkId"));
        this.entryExportContext.setSheetName((String)params.get("sheetName"));
        this.entryExportContext.setDownLoadFileName((String)params.get("downLoadFileName"));
        String tplpkid = (String)params.get("tplpkid");
        String tplPlugins = null;
        if (StringUtils.isNotEmpty((CharSequence)tplpkid)) {
            long id = Long.parseLong(tplpkid);
            this.entryExportContext.setTplPkid(id);
            this.entryExportContext.setTpl(EntryTemplateConfService.load(tplpkid));
            this.entryExportContext.setTplFieldConfig(EntryTemplateConfService.getTplFieldConfig(this.entryExportContext.getTpl()));
            this.entryExportContext.setTplType("config");
            tplPlugins = this.entryExportContext.getTpl().getString("plugin");
        }
        List<HREntryExportPlugin> hrEntryExportPlugin = UserEntryExportPluginUtil.getHREntryExportPlugin((String)this.entryExportContext.getPageParams().get("exportPlugin"), tplPlugins, this.entryExportContext);
        this.entryExportContext.setUserPluginInstances(hrEntryExportPlugin);
    }

    public void startCurrentTpl(Map<String, Object> resultInfo) throws Exception {
        LOGGER.info("expStart_start.");
        long startTime = System.currentTimeMillis();
        try {
            Map<String, Object> pageParams = this.entryExportContext.getPageParams();
            IFormView formView = this.entryExportContext.getFormView();
            AfterInitContextDto dto = new AfterInitContextDto(this.entryExportContext);
            UserEntryExportPluginEngine.fireUserPluginEvent(this.entryExportContext, "afterInitContext", (EntryAbstractEventArgs)dto);
            List<KeyValue> expHeader = ExportEntryDataHelper.getExpHeader(pageParams, formView, this.entryExportContext.getDefaultBaseinfoformat(), this.entryExportContext.getF7formatCfg());
            String entryKey = this.entryExportContext.getEntryKey();
            String entityId = (String)pageParams.get("formId");
            BeforeCreateHeaderColumnEventArgs args = new BeforeCreateHeaderColumnEventArgs(this.entryExportContext);
            args.setFieldCaptions(expHeader);
            args.setEntryKey(entryKey);
            UserEntryExportPluginEngine.fireUserPluginEvent(this.entryExportContext, "beforeCreateHeaderColumn", (EntryAbstractEventArgs)args);
            HasPermOrgResult hasPermOrg = ImportServiceHelper.getEntityHasPermOrg((String)entityId, (String)((String)pageParams.get("ServiceAppId")));
            HashMap mapParam = Maps.newHashMapWithExpectedSize((int)2);
            mapParam.put("userPlugins", this.entryExportContext.getUserPluginInstances());
            mapParam.put("source", OprType.EXPORT.getValue());
            Object startRowNum = pageParams.get("startRowNum");
            String entryName = ExportEntryDataHelper.getEntryName(entryKey, formView.getModel());
            EntryExcelCurrentTplGenerator exporter = new EntryExcelCurrentTplGenerator(entryName, expHeader, ObjectUtils.isEmpty((Object)startRowNum) ? 4 : (Integer)startRowNum, true, entityId, this.entryExportContext.getDownLoadFileName(), formView, this.entryExportContext.getAppId());
            exporter.setEntryExpStarter(this.entryExportContext);
            exporter.setExportSheetStyle(ExcelStyleUtil.getGlobalSheetStyle((Set)Sets.newHashSet((Object[])new String[]{entityId}), (SXSSFWorkbook)exporter.getWb()));
            exporter.setEntryKey(entryKey);
            exporter.setMapParam(mapParam);
            exporter.setHasPermOrg(hasPermOrg);
            Map<String, Object> result = exporter.genExportExcel(entryKey, pageParams, formView);
            resultInfo.putAll(result);
            resultInfo.put("url", result.get("url"));
            resultInfo.put("timeRemaining", (System.currentTimeMillis() - startTime) / 1000L);
        }
        catch (Throwable exception) {
            LOGGER.error("EntryExport_Exception:", exception);
            throw exception;
        }
    }

    public void startConfigTpl(Map<String, Object> resultInfo) throws Exception {
        LOGGER.info("expStart_start.");
        long startTime = System.currentTimeMillis();
        SXSSFWorkbook wb = null;
        try {
            HashMap mapParam = Maps.newHashMapWithExpectedSize((int)16);
            mapParam.put("pageId", this.entryExportContext.getPageParams().get("pageId"));
            mapParam.put("extParam", "");
            mapParam.put("appId", this.entryExportContext.getAppId());
            mapParam.put("source", OprType.EXPORT.getValue());
            mapParam.put("exportContext", this.entryExportContext);
            wb = EntryExcelCfgTplGenerator.getSXSSFWorkbook(this.entryExportContext.getTpl(), mapParam);
            EntryExcelCfgTplGenerator.writeData(wb, mapParam);
            String url = EntryExcelCfgTplGenerator.saveAndUploadFile(wb, this.entryExportContext.getTpl(), mapParam);
            resultInfo.put("url", url);
            resultInfo.put("total", mapParam.get("total"));
            resultInfo.put("timeRemaining", (System.currentTimeMillis() - startTime) / 1000L);
        }
        catch (Throwable exception) {
            LOGGER.error("EntryExport_Exception:", exception);
            throw exception;
        }
        finally {
            if (wb != null) {
                wb.dispose();
            }
        }
    }
}

