/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hrmp.hies.entry.business.ImportService;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.util.EntryImportUtil;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.parse.EntryParser;
import kd.hrmp.hies.entry.core.parse.EntryReporter;
import kd.hrmp.hies.entry.core.validate.EntryDataValidateManager;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class EntryImportStarter {
    private EntryImportContext importContext;
    private ThreadPool pool;
    private LinkedBlockingQueue<ImportBillData> parserQueue;
    private AtomicInteger batchIndex = new AtomicInteger(0);
    private List<ImportBillData> successRowData = new LinkedList<ImportBillData>();
    private volatile boolean isStoped = false;
    private volatile boolean isEnd = false;
    private CountDownLatch latch = new CountDownLatch(2);
    private static final Log LOGGER = LogFactory.getLog(EntryImportStarter.class);

    public EntryImportStarter(EntryImportContext importContext) {
        this.importContext = importContext;
        this.parserQueue = new LinkedBlockingQueue(MCConfigConstant.getQueueSize());
        this.pool = ThreadPools.newFixedThreadPool((String)(EntryImportStarter.class.getSimpleName() + RequestContext.get().getTraceId()), (int)2);
    }

    public LinkedBlockingQueue<ImportBillData> getParserQueue() {
        return this.parserQueue;
    }

    public EntryImportContext getImportContext() {
        return this.importContext;
    }

    public void setImportContext(EntryImportContext importContext) {
        this.importContext = importContext;
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    public void setStoped(boolean stoped) {
        this.isStoped = stoped;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    public int drainDataFromParseQueue(List<ImportBillData> tempBillDataList) {
        int count = this.parserQueue.drainTo(tempBillDataList, 1000);
        if (count == 0) {
            return -1;
        }
        return this.batchIndex.getAndIncrement();
    }

    public void putToSuccessDataList(int currBatchIndex, List<ImportBillData> tempBillDataList) {
        this.importContext.getFinishedBillCount().getAndAdd(tempBillDataList.size());
        Map errorMap = this.importContext.getImportLog().getRowErrors().getOrDefault(this.importContext.getSheetName(), null);
        Iterator<ImportBillData> iterator = tempBillDataList.iterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            if (errorMap == null || !errorMap.containsKey(next.getStartIndex())) continue;
            iterator.remove();
        }
        this.successRowData.addAll(tempBillDataList);
    }

    public void start() throws Exception {
        this.importContext.setMainTread(Thread.currentThread());
        LOGGER.info("ImportStart_start.");
        this.initImportStatus();
        LOGGER.info("EntryImportStarter initImportStatus:2");
        this.pool.submit((Callable)new EntryParser(this));
        this.pool.submit((Callable)new EntryDataValidateManager(this, "1"));
        this.wait2End();
        LOGGER.info("EntryImportStarter wait2End:3");
        this.backFillData();
        LOGGER.info("EntryImportStarter fillBackData:4");
        boolean needReport = this.needReport();
        this.end(needReport, false, null);
        LOGGER.info("ImportStart_end.");
    }

    private boolean needReport() {
        ConcurrentHashMap rowErrors = this.importContext.getImportLog().getRowErrors();
        return !CollectionUtils.isEmpty((Map)rowErrors);
    }

    private void backFillData() {
        if (this.isStoped()) {
            LOGGER.info("EntryImportStarter fillBackData(task={}) has been suspended by user", (Object)this.importContext.getTaskid());
            return;
        }
        if (this.successRowData.size() == 0) {
            LOGGER.info("EntryImportStarter fillBackData(task={}) storeQueue is empty", (Object)this.importContext.getTaskid());
            return;
        }
        EntityType entityType = this.importContext.getEntityType().getAllEntities().getOrDefault(this.importContext.getEntryKey(), null);
        if (entityType == null) {
            LOGGER.info("EntryImportStarter fillBackData(task={}) entity type is null", (Object)this.importContext.getTaskid());
            return;
        }
        LOGGER.info("EntryImportStarter.backFillData,successRowData size:{}", (Object)this.successRowData.size());
        BeforeBackFillDataEventArgs args0 = new BeforeBackFillDataEventArgs(this.importContext);
        args0.setRowData(this.successRowData);
        HREntryImpPluginEngine.fireImptPluginEvent(this, "beforeBackFillData", (EntryAbstractEventArgs)args0);
        IDataModel model = this.importContext.getFormView().getModel();
        model.beginInit();
        this.updateEntryModel(entityType, model);
        model.endInit();
        this.importContext.getFormView().updateView(this.importContext.getEntryKey());
        AfterBackFillDataEventArgs args1 = new AfterBackFillDataEventArgs(this.importContext);
        HREntryImpPluginEngine.fireImptPluginEvent(this, "afterBackFillData", (EntryAbstractEventArgs)args1);
    }

    private void updateEntryModel(EntityType entityType, IDataModel model) {
        HashMap currDataMap;
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String entryKey = this.importContext.getEntryKey();
        DynamicObjectCollection currDataCollection = model.getEntryEntity(entryKey);
        HashMap<String, Map<String, Object>> comboItems = new HashMap<String, Map<String, Object>>();
        this.importContext.getEntryAllFields().values().forEach(prop -> {
            if (prop instanceof ComboProp) {
                HashMap<String, String> itmes = new HashMap<String, String>(16);
                comboItems.put(prop.getName(), itmes);
                ComboProp temp = (ComboProp)prop;
                for (ValueMapItem item : temp.getComboItems()) {
                    itmes.put(item.getName().getLocaleValue(), item.getValue());
                }
            }
        });
        List<String> uniqueFields = this.importContext.getUniqueFields();
        HashMap finalCurrDataMap = currDataMap = Maps.newHashMapWithExpectedSize((int)currDataCollection.size());
        currDataCollection.forEach(row -> {
            StringBuilder str = new StringBuilder();
            uniqueFields.forEach(field -> {
                String tmpField = field;
                if (!row.containsProperty(tmpField)) {
                    if (field.equals("id")) {
                        tmpField = entryKey + '.' + "id";
                    } else if (field.endsWith(".id")) {
                        tmpField = "id";
                    }
                }
                if (!row.containsProperty(tmpField)) {
                    LOGGER.error("uniqueFields_not_exist_tmpField:{}", (Object)tmpField);
                    return;
                }
                Object val = row.get(tmpField);
                if (val instanceof DynamicObject) {
                    DynamicObject obj = (DynamicObject)val;
                    Map<String, Object> map = this.importContext.bdFieldMainPropName.get(field);
                    String numberField = (String)map.get("number");
                    String nameField = (String)map.get("name");
                    if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                        str.append(obj.getString(numberField)).append("&");
                    }
                    String bdformat = EntryImportUtil.getF7ImptBaseDataFormat(this.importContext, tmpField);
                    if (StringUtils.isNotEmpty((CharSequence)nameField) && !"number".equalsIgnoreCase(bdformat)) {
                        str.append(obj.getString(nameField)).append("&");
                    }
                } else if (val instanceof Date) {
                    str.append(((Date)val).getTime()).append("&");
                } else {
                    String val1 = row.getString(tmpField);
                    if (StringUtils.isNotEmpty((CharSequence)val1)) {
                        str.append(val1).append("&");
                    }
                }
            });
            String key = str.toString();
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                List entries = finalCurrDataMap.computeIfAbsent(key, val -> new LinkedList());
                entries.add(row);
            }
        });
        LOGGER.info("EntryImportStarter.updateEntryModel,successRowData size:{}", (Object)this.successRowData.size());
        for (ImportBillData billData : this.successRowData) {
            String status = (String)cache.get(MethodUtil.getTaskCachePath((String)this.importContext.getTaskid(), (String)ImportCacheKeyType.IMPORT, (String)"status"), String.class);
            if (HRStringUtils.equals((String)"stop", (String)status)) {
                HashMap result = Maps.newHashMapWithExpectedSize((int)6);
                result.put("userHasTerminator", "true");
                result.put("successedBillCount", this.importContext.getFinishedImportCount());
                result.put("totalBillCount", this.importContext.getTotalBillCount());
                result.put("finishedBillCount", this.importContext.getFinishedImportCount());
                result.put("needReport", false);
                result.put("userEndTime", String.valueOf(System.currentTimeMillis()));
                cache.put(MethodUtil.getTaskCachePath((String)this.importContext.getTaskid(), (String)ImportCacheKeyType.IMPORT, (String)"result"), (Object)result);
                return;
            }
            JSONObject importData = (JSONObject)billData.getData().getOrDefault((Object)entryKey, null);
            if (importData == null) {
                LOGGER.info("EntryImportStarter handleAllData billDataList data null");
                continue;
            }
            StringBuilder str = new StringBuilder();
            uniqueFields.forEach(field -> {
                Object val;
                if ("id".equalsIgnoreCase((String)field) || field.endsWith(".id")) {
                    field = entryKey + '_' + "id";
                }
                if ((val = importData.get(field)) instanceof JSONObject) {
                    JSONObject obj = (JSONObject)val;
                    Map<String, Object> map = this.importContext.bdFieldMainPropName.get(field);
                    if (ObjectUtils.isNotEmpty(map)) {
                        String numberField = (String)map.get("number");
                        String nameField = (String)map.get("name");
                        if (StringUtils.isNotEmpty((CharSequence)numberField)) {
                            str.append(obj.getString(numberField)).append("&");
                        }
                        String bdformat = EntryImportUtil.getF7ImptBaseDataFormat(this.importContext, field);
                        if (StringUtils.isNotEmpty((CharSequence)nameField) && !"number".equalsIgnoreCase(bdformat)) {
                            str.append(obj.getString(nameField)).append("&");
                        }
                    } else {
                        String langVal = obj.getString(RequestContext.get().getLang().toString());
                        str.append(langVal).append("&");
                    }
                } else if (val instanceof Timestamp) {
                    str.append(((Timestamp)val).getTime()).append("&");
                } else {
                    String val1 = importData.getString(field);
                    if (StringUtils.isNotEmpty((CharSequence)val1)) {
                        str.append(val1).append("&");
                    }
                }
            });
            List updateDynObjs = (List)currDataMap.get(str.toString());
            this.importContext.addImportCount();
            this.countProgress(cache);
            if (!CollectionUtils.isEmpty((Collection)updateDynObjs)) {
                ImportService.updateRow(updateDynObjs, importData, this.importContext, billData, comboItems);
            } else {
                ImportService.addRow(importData, billData, comboItems, this.importContext);
            }
            this.importContext.getSuccessBillCount().getAndIncrement();
        }
    }

    private void countProgress(IHRAppCache cache) {
        int finishedImportCount = this.importContext.getFinishedImportCount();
        if (finishedImportCount % 10 == 0) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)1);
            int total = this.importContext.getTotalRowCount();
            int progress = finishedImportCount * 100 / total;
            data.put("progress", progress);
            cache.put(MethodUtil.getTaskCachePath((String)this.importContext.getTaskid(), (String)ImportCacheKeyType.IMPORT, (String)"processing"), (Object)data);
        }
    }

    private void wait2End() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("wait2End interrupted by something.", (Throwable)e);
        }
    }

    public void notifyWhenEnd() {
        this.latch.countDown();
    }

    public void end(boolean needReport, boolean sysTerminator, Throwable ee) {
        this.isStoped = true;
        this.pool.close();
        this.collectAppCacheData(needReport, sysTerminator, ee);
        if (needReport) {
            new EntryReporter(this).genReport();
        } else {
            try {
                ImportFileUtil.deleteLocalTempFile((String)this.importContext.getFileLocalPath());
            }
            catch (Throwable ee1) {
                LOGGER.error(ee1);
            }
        }
        LOGGER.info("ImportStart_normally_finished!");
    }

    private void collectAppCacheData(boolean needReport, boolean sysTerminator, Throwable ee) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String status = (String)cache.get(MethodUtil.getTaskCachePath((String)this.importContext.getTaskid(), (String)ImportCacheKeyType.IMPORT, (String)"status"), String.class);
        if (HRStringUtils.equals((String)"stop", (String)status)) {
            return;
        }
        String key = MethodUtil.getTaskCachePath((String)this.importContext.getTaskid(), (String)ImportCacheKeyType.IMPORT, (String)"result");
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        result.put("successedBillCount", this.importContext.getSuccessBillCount().get());
        result.put("totalBillCount", this.importContext.getTotalBillCount());
        result.put("finishedBillCount", this.importContext.getFinishedRowCount());
        result.put("needReport", needReport);
        result.put("userEndTime", String.valueOf(System.currentTimeMillis()));
        result.put("entryKey", this.importContext.getEntryKey());
        result.put("sysTerminator", sysTerminator);
        cache.put(key, (Object)result);
        if (sysTerminator) {
            try {
                String errMsg = HIESUtil.formatException((Throwable)ee);
                int row = this.importContext.getStartRowNum() + 1;
                String entryName = this.importContext.getEntryName();
                this.importContext.getImportLog().writeRowLog(entryName, row, row, errMsg);
            }
            catch (Exception ee1) {
                LOGGER.error((Throwable)ee1);
            }
        }
    }

    private void initImportStatus() throws Exception {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        cache.put(MethodUtil.getTaskCachePath((String)this.importContext.getTaskid(), (String)ImportCacheKeyType.IMPORT, (String)"status"), (Object)"run");
    }
}

