/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.parse;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.core.parse.SheetHandler;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EntryExcelReader {
    private static final Log log = LogFactory.getLog(EntryExcelReader.class);
    protected EntryImportContext importContext;

    public EntryExcelReader(EntryImportContext importContext) {
        this.importContext = importContext;
    }

    public void read(File file, SheetHandler sheetHandler) throws Exception {
        this.read(file, sheetHandler, "common");
    }

    public void read(File file, SheetHandler sheetHandler, String readerWayType) throws Exception {
        String sheetName;
        InputStream sheet;
        log.info("ExcelReader_read_started.");
        log.info("ExcelReader_read_filePath=".concat(file.getPath()));
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        OPCPackage pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        XSSFReader xssfReader = new XSSFReader(pkg);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        LinkedList<String> allSheetNames = new LinkedList<String>();
        while (sheets.hasNext()) {
            sheets.next();
            String sheetName2 = sheets.getSheetName();
            allSheetNames.add(sheetName2);
        }
        if (this.importContext != null) {
            sheetHandler.setEffectSheetNames(this.importContext.getEffectSheetNames());
        }
        sheetHandler.setAllSheetNames(allSheetNames);
        sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        sheetHandler.setSharedStringsTable((SharedStringsTable)xssfReader.getSharedStringsTable());
        sheetHandler.setStylesTable(xssfReader.getStylesTable());
        XMLReader reader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setContentHandler((ContentHandler)sheetHandler);
        ReaderWay readerWay = this.getReaderWay(readerWayType, sheetHandler, reader, sheets);
        while (sheets.hasNext() && !readerWay.interrupt(sheet = sheets.next(), sheetName = sheets.getSheetName())) {
            try {
                List<String> effectSheetNames = this.importContext == null ? null : this.importContext.getEffectSheetNames();
                log.info("ExcelReader_read_effectSheetNames:{}", effectSheetNames);
                readerWay.handle(sheet, effectSheetNames, sheetName);
            }
            catch (KDBizException e) {
                sheet.close();
                if (e.getErrorCode().getCode().equals("908")) {
                    log.info(e.getMessage());
                }
                throw e;
            }
            sheet.close();
        }
        pkg.close();
    }

    private ReaderWay getReaderWay(String readerWayType, SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
        if (StringUtils.isBlank((CharSequence)readerWayType)) {
            return new CommonReaderWay(sheetHandler, parser, sheets);
        }
        switch (readerWayType.toLowerCase(Locale.ENGLISH)) {
            case "fail": {
                return new FailReaderWay(sheetHandler, parser, sheets);
            }
            case "sensitive": {
                return new SensitiveReaderWay(sheetHandler, parser, sheets);
            }
        }
        return new CommonReaderWay(sheetHandler, parser, sheets);
    }

    static class SensitiveReaderWay
    extends CommonReaderWay {
        private int count = 0;

        public SensitiveReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            super(sheetHandler, parser, sheets);
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            if (this.count++ == 0 || StringUtils.isNotBlank((CharSequence)sheetName) && StringUtils.equals((CharSequence)sheetName, (CharSequence)"sensitive_fields_sheet")) {
                super.handle(sheet, effectSheetNames, sheetName);
            }
        }
    }

    static class FailReaderWay
    extends CommonReaderWay {
        public FailReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            super(sheetHandler, parser, sheets);
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            InputSource sheetSource = new InputSource(sheet);
            String curSheetName = this.sheets.getSheetName();
            if (StringUtils.isNotBlank((CharSequence)curSheetName)) {
                this.sheetHandler.setCurrentSheetName(curSheetName);
                Comments comments = this.sheets.getSheetComments();
                if (comments != null) {
                    this.sheetHandler.addSheetComments(curSheetName, (CommentsTable)comments);
                }
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }
    }

    static class CommonReaderWay
    implements ReaderWay {
        protected SheetHandler sheetHandler;
        protected XMLReader parser;
        protected XSSFReader.SheetIterator sheets;

        public CommonReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            this.sheetHandler = sheetHandler;
            this.parser = parser;
            this.sheets = sheets;
        }

        @Override
        public void handle(InputStream sheet, List<String> effectSheetNames, String sheetName) throws Exception {
            if (sheetName.endsWith("DDM") || effectSheetNames != null && !effectSheetNames.contains(sheetName)) {
                return;
            }
            InputSource sheetSource = new InputSource(sheet);
            this.sheetHandler.setCurrentSheetName(this.sheets.getSheetName());
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                return this.sheetHandler.isInterrupt();
            }
            return true;
        }
    }

    static interface ReaderWay {
        public void handle(InputStream var1, List<String> var2, String var3) throws Exception;

        public boolean interrupt(InputStream var1, String var2);
    }
}

