/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.parse;

import java.io.File;
import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.init.EntryImportStarter;
import kd.hrmp.hies.entry.core.parse.EntryExcelImptFailedSheetHandler;
import kd.hrmp.hies.entry.core.parse.EntryExcelReader;

public class EntryReporter {
    private static final Log LOGGER = LogFactory.getLog(EntryReporter.class);
    private final EntryImportStarter entryImportStarter;

    public EntryReporter(EntryImportStarter starter) {
        this.entryImportStarter = starter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genReport() {
        LOGGER.info("EntryReport_started.");
        EntryImportContext importContext = this.entryImportStarter.getImportContext();
        try {
            File file = new File(importContext.getFileLocalPath());
            if (!file.exists()) {
                String localPatch = ImportFileUtil.downloadFile((String)importContext.getFilePath());
                importContext.setFileLocalPath(localPatch);
                file = new File(localPatch);
            }
            new EntryExcelReader(importContext).read(file, new EntryExcelImptFailedSheetHandler(importContext), "fail");
            LOGGER.info("Reporter_end.");
        }
        catch (Throwable exception) {
            LOGGER.error("Reporter-call() error:", exception);
        }
        finally {
            try {
                ImportFileUtil.deleteLocalTempFile((String)importContext.getFileLocalPath());
            }
            catch (IOException ex) {
                LOGGER.error("Reporter-deleteLocalTempFile() error:", (Throwable)ex);
            }
        }
    }
}

