/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.common.util.EntryImportUtil;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class EntryControlledBDValidator
extends InnerEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryControlledBDValidator.class);

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        BaseDataContainer baseDataContainer = this.getDataValidateParams().getBaseDataContainer();
        for (ImportBillData billData : billDataList) {
            billData.getData().values().forEach(json -> this.checkData(importLog, billData, baseDataContainer, json));
        }
    }

    private void checkData(ImportLog importLog, ImportBillData billData, BaseDataContainer baseDataContainer, Object json) {
        ((JSONObject)json).values().forEach(bdJson -> {
            String val;
            if (bdJson instanceof JSONObject) {
                String val2 = ((JSONObject)bdJson).getString("$basedataentity");
                if (StringUtils.isNotEmpty((CharSequence)val2) && baseDataContainer.getAllControlledBDPermTable().contains(val2)) {
                    this.checkControlledRefBD(importLog, billData, baseDataContainer, (JSONObject)bdJson);
                }
            } else if (bdJson instanceof JSONArray && StringUtils.isNotEmpty((CharSequence)(val = ((JSONArray)bdJson).getJSONObject(0).getString("$basedataentity"))) && baseDataContainer.getAllControlledBDPermTable().contains(val)) {
                JSONArray basedataJsonArray = (JSONArray)bdJson;
                basedataJsonArray.forEach(jsonObject -> this.checkControlledRefBD(importLog, billData, baseDataContainer, (JSONObject)jsonObject));
            }
        });
    }

    private void checkControlledRefBD(ImportLog importLog, ImportBillData billData, BaseDataContainer baseDataContainer, JSONObject basedata) {
        String baseDataEntity = basedata.getString("$basedataentity");
        List controlledBDPermIds = baseDataContainer.getControlledBDPermTable(baseDataEntity, basedata.getLong("$useOrgId"));
        if (controlledBDPermIds == null) {
            controlledBDPermIds = baseDataContainer.getControlledBDPermTable(baseDataEntity, Long.valueOf(RequestContext.get().getCurrUserId()));
            LOGGER.info("ControlledBDPermValidator_checkControlledRefBD(),currUserId:{}", (Object)RequestContext.get().getCurrUserId());
        }
        if (controlledBDPermIds != null && !controlledBDPermIds.contains(basedata.getLong("id"))) {
            LOGGER.info("EntryControlledBDValidator.checkControlledRefBD(),baseDataNum:{},useOrg:{},id:{}", new Object[]{basedata.getString("$basedataentity"), basedata.getLong("$useOrgId"), basedata.getLong("id")});
            String cellIndex = this.getCellIndex(basedata.getString("$basedataFieldKey"));
            Map<String, Map<String, Object>> bdFieldMainPropName = this.getDataValidateParams().getImportStarter().getImportContext().getBdFieldMainPropName();
            String fieldKey = MethodUtil.getLevelOneKey((String)basedata.getString("$basedataFieldKey"));
            Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
            Map<String, Map<String, String>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
            if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
                f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(fieldKey, val -> Maps.newHashMapWithExpectedSize((int)0));
            }
            Map<String, Object> fieldMainPropName = bdFieldMainPropName.get(fieldKey);
            String baseDataFormat = EntryImportUtil.getF7ImptBaseDataFormat(this.getDataValidateParams().getImportStarter().getImportContext(), fieldKey);
            DataValidateServiceHelper.writeRowErrorLog((int)7, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), this.getPutWhereKey(basedata, baseDataFormat, fieldMainPropName, billData.getData(), this.getExtF7UniqueVal(fieldKey), (Map<String, String>)f7ExtUniqueValFieldMap)});
        }
    }

    private String[] getExtF7UniqueVal(String fieldNum) {
        Map<String, String> f7UniqueValMap = this.getDataValidateParams().getF7ExtUniqueValMap();
        if (!ObjectUtils.isEmpty(f7UniqueValMap)) {
            return StringUtils.split((String)f7UniqueValMap.get(fieldNum), (String)",");
        }
        return null;
    }
}

