/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hies.common.enu.BaseInfoFormatEnum;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.dto.BaseDataWrapping;
import kd.hr.impt.core.validate.dto.DistinctionWrapping;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterF7MatchedEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.util.EntryImportUtil;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;

public final class EntryExistsValidator
extends InnerEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryExistsValidator.class);
    private final List<EnabledLang> enabledLang = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
    private FunctionSubPageService functionSubPageService = new FunctionSubPageService();
    private ImportBillData curBillData;
    private Long mainOrgValue;
    private Map<String, Map<String, Set<String>>> allRefBdSelectedAtrr = new HashMap<String, Map<String, Set<String>>>();

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        HashMap baseDataWrappingMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap refBillNoMap = Maps.newHashMapWithExpectedSize((int)16);
        BaseDataContainer baseDataContainer = this.getDataValidateParams().getBaseDataContainer();
        EntryImportContext importContext = this.getDataValidateParams().getImportStarter().getImportContext();
        JSONObject tplFieldDefValue = this.getDataValidateParams().getTplFieldDefValue();
        LOGGER.info("EntryExistsValidator.validate_tplFieldDefValue:{}", (Object)tplFieldDefValue);
        Map<String, Object> orgMap = this.getDataValidateParams().getOrgMap();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billDataList.get(0).getMainEntityId());
        Object org = orgMap.get(entityType.getMainOrg());
        if (Objects.nonNull(org)) {
            this.mainOrgValue = Long.parseLong(String.valueOf(org));
        }
        billDataList.forEach(billData -> billData.getData().forEach((key, dataJson) -> {
            Collection<IDataEntityProperty> properties = importContext.getEntryAllFields().values();
            for (IDataEntityProperty property : properties) {
                if (((JSONObject)dataJson).get((Object)property.getName()) == null) continue;
                if (property instanceof BasedataProp) {
                    this.addBaseDataWrap(baseDataWrappingMap, (JSONObject)dataJson, ((JSONObject)dataJson).getJSONObject(property.getName()), entityType, property);
                    continue;
                }
                if (property instanceof MulBasedataProp) {
                    ((JSONObject)dataJson).getJSONArray(property.getName()).forEach(dataTemp -> this.addBaseDataWrap(baseDataWrappingMap, (JSONObject)dataJson, (JSONObject)dataTemp, entityType, property));
                    continue;
                }
                if (!(property instanceof RefBillProp)) continue;
                this.iterateRefBillProp(entityType.getName(), (RefBillProp)property, (JSONObject)dataJson, refBillNoMap, this.getDataValidateParams().getBaseDataContainer());
            }
        }));
        Collection baseDataWrappingCollection = baseDataWrappingMap.values();
        baseDataWrappingCollection.stream().sorted((o1, o2) -> !(o1.getProp() instanceof OrgProp) && o2.getProp() instanceof OrgProp ? 1 : -1).forEachOrdered(baseDataWrapping -> {
            this.setControlledBDPermTable(baseDataContainer, (BaseDataWrapping)baseDataWrapping);
            this.queryBaseDataByWrap(billDataList, baseDataContainer, importContext, (BaseDataWrapping)baseDataWrapping);
        });
        refBillNoMap.entrySet().stream().forEach(entry -> {
            DistinctionWrapping distinctionWrapping = (DistinctionWrapping)entry.getKey();
            QFilter[] qFilters = ImportServiceHelper.getRefBillDefaultQFilter((DistinctionWrapping)distinctionWrapping, (Set)((Set)entry.getValue()));
            BeforeQueryRefBdEventArgs args = new BeforeQueryRefBdEventArgs(importContext);
            args.setEntityId(distinctionWrapping.getEntityId());
            args.setBaseDataName(distinctionWrapping.getBdType());
            args.setFieldId(distinctionWrapping.getFieldKey());
            args.setFilters(qFilters);
            args.setSelectFields(Sets.newHashSet((Object[])new String[]{"billno"}));
            args.setBillDataList(billDataList);
            args.setImportInvoke(true);
            HREntryImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStarter(), "beforeQueryRefBd", (EntryAbstractEventArgs)args);
            DataSet dataSet = new HRBaseServiceHelper(distinctionWrapping.getBdType()).queryDataSet("EntryExistsValidator_query_refbill", "id,billno", args.getFilters());
            ConcurrentHashMap<Object, Object> map = baseDataContainer.getBasedataIdMap().getOrDefault(distinctionWrapping.getBdType(), new ConcurrentHashMap());
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.get(1), row.get(0));
            }
            baseDataContainer.getBasedataIdMap().put(distinctionWrapping.getBdType(), map);
        });
        billDataList.forEach(billData -> {
            this.curBillData = billData;
            billData.getData().forEach((key, value) -> {
                JSONObject data = (JSONObject)value;
                Collection<IDataEntityProperty> properties = importContext.getEntryAllFields().values();
                for (IDataEntityProperty property : properties) {
                    Object propValue = data.get((Object)property.getName());
                    if (property instanceof BasedataProp && propValue != null) {
                        JSONObject baseDataJson = data.getJSONObject(property.getName());
                        this.checkBaseDataExists(importLog, baseDataContainer, (IBasedataField)((BasedataProp)property), data, baseDataJson);
                    } else if (property instanceof MulBasedataProp && propValue != null) {
                        data.getJSONArray(property.getName()).forEach(dataTemp -> this.checkBaseDataExists(importLog, baseDataContainer, (IBasedataField)((MulBasedataProp)property), data, (JSONObject)dataTemp));
                    } else if (property instanceof RefBillProp && propValue != null) {
                        this.checkRefBillExists(importLog, baseDataContainer, data, property);
                    } else if (property instanceof AdminDivisionProp && propValue != null) {
                        this.handleAdminDivision(importLog, data, property, propValue);
                    }
                    if (!"config".equals(importContext.getTplType())) continue;
                    this.handleDefValue(tplFieldDefValue, (String)key, data, entityType.getAllFields());
                }
            });
        });
    }

    private void checkRefBillExists(ImportLog importLog, BaseDataContainer baseDataContainer, JSONObject data, IDataEntityProperty property) {
        JSONObject baseDataJson = data.getJSONObject(property.getName());
        String billno = baseDataJson.getString("billno");
        ConcurrentHashMap map = (ConcurrentHashMap)baseDataContainer.getBasedataIdMap().get(((RefBillProp)property).getBillEntityId());
        if (map != null && map.get(billno) != null) {
            baseDataJson.put("$refbillentity", (Object)((RefBillProp)property).getBillEntityId());
            baseDataJson.put("id", map.get(billno));
        } else {
            int rowIndex = data.getIntValue("$excelIndex");
            String cellIndex = this.getCellIndex(property.getName());
            DataValidateServiceHelper.writeRowErrorLog((int)5, (ImportLog)importLog, (String)this.curBillData.getSheetName(), (int)this.curBillData.getStartIndex(), (int)this.curBillData.getEndIndex(), (int)rowIndex, (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), billno});
        }
    }

    private void iterateRefBillProp(String entityTypeName, RefBillProp property, JSONObject dataJson, Map<DistinctionWrapping, Set<String>> refBillNoMap, BaseDataContainer baseDataContainer) {
        String billEntityId = property.getBillEntityId();
        String propName = property.getName();
        JSONObject valueJson = dataJson.getJSONObject(propName);
        String billNo = valueJson.getString("billno");
        DistinctionWrapping key = new DistinctionWrapping(entityTypeName, billEntityId, propName);
        key.setProperty(property);
        Set<String> set = refBillNoMap.get(key);
        if (set == null) {
            refBillNoMap.put(key, Sets.newHashSet((Object[])new String[]{billNo}));
        } else if (set.add(billNo)) {
            refBillNoMap.put(key, set);
        } else if (baseDataContainer.getRefBillIdMap().get(entityTypeName) != null && !((ConcurrentHashMap)baseDataContainer.getRefBillIdMap().get(entityTypeName)).containsKey(billNo)) {
            set.add(billNo);
            refBillNoMap.put(key, set);
        }
    }

    private void handleAdminDivision(ImportLog importLog, JSONObject data, IDataEntityProperty property, Object propValue) {
        Map<String, Long> adminDivisionMap = this.getDataValidateParams().getBaseDataContainer().getAdminDivisionMap();
        if (adminDivisionMap.size() == 0) {
            String entityName = this.getDataValidateParams().getImportStarter().getImportContext().getEntityType().getName();
            List qFilters = ImportServiceHelper.getDefaultQFilter((String)entityName, (IDataEntityProperty)property, (String)"bd_admindivision", (boolean)false);
            DynamicObjectCollection collection = new HRBaseServiceHelper("bd_admindivision").queryOriginalCollection("id,fullname,country.name", qFilters.toArray(new QFilter[0]));
            adminDivisionMap = collection.stream().collect(Collectors.toMap(dy -> dy.getString(2) + "/" + dy.getString(1).replace("_", "/"), dy2 -> dy2.getLong(0), (x1, x2) -> x1));
        }
        if (adminDivisionMap.get(propValue) != null) {
            data.put(property.getName(), (Object)(propValue + "##" + adminDivisionMap.get(propValue)));
        } else {
            if (Pattern.compile("^[1-9]\\d*$").matcher(String.valueOf(propValue)).matches() && adminDivisionMap.containsValue(Long.valueOf(String.valueOf(propValue)))) {
                return;
            }
            String cellIndex = this.getCellIndex(property.getName());
            DataValidateServiceHelper.writeRowErrorLog((int)5, (ImportLog)importLog, (String)this.curBillData.getSheetName(), (int)this.curBillData.getStartIndex(), (int)this.curBillData.getEndIndex(), (int)data.getIntValue("$excelIndex"), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), propValue});
        }
    }

    private void queryBaseDataByWrap(List<ImportBillData> billDataList, BaseDataContainer baseDataContainer, EntryImportContext importContext, BaseDataWrapping baseDataWrapping) {
        String baseDataEntityNum = baseDataWrapping.getBaseDataEntityNum();
        String mainEntityNum = baseDataWrapping.getEntityType().getName();
        String fieldNum = baseDataWrapping.getProp().getName();
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, String>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(fieldNum, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        String logKey = "queryBaseDataByWrap_" + baseDataEntityNum + "&" + baseDataWrapping.getProp().getName() + "_" + System.currentTimeMillis();
        QFilter[] qFilters = baseDataWrapping.getQFiltrs(baseDataContainer);
        if (qFilters == null) {
            return;
        }
        BeforeQueryRefBdEventArgs args = new BeforeQueryRefBdEventArgs(importContext);
        args.setBaseDataName(baseDataEntityNum);
        args.setEntityId(mainEntityNum);
        args.setFieldId(fieldNum);
        args.setFilters(qFilters);
        args.setSelectFields(baseDataWrapping.getSelectFields());
        args.setBillDataList(billDataList);
        args.setSourceCondition(baseDataWrapping.getSourceCondition());
        args.setImportInvoke(true);
        HREntryImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStarter(), "beforeQueryRefBd", (EntryAbstractEventArgs)args);
        qFilters = args.getFilters();
        QFilter bdRefPermQFilters = baseDataWrapping.getBDRefPermQFilters();
        Set<String> selectFields = args.getSelectFields();
        LOGGER.info(logKey + "_BeforeQueryRefBdEvent_selectFields:{}", selectFields);
        MethodUtil.printQfilters((QFilter[])qFilters, (String)(logKey + "_BeforeQueryRefBdEvent_qFilters"));
        boolean isQueryProp = baseDataWrapping.getProp() instanceof IQueryProp;
        DataSet resultDataSet = HIESUtil.smartQueryF7((String)baseDataEntityNum, selectFields, (QFilter[])qFilters, (boolean)isQueryProp, (String)logKey);
        if (bdRefPermQFilters != null && baseDataContainer.getDataRulePermBasedata(mainEntityNum, baseDataEntityNum, fieldNum) == null) {
            MethodUtil.printQfilters((QFilter[])new QFilter[]{bdRefPermQFilters}, (String)(logKey + "_bdRefPermQFilters_"));
            DataSet dataSet = resultDataSet.copy().filter(bdRefPermQFilters.toString());
            HashSet hasPermId = Sets.newHashSetWithExpectedSize((int)16);
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                hasPermId.add(next.getLong("id"));
            }
            dataSet.close();
            baseDataContainer.addDataRulePermBasedata(mainEntityNum, baseDataEntityNum, fieldNum, (Set)hasPermId);
            LOGGER.info("EntryExistsValidator.queryBaseDataByWrap.addDataRulePermBasedata,fieldNum:{},hasPermId:{}", (Object)fieldNum, (Object)hasPermId);
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        while (resultDataSet.hasNext()) {
            Row next = resultDataSet.next();
            ids.add(next.get("id"));
        }
        LOGGER.info(logKey + "_resultDataSet_idsSize:{}", (Object)ids.size());
        if (ids.size() > 0) {
            DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)baseDataEntityNum, (Collection)baseDataWrapping.getSelectFields());
            DynamicObject[] dynamicObjects = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)type, (Boolean)true);
            LOGGER.info(logKey + "_BusinessDataReader_load_dynamicObjects_size:{}", (Object)(dynamicObjects == null ? 0 : dynamicObjects.length));
            AfterQueryRefBdEventArgs args2 = new AfterQueryRefBdEventArgs(importContext);
            args2.setBaseDataName(baseDataEntityNum);
            args2.setDatas(dynamicObjects);
            args2.setImportInvoke(true);
            HREntryImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStarter(), "AfterQueryRefBd", (EntryAbstractEventArgs)args2);
            dynamicObjects = args2.getDatas();
            LOGGER.info(logKey + "_AfterQueryRefBdEventArgs_dynamicObjects_size:{}", (Object)(dynamicObjects == null ? 0 : dynamicObjects.length));
            if (dynamicObjects != null) {
                Map<String, Map<String, Object>> bdFieldMainPropName = importContext.getBdFieldMainPropName();
                Map<String, Object> fieldMainPropName = bdFieldMainPropName.get(fieldNum);
                String baseDataFormat = EntryImportUtil.getF7ImptBaseDataFormat(importContext, fieldNum);
                String customKey = isQueryProp ? baseDataWrapping.getHRControlQueryKey("") : "";
                Map finalF7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap;
                Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> this.getPutWhereKey((DynamicObject)dy, customKey, baseDataFormat, fieldMainPropName, this.getExtF7UniqueVal(fieldNum), (Map<String, String>)finalF7ExtUniqueValFieldMap))).forEach((key, value) -> {
                    baseDataContainer.addBaseDataDy(mainEntityNum, baseDataEntityNum, fieldNum, key, value);
                    LOGGER.info(logKey + "_mainEntityNum:{},key:{},valueSize:{}", new Object[]{mainEntityNum, key, value.size()});
                });
            }
        }
        resultDataSet.close();
    }

    private void setControlledBDPermTable(BaseDataContainer baseDataContainer, BaseDataWrapping baseDataWrapping) {
        if (baseDataWrapping.isBaseDataCtrl()) {
            Set useOrgValueSet = baseDataWrapping.getUseOrgValue();
            LOGGER.info("EntryExistsValidator_getControlledBDPerm(),BaseDataEntityNum:{},useOrgValueSet:{}", (Object)baseDataWrapping.getBaseDataEntityNum(), (Object)useOrgValueSet);
            if (useOrgValueSet == null || useOrgValueSet.size() == 0) {
                return;
            }
            useOrgValueSet.forEach(useOrgValue -> {
                String useOrgValueTemp;
                String string = useOrgValueTemp = useOrgValue == null ? null : String.valueOf(useOrgValue);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)useOrgValueTemp) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)baseDataWrapping.getUseOrgFieldKey())) {
                    QFilter dataRuleForBdProp = DataValidateServiceHelper.getDataRuleForBdProp((String)baseDataWrapping.getEntityType().getName(), (String)baseDataWrapping.getEntityType().getAppId(), (String)baseDataWrapping.getUseOrgFieldKey(), (String)"47150e89000000ac");
                    if (dataRuleForBdProp == null) {
                        LOGGER.info("EntryExistsValidator_getControlledBDPerm()_has all perm");
                        return;
                    }
                    DataSet dataSet = new HRBaseServiceHelper("bos_org").queryDataSet("EntryExistsValidator.setControlledBDPermTable", "id", new QFilter[]{dataRuleForBdProp});
                    ArrayList orgID = Lists.newArrayListWithExpectedSize((int)16);
                    while (dataSet.hasNext()) {
                        orgID.add(dataSet.next().getLong(0));
                    }
                    QFilter baseDataQFilter = DataValidateServiceHelper.getBaseDataQFilter((String)baseDataWrapping.getBaseDataEntityNum(), (List)orgID, (boolean)true);
                    DynamicObject[] results = new HRBaseServiceHelper(baseDataWrapping.getBaseDataEntityNum()).queryOriginalArray("id", new QFilter[]{baseDataQFilter});
                    List collect = Arrays.stream(results).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    long currUserId = RequestContext.get().getCurrUserId();
                    baseDataContainer.setControlledBDPermTable(baseDataWrapping.getBaseDataEntityNum(), Long.valueOf(currUserId), collect);
                    LOGGER.info("EntryExistsValidator_setControlledBDPermTable(),BaseDataEntityNum:{},currUserId:{},results:{}", new Object[]{baseDataWrapping.getBaseDataEntityNum(), currUserId, collect});
                    return;
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)useOrgValueTemp)) {
                    return;
                }
                Long id = Long.valueOf(useOrgValueTemp);
                if (id != 0L && baseDataContainer.getControlledBDPermTable(baseDataWrapping.getBaseDataEntityNum(), id) == null) {
                    QFilter baseDataQFilter = (QFilter)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IBaseDataService", (String)"getBaseDataFilter", (Object[])new Object[]{baseDataWrapping.getBaseDataEntityNum(), id});
                    LOGGER.info("EntryExistsValidator_getControlledBDPerm(),BaseDataEntityNum:{},baseDataQFilter:{}", (Object)baseDataWrapping.getBaseDataEntityNum(), (Object)baseDataQFilter);
                    DynamicObject[] results = new HRBaseServiceHelper(baseDataWrapping.getBaseDataEntityNum()).queryOriginalArray("id", new QFilter[]{baseDataQFilter});
                    List collect = Arrays.stream(results).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    if (collect.size() == 0) {
                        collect.add(-2L);
                    }
                    baseDataContainer.setControlledBDPermTable(baseDataWrapping.getBaseDataEntityNum(), id, collect);
                    LOGGER.info("EntryExistsValidator_getControlledBDPerm(),BaseDataEntityNum:{},useOrg:{},results:{}", new Object[]{baseDataWrapping.getBaseDataEntityNum(), id, collect});
                }
            });
        }
    }

    private void checkBaseDataExists(ImportLog importLog, BaseDataContainer baseDataContainer, IBasedataField property, JSONObject baseDataParentJson, JSONObject baseDataJson) {
        Object putWhereKey;
        EntryImportContext importContext = this.getDataValidateParams().getImportStarter().getImportContext();
        Map<String, Map<String, Object>> bdFieldMainPropName = importContext.getBdFieldMainPropName();
        Map<String, Object> fieldMainPropName = bdFieldMainPropName.get(property.getName());
        String baseDataFormat = EntryImportUtil.getF7ImptBaseDataFormat(importContext, property.getName());
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, String>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(property.getName(), val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        if ((putWhereKey = this.getPutWhereKey(baseDataJson, baseDataFormat, fieldMainPropName, baseDataParentJson, this.getExtF7UniqueVal(MethodUtil.getLevelOneKey((String)property.getName())), (Map<String, String>)f7ExtUniqueValFieldMap)) == null) {
            return;
        }
        String baseDataEntityId = baseDataJson.getString("$basedataentity");
        List<DynamicObject> baseDataDys = baseDataContainer.getBaseDataDy(importContext.getEntityType().getName(), baseDataEntityId, property.getName(), putWhereKey);
        if (ObjectUtils.isEmpty((Object)baseDataDys) || baseDataDys.size() > 1) {
            AfterF7MatchedEventArgs args = new AfterF7MatchedEventArgs(importContext);
            args.setFieldId(property.getName());
            args.setCurrentF7Key(putWhereKey);
            args.setBaseDataDys(baseDataDys);
            args.setF7QueryDataMap(baseDataContainer.getBaseDataDyMap(importContext.getEntityType().getName(), baseDataEntityId, property.getName()));
            HREntryImpPluginEngine.fireImptPluginEvent(this.getDataValidateParams().getImportStarter(), "AfterF7Matched", (EntryAbstractEventArgs)args);
            baseDataDys = args.getBaseDataDys();
        }
        int rowIndex = this.curBillData.getStartIndex();
        String fieldKey = this.getFieldKey(property.getName(), baseDataFormat, fieldMainPropName);
        if (ObjectUtils.isEmpty((Object)baseDataDys)) {
            if (property instanceof ItemClassProp && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)baseDataEntityId)) {
                String cellIndex = this.getCellIndex(((ItemClassProp)property).getTypePropName());
                DataValidateServiceHelper.writeRowErrorLog((int)30, (ImportLog)importLog, (String)this.curBillData.getSheetName(), (int)this.curBillData.getStartIndex(), (int)this.curBillData.getEndIndex(), (int)rowIndex, (Object[])new Object[]{cellIndex, this.getCellName(cellIndex)});
            } else {
                String cellIndex = this.getCellIndex(fieldKey);
                DataValidateServiceHelper.writeRowErrorLog((int)5, (ImportLog)importLog, (String)this.curBillData.getSheetName(), (int)this.curBillData.getStartIndex(), (int)this.curBillData.getEndIndex(), (int)rowIndex, (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), putWhereKey});
            }
        } else if (baseDataDys.size() > 1) {
            if (BaseDataServiceHelper.checkBaseDataCtrl((String)baseDataEntityId).booleanValue()) {
                List collect;
                String useOrgKey;
                Map<String, Object> orgMap = this.getDataValidateParams().getOrgMap();
                Object useOrgId = orgMap.get(useOrgKey = property.getOrgProp());
                if (useOrgId == null || Long.parseLong(String.valueOf(useOrgId)) == 0L) {
                    baseDataJson.put("$useOrgId", (Object)this.mainOrgValue);
                    useOrgId = this.mainOrgValue;
                } else {
                    baseDataJson.put("$useOrgId", (Object)Long.parseLong(String.valueOf(useOrgId)));
                }
                List controlledBDPermTable = useOrgId == null ? null : baseDataContainer.getControlledBDPermTable(baseDataEntityId, Long.valueOf(Long.parseLong(String.valueOf(useOrgId))));
                if (controlledBDPermTable != null && controlledBDPermTable.size() > 0 && (collect = baseDataDys.stream().filter(dy -> controlledBDPermTable.contains(dy.getLong("id"))).collect(Collectors.toList())).size() == 1) {
                    this.setBaseDataF7Json(property, baseDataJson, baseDataEntityId, baseDataDys, fieldKey);
                    return;
                }
            }
            String cellIndex = this.getCellIndex(fieldKey);
            DataValidateServiceHelper.writeRowErrorLog((int)6, (ImportLog)importLog, (String)this.curBillData.getSheetName(), (int)rowIndex, (int)this.curBillData.getEndIndex(), (int)rowIndex, (Object[])new Object[]{cellIndex, this.getCellName(cellIndex), putWhereKey});
        } else {
            this.setBaseDataF7Json(property, baseDataJson, baseDataEntityId, baseDataDys, fieldKey);
        }
    }

    private void setBaseDataF7Json(IBasedataField property, JSONObject baseDataJson, String baseEntityId, List<DynamicObject> baseDataDys, String fieldKey) {
        baseDataJson.put("$basedataentity", (Object)baseEntityId);
        DynamicObject dynamicObject = baseDataDys.get(0);
        baseDataJson.put("id", dynamicObject.get("id"));
        if (ImportServiceHelper.hasHis((String)baseEntityId)) {
            baseDataJson.put("boid", dynamicObject.get("boid"));
        }
        baseDataJson.put("$basedataFieldKey", (Object)fieldKey);
        Map<String, Object> orgMap = this.getDataValidateParams().getOrgMap();
        String useOrgKey = property.getOrgProp();
        Object useOrgId = orgMap.get(useOrgKey);
        if (useOrgId == null || Long.parseLong(String.valueOf(useOrgId)) == 0L) {
            baseDataJson.put("$useOrgId", (Object)this.mainOrgValue);
        } else {
            baseDataJson.put("$useOrgId", useOrgId);
        }
    }

    private void addBaseDataWrap(Map<String, BaseDataWrapping> baseDataWrappingMap, JSONObject rowJson, JSONObject svalueJson, MainEntityType entityType, IDataEntityProperty property) {
        JSONObject valueJson = svalueJson.clone();
        Map<String, Map<String, Object>> bdFieldMainPropName = this.getDataValidateParams().getImportStarter().getImportContext().getBdFieldMainPropName();
        Map<String, Object> fieldMainPropName = bdFieldMainPropName.get(property.getName());
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, String>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(property.getName(), val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        EntryImportContext importContext = this.getDataValidateParams().getImportStarter().getImportContext();
        String baseDataFormat = EntryImportUtil.getF7ImptBaseDataFormat(importContext, property.getName());
        if (BaseInfoFormatEnum.NUMBER.getCode().equalsIgnoreCase(baseDataFormat) && !fieldMainPropName.get(BaseInfoFormatEnum.NUMBER.getCode()).equals(fieldMainPropName.get(BaseInfoFormatEnum.NAME.getCode()))) {
            valueJson.remove(fieldMainPropName.get(BaseInfoFormatEnum.NAME.getCode()));
        }
        if (valueJson.isEmpty()) {
            return;
        }
        Map<String, Object> orgMap = this.getDataValidateParams().getOrgMap();
        String baseEntityId = this.handleMulClassBD(rowJson, entityType, property);
        svalueJson.put("$basedataentity", (Object)baseEntityId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)baseEntityId)) {
            return;
        }
        String bdkey = entityType.getName() + '&' + baseEntityId + '&' + property.getName();
        BaseDataWrapping baseDataWrapping = baseDataWrappingMap.get(bdkey);
        String[] extF7UniqueVal = this.getExtF7UniqueVal(property.getName());
        JSONObject valueJsonClone = this.addExtF7UniqueVal(valueJson, rowJson, extF7UniqueVal, f7ExtUniqueValFieldMap);
        if (baseDataWrapping != null) {
            baseDataWrapping.getWhereMap().put(this.getPutWhereKey(valueJson, baseDataFormat, fieldMainPropName, rowJson, extF7UniqueVal, (Map<String, String>)f7ExtUniqueValFieldMap), valueJsonClone);
            this.addSourceCondition(rowJson, valueJsonClone, baseDataWrapping);
            String useOrgFieldKey = ((IBasedataField)property).getOrgProp();
            Object useOrg = "";
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)useOrgFieldKey) || orgMap.get(useOrgFieldKey) != null && Long.parseLong(String.valueOf(orgMap.get(useOrgFieldKey))) == 0L) {
                Object org = orgMap.get(entityType.getMainOrg());
                if (Objects.nonNull(org)) {
                    useOrg = org;
                }
            } else {
                Object org = orgMap.get(useOrgFieldKey);
                if (Objects.nonNull(org)) {
                    useOrg = org;
                }
            }
            LOGGER.info("EntryExistsValidator_add_BaseDataWrapping,baseEntityId:{},Org:{}", (Object)baseEntityId, (Object)useOrgFieldKey);
            baseDataWrapping.setUseOrgValue(useOrg);
        } else {
            Object putWhereKey = this.getPutWhereKey(valueJson, baseDataFormat, fieldMainPropName, rowJson, extF7UniqueVal, (Map<String, String>)f7ExtUniqueValFieldMap);
            if (putWhereKey == null) {
                return;
            }
            Set<String> defaultF7SelectFields = this.getF7SelectFields(entityType, property);
            this.addF7ExtUniqueField(defaultF7SelectFields, property.getName());
            baseDataWrapping = new BaseDataWrapping((IBasedataField)property, defaultF7SelectFields, baseDataFormat);
            baseDataWrapping.setAppId(importContext.getAppId());
            baseDataWrapping.setMainFormId(importContext.getMainFormId());
            baseDataWrapping.setEntityType(entityType);
            baseDataWrapping.setBaseDataEntityNum(baseEntityId);
            baseDataWrapping.putWhere(putWhereKey, valueJsonClone);
            this.addSourceCondition(rowJson, valueJsonClone, baseDataWrapping);
            baseDataWrapping.setBaseDataCtrl(BaseDataServiceHelper.checkBaseDataCtrl((String)baseEntityId).booleanValue());
            if (!((IBasedataField)property).isShowUsed()) {
                baseDataWrapping.setAllowDisableData(true);
            }
            baseDataWrapping.setExtF7UniqueVal(extF7UniqueVal);
            String useOrgFieldKey = ((IBasedataField)property).getOrgProp();
            LOGGER.info("EntryExistsValidator_new_BaseDataWrapping,bdkey:{},Org:{}", (Object)bdkey, (Object)useOrgFieldKey);
            Object useOrg = "";
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)useOrgFieldKey) || orgMap.get(useOrgFieldKey) != null && Long.parseLong(String.valueOf(orgMap.get(useOrgFieldKey))) == 0L) {
                useOrgFieldKey = entityType.getMainOrg();
                Object org = orgMap.get(entityType.getMainOrg());
                if (Objects.nonNull(org)) {
                    useOrg = org;
                }
                LOGGER.info("EntryExistsValidator_new_BaseDataWrapping,bdkey:{},MainOrg:{}", (Object)bdkey, (Object)useOrgFieldKey);
            } else {
                Object org = orgMap.get(useOrgFieldKey);
                if (Objects.nonNull(org)) {
                    useOrg = org;
                }
            }
            baseDataWrapping.setUseOrgFieldKey(useOrgFieldKey);
            baseDataWrapping.setUseOrgValue(useOrg);
            baseDataWrappingMap.put(bdkey, baseDataWrapping);
        }
    }

    private Set<String> getF7SelectFields(MainEntityType entityType, IDataEntityProperty property) {
        HashSet defaultF7SelectFields;
        String baseEntityId = ((IBasedataField)property).getBaseEntityId();
        if (property instanceof IQueryProp) {
            defaultF7SelectFields = Sets.newHashSet((Object[])new String[]{"id"});
            Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)baseEntityId);
            defaultF7SelectFields.add((String)hrPersonMainProp.get("number"));
            defaultF7SelectFields.add((String)hrPersonMainProp.get("name"));
            this.addF7SelectFields(defaultF7SelectFields, this.allRefBdSelectedAtrr, entityType.getName(), property.getName());
        } else {
            defaultF7SelectFields = Sets.newHashSet((Object[])"id,status,enable".split(","));
            Map<String, Map<String, Object>> bdFieldMainPropName = this.getDataValidateParams().getImportStarter().getImportContext().getBdFieldMainPropName();
            Map<String, Object> fieldMainPropName = bdFieldMainPropName.get(property.getName());
            String realName = (String)fieldMainPropName.get("name");
            String realNumber = (String)fieldMainPropName.get("number");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)realName)) {
                defaultF7SelectFields.add(realName);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)realNumber)) {
                defaultF7SelectFields.add(realNumber);
            }
            this.addF7SelectFields(defaultF7SelectFields, this.allRefBdSelectedAtrr, entityType.getName(), property.getName());
        }
        if (ImportServiceHelper.hasHis((String)baseEntityId)) {
            defaultF7SelectFields.add("boid");
        }
        return defaultF7SelectFields;
    }

    private String handleMulClassBD(JSONObject rowJson, MainEntityType entityType, Object property) {
        String baseEntityId = ((IBasedataField)property).getBaseEntityId();
        if (property instanceof ItemClassProp) {
            String typePropName = ((ItemClassProp)property).getTypePropName();
            String typeValue = rowJson.getString(typePropName);
            if (StringUtils.isBlank((CharSequence)typeValue)) {
                return "";
            }
            List comboItems = ((ItemClassTypeProp)entityType.getAllFields().get(typePropName)).getComboItems();
            Optional<ValueMapItem> optional = comboItems.stream().filter(comboItem -> comboItem.getName().getLocaleValue().equals(typeValue)).findFirst();
            if (optional.isPresent()) {
                baseEntityId = optional.get().getValue();
            }
        }
        return baseEntityId;
    }

    private void addF7SelectFields(Set<String> defaultF7SelectFields, Map<String, Map<String, Set<String>>> allRefBdSelectedAtrr, String entityName, String propName) {
        Set sets;
        Map keysRefBdSelectedAtrr = allRefBdSelectedAtrr.get(entityName);
        if (keysRefBdSelectedAtrr == null) {
            keysRefBdSelectedAtrr = MethodUtil.getAllRefBdSelectedAtrr((String)entityName);
            Set strings = (Set)keysRefBdSelectedAtrr.get(propName);
            if (Objects.nonNull(strings)) {
                defaultF7SelectFields.addAll(strings);
            }
            this.allRefBdSelectedAtrr.put(entityName, keysRefBdSelectedAtrr);
        }
        if ((sets = (Set)keysRefBdSelectedAtrr.get(propName)) != null) {
            defaultF7SelectFields.addAll(sets);
        }
    }

    private void addSourceCondition(JSONObject rowJson, JSONObject valueJson, BaseDataWrapping baseDataWrapping) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("data", rowJson);
        HashMap map1 = Maps.newHashMapWithExpectedSize((int)3);
        for (Map.Entry entryTemp : valueJson.entrySet()) {
            String key = (String)entryTemp.getKey();
            if ("$bdSplit".equals(key)) continue;
            if (baseDataWrapping.isHRPersonProp()) {
                Map hrPersonMainProp = MethodUtil.getHRPersonMainProp((String)baseDataWrapping.getBaseDataEntityNum());
                key = (String)hrPersonMainProp.get(key);
            }
            map1.put(key, entryTemp.getValue());
        }
        map.put("val", map1);
        baseDataWrapping.getSourceCondition().add(map);
    }

    private DataSet queryHrPersonF7(String baseDataEntityNum, Set<String> selectFields, QFilter[] qFilters) {
        if ("hrpi_depempf7query".equalsIgnoreCase(baseDataEntityNum)) {
            selectFields.add("adminorg.id");
            selectFields.add("adminorg");
        }
        return new HRBaseServiceHelper(baseDataEntityNum).queryMultiEntityDataSet(String.join((CharSequence)",", selectFields), qFilters, "", false, 0, 0);
    }

    private void handleDefValue(JSONObject tplFieldDefValue, String key, JSONObject dataJson, Map<String, IDataEntityProperty> allFieldMap) {
        JSONObject fieldDef = tplFieldDefValue.getJSONObject(key);
        if (fieldDef != null && dataJson != null) {
            HashMap defaultValMap = Maps.newHashMap();
            StringBuilder errorMsg = new StringBuilder();
            if (fieldDef != null) {
                fieldDef.forEach((fieldNumber, defValue) -> {
                    if (defValue.toString().contains("$dynamicFlag_")) {
                        this.handleDynamicDefValue(dataJson, allFieldMap, defaultValMap, errorMsg, (String)fieldNumber, defValue);
                    } else {
                        dataJson.put(fieldNumber, defValue);
                    }
                });
            }
        }
    }

    private void handleDynamicDefValue(JSONObject entryDataJson, Map<String, IDataEntityProperty> allFieldMap, Map<String, Object> defaultValMap, StringBuilder errorMsg, String fieldNumber, Object function) {
        defaultValMap.clear();
        errorMsg.reverse();
        String valueTemp = function.toString().replace("$dynamicFlag_", "");
        IDataEntityProperty prop = allFieldMap.get(fieldNumber);
        if (prop instanceof MuliLangTextProp) {
            JSONObject valueJson = new JSONObject();
            for (EnabledLang lang : this.enabledLang) {
                String langNumber = lang.getNumber();
                boolean flag = false;
                for (Map.Entry entryTemp : entryDataJson.entrySet()) {
                    if (!valueTemp.contains("$" + (String)entryTemp.getKey() + "$")) continue;
                    if (entryTemp.getValue() instanceof JSONObject && ((JSONObject)entryTemp.getValue()).get((Object)langNumber) != null) {
                        defaultValMap.put((String)entryTemp.getKey(), ((JSONObject)entryTemp.getValue()).get((Object)langNumber));
                        continue;
                    }
                    if (entryTemp.getValue() instanceof String) {
                        defaultValMap.put((String)entryTemp.getKey(), entryTemp.getValue());
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                Object executeResult = this.functionSubPageService.preExecuteExpr(valueTemp, defaultValMap, errorMsg, ReportFunctionExecuteService.class.getName());
                if (executeResult == null && errorMsg.length() > 0) {
                    LOGGER.info("ExistsValidator.handleDefValue_fieldNumber:{},error:{}", (Object)fieldNumber, (Object)errorMsg);
                    continue;
                }
                valueJson.put(langNumber, (Object)String.valueOf(executeResult));
            }
            entryDataJson.put(fieldNumber, (Object)valueJson);
        } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
            for (Map.Entry entryTemp : entryDataJson.entrySet()) {
                if (!valueTemp.contains("." + (String)entryTemp.getKey() + ".")) continue;
                entryDataJson.put(fieldNumber, entryTemp.getValue());
                break;
            }
        } else {
            Object executeResult;
            if (entryDataJson != null) {
                for (Map.Entry entryTemp : entryDataJson.entrySet()) {
                    if (!valueTemp.contains((CharSequence)entryTemp.getKey())) continue;
                    defaultValMap.put(valueTemp.replace("$", ""), entryTemp.getValue());
                }
            }
            if ((executeResult = this.functionSubPageService.preExecuteExpr(valueTemp, defaultValMap, errorMsg, ReportFunctionExecuteService.class.getName())) == null && errorMsg.length() > 0) {
                LOGGER.info("ExistsValidator.handleDefValue_fieldNumber:{},error:{}", (Object)fieldNumber, (Object)errorMsg);
            } else {
                entryDataJson.put(fieldNumber, executeResult);
            }
        }
    }

    private void addF7ExtUniqueField(Set<String> defaultF7SelectFields, String fieldNum) {
        Object[] extF7UniqueVal = this.getExtF7UniqueVal(fieldNum);
        if (!ObjectUtils.isEmpty((Object[])extF7UniqueVal)) {
            Collections.addAll(defaultF7SelectFields, extF7UniqueVal);
        }
    }

    private String[] getExtF7UniqueVal(String fieldNum) {
        Map<String, String> f7UniqueValMap = this.getDataValidateParams().getF7ExtUniqueValMap();
        if (!ObjectUtils.isEmpty(f7UniqueValMap)) {
            return org.apache.commons.lang3.StringUtils.split((String)f7UniqueValMap.get(fieldNum), (String)",");
        }
        return null;
    }

    private JSONObject addExtF7UniqueVal(JSONObject valueJson, JSONObject billJson, String[] extF7UniqueVal, Map<String, String> f7ExtUniqueValFieldMap) {
        JSONObject clone = valueJson.clone();
        if (!ObjectUtils.isEmpty((Object[])extF7UniqueVal) && !ObjectUtils.isEmpty((Object)billJson)) {
            for (String ext : extF7UniqueVal) {
                if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap) && f7ExtUniqueValFieldMap.containsKey(ext)) {
                    String ext2 = f7ExtUniqueValFieldMap.get(ext);
                    clone.put(ext, billJson.get((Object)ext2));
                    continue;
                }
                clone.put(ext, billJson.get((Object)ext));
            }
        }
        return clone;
    }
}

