/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import kd.hrmp.hies.entry.core.validate.InnerEntryValidateHandler;
import org.apache.commons.lang3.StringUtils;

public final class EntryMustFillInValidator
extends InnerEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(EntryMustFillInValidator.class);

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        Map<String, List<IDataEntityProperty>> entityToFields = this.getDataValidateParams().getEntity2MustFillInFields();
        for (ImportBillData billData : billDataList) {
            JSONObject data = billData.getData();
            data.forEach((key, value) -> this.getErrCollect(importLog, billData, (JSONObject)value, (Collection)entityToFields.get(key)));
        }
    }

    private void getErrCollect(ImportLog importLog, ImportBillData billData, JSONObject rowJSON, Collection<IDataEntityProperty> mustFillFields) {
        if (mustFillFields == null) {
            return;
        }
        mustFillFields.remove(null);
        mustFillFields.forEach(fieldProp -> {
            String fieldKey = fieldProp.getName();
            List<String> ignoreValidateField = this.getDataValidateParams().getIgnoreValidateField();
            if (CollectionUtils.isNotEmpty(ignoreValidateField) && ignoreValidateField.contains(fieldKey)) {
                return;
            }
            if (fieldKey.endsWith(".id")) {
                fieldKey = fieldKey.replace(".", "_");
            } else if (fieldKey.equals("id")) {
                fieldKey = this.getDataValidateParams().getImportStarter().getImportContext().getEntryKey() + "_id";
            }
            if (!rowJSON.containsKey((Object)fieldKey) || Objects.isNull(rowJSON.get((Object)fieldKey))) {
                if (fieldProp instanceof MuliLangTextProp) {
                    fieldKey = fieldKey.concat(".").concat(Lang.get().toString());
                }
                String cellIndex = this.getCellIndex(fieldKey);
                DataValidateServiceHelper.writeRowErrorLog((int)0, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex)});
            } else if (fieldProp instanceof MuliLangTextProp && StringUtils.isBlank((CharSequence)rowJSON.getJSONObject(fieldProp.getName()).getString(Lang.get().toString()))) {
                fieldKey = fieldKey.concat(".").concat(Lang.get().toString());
                String cellIndex = this.getCellIndex(fieldKey);
                DataValidateServiceHelper.writeRowErrorLog((int)0, (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{cellIndex, this.getCellName(cellIndex)});
            }
        });
        this.checkRangeFields(billData, importLog, 12, this.getDataValidateParams().getDateRangeFields(), rowJSON);
        this.checkRangeFields(billData, importLog, 15, this.getDataValidateParams().getTimeRangeFields(), rowJSON);
    }

    private void checkRangeFields(ImportBillData billData, ImportLog importLog, int errType, Map<String, String> rangeFields, JSONObject dataJson) {
        if (rangeFields == null) {
            return;
        }
        rangeFields.forEach((key, value) -> {
            if (dataJson.containsKey(key) && !dataJson.containsKey(value)) {
                int rowIndex = billData.getStartIndex();
                String cellIndex = this.getCellIndex((String)value);
                DataValidateServiceHelper.writeRowErrorLog((int)errType, (ImportLog)importLog, (String)billData.getSheetName(), (int)rowIndex, (int)billData.getEndIndex(), (int)rowIndex, (Object[])new Object[]{cellIndex, this.getCellName(cellIndex)});
            } else if (!dataJson.containsKey(key) && dataJson.containsKey(value)) {
                int rowIndex = billData.getStartIndex();
                String cellIndex = this.getCellIndex((String)key);
                DataValidateServiceHelper.writeRowErrorLog((int)(errType + 1), (ImportLog)importLog, (String)billData.getSheetName(), (int)rowIndex, (int)billData.getEndIndex(), (int)rowIndex, (Object[])new Object[]{cellIndex, this.getCellName(cellIndex)});
            } else {
                this.compareDateOrTime(billData, importLog, errType, dataJson, (String)key, (String)value);
            }
        });
    }

    private void compareDateOrTime(ImportBillData billData, ImportLog importLog, int errType, JSONObject dataJson, String key, String value) {
        try {
            if (dataJson.containsKey((Object)key) && dataJson.containsKey((Object)value)) {
                if (errType == 12 && ((Timestamp)dataJson.getTimestamp(key)).after((Timestamp)dataJson.getTimestamp(value))) {
                    DataValidateServiceHelper.writeRowErrorLog((int)(errType + 2), (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{this.getCellIndex(key), this.getCellIndex(value)});
                } else if (errType == 15 && LocalTime.parse(dataJson.getString(key)).isAfter(LocalTime.parse(dataJson.getString(value)))) {
                    DataValidateServiceHelper.writeRowErrorLog((int)(errType + 2), (ImportLog)importLog, (String)billData.getSheetName(), (int)billData.getStartIndex(), (int)billData.getEndIndex(), (int)billData.getStartIndex(), (Object[])new Object[]{this.getCellIndex(key), this.getCellIndex(value)});
                }
            }
        }
        catch (Exception exception) {
            LOGGER.info("EntryMustFillInValidator.compareDateOrTime(),error:{}", (Object)exception.getMessage());
        }
    }
}

