/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.core.validate.AbstractTemplateValidator;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.business.templateConf.EntryTplApplyScopeServiceHelper;
import kd.hrmp.hies.entry.common.plugin.EntryAbstractEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterTemplateValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImpPluginEngine;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import org.apache.commons.lang3.StringUtils;

public final class EntryTemplateValidator
extends AbstractTemplateValidator {
    private final String firstSheetName;
    private final String pageMainEntityNum;
    private final String entryKey;
    private int startRowNum = 5;
    private String defautBaseinfoformat;
    private Map<String, String> f7formatCfg;
    private IFormView iFormView;

    public EntryTemplateValidator(String firstSheetName, String pageMainEntityNum, String entryKey, int startRowNum, String defautBaseinfoformat, Map<String, String> f7formatCfg, IFormView iFormView) {
        this.firstSheetName = firstSheetName;
        this.pageMainEntityNum = pageMainEntityNum;
        this.entryKey = entryKey;
        this.startRowNum = startRowNum;
        this.defautBaseinfoformat = defautBaseinfoformat;
        this.f7formatCfg = f7formatCfg;
        this.iFormView = iFormView;
    }

    public static String fireAfterTemplateValidateEvent(Collection<String> entryFields, String errorMsg, String extParam, List<HREntryImportPlugin> templatePlugins, String entityId, String entryKey, IFormView formView, String tplType) {
        AfterTemplateValidateEventArgs args = new AfterTemplateValidateEventArgs(extParam, null, entityId, entryKey, formView, formView.getModel(), tplType);
        args.setEntryFields(entryFields);
        args.setErrorMsg(errorMsg);
        HREntryImpPluginEngine.fireImptPluginEvent(templatePlugins, "afterTemplateValidate", (EntryAbstractEventArgs)args);
        return args.getErrorMsg();
    }

    public String validate(Map<Integer, Collection<String>> data, List<String> ignoreValidateField, Collection<String> entryFields, DynamicObject entryTpl) {
        StringBuilder errMsg = new StringBuilder();
        ArrayList errInfo = Lists.newArrayList();
        String mainEntityNum = HIESUtil.getSplitValue((String)data.get(0).stream().findFirst().orElse(""));
        boolean isHasTemplate = this.pageMainEntityNum.equalsIgnoreCase(mainEntityNum);
        if (!isHasTemplate) {
            boolean flag;
            DynamicObject dynamicObject;
            QFilter qFilter;
            if (entryTpl == null) {
                this.addErrMsg("0", errMsg, this.firstSheetName, 1, Lists.newArrayList((Object[])new String[]{mainEntityNum}));
                return errMsg.toString();
            }
            if (!entryTpl.getBoolean("enable")) {
                this.addErrMsg("-6", errMsg, this.firstSheetName, 1, Lists.newArrayList((Object[])new String[]{mainEntityNum}));
                return errMsg.toString();
            }
            String templateNumber = entryTpl.getString("number");
            if (!this.pageMainEntityNum.equals(entryTpl.getString("entity.number"))) {
                this.addErrMsg("-3", errMsg, "", 0, Lists.newArrayList((Object[])new String[]{mainEntityNum}));
                return errMsg.toString();
            }
            if (!"full".equalsIgnoreCase(entryTpl.getString("source")) && (qFilter = EntryTplApplyScopeServiceHelper.getCurrentUserTemplate()) != null && (dynamicObject = HRBaseServiceHelper.create((String)"hies_entry_tpl").queryOriginalOne("id", qFilter.and(new QFilter("number", "=", (Object)templateNumber)))) == null) {
                errInfo.add(templateNumber);
                this.addErrMsg("-4", errMsg, "", 0, errInfo);
                return errMsg.toString();
            }
            data.get(1).forEach(key -> {
                if (!this.entryKey.equals(key = HIESUtil.getSplitValue((String)key))) {
                    errInfo.add(key);
                }
            });
            this.addErrMsg("6", errMsg, this.firstSheetName, 2, errInfo);
            boolean bl = flag = errInfo.size() > 0;
            if (flag) {
                return errMsg.toString();
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.pageMainEntityNum);
            Map allFields = mainType.getAllFields();
            List bdFields = allFields.values().stream().filter(iDataEntityProperty -> iDataEntityProperty instanceof BasedataProp || iDataEntityProperty instanceof MulBasedataProp).collect(Collectors.toList());
            Map tplFieldConfig = HIESUtil.getTplFieldConfig((DynamicObject)entryTpl);
            DynamicObjectCollection fieldEntryCollection = entryTpl.getDynamicObjectCollection("tpltreeentryentity");
            Map<String, List<DynamicObject>> entityToFields = fieldEntryCollection.stream().filter(field -> field.getBoolean("isfield")).collect(Collectors.groupingBy(dy -> dy.getString("childentity")));
            Collection<String> fieldCollection = data.get(3);
            entryFields.addAll(fieldCollection);
            if (entityToFields.get(this.pageMainEntityNum) != null) {
                entityToFields.get(this.pageMainEntityNum).stream().filter(dy -> dy.getBoolean("ismustinput") && dy.getBoolean("isimport")).forEach(mustInputFieldDy -> {
                    String mustInputField = mustInputFieldDy.getString("fieldnumber");
                    mustInputField = mustInputField.replace(this.entryKey + ".id", this.entryKey + "_id");
                    if (!CollectionUtils.isEmpty((Collection)ignoreValidateField) && ignoreValidateField.contains(mustInputField)) {
                        return;
                    }
                    IDataEntityProperty fieldProp = (IDataEntityProperty)allFields.get(mustInputField);
                    String bdFormat = mustInputFieldDy.getString("imptattr");
                    String fieldSuffix = this.getFieldSuffix(bdFormat, fieldProp);
                    if (this.hasMustFillFieldContains(fieldSuffix, fieldCollection, mustInputField)) {
                        if (fieldProp == null) {
                            return;
                        }
                        String mustInputFieldName = fieldProp.getDisplayName().getLocaleValue();
                        errInfo.add(mustInputField.concat(fieldSuffix).concat("\uff08").concat(mustInputFieldName).concat("\uff09"));
                    }
                });
                this.addErrMsg("7", errMsg, this.firstSheetName, 4, errInfo);
            }
            List<String> importFieldList = this.getImportFieldsList(entityToFields, this.pageMainEntityNum);
            fieldCollection.forEach(field -> {
                if (!CollectionUtils.isEmpty((Collection)ignoreValidateField) && ignoreValidateField.contains(field)) {
                    return;
                }
                String bdFormat = "";
                DynamicObject fieldDy = (DynamicObject)((Map)tplFieldConfig.get(this.pageMainEntityNum)).get(MethodUtil.getLevelOneKey((String)field));
                if (fieldDy != null) {
                    bdFormat = fieldDy.getString("imptattr");
                }
                if (this.hasReversalContains(Sets.newHashSet((Object[])new String[]{this.entryKey}), bdFields, bdFormat, importFieldList, (String)field, (IDataEntityProperty)allFields.get(MethodUtil.getLevelOneKey((String)field)))) {
                    errInfo.add(field);
                }
            });
            this.addErrMsg("9", errMsg, this.firstSheetName, 4, errInfo);
        } else {
            if (!this.pageMainEntityNum.equals(mainEntityNum)) {
                this.addErrMsg("10", errMsg, this.firstSheetName, 1, Lists.newArrayList((Object[])new String[]{mainEntityNum}));
                return errMsg.toString();
            }
            Map<String, IDataEntityProperty> fields = ExportEntryDataHelper.getEntryAllField(this.iFormView, this.entryKey);
            List<IDataEntityProperty> bdFields = this.getBDFields(fields);
            ArrayList entryKeys = Lists.newArrayListWithCapacity((int)fields.size());
            data.get(1).forEach(key -> {
                if (!this.entryKey.equals(key = HIESUtil.getSplitValue((String)key))) {
                    errInfo.add(key);
                } else {
                    entryKeys.add(key);
                }
            });
            this.addErrMsg("6", errMsg, this.firstSheetName, 2, errInfo);
            ArrayList errFieldInfo = Lists.newArrayList();
            Collection<String> fieldCollection = data.get(3);
            entryFields.addAll(fieldCollection);
            fields.values().stream().filter(consumer -> {
                if (consumer instanceof MulBasedataProp) {
                    return ((MulBasedataProp)consumer).isMustInput();
                }
                if (consumer instanceof BasedataProp) {
                    return ((BasedataProp)consumer).isMustInput();
                }
                if (consumer instanceof RefBillProp) {
                    return ((RefBillProp)consumer).isMustInput();
                }
                return ((FieldProp)consumer).isMustInput();
            }).forEach(mustInputField -> {
                if (!CollectionUtils.isEmpty((Collection)ignoreValidateField) && ignoreValidateField.contains(mustInputField.getName())) {
                    return;
                }
                String bdFormat = this.f7formatCfg.getOrDefault(mustInputField.getName(), this.defautBaseinfoformat);
                String fieldSuffix = this.getFieldSuffix(bdFormat, (IDataEntityProperty)mustInputField);
                if (this.hasMustFillFieldContains(fieldSuffix, fieldCollection, mustInputField.getName())) {
                    String mustInputFieldName = mustInputField.getDisplayName().getLocaleValue();
                    errInfo.add(mustInputField.getName().concat(fieldSuffix).concat("\uff08").concat(mustInputFieldName).concat("\uff09"));
                }
            });
            Set<String> fieldsKey = fields.keySet();
            fieldCollection.forEach(field -> {
                if (!CollectionUtils.isEmpty((Collection)ignoreValidateField) && ignoreValidateField.contains(field)) {
                    return;
                }
                String bdFormat = this.f7formatCfg.getOrDefault(MethodUtil.getLevelOneKey((String)field), this.defautBaseinfoformat);
                if (this.hasReversalContains(entryKeys, bdFields, bdFormat, fieldsKey, (String)field, (IDataEntityProperty)fields.get(MethodUtil.getLevelOneKey((String)field)))) {
                    errFieldInfo.add(field);
                }
            });
            this.addErrMsg("7", errMsg, this.firstSheetName, 4, errInfo);
            this.addErrMsg("9", errMsg, this.firstSheetName, 4, errFieldInfo);
        }
        int firstDataRowNum = this.startRowNum;
        if (StringUtils.isBlank((CharSequence)errMsg) && data.entrySet().stream().filter(entry -> (Integer)entry.getKey() >= firstDataRowNum && (Integer)entry.getKey() < firstDataRowNum + 10).noneMatch(entry2 -> ((Collection)entry2.getValue()).size() > 0)) {
            errInfo.add("error");
            this.addErrMsg("-1", errMsg, this.firstSheetName, 0, errInfo);
        }
        return errMsg.toString();
    }

    protected List<IDataEntityProperty> getBDFields(Map<String, IDataEntityProperty> fields) {
        return fields.values().stream().filter(iDataEntityProperty -> iDataEntityProperty instanceof BasedataProp || iDataEntityProperty instanceof MulBasedataProp).collect(Collectors.toList());
    }

    private List<String> getImportFieldsList(Map<String, List<DynamicObject>> entityToFields, String curEntityNumber) {
        if (entityToFields.get(curEntityNumber) == null) {
            return null;
        }
        return entityToFields.get(curEntityNumber).stream().filter(dy -> dy.getBoolean("isimport")).map(field -> field.getString("fieldnumber")).collect(Collectors.toList());
    }

    public int getStartRowNum() {
        return this.startRowNum;
    }

    public void setStartRowNum(int startRowNum) {
        this.startRowNum = startRowNum;
    }
}

