/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.core.validate;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hrmp.hies.entry.core.init.EntryImportContext;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;
import kd.hrmp.hies.entry.core.validate.EntryDataValidateParams;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

class InnerEntryValidateHandler
extends AbstractEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(InnerEntryValidateHandler.class);
    private EntryDataValidateParams customParams;

    InnerEntryValidateHandler() {
    }

    public void setCustomParams(EntryDataValidateParams customParams) {
        this.customParams = customParams;
    }

    public EntryDataValidateParams getDataValidateParams() {
        return this.customParams;
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
    }

    protected Object getPutWhereKey(DynamicObject dynamicObject, String customKey, String baseDataFormat, Map<String, Object> bdFieldMainPropName, String[] extF7UniqueVal, Map<String, String> f7ExtUniqueValFieldMap) {
        String realNumber = (String)bdFieldMainPropName.get("number");
        String realName = (String)bdFieldMainPropName.get("name");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)realNumber)) {
            jsonObject.put(realNumber, dynamicObject.get(customKey.concat(realNumber)));
        }
        if (StringUtils.isNotEmpty((CharSequence)realName)) {
            jsonObject.put(realName, dynamicObject.get(customKey.concat(realName)));
        }
        if ("number_name".equalsIgnoreCase(baseDataFormat)) {
            jsonObject.put("$bdSplit", (Object)"##");
        }
        if ("id".equalsIgnoreCase(baseDataFormat)) {
            jsonObject.put("id", dynamicObject.get("id"));
        }
        Object putWhereKey = this.getPutWhereKey(jsonObject, baseDataFormat, bdFieldMainPropName, null, extF7UniqueVal, f7ExtUniqueValFieldMap);
        if (ObjectUtils.isNotEmpty((Object)extF7UniqueVal)) {
            for (String ext : extF7UniqueVal) {
                putWhereKey = putWhereKey + ',' + dynamicObject.getString(ext);
            }
        }
        LOGGER.info("InnerEntryValidateHandler.getPutWhereKey()_customKey:{},baseDataFormat:{},bdFieldMainPropName:{},putWhereKey:{}", new Object[]{customKey, baseDataFormat, bdFieldMainPropName, putWhereKey});
        return putWhereKey;
    }

    protected Object getPutWhereKey(JSONObject valueJson, String baseDataFormat, Map<String, Object> bdFieldMainPropName, JSONObject billJson, String[] extF7UniqueVal, Map<String, String> f7ExtUniqueValFieldMap) {
        StringBuilder builder = new StringBuilder();
        if (ObjectUtils.isNotEmpty((Object)extF7UniqueVal) && ObjectUtils.isNotEmpty((Object)billJson)) {
            for (String ext : extF7UniqueVal) {
                if (ObjectUtils.isNotEmpty(f7ExtUniqueValFieldMap) && f7ExtUniqueValFieldMap.containsKey(ext)) {
                    ext = f7ExtUniqueValFieldMap.get(ext);
                }
                builder.append(",").append(billJson.getString(ext));
            }
        }
        String bui = builder.toString();
        Object key = ImportServiceHelper.getPutWhereKey((JSONObject)valueJson, (String)baseDataFormat, bdFieldMainPropName);
        if (StringUtils.isNotEmpty((CharSequence)bui)) {
            key = key + bui;
        }
        return key;
    }

    protected String getFieldKey(String fieldKey, String baseDataFormat, Map<String, Object> bdFieldMainPropName) {
        if (!"number_name".equalsIgnoreCase(baseDataFormat)) {
            Object val = bdFieldMainPropName.get(baseDataFormat);
            String tempkey = val instanceof PKFieldProp ? "id" : (String)val;
            fieldKey = fieldKey.concat(".").concat(tempkey);
        }
        return fieldKey;
    }

    protected String getCellIndex(String fieldKey) {
        EntryImportContext importContext = this.getDataValidateParams().getImportStarter().getImportContext();
        Map<String, DynamicObject> tplFieldConfig = importContext.getTplFieldConfig();
        Map<String, String> cellIndexOfEntities = this.getDataValidateParams().getCellIndexOfEntities();
        String cellIndex = cellIndexOfEntities.get(fieldKey);
        try {
            if (StringUtils.isBlank((CharSequence)cellIndex)) {
                DynamicObject fieldDy = tplFieldConfig.get(MethodUtil.getLevelOneKey((String)fieldKey));
                Map<String, Map<String, Object>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStarter().getImportContext().getBdFieldMainPropName();
                Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(fieldKey);
                if (bdFieldMainPropName != null) {
                    String dbFormat = fieldDy.getString("imptattr");
                    dbFormat = (String)bdFieldMainPropName.getOrDefault(dbFormat, dbFormat);
                    if (cellIndexOfEntities.get(fieldKey.concat(".").concat(dbFormat)) != null) {
                        cellIndex = cellIndexOfEntities.get(fieldKey.concat(".").concat(dbFormat));
                    }
                }
                if (StringUtils.isBlank((CharSequence)cellIndex)) {
                    cellIndex = cellIndexOfEntities.get(fieldKey.concat(".").concat(Lang.get().toString()));
                }
                if (StringUtils.isBlank((CharSequence)cellIndex) && ("id".equals(fieldKey) || importContext.getEntryKey().concat(".id").equals(fieldKey))) {
                    cellIndex = cellIndexOfEntities.get(importContext.getEntryKey().concat("_id"));
                }
            }
        }
        catch (NullPointerException exception) {
            LOGGER.info("AbstractEntryValidateHandler.getCellIndex(),fieldKey:{},cellIndexOfEntities:{}", (Object)fieldKey, cellIndexOfEntities);
            LOGGER.error((Throwable)exception);
        }
        if (StringUtils.isEmpty((CharSequence)cellIndex)) {
            LOGGER.error("getCellIndex\u65b9\u6cd5\u8fd4\u56denull\u503c\u3002fieldKey=" + fieldKey);
            LOGGER.info("AbstractEntryValidateHandler.getCellIndex(),fieldKey:{},cellIndexOfEntities:{}", (Object)fieldKey, cellIndexOfEntities);
        }
        return cellIndex;
    }

    protected String getCellName(String fieldCellIndex) {
        if (StringUtils.isEmpty((CharSequence)fieldCellIndex)) {
            return "";
        }
        Map<String, String> cellNameIndexOfEntities = this.getDataValidateParams().getCellNameIndexOfEntities();
        return cellNameIndexOfEntities.get(fieldCellIndex);
    }
}

