/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.dto.CustomTabPage;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.TemplateConfConst;
import kd.hrmp.hies.entry.common.util.EntityTreeServiceHelper;
import kd.hrmp.hies.entry.common.util.TemplateFormCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

public class EntityTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeCheckListener,
TemplateConfConst {
    public static final String TREEVIEW = "treeviewap";
    public static final String SEARCHAP = "searchap";
    private static final String CONFIRMCALLBACK_SAVE = "confirmcallback_save";
    private static final String CONFIRMCALLBACK_SELECTBDFIELD = "confirmcallback_selectbdfield";
    private static final String CONFIRMCALLBACK_QUICKMOVE = "confirmcallback_quickmove";
    private static final String CUSFIELD_FIELDNUMBER = " ";
    String PAGECACHE_SEARCH_MODE_KEY = "lefttree_search_mode";
    private EntityTreeServiceHelper treeHelper;
    private String mainEntityNumber;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"sheetbdfieldnames"});
        this.addItemClickListeners(new String[]{"fieldcoftoolbar"});
    }

    public void updateParentEntry(IFormView view, int rowIndex, String propertyName, Object newValue, Object oldValue) {
        DynamicObject dynamicObject;
        DynamicObject rowEntity = view.getModel().getEntryRowEntity("treeentryentity", rowIndex);
        String entityId = rowEntity.getString("childentity");
        long cusFieldId = rowEntity.getLong("cusfieldid");
        IDataModel parentDataModel = view.getParentView().getModel();
        DynamicObjectCollection collection = parentDataModel.getEntryEntity("tpltreeentryentity");
        Iterator iterator = collection.iterator();
        boolean isInit = false;
        Iterator idIterator = parentDataModel.getEntryEntity("tpltreeentryentity").iterator();
        boolean isTarget = false;
        while (idIterator.hasNext()) {
            dynamicObject = (DynamicObject)idIterator.next();
            boolean isTargetId = dynamicObject.getLong("cusfieldid") == cusFieldId;
            if (!isTargetId) continue;
            Object obj = dynamicObject.get(propertyName);
            if (obj instanceof OrmLocaleValue) {
                ILocaleString localeString = rowEntity.getLocaleString(propertyName);
                dynamicObject.set(propertyName, (Object)localeString);
            } else {
                parentDataModel.beginInit();
                dynamicObject.set(propertyName, newValue);
                parentDataModel.endInit();
            }
            isInit = true;
            isTarget = true;
        }
        if (!isTarget) {
            while (iterator.hasNext()) {
                dynamicObject = (DynamicObject)iterator.next();
                boolean isEntityId = entityId.equals(dynamicObject.getString("childentity"));
                boolean isCusField = dynamicObject.getBoolean("iscusfield");
                boolean isFieldNumber = dynamicObject.getString("fieldnumber").equals(oldValue);
                if (!isCusField || !isEntityId || !isFieldNumber) continue;
                parentDataModel.beginInit();
                dynamicObject.set(propertyName, newValue);
                parentDataModel.endInit();
                isInit = true;
            }
        }
        view.getParentView().updateView("tpltreeentryentity", rowIndex);
        view.sendFormAction(view.getParentView());
    }

    public void initialize() {
        String mainEntityNumber;
        super.initialize();
        IFormView view = this.getView();
        this.mainEntityNumber = mainEntityNumber = (String)view.getFormShowParameter().getCustomParam("entityId");
        TreeView treeView = (TreeView)view.getControl(TREEVIEW);
        this.treeHelper = new EntityTreeServiceHelper(treeView, mainEntityNumber);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        Boolean isImport = (Boolean)view.getFormShowParameter().getCustomParam("isImport");
        TreeNode treeNode = this.treeHelper.reBuildWholeTree(isImport, "", true, TemplateFormCommonUtil.getEntryEntityKey(view));
        view.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)treeNode));
        this.treeHelper.initCheckedNodeMap(view, treeNode);
        this.treeHelper.setRootNode(treeNode);
        this.treeHelper.resetCheckedNode(view);
        this.treeHelper.resetEdit(view);
        TreeEntryGrid entryGrid = (TreeEntryGrid)view.getControl("treeentryentity");
        entryGrid.setCollapse(false);
        String operationStatus = (String)view.getFormShowParameter().getCustomParam("operationStatus");
        boolean isView = !OperationStatus.VIEW.toString().equals(operationStatus);
        view.setEnable(Boolean.valueOf(isView), new String[]{SEARCHAP});
        boolean isTreeLock = OperationStatus.VIEW.toString().equals(operationStatus);
        String treeLockFlag = view.getParentView().getPageCache().get("treeLockFlag");
        if (StringUtils.isNotBlank((CharSequence)treeLockFlag)) {
            isTreeLock = "Y".equals(treeLockFlag);
            view.setVisible(Boolean.valueOf(!isTreeLock), new String[]{"operationcolumnap"});
        }
        view.setVisible(isImport, new String[]{"insertcusfieldbar"});
        TreeNode treeNodeRoot = this.treeHelper.getRootNode();
        treeNodeRoot.setDisabled(isTreeLock);
        List children = treeNodeRoot.getChildren();
        this.updateChildNodes(children, isTreeLock);
    }

    private void updateChildNodes(List<TreeNode> nodes, boolean flag) {
        if (!CollectionUtils.isEmpty(nodes)) {
            nodes.forEach(x -> {
                x.setDisabled(flag);
                List children = x.getChildren();
                this.updateChildNodes(children, flag);
            });
        }
    }

    public void search(SearchEnterEvent evt) {
        IFormView view = this.getView();
        boolean isImport = true;
        String searchText = evt.getText();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.treeHelper.reBuildWholeTree(isImport, searchText, false, TemplateFormCommonUtil.getEntryEntityKey(view));
            this.treeHelper.resetCheckedNode(view);
            this.getPageCache().put(this.PAGECACHE_SEARCH_MODE_KEY, "false");
            view.updateView(TREEVIEW);
        } else {
            TreeView treeView = (TreeView)view.getControl(TREEVIEW);
            boolean flag = this.treeHelper.reBuildTreeBySearchKey(treeView, isImport, searchText, TemplateFormCommonUtil.getEntryEntityKey(view));
            if (!flag) {
                this.treeHelper.resetCheckedNode(view);
                this.getPageCache().put(this.PAGECACHE_SEARCH_MODE_KEY, "true");
                view.updateView(TREEVIEW);
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        IFormView view = this.getView();
        Set<TreeNode> checkedNode = EntityTreeServiceHelper.getCheckedNode(view);
        String nodeId = (String)event.getNodeId();
        Boolean checked = event.getChecked();
        if ("1010".equals(nodeId)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)view.getPageCache().get("rootNode"), TreeNode.class);
            List childrenLv2 = rootNode.getChildren();
            for (TreeNode child : childrenLv2) {
                List childrenLv3 = child.getChildren();
                for (TreeNode treeNode : childrenLv3) {
                    String[] split = treeNode.getId().split("\\.");
                    String entityNubmer = split[0];
                    String fieldNubmer = split[1];
                    int index = (Integer)treeNode.getData();
                    TemplateFormCommonUtil.updateEntryField(checkedNode, treeNode, view, this.mainEntityNumber, fieldNubmer, checked);
                }
            }
        } else {
            checkedNode = this.checkTreeNode(checkedNode, nodeId, checked);
        }
        this.dealChildEntryFieldDisplay(checkedNode);
    }

    private void dealChildEntryFieldDisplay(Set<TreeNode> checkedNode) {
        IFormView view = this.getView();
        EntityTreeServiceHelper.putCheckedNodeToCache(view, checkedNode);
        TemplateFormCommonUtil.refreshChildEntryFieldDisplay(view);
        String focusNodeStr = view.getPageCache().get("focusNode");
        if (StringUtils.isNotBlank((CharSequence)focusNodeStr)) {
            TreeNode focusNode = (TreeNode)SerializationUtils.fromJsonString((String)focusNodeStr, TreeNode.class);
            TreeView treeView = (TreeView)view.getControl(TREEVIEW);
            treeView.focusNode(focusNode);
        }
        view.updateView("treeentryentity");
        IFormView parentView = view.getParentView();
        String mustInputField = TemplateFormCommonUtil.getEntityMustInputField(parentView.getModel(), this.mainEntityNumber);
        EntityTreeServiceHelper.lockMustInputField(view, mustInputField);
    }

    public void search(TreeNode treeNode, String targetNodeId, List<TreeNode> targetNode) {
        for (TreeNode node : treeNode.getChildren()) {
            if (node.getChildren() != null) {
                this.search(node, targetNodeId, targetNode);
                continue;
            }
            if (!node.getId().equals(targetNodeId)) continue;
            targetNode.add(node);
        }
    }

    private Set<TreeNode> checkTreeNode(Set<TreeNode> checkedNode, String nodeId, Boolean checked) {
        IFormView view = this.getView();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.mainEntityNumber);
        Map allEntities = mainType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(nodeId);
        if (Objects.isNull(entityType)) {
            String fieldNumber = nodeId;
            if (Boolean.TRUE.equals(checked)) {
                if (this.isDefField(fieldNumber)) {
                    String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u5df2\u5728\u201c\u5b57\u6bb5\u9ed8\u8ba4\u503c\u914d\u7f6e\u201d\u7ef4\u62a4\uff0c\u82e5\u6dfb\u52a0\u4e3a\u5bfc\u5165\u6a21\u677f\u5b57\u6bb5\uff0c\u5c06\u6e05\u7a7a\u5df2\u7ef4\u62a4\u7684\u9ed8\u8ba4\u503c\u914d\u7f6e\uff0c\u786e\u8ba4\u8981\u6dfb\u52a0\u5417\uff1f", (String)HiesEntryRes.EntityTreeListPlugin_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), fieldNumber);
                    view.showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirmcallback_save:" + fieldNumber, (IFormPlugin)this));
                    return checkedNode;
                }
                String entityNumber = this.mainEntityNumber;
                TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)view.getPageCache().get("rootNode"), TreeNode.class);
                ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
                this.search(rootNode, nodeId, nodes);
                Map allFields = mainType.getAllFields();
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldNumber);
                if (property instanceof ItemClassProp) {
                    String typePropFieldNumber = ((ItemClassProp)property).getTypePropName();
                    this.search(rootNode, typePropFieldNumber, nodes);
                    if (nodes.size() != 2) {
                        property = (IDataEntityProperty)allFields.get(typePropFieldNumber);
                        String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e3a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u5c06\u5176\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201c%2$s\u201d\u914d\u7f6e\u4e3a\u53ef\u5bfc\u5165\u3002", (String)HiesEntryRes.EntityTreeListPlugin_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), fieldNumber, property.getName());
                        view.showTipNotification(message);
                        return checkedNode;
                    }
                    boolean isTypeFieldChecked = checkedNode.stream().anyMatch(item -> item.getId().equals(typePropFieldNumber));
                    TreeView treeView = (TreeView)view.getControl(TREEVIEW);
                    TreeNode treeNode = (TreeNode)nodes.get(1);
                    if (!isTypeFieldChecked) {
                        treeView.checkNode(treeNode);
                        TemplateFormCommonUtil.updateEntryField(checkedNode, treeNode, view, entityNumber, typePropFieldNumber, true);
                    }
                    treeNode.setDisabled(true);
                    treeView.updateNode(treeNode);
                    TemplateFormCommonUtil.updateEntryField(checkedNode, (TreeNode)nodes.get(0), view, entityNumber, fieldNumber, true);
                    this.treeHelper.dealItemClassTypePropMustInput(view);
                } else {
                    TemplateFormCommonUtil.updateEntryField(checkedNode, (TreeNode)nodes.get(0), view, entityNumber, fieldNumber, true);
                }
                view.getPageCache().put("focusNode", SerializationUtils.toJsonString(nodes.get(0)));
            } else {
                String entityNumber = this.mainEntityNumber;
                TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)view.getPageCache().get("rootNode"), TreeNode.class);
                ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
                this.search(rootNode, nodeId, nodes);
                Map allFields = mainType.getAllFields();
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldNumber);
                if (property instanceof ItemClassProp) {
                    String typePropFieldNumber = ((ItemClassProp)property).getTypePropName();
                    this.search(rootNode, typePropFieldNumber, nodes);
                    if (nodes.size() != 2) {
                        property = (IDataEntityProperty)allFields.get(typePropFieldNumber);
                        String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e3a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u5c06\u5176\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201c%2$s\u201d\u914d\u7f6e\u4e3a\u53ef\u5bfc\u5165\u3002", (String)HiesEntryRes.EntityTreeListPlugin_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), fieldNumber, property.getName());
                        view.showTipNotification(message);
                        return checkedNode;
                    }
                    String entityMustInputField = TemplateFormCommonUtil.getEntityMustInputField(view.getParentView().getModel(), this.mainEntityNumber);
                    List mustInputFieldList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)entityMustInputField);
                    if (!mustInputFieldList.contains(typePropFieldNumber)) {
                        TreeView treeView = (TreeView)view.getControl(TREEVIEW);
                        TreeNode treeNode = (TreeNode)nodes.get(1);
                        treeNode.setDisabled(false);
                        treeView.updateNode(treeNode);
                    }
                    TemplateFormCommonUtil.updateEntryField(checkedNode, (TreeNode)nodes.get(0), view, entityNumber, fieldNumber, checked);
                    this.treeHelper.dealItemClassTypePropMustInput(view);
                } else {
                    TemplateFormCommonUtil.updateEntryField(checkedNode, (TreeNode)nodes.get(0), view, entityNumber, fieldNumber, checked);
                }
                view.getPageCache().put("focusNode", SerializationUtils.toJsonString(nodes.get(0)));
            }
        } else {
            ArrayList toCheckDefField = Lists.newArrayListWithExpectedSize((int)16);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)view.getPageCache().get("rootNode"), TreeNode.class);
            List childrenLv2 = rootNode.getChildren();
            for (TreeNode child : childrenLv2) {
                String id = child.getId();
                if (!id.equals(nodeId)) continue;
                List childrenLv3 = child.getChildren();
                for (TreeNode treeNode : childrenLv3) {
                    String fieldNumber = treeNode.getId();
                    if (!this.isDefField(fieldNumber)) continue;
                    toCheckDefField.add(fieldNumber);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)toCheckDefField)) {
                String fieldNumber = Joiner.on((String)",").join((Iterable)toCheckDefField);
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u5df2\u5728\u201c\u5b57\u6bb5\u9ed8\u8ba4\u503c\u914d\u7f6e\u201d\u7ef4\u62a4\uff0c\u82e5\u6dfb\u52a0\u4e3a\u5bfc\u5165\u6a21\u677f\u5b57\u6bb5\uff0c\u5c06\u6e05\u7a7a\u5df2\u7ef4\u62a4\u7684\u9ed8\u8ba4\u503c\u914d\u7f6e\uff0c\u786e\u8ba4\u8981\u6dfb\u52a0\u5417\uff1f", (String)HiesEntryRes.EntityTreeListPlugin_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), fieldNumber);
                view.showConfirm(message, null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("confirmcallback_save:" + fieldNumber, (IFormPlugin)this), null, nodeId);
                return checkedNode;
            }
            checkedNode = this.batchDealNodes(nodeId, checked);
        }
        TemplateFormCommonUtil.deleteParentNode(view);
        return checkedNode;
    }

    private Set<TreeNode> batchDealNodes(String entityNodeId, Boolean checked) {
        IFormView view = this.getView();
        Set<TreeNode> checkedNode = EntityTreeServiceHelper.getCheckedNode(view);
        Map itemClassTypePropMapProps = MethodUtil.itemClassTypePropMapProps((String)this.mainEntityNumber);
        Set itemClassTypePropMapPropKeys = itemClassTypePropMapProps.keySet();
        String entityMustInputField = TemplateFormCommonUtil.getEntityMustInputField(view.getParentView().getModel(), this.mainEntityNumber);
        List mustInputFieldList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)entityMustInputField);
        TreeNode focusNode = null;
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)view.getPageCache().get("rootNode"), TreeNode.class);
        List childrenLv2s = rootNode.getChildren();
        for (TreeNode childrenLv2 : childrenLv2s) {
            String nodeId = childrenLv2.getId();
            if (!nodeId.equals(entityNodeId)) continue;
            focusNode = childrenLv2;
            List childrenLv3s = childrenLv2.getChildren();
            for (TreeNode treeNode : childrenLv3s) {
                TreeView treeView;
                String fieldNumber = treeNode.getId();
                if (this.isDefField(fieldNumber) || mustInputFieldList.contains(fieldNumber)) continue;
                TemplateFormCommonUtil.updateEntryField(checkedNode, treeNode, view, this.mainEntityNumber, fieldNumber, checked);
                if (!itemClassTypePropMapPropKeys.contains(fieldNumber)) continue;
                if (checked.booleanValue()) {
                    treeView = (TreeView)view.getControl(TREEVIEW);
                    treeNode.setDisabled(true);
                    treeView.updateNode(treeNode);
                    continue;
                }
                if (mustInputFieldList.contains(fieldNumber)) continue;
                treeView = (TreeView)view.getControl(TREEVIEW);
                treeNode.setDisabled(false);
                treeView.uncheckNode(treeNode.getId());
                treeView.updateNode(treeNode);
            }
        }
        this.treeHelper.dealItemClassTypePropMustInput(view);
        view.getPageCache().put("focusNode", SerializationUtils.toJsonString(focusNode));
        return checkedNode;
    }

    private boolean isDefField(String fieldNumber) {
        Set<String> fieldNumberList = TemplateFormCommonUtil.getAllListIdSet(this.getModel(), "cusfieldentryentity", "deffieldnumber");
        return fieldNumberList.contains(fieldNumber);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        IFormView view = this.getView();
        String callBackId = event.getCallBackId();
        if (callBackId.contains(CONFIRMCALLBACK_SAVE)) {
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                if (view != null) {
                    String[] fieldList;
                    Set<TreeNode> checkedNode = this.batchDealNodes(event.getCustomVaule(), true);
                    TemplateFormCommonUtil.deleteParentNode(view);
                    String[] split = callBackId.split(":");
                    String fieldStr = split[1];
                    for (String fieldNumber : fieldList = fieldStr.split(",")) {
                        TreeNode treeNode = this.getTargetNode(fieldNumber);
                        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("cusfieldentryentity");
                        Iterator iterator = entryEntity.iterator();
                        int i = 0;
                        int targetIndex = 0;
                        while (iterator.hasNext()) {
                            DynamicObject dynamicObject = (DynamicObject)iterator.next();
                            boolean isFieldNumber = fieldNumber.equals(dynamicObject.getString("deffieldnumber"));
                            if (isFieldNumber) {
                                targetIndex = i;
                                TemplateFormCommonUtil.updateEntryField(checkedNode, treeNode, view, this.mainEntityNumber, fieldNumber, true);
                                TemplateFormCommonUtil.updateParentEntry(view, this.mainEntityNumber, fieldNumber, "defvalprop", "");
                                TemplateFormCommonUtil.refreshChildEntryFieldDisplay(view);
                                break;
                            }
                            ++i;
                        }
                        view.getModel().deleteEntryRow("cusfieldentryentity", targetIndex);
                    }
                    this.treeHelper.resetEdit(view);
                    EntityTreeServiceHelper.putCheckedNodeToCache(view, checkedNode);
                }
            } else if (view != null) {
                IDataModel model = view.getParentView().getModel();
                DynamicObjectCollection dynColl = model.getEntryEntity("tpltreeentryentity");
                ArrayList unCheckedField = Lists.newArrayListWithExpectedSize((int)16);
                for (DynamicObject dyn : dynColl) {
                    String fieldNumber = dyn.getString("fieldnumber");
                    String entityNumber = dyn.getString("childentity");
                    boolean isEntity = entityNumber.equals(this.mainEntityNumber);
                    boolean isChecked = dyn.getBoolean("ischecked") || dyn.getBoolean("isimport");
                    boolean isField = dyn.getBoolean("isfield");
                    if (!isEntity || !isField || isChecked) continue;
                    unCheckedField.add(fieldNumber);
                }
                if (CollectionUtils.isNotEmpty((Collection)unCheckedField)) {
                    TreeView treeView = (TreeView)view.getControl(TREEVIEW);
                    for (String nodeId : unCheckedField) {
                        treeView.uncheckNode(nodeId);
                    }
                }
            }
        }
    }

    private TreeNode getTargetNode(String fieldNumber) {
        String rootNodeStr = this.getView().getPageCache().get("rootNode");
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        List children = rootNode.getChildren();
        ArrayList fieldNumberList = Lists.newArrayList((Object[])new String[]{fieldNumber});
        HashSet treeNodeList = Sets.newHashSetWithExpectedSize((int)1);
        EntityTreeServiceHelper.checkNodes(children, fieldNumberList, treeNodeList);
        return (TreeNode)treeNodeList.stream().findFirst().get();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryentity.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int rowNum = selectRows[0];
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
        boolean isField = dynamicObject.getBoolean("isfield");
        if (!isField) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        IFormView view = this.getView();
        IDataModel parentModel = view.getParentView().getModel();
        String tmpltype = (String)parentModel.getValue("tmpltype");
        boolean isImportTpl = "IMPT".equalsIgnoreCase(tmpltype);
        String operationStatus = (String)view.getFormShowParameter().getCustomParam("operationStatus");
        if (OperationStatus.VIEW.toString().equals(operationStatus)) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "new": {
                EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
                int[] selectRows = entryentity.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                String cusFieldName = "";
                String cusFieldNumber = this.getCusFieldNumber();
                this.createEntry(cusFieldNumber, cusFieldName);
                break;
            }
            case "delete": {
                EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
                int[] selectRows = entryentity.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                int rowNum = selectRows[0];
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
                boolean isCusField = dynamicObject.getBoolean("iscusfield");
                String selectFieldNumber = dynamicObject.getString("fieldnumber");
                if (isCusField) {
                    long cusFieldId = dynamicObject.getLong("cusfieldid");
                    view.getModel().deleteEntryRow("treeentryentity", rowNum);
                    int fieldIndex = this.getParentEntryIndex(this.mainEntityNumber, selectFieldNumber, cusFieldId);
                    parentModel.deleteEntryRow("tpltreeentryentity", fieldIndex);
                    this.treeHelper.resetEdit(view);
                    view.getParentView().updateView("tpltreeentryentity");
                    view.sendFormAction(view.getParentView());
                } else {
                    Set<TreeNode> checkedNode;
                    String entityMustInputField = TemplateFormCommonUtil.getEntityMustInputField(view.getParentView().getModel(), this.mainEntityNumber);
                    List mustInputFieldList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)entityMustInputField);
                    if (mustInputFieldList.contains(selectFieldNumber)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u4e3a\u201c\u9700\u66f4\u65b0\u8bb0\u5f55\u8bc6\u522b\u5b57\u6bb5\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)HiesEntryRes.EntityTreeListPlugin_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                        return;
                    }
                    Set formulaRelFieldNumbers = MethodUtil.getFormulaRelFieldNumbers((String)this.mainEntityNumber, (IFormView)view);
                    if (CollectionUtils.isNotEmpty((Collection)formulaRelFieldNumbers) && formulaRelFieldNumbers.contains(selectFieldNumber)) {
                        view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u88ab\u5b57\u6bb5\u9ed8\u8ba4\u503c\u516c\u5f0f\u5173\u8054\uff0c\u8bf7\u53d6\u6d88\u5173\u8054\u540e\u518d\u8fdb\u884c\u5220\u9664\u3002", (String)HiesEntryRes.EntityTreeListPlugin_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), selectFieldNumber));
                        return;
                    }
                    Map itemClassTypePropMapProps = MethodUtil.itemClassTypePropMapProps((String)this.mainEntityNumber);
                    Set relItemClassTypeProps = (Set)itemClassTypePropMapProps.get(selectFieldNumber);
                    if (CollectionUtils.isNotEmpty((Collection)relItemClassTypeProps) && CollectionUtils.isNotEmpty(checkedNode = EntityTreeServiceHelper.getCheckedNode(view))) {
                        Set selectedNodeIds = checkedNode.stream().map(TreeNode::getId).collect(Collectors.toSet());
                        relItemClassTypeProps.retainAll(selectedNodeIds);
                        if (CollectionUtils.isNotEmpty((Collection)relItemClassTypeProps)) {
                            view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u201c%1$s\u201d\u5173\u8054\u7684\u201c%2$s\u201d\uff0c\u518d\u8fdb\u884c\u5220\u9664\u3002", (String)HiesEntryRes.EntityTreeListPlugin_9.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), selectFieldNumber, String.join((CharSequence)",", relItemClassTypeProps)));
                            return;
                        }
                    }
                    TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)view.getPageCache().get("rootNode"), TreeNode.class);
                    ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
                    this.search(rootNode, selectFieldNumber, nodes);
                    MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.mainEntityNumber);
                    Map allFields = mainType.getAllFields();
                    IDataEntityProperty property = (IDataEntityProperty)allFields.get(selectFieldNumber);
                    if (property instanceof ItemClassProp) {
                        String typePropFieldNumber = ((ItemClassProp)property).getTypePropName();
                        this.search(rootNode, typePropFieldNumber, nodes);
                        if (nodes.size() != 2) {
                            property = (IDataEntityProperty)allFields.get(typePropFieldNumber);
                            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e3a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u5c06\u5176\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201c%2$s\u201d\u914d\u7f6e\u4e3a\u53ef\u5bfc\u5165\u3002", (String)HiesEntryRes.EntityTreeListPlugin_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), selectFieldNumber, property.getName());
                            view.showTipNotification(message);
                            return;
                        }
                        if (!mustInputFieldList.contains(typePropFieldNumber)) {
                            TreeView treeView = (TreeView)view.getControl(TREEVIEW);
                            TreeNode treeNode = (TreeNode)nodes.get(1);
                            treeNode.setDisabled(false);
                            treeView.updateNode(treeNode);
                        }
                    }
                    DynamicObject dyn = (DynamicObject)view.getModel().getEntryEntity("treeentryentity").get(rowNum);
                    dyn.set("ischecked", (Object)false);
                    dyn.set("isimport", (Object)false);
                    TemplateFormCommonUtil.updateParentEntry(view, dyn.getString("childentity"), selectFieldNumber, "ischecked", false);
                    TemplateFormCommonUtil.updateParentEntry(view, dyn.getString("childentity"), selectFieldNumber, "isimport", false);
                    TemplateFormCommonUtil.cacheDisableEntry(view, selectFieldNumber, rowNum);
                    view.getModel().deleteEntryRow("treeentryentity", rowNum);
                    TreeNode treeNode = this.treeHelper.reBuildWholeTree(isImportTpl, "", false, TemplateFormCommonUtil.getEntryEntityKey(view));
                    this.treeHelper.initCheckedNodeMap(view, treeNode);
                    this.treeHelper.setRootNode(treeNode);
                    this.treeHelper.resetCheckedNode(view);
                    this.treeHelper.resetEdit(view);
                }
                TemplateFormCommonUtil.refreshChildEntryFieldDisplay(view);
                break;
            }
            case "moveentryup": 
            case "moveentrydown": {
                EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
                int[] selectRows = entryentity.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                TemplateFormCommonUtil.refreshChildEntryFieldDisplay(view);
                this.treeHelper.dealItemClassTypePropMustInput(view);
                String mustInputField = TemplateFormCommonUtil.getEntityMustInputField(parentModel, this.mainEntityNumber);
                EntityTreeServiceHelper.lockMustInputField(view, mustInputField);
                IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                int rowNum = selectRows[0];
                DynamicObject moveRow = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
                int moveRowInt = moveRow.getInt("seq") - 1;
                this.focusMoveRow(moveRow, proxy, moveRowInt);
                break;
            }
        }
    }

    private void focusMoveRow(DynamicObject moveRow, IClientViewProxy proxy, int moveRowInt) {
        String pid = moveRow.getString("pid");
        DynamicObjectCollection collection = this.getModel().getEntryEntity("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        for (int i = moveRowInt; i > 0; --i) {
            if (!StringUtils.equals((CharSequence)pid, (CharSequence)((DynamicObject)collection.get(i)).getString("id"))) continue;
            grid.focus(i, moveRowInt);
        }
        proxy.getEntryState("treeentryentity").selectRow(moveRowInt);
    }

    private String getCusFieldNumber() {
        StringBuilder sb = new StringBuilder();
        sb.append(CUSFIELD_FIELDNUMBER);
        while (this.exsist(sb.toString())) {
            sb.append(CUSFIELD_FIELDNUMBER);
        }
        return sb.toString();
    }

    private boolean exsist(String fieldNumber) {
        DynamicObjectCollection dynColl = this.getView().getModel().getEntryEntity("treeentryentity");
        for (DynamicObject dyn : dynColl) {
            String dynFieldNumber = dyn.getString("fieldnumber");
            if (!fieldNumber.equals(dynFieldNumber)) continue;
            return true;
        }
        return false;
    }

    private void createEntry(String fieldNumber, String fieldName) {
        IFormView view = this.getView();
        IDataModel parentModel = view.getParentView().getModel();
        String tmpltype = (String)parentModel.getValue("tmpltype");
        boolean isImportTpl = "IMPT".equalsIgnoreCase(tmpltype);
        EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryentity.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int rowNum = selectRows[0];
        String cusfieldName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5", (String)HiesEntryRes.EntityTreeListPlugin_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("treeentryentity").getDynamicObjectType();
        Long id = DBServiceHelper.genLongIds((String)"tpltreeentryentity", (int)1)[0];
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("cusfieldid", (Object)id);
        dynamicObject.set("fieldnumber", (Object)fieldNumber);
        dynamicObject.set("tplentityname", (Object)cusfieldName);
        dynamicObject.set("childentity", (Object)this.mainEntityNumber);
        dynamicObject.set("fieldname", (Object)fieldName);
        dynamicObject.set("isfield", (Object)true);
        dynamicObject.set("ischecked", (Object)true);
        dynamicObject.set("iscusfield", (Object)true);
        dynamicObject.set("isimport", (Object)true);
        dynamicObject.set("imptattr", (Object)"");
        DynamicObject entity = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
        String selectFieldNumber = entity.getString("fieldnumber");
        dynamicObject.set("pid", entity.get("pid"));
        int newEntryIndex = ++rowNum;
        int newEntryRow = this.getModel().createNewEntryRow("treeentryentity", newEntryIndex, dynamicObject);
        DynamicObject newObject = (DynamicObject)this.getModel().getEntryEntity("treeentryentity").get(newEntryRow);
        newObject.set("cusfieldid", (Object)id);
        newObject.set("fieldnumber", (Object)fieldNumber);
        newObject.set("tplentityname", (Object)cusfieldName);
        newObject.set("childentity", (Object)this.mainEntityNumber);
        newObject.set("fieldname", (Object)fieldName);
        newObject.set("ischecked", (Object)true);
        newObject.set("isfield", (Object)true);
        newObject.set("iscusfield", (Object)true);
        newObject.set("isimport", (Object)true);
        newObject.set("imptattr", (Object)"");
        entryentity.selectRows(newEntryRow);
        int fieldIndex = this.getParentEntryIndex(this.mainEntityNumber, selectFieldNumber);
        IFormView parentView = view.getParentView();
        DynamicObjectType pDynamicObjectType = parentView.getModel().getEntryEntity("tpltreeentryentity").getDynamicObjectType();
        DynamicObject pDynamicObject = new DynamicObject(pDynamicObjectType);
        pDynamicObject.set("id", (Object)id);
        pDynamicObject.set("cusfieldid", (Object)id);
        pDynamicObject.set("fieldnumber", (Object)fieldNumber);
        pDynamicObject.set("childentity", (Object)this.mainEntityNumber);
        pDynamicObject.set("fieldname", (Object)fieldName);
        pDynamicObject.set("isfield", (Object)true);
        pDynamicObject.set("ischecked", (Object)true);
        pDynamicObject.set("iscusfield", (Object)true);
        pDynamicObject.set("isimport", (Object)true);
        pDynamicObject.set("imptattr", (Object)"");
        DynamicObject pEntity = view.getParentView().getModel().getEntryRowEntity("tpltreeentryentity", fieldIndex);
        pDynamicObject.set("pid", pEntity.get("pid"));
        int pFieldIndex = ++fieldIndex;
        int pEntryRow = view.getParentView().getModel().createNewEntryRow("tpltreeentryentity", pFieldIndex, pDynamicObject);
        DynamicObject pNewObject = (DynamicObject)parentView.getModel().getEntryEntity("tpltreeentryentity").get(pEntryRow);
        pNewObject.set("cusfieldid", (Object)id);
        pNewObject.set("fieldnumber", (Object)fieldNumber);
        pNewObject.set("childentity", (Object)this.mainEntityNumber);
        pNewObject.set("fieldname", (Object)fieldName);
        pNewObject.set("ischecked", (Object)true);
        pNewObject.set("isfield", (Object)true);
        pNewObject.set("iscusfield", (Object)true);
        pNewObject.set("isimport", (Object)true);
        pNewObject.set("imptattr", (Object)"");
        parentView.updateView("tpltreeentryentity");
        view.sendFormAction(parentView);
        TreeNode treeNode = this.treeHelper.reBuildWholeTree(isImportTpl, "", false, TemplateFormCommonUtil.getEntryEntityKey(view));
        this.treeHelper.initCheckedNodeMap(view, treeNode);
        this.treeHelper.setRootNode(treeNode);
        this.treeHelper.resetCheckedNode(view);
        this.treeHelper.resetEdit(view);
        entryentity.selectRows(newEntryRow);
    }

    private void showCusFieldConfForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hies_cusfieldconf");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("440");
        styleCss.setHeight("330");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIRMCALLBACK_SAVE));
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Map itemClassPropMapTypes;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String propertyName = args.getProperty().getName();
        String entryEntity = args.getProperty().getParent().getName();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int row = args.getChangeSet()[0].getRowIndex();
        if ("fieldnumber".equals(propertyName) || "fieldname".equals(propertyName)) {
            if ("treeentryentity".equals(entryEntity)) {
                this.updateParentEntry(view, row, propertyName, newValue, oldValue);
            }
        } else if ("issheet".equals(propertyName)) {
            if ("1".equals(newValue)) {
                view.setEnable(Boolean.TRUE, row, new String[]{"sheetbdfieldnames"});
            } else {
                view.setEnable(Boolean.FALSE, row, new String[]{"sheetbdfieldnames"});
                model.setValue("sheetbdfields", null, row);
                model.setValue("sheetbdfieldnames", null, row);
                model.setValue("issheet", (Object)"0", row);
            }
        } else if ("sheetbdfieldnames".equals(propertyName)) {
            if (StringUtils.isBlank((Object)newValue)) {
                model.setValue("sheetbdfields", null, row);
                model.setValue("sheetbdfieldnames", null, row);
            }
        } else if ("ismustinput".equals(propertyName) && MapUtils.isNotEmpty((Map)(itemClassPropMapTypes = MethodUtil.itemClassPropMapTypes((String)this.mainEntityNumber)))) {
            DynamicObject rowEntity = view.getModel().getEntryRowEntity("treeentryentity", row);
            String fieldNumber = rowEntity.getString("fieldnumber");
            String relItemClassTypePropId = (String)itemClassPropMapTypes.get(fieldNumber);
            if (StringUtils.isBlank((CharSequence)relItemClassTypePropId)) {
                return;
            }
            boolean isMustInput = rowEntity.getBoolean("ismustinput");
            DynamicObjectCollection collection = this.getModel().getEntryEntity("treeentryentity");
            for (int rowNum = 0; rowNum < collection.size(); ++rowNum) {
                DynamicObject dyn = (DynamicObject)collection.get(rowNum);
                String dynFieldNumber = dyn.getString("fieldnumber");
                if (!relItemClassTypePropId.equals(dynFieldNumber)) continue;
                if (isMustInput) {
                    model.setValue("ismustinput", (Object)Boolean.TRUE, rowNum);
                    view.setEnable(Boolean.FALSE, rowNum, new String[]{"ismustinput"});
                } else {
                    view.setEnable(Boolean.TRUE, rowNum, new String[]{"ismustinput"});
                }
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        IFormView view = this.getView();
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)CONFIRMCALLBACK_SAVE, (String)actionId)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 instanceof Map) {
                Map data = (Map)returnData2;
                OrmLocaleValue fieldName = (OrmLocaleValue)data.get("fieldname");
                String fieldNumber = (String)data.get("fieldnumber");
                this.createEntry(fieldNumber, fieldName.toString());
            }
        } else if (HRStringUtils.equals((String)CONFIRMCALLBACK_SELECTBDFIELD, (String)actionId)) {
            Object returnData3 = closedCallBackEvent.getReturnData();
            if (returnData3 instanceof Map) {
                EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
                int[] selectRows = entryentity.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                int rowNum = selectRows[0];
                Map data = (Map)returnData3;
                String selectFieldName = (String)data.get("selectfieldname");
                String selectFieldValue = (String)data.get("selectfieldvalue");
                this.getModel().setValue("sheetbdfieldnames", (Object)selectFieldName, rowNum);
                this.getModel().setValue("sheetbdfields", (Object)selectFieldValue, rowNum);
            }
        } else if (HRStringUtils.equals((String)CONFIRMCALLBACK_QUICKMOVE, (String)actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            int i;
            int distance;
            EntryGrid entryentity = (EntryGrid)this.getControl("treeentryentity");
            int[] selectRows = entryentity.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                return;
            }
            int rowNum = selectRows[0];
            Map data = (Map)returnData;
            int targetFieldIndex = (Integer)data.get("targetFieldIndex");
            String position = (String)data.get("position");
            if (!"below".equals(position)) {
                if (targetFieldIndex > rowNum) {
                    --targetFieldIndex;
                }
            } else if (targetFieldIndex < rowNum) {
                ++targetFieldIndex;
            }
            if ((distance = targetFieldIndex - rowNum) == 0) {
                return;
            }
            if (distance > 0) {
                this.getModel().moveEntryRowsDown("treeentryentity", selectRows);
                for (i = 0; i < distance - 1; ++i) {
                    selectRows[0] = selectRows[0] + 1;
                    this.getModel().moveEntryRowsDown("treeentryentity", selectRows);
                }
            } else {
                this.getModel().moveEntryRowsUp("treeentryentity", selectRows);
                for (i = 0; i < Math.abs(distance) - 1; ++i) {
                    selectRows[0] = selectRows[0] - 1;
                    this.getModel().moveEntryRowsUp("treeentryentity", selectRows);
                }
            }
            rowNum += distance;
            TemplateFormCommonUtil.refreshChildEntryFieldDisplay(view);
            this.treeHelper.dealItemClassTypePropMustInput(view);
            String mustInputField = TemplateFormCommonUtil.getEntityMustInputField(view.getParentView().getModel(), this.mainEntityNumber);
            EntityTreeServiceHelper.lockMustInputField(view, mustInputField);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            DynamicObject moveRow = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
            int moveRowInt = moveRow.getInt("seq") - 1;
            this.focusMoveRow(moveRow, proxy, moveRowInt);
        }
    }

    private int getParentEntryIndex(String mainEntityNumber, String fieldNumber) {
        DynamicObjectCollection collection = this.getView().getParentView().getModel().getEntryEntity("tpltreeentryentity");
        Iterator iterator = collection.iterator();
        int i = 0;
        int targetIndex = 0;
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            boolean isEntityId = mainEntityNumber.equals(dynamicObject.getString("childentity"));
            boolean isFieldNumber = fieldNumber.equals(dynamicObject.getString("fieldnumber"));
            if (isEntityId && isFieldNumber) {
                targetIndex = i;
                break;
            }
            ++i;
        }
        return targetIndex;
    }

    private int getParentEntryIndex(String mainEntityNumber, String fieldNumber, Long cusFieldId) {
        DynamicObject dynamicObject;
        DynamicObjectCollection collection = this.getView().getParentView().getModel().getEntryEntity("tpltreeentryentity");
        Iterator idIterator = collection.iterator();
        Iterator iterator = collection.iterator();
        int i = 0;
        int targetIndex = 0;
        boolean isTarget = false;
        while (idIterator.hasNext()) {
            boolean isTargetId;
            dynamicObject = (DynamicObject)idIterator.next();
            boolean bl = isTargetId = dynamicObject.getLong("cusfieldid") == cusFieldId.longValue();
            if (isTargetId) {
                targetIndex = i;
                isTarget = true;
                break;
            }
            ++i;
        }
        if (!isTarget) {
            i = 0;
            while (iterator.hasNext()) {
                dynamicObject = (DynamicObject)iterator.next();
                boolean isEntityId = mainEntityNumber.equals(dynamicObject.getString("childentity"));
                boolean isCusField = dynamicObject.getBoolean("iscusfield");
                boolean isFieldNumber = dynamicObject.getString("fieldnumber").equals(fieldNumber);
                if (isCusField && isEntityId && isFieldNumber) {
                    targetIndex = i;
                    break;
                }
                ++i;
            }
        }
        return targetIndex;
    }

    public void beforeClick(BeforeClickEvent evt) {
        String operateKey = ((Control)evt.getSource()).getKey();
        if ("sheetbdfieldnames".equalsIgnoreCase(operateKey)) {
            this.showAllFieldF7();
            evt.setCancel(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IFormView view = this.getView();
        String operateKey = evt.getOperationKey().toLowerCase();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        int[] selectRows = proxy.getEntryState("treeentryentity").getSelectedRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            if (operateKey.equals("new") || operateKey.equals("moveentryup") || operateKey.equals("moveentrydown") || operateKey.equals("quickmove")) {
                evt.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)HiesEntryRes.EntityTreeListPlugin_10.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            }
            return;
        }
        int rowNum = selectRows[0];
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
        boolean isField = dynamicObject.getBoolean("isfield");
        if (!isField) {
            evt.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9488\u5bf9\u5b57\u6bb5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)HiesEntryRes.EntityTreeListPlugin_11.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            return;
        }
        if ("quickmove".equalsIgnoreCase(operateKey)) {
            this.showQuickMovePage();
            evt.setCancel(true);
        }
    }

    private void showAllFieldF7() {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hies_bdsheetfieldconf");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowNum = selectRows[0];
        DynamicObject entity = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
        String selectFieldNumber = entity.getString("fieldnumber");
        String billFormId = view.getFormShowParameter().getOpenStyle().getTargetKey();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        Map allFields = entityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(selectFieldNumber);
        ArrayList<CustomTabPage> customTabPages = new ArrayList<CustomTabPage>();
        if (property instanceof ItemClassProp) {
            String typePropFieldNumber = ((ItemClassProp)property).getTypePropName();
            IDataEntityProperty typeProperty = (IDataEntityProperty)allFields.get(typePropFieldNumber);
            List baseEntityIds = ((ItemClassTypeProp)typeProperty).getBaseEntityIds();
            if (CollectionUtils.isEmpty((Collection)baseEntityIds)) {
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e3a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u5176\u5173\u8054\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201c%2$s\u201d\u7684\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)HiesEntryRes.EntityTreeListPlugin_7.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), selectFieldNumber, typeProperty.getName());
                view.showTipNotification(message);
                return;
            }
            for (String baseEntityId : baseEntityIds) {
                MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                CustomTabPage customTabPage = new CustomTabPage(baseEntityId, baseEntityType.getDisplayName().getLocaleValue());
                customTabPages.add(customTabPage);
            }
        } else {
            String baseEntityId = property instanceof MulBasedataProp ? ((MulBasedataProp)property).getBaseEntityId() : ((BasedataProp)property).getBaseEntityId();
            MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            CustomTabPage customTabPage = new CustomTabPage(baseEntityId, baseEntityType.getDisplayName().getLocaleValue());
            customTabPages.add(customTabPage);
        }
        showParameter.getCustomParams().put("customTabPages", customTabPages);
        showParameter.getCustomParams().put("sheetbdfields", this.getModel().getValue("sheetbdfields"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIRMCALLBACK_SELECTBDFIELD));
        view.showForm(showParameter);
    }

    private void showQuickMovePage() {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hies_quickmove");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowNum = selectRows[0];
        DynamicObject pidDyn = null;
        DynamicObject entity = this.getModel().getEntryRowEntity("treeentryentity", rowNum);
        String pid = entity.getString("pid");
        String id = entity.getString("id");
        boolean isEntry = entity.getParent() instanceof EntryType;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        ArrayList<DynamicObject> targetDyns = new ArrayList<DynamicObject>(entryEntity.size());
        for (DynamicObject dyn : entryEntity) {
            String curId = dyn.getString("id");
            if (pid.equals(curId)) {
                pidDyn = dyn;
                continue;
            }
            if (id.equals(curId) || !pid.equals(dyn.getString("pid"))) continue;
            targetDyns.add(dyn);
        }
        if (CollectionUtils.isEmpty(targetDyns)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5feb\u901f\u79fb\u52a8\u7684\u76ee\u6807\u5b57\u6bb5\u3002", (String)HiesEntryRes.EntityTreeListPlugin_12.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            return;
        }
        String billFormId = view.getFormShowParameter().getOpenStyle().getTargetKey();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        String billName = entityType.getName();
        TreeNode billNode = new TreeNode("", billName, entityType.getDisplayName().toString());
        billNode.setIsOpened(true);
        if (isEntry) {
            String entryId = billName + "." + pidDyn.getString("fieldnumber");
            TreeNode entryNode = new TreeNode(billNode.getId(), entryId, pidDyn.getString("fieldname"));
            entryNode.setIsOpened(true);
            billNode.addChild(entryNode);
            for (DynamicObject targetDyn : targetDyns) {
                String fieldName = targetDyn.getString("fieldname");
                if (StringUtils.isNotBlank((CharSequence)fieldName) && fieldName.endsWith("*")) {
                    fieldName = fieldName.substring(0, fieldName.length() - 1);
                }
                TreeNode targetNode = new TreeNode(entryNode.getId(), entryId + "." + targetDyn.getString("fieldnumber") + "_" + targetDyn.getString("seq"), fieldName);
                targetNode.setIsOpened(false);
                entryNode.addChild(targetNode);
            }
        } else {
            TreeNode entityNode = new TreeNode(billName, billName + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)HiesEntryRes.EntityTreeListPlugin_13.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            entityNode.setIsOpened(true);
            billNode.addChild(entityNode);
            for (DynamicObject targetDyn : targetDyns) {
                String fieldName = targetDyn.getString("fieldname");
                if (StringUtils.isNotBlank((CharSequence)fieldName) && fieldName.endsWith("*")) {
                    fieldName = fieldName.substring(0, fieldName.length() - 1);
                }
                TreeNode targetNode = new TreeNode(entityNode.getId(), billName + "." + targetDyn.getString("fieldnumber") + "_" + targetDyn.getString("seq"), fieldName);
                targetNode.setIsOpened(false);
                entityNode.addChild(targetNode);
            }
        }
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entityalias", billName);
        showParameter.getCustomParams().put("entitynumber", billName);
        showParameter.getCustomParams().put("rowindex", 0);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIRMCALLBACK_QUICKMOVE));
        view.showForm(showParameter);
    }
}

