/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.business.templateConf.EntryTplApplyScopeServiceHelper;
import kd.hrmp.hies.entry.common.HiesEntryRes;

public class EntryTplExptSelectPlugin
extends HRDataBaseList {
    private static Log log = LogFactory.getLog(EntryTplExptSelectPlugin.class);
    private int billDataCount;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa", (String)"EntryTplExptSelectPlugin_2", (String)"hrmp-hies-entry", (Object[])new Object[0]));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        LinkedList<IListColumn> deletes = new LinkedList<IListColumn>();
        for (IListColumn iListColumn : columns) {
            if (!"applyscope".equals(iListColumn.getListFieldKey()) && !"description".equals(iListColumn.getListFieldKey()) && !"listoperationcolumnap".equals(iListColumn.getListFieldKey())) continue;
            deletes.add(iListColumn);
        }
        deletes.forEach(co -> columns.remove(co));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList list = (BillList)this.getControl("billlistap");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
            if (listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u3002", (String)HiesEntryRes.EntryTplExptSelectPlugin_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                return;
            }
            DynamicObject tpl = EntryTemplateConfService.load(listSelectedData.get(0).getPrimaryKeyValue());
            this.getView().returnDataToParent(tpl.getPkValue());
            this.getView().close();
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (this.billDataCount == 0) {
            this.billDataCount = billList.getListModel().getBillDataCount();
        }
        if (this.billDataCount == 1) {
            ListSelectedRowCollection collection = new ListSelectedRowCollection();
            collection.add((Object)new ListSelectedRow(e.getRowData().getPkValue()));
            billList.putSelectedRows(collection);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object formId = customParams.get("formId");
        LinkedList<QFilter> list = new LinkedList<QFilter>();
        QFilter currentUserRightTpt = EntryTplApplyScopeServiceHelper.getCurrentUserTemplate();
        if (currentUserRightTpt != null) {
            list.add(currentUserRightTpt);
        }
        QFilter filter = new QFilter("entity.id", "=", formId);
        filter.and(new QFilter("entrytype", "=", customParams.get("entryKey")));
        list.add(filter);
        list.add(HRQFilterHelper.buildEnable());
        e.setCustomQFilters(list);
        e.setOrderBy("number desc");
    }
}

