/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.business.templateConf.EntryTemplateConfService;
import kd.hrmp.hies.entry.business.templateConf.EntryTplApplyScopeServiceHelper;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.mservice.api.IEntryTemplateService;

public class EntryTplSelectPlugin
extends HRDataBaseList {
    private static Log log = LogFactory.getLog(EntryTplSelectPlugin.class);
    private int billDataCount;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        LinkedList<IListColumn> deletes = new LinkedList<IListColumn>();
        for (IListColumn iListColumn : columns) {
            if (!"applyscope".equals(iListColumn.getListFieldKey()) && !"description".equals(iListColumn.getListFieldKey())) continue;
            deletes.add(iListColumn);
        }
        deletes.forEach(co -> columns.remove(co));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList list = (BillList)this.getControl("billlistap");
    }

    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter parentP = this.getView().getFormShowParameter();
        String formId = (String)parentP.getCustomParam("formId");
        boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)parentP.getAppId(), (String)formId, (String)"4730fc9f000003ae");
        if (!checkPermission) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u5bfc\u5165\u6743\u9650\uff0c\u5982\u9700\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)HiesEntryRes.EntryTplSelectPlugin_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), (String)parentP.getCustomParam("ListName")));
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
            if (listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u3002", (String)HiesEntryRes.EntryTplSelectPlugin_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                return;
            }
            DynamicObject tpl = EntryTemplateConfService.load(listSelectedData.get(0).getPrimaryKeyValue());
            this.getView().returnDataToParent(tpl.getPkValue());
            HashMap map = Maps.newHashMapWithExpectedSize((int)3);
            map.put("formId", formId);
            map.put("appId", showParameter.getAppId());
            map.put("importPlugin", showParameter.getCustomParam("importPlugin"));
            map.put("extParam", showParameter.getCustomParam("extParam"));
            map.put("pageId", showParameter.getCustomParam("pageId"));
            String routeAppId = MethodUtil.getRouteAppId((String)((String)this.getView().getFormShowParameter().getCustomParam("ServiceAppId")));
            Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hrmp.hies.entry.servicehelper", (String)routeAppId, (String)IEntryTemplateService.class.getSimpleName(), (String)"genPreView", (Object[])new Object[]{tpl, map});
            if (result.isSuccess()) {
                this.getView().download((String)result.getData());
                this.getView().close();
            } else {
                this.getView().showErrorNotification(result.getMsg());
                return;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        Object pkValue;
        List attachments;
        AbstractColumnDesc columnDesc;
        String fieldKey;
        super.packageData(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (this.billDataCount == 0) {
            this.billDataCount = billList.getListModel().getBillDataCount();
        }
        if (this.billDataCount == 1) {
            ListSelectedRowCollection collection = new ListSelectedRowCollection();
            collection.add((Object)new ListSelectedRow(e.getRowData().getPkValue()));
            billList.putSelectedRows(collection);
        }
        if ((fieldKey = (columnDesc = (AbstractColumnDesc)e.getSource()).getFieldKey()).equalsIgnoreCase("listoperationcolumnap") && CollectionUtils.isEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)"hies_entry_tpl", (Object)(pkValue = e.getRowData().getPkValue()), (String)"attachmentpanelap")))) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem item : operationColItems) {
                item.setVisible(false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long pkId;
        List attachments;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("donothing_downattach".equals(formOperate.getOperateKey()) && CollectionUtils.isNotEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)"hies_entry_tpl", (Object)(pkId = ((Long)args.getListSelectedData().get(0).getPrimaryKeyValue()).longValue()), (String)"attachmentpanelap")))) {
            try {
                String downUrl = ImportFileUtil.downloadRenameFile((String)((String)((Map)attachments.get(0)).get("url")), (String)((String)((Map)attachments.get(0)).get("name")));
                this.getView().download(downUrl);
            }
            catch (IOException e) {
                log.error((Throwable)e);
                this.getView().download((String)((Map)attachments.get(0)).get("url"));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object formId = customParams.get("formId");
        LinkedList<QFilter> list = new LinkedList<QFilter>();
        QFilter currentUserRightTpt = EntryTplApplyScopeServiceHelper.getCurrentUserTemplate();
        if (currentUserRightTpt != null) {
            list.add(currentUserRightTpt);
        }
        QFilter filter = new QFilter("entity.id", "=", formId);
        filter.and(new QFilter("entrytype", "=", customParams.get("entryKey")));
        list.add(filter);
        list.add(HRQFilterHelper.buildEnable());
        e.setCustomQFilters(list);
        e.setOrderBy("number desc");
    }
}

