/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRMultiEntityImptUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.TemplateConfConst;
import kd.hrmp.hies.entry.common.util.TemplateEntityFieldUtil;
import kd.hrmp.hies.entry.common.util.TemplateFormCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateAddSubEntityPlugin
extends HRBaseDataCommonEdit
implements BeforeF7SelectListener,
TemplateConfConst {
    private static final Log LOG = LogFactory.getLog(TemplateAddSubEntityPlugin.class);
    private static final int ENTITY_UNIQUE_VAL = 500;
    private static final String KEY_OPKEY = "saveandnew";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit mainEntityBaseData = (BasedataEdit)this.getView().getControl("entity");
        mainEntityBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        String entryEntityKey = (String)this.getModel().getValue("entrytype");
        this.resetMainEntityUniqueVal(entryEntityKey);
    }

    public void afterLoadData(EventObject eventObject) {
        String entryEntityKey = (String)this.getModel().getValue("entrytype");
        this.resetMainEntityUniqueVal(entryEntityKey);
    }

    public void afterCopyData(EventObject e) {
        String entryEntityKey = (String)this.getModel().getValue("entrytype");
        this.resetMainEntityUniqueVal(entryEntityKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTemplateType();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof SaveAndNew && StringUtils.equals((CharSequence)KEY_OPKEY, (CharSequence)((SaveAndNew)formOperate).getOriOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            TemplateFormCommonUtil.removeTabPage(this.getView());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (!"save".equals(evt.getOperationKey()) && !KEY_OPKEY.equals(evt.getOperationKey())) {
            return;
        }
        boolean isImport = "IMPT".equals(this.getModel().getValue("tmpltype"));
        Object importType = this.getModel().getValue("importtype");
        if (isImport && Objects.isNull(importType)) {
            String importTypeName = ((ComboEdit)this.getView().getControl("importtype")).getProperty().getDisplayName().getLocaleValue();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)HiesEntryRes.TemplateAddSubEntityPlugin_9.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), importTypeName));
            evt.setCancel(true);
            return;
        }
        Object entityUnique = this.getModel().getValue("mainentityuniqueval");
        boolean canEdit = TemplateEntityFieldUtil.mustInputCanEdit(this.getModel());
        if (Objects.nonNull(entityUnique) && entityUnique.toString().length() > 500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9700\u66f4\u65b0\u8bb0\u5f55\u8bc6\u522b\u5b57\u6bb5\u201d\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236\u3002", (String)HiesEntryRes.TemplateAddSubEntityPlugin_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            evt.setCancel(true);
        } else if (Objects.isNull(entityUnique) && isImport && canEdit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9700\u66f4\u65b0\u8bb0\u5f55\u8bc6\u522b\u5b57\u6bb5\u201d\u3002", (String)HiesEntryRes.TemplateAddSubEntityPlugin_8.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        switch (propName) {
            case "entity": {
                this.resetMainEntityUniqueVal("");
                break;
            }
            case "entrytype": {
                String newValue2 = (String)changeSet[0].getNewValue();
                this.resetMainEntityUniqueVal(newValue2);
                break;
            }
            case "tmpltype": {
                this.initTemplateType();
                break;
            }
            case "importtype": {
                this.initUnique();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"entity")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u5b9e\u4f53\u9009\u62e9\u5217\u8868", (String)HiesEntryRes.TemplateAddSubEntityPlugin_10.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            showParameter.getListFilterParameter().setFilter(new QFilter("number", "in", this.getBillNumbers()));
        }
    }

    private void resetMainEntityUniqueVal(String entryEntityKey) {
        ComboEdit combo = (ComboEdit)this.getControl("mainentityuniqueval");
        Object mainEntityTmplObj = this.getModel().getValue("entity");
        if (Objects.isNull(mainEntityTmplObj)) {
            combo.setComboItems(Collections.emptyList());
        } else {
            DynamicObject mainEntityTmplDyo = (DynamicObject)mainEntityTmplObj;
            String entityNumber = mainEntityTmplDyo.getString("number");
            this.loadImportField4Combo(entityNumber, entryEntityKey, combo);
        }
    }

    private void loadImportField4Combo(String billFormId, String entryEntityKey, ComboEdit combo) {
        if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
            combo.setComboItems(Collections.emptyList());
            return;
        }
        ArrayList keyFieldItems = Lists.newArrayListWithExpectedSize((int)16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        List newItems = entityItems.stream().filter(item -> item instanceof Field && HRMultiEntityImptUtil.isValid((Field)((Field)item))).collect(Collectors.toList());
        EntityType entryEntityType = (EntityType)entityType.getAllEntities().get(entryEntityKey);
        Map allFields = entryEntityType.getFields();
        DynamicProperty primaryKey = (DynamicProperty)entryEntityType.getPrimaryKey();
        if (ObjectUtils.isNotEmpty((Object)primaryKey)) {
            String name = primaryKey.getName();
            if (!name.contains(".")) {
                name = primaryKey.getParent().getName() + "." + name;
                primaryKey.setName(name);
            }
            keyFieldItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)HiesEntryRes.TemplateAddSubEntityPlugin_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0])), name));
        }
        if (ObjectUtils.isEmpty((Object)allFields) && CollectionUtils.isEmpty((Collection)keyFieldItems)) {
            combo.setComboItems(Collections.emptyList());
            return;
        }
        for (Map.Entry entry : allFields.entrySet()) {
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            if (MethodUtil.ignoreUniqueValField((IDataEntityProperty)prop) || !HRMultiEntityImptUtil.isPropertyImport(newItems, (IDataEntityProperty)prop) || prop.getName() == null) continue;
            keyFieldItems.add(new ComboItem(prop.getDisplayName(), prop.getName()));
        }
        if (!keyFieldItems.isEmpty()) {
            this.sortKeyFieldItems(keyFieldItems, entityType);
            combo.setComboItems((List)Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)keyFieldItems)));
        }
    }

    private void sortKeyFieldItems(List<ComboItem> keyFieldItems, MainEntityType entityType) {
        String orgKey = "";
        if (entityType != null && entityType.getMainOrg() != null) {
            orgKey = entityType.getMainOrg();
        }
        int orgIndex = 0;
        int billNoIndex = 0;
        boolean hasOrg = false;
        boolean hasBillNo = false;
        for (int i = 0; i < keyFieldItems.size(); ++i) {
            ComboItem comboItem = keyFieldItems.get(i);
            if (HRStringUtils.isNotEmpty((String)orgKey) && HRStringUtils.equals((String)orgKey, (String)comboItem.getValue())) {
                orgIndex = i;
                hasOrg = true;
                continue;
            }
            if (!HRStringUtils.equals((String)"billno", (String)comboItem.getValue())) continue;
            billNoIndex = i;
            hasBillNo = true;
        }
        if (hasOrg) {
            keyFieldItems.add(1, keyFieldItems.get(orgIndex));
            keyFieldItems.remove(orgIndex + 1);
        }
        if (hasBillNo) {
            keyFieldItems.add(hasOrg ? 2 : 1, keyFieldItems.get(billNoIndex));
            keyFieldItems.remove(billNoIndex + 1);
        }
    }

    private void initTemplateType() {
        boolean isImportTpl = "IMPT".equals(this.getModel().getValue("tmpltype"));
        ((ComboEdit)this.getControl("importtype")).setMustInput(isImportTpl);
        this.initUnique();
    }

    private void initUnique() {
        boolean isImportTpl = "IMPT".equals(this.getModel().getValue("tmpltype"));
        String importType = (String)this.getModel().getValue("importtype");
        boolean isNew = OprCategory.isNew((String)importType);
        boolean isUniqueMust = !isNew && isImportTpl;
        ((ComboEdit)this.getControl("mainentityuniqueval")).setMustInput(isUniqueMust);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBillNumbers() {
        String fields = "number";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter[] filters = new QFilter[4];
        filters[0] = modelTypeFilter;
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderby);){
            for (Row row : ds) {
                billNumbers.add(row.getString("number"));
            }
        }
        LOG.info("TemplateAddSubEntityPlugin.getBillNumbers billNumbers:{}", billNumbers);
        return billNumbers;
    }

    public static boolean isValid(Field<?> field) {
        return field.getFeatures().isImportable() && !(field instanceof BillStatusField) && !(field instanceof CheckBoxField) && !(field instanceof RadioField) && !(field instanceof RadioGroupField) && !(field instanceof ModifierField) && !(field instanceof PictureField) && !(field instanceof UserAvatarField) && !(field instanceof IconField) && !(field instanceof AttachmentCountField) && !(field instanceof AttachmentField) && !(field instanceof PrintCountField);
    }
}

