/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hrmp.hies.entry.common.HiesEntryRes;

public class TemplatePopComboEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String VALUE = "value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter params = this.getView().getFormShowParameter();
        JSONArray items = (JSONArray)params.getCustomParam("items");
        if (items != null && !items.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, items.size());
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(ENTRYENTITY);
            int i = 0;
            String lang = RequestContext.get().getLang().name();
            for (DynamicObject dyn : dynColl) {
                JSONObject item = items.getJSONObject(i);
                JSONObject caption = item.getJSONObject("caption");
                dyn.set("name", caption instanceof Map ? ((Map)caption).get(lang) : caption);
                dyn.set(VALUE, (Object)item.getString(VALUE));
                ++i;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter params = this.getView().getFormShowParameter();
        JSONArray values = (JSONArray)params.getCustomParam("values");
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(ENTRYENTITY);
        int i = 0;
        ArrayList<Integer> selectRowKeys = new ArrayList<Integer>(10);
        for (DynamicObject dyn : dynColl) {
            String val = dyn.getString(VALUE);
            if (values != null && values.contains((Object)val)) {
                selectRowKeys.add(i);
            }
            ++i;
        }
        if (!selectRowKeys.isEmpty()) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selRks = new int[selectRowKeys.size()];
            i = 0;
            for (Integer rk : selectRowKeys) {
                selRks[i++] = rk;
            }
            grid.selectRows(selRks, ((Integer)selectRowKeys.get(0)).intValue());
        }
    }

    public void click(EventObject evt) {
        if ("btnok".equals(((Control)evt.getSource()).getKey())) {
            IFormView view = this.getView();
            FormShowParameter params = view.getFormShowParameter();
            int maxselect = (Integer)params.getCustomParam("maxselect");
            ArrayList<String> values = new ArrayList<String>(10);
            AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
            IDataModel model = this.getModel();
            for (int i : grid.getEntryState().getSelectedRows()) {
                values.add((String)model.getValue(VALUE, i));
            }
            if ("EXPT".equals(params.getCustomParam("templatetype")) && values.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)HiesEntryRes.TemplatePopComboEditPlugin_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                return;
            }
            if (values.size() > maxselect) {
                String msgfmt = ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u9009\u62e9%s\u6761\u6570\u636e\u3002", (String)HiesEntryRes.TemplatePopComboEditPlugin_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
                view.showTipNotification(String.format(msgfmt, maxselect));
                return;
            }
            view.returnDataToParent(values);
            view.close();
        }
    }
}

