/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.TreeListBizAppsPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.mvc.export.ListExporter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hies.entry.business.TemplateConfService;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.TemplateConfConst;
import kd.hrmp.hies.entry.formplugin.TemplateListDataProvider;
import org.apache.commons.lang3.tuple.Pair;

public class TemplateTreeListEdit
extends TreeListBizAppsPlugin
implements TemplateConfConst {
    private static final String BIZOBJECT = "entity";
    private static final String NEW = "tblnew";
    private static final String COPY = "tblcopy";
    private static final String OP_REFRESH = "refresh";
    private static final String BINDENTITYID = "bindEntityId";
    private static final String CLOSECALLBACK_SAVE = "closeCallBack_save";
    private static final String TBLNEW_IMPORT = "tblnew_import";
    private static final String TBLNEW_EXPORT = "tblnew_export";
    private static final String TBL_ENTRY_IMPORT = "tbl_entry_import";
    private static final String CLOSECALLBACK_IMPORT_TYPE = "closeCallBack_import_type";
    private static final String TEMPTYPE_SYS_GEN = "flexpanel_sys";
    private static final String TEMPTYPE_LOC_GEN = "flexpanel_loc";
    private static final String IS_IMPORT = "isImport";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new TemplateListDataProvider());
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{NEW});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        root.setIsOpened(true);
        root.setChildren(this.getCloudNodes());
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    private void openNewTempTab(String tplGenMode, String isImport) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hies_entry_tpl");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String bindEntityId = this.getView().getPageCache().get("_IMPORTTEMPLATETREELIST_BIZOBJID_");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bindEntityId)) {
            showParameter.setCustomParam(BINDENTITYID, (Object)bindEntityId);
        }
        showParameter.setCustomParam("tplgenmode", (Object)tplGenMode);
        showParameter.setCustomParam(IS_IMPORT, (Object)isImport);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_SAVE));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        BillShowParameter parameter = new BillShowParameter();
        switch (evt.getItemKey()) {
            case "tblnew": {
                this.openNewTempTab("sysgen", "1");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (HRStringUtils.equals((String)key, (String)"assign")) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            ListSelectedRow selectedRow = selectedRows.get(0);
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("hies_entry_tpl");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u914d\u4f7f\u7528\u4eba", (String)HiesEntryRes.TemplateTreeListEdit_7.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            showParameter.setPkId(primaryKeyValue);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1000");
            styleCss.setHeight("600");
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("btn", (Object)"assign");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_SAVE));
            this.getView().showForm((FormShowParameter)showParameter);
            args.setCancel(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        switch (evt.getItemKey()) {
            case "tblcopy": {
                if (!selectedRows.isEmpty()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6a21\u677f\u3002", (String)HiesEntryRes.TemplateTreeListEdit_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "assign": {
                if (selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)HiesEntryRes.TemplateTreeListEdit_11.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)HiesEntryRes.TemplateTreeListEdit_12.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject dy = TemplateConfService.load(primaryKeyValue);
                Boolean issyspreset = dy.getBoolean("issyspreset");
                if (!Boolean.TRUE.equals(issyspreset)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u64cd\u4f5c\u3002", (String)HiesEntryRes.TemplateTreeListEdit_8.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "tblnew_import": {
                this.openTemplateTypeChoose(evt, "1");
                break;
            }
            case "tblnew_export": {
                this.openNewTempTab("sysgen", "0");
                evt.setCancel(true);
                break;
            }
            case "tbl_entry_import": {
                this.openNewTempTab("sysgen", "1");
                break;
            }
        }
    }

    private void openTemplateTypeChoose(BeforeItemClickEvent evt, String isImport) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hies_tempgentype");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_IMPORT_TYPE));
        formShowParameter.setCustomParam(IS_IMPORT, (Object)isImport);
        this.getView().showForm(formShowParameter);
        evt.setCancel(true);
    }

    private List<TreeNode> getCloudNodes() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] hrClouds = cloudHelper.queryOriginalArray("cloud", new QFilter[0], "index");
        Pair<Set<Object>, Set<Object>> pair = this.getEntityCloudIdList();
        Set cloudIds = (Set)pair.getLeft();
        Set appIds = (Set)pair.getRight();
        Object[] hrCloudIds = Arrays.stream(hrClouds).filter(el -> {
            String pkValue = el.getString("cloud");
            return cloudIds.contains(pkValue);
        }).map(el -> el.getString("cloud")).toArray();
        TreeNode root = AppUtils.getSubsysTree((String[])cloudIds.toArray(new String[0]), (String[])appIds.toArray(new String[0]), null, (String)"app", (boolean)true, (boolean)false, (boolean)true);
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> cloudOrderNodes = new ArrayList<TreeNode>();
        for (Object cloudId : hrCloudIds) {
            for (TreeNode cloudNode : clouds) {
                if (!cloudId.equals(cloudNode.getId())) continue;
                cloudNode.setChildren(new ArrayList());
                cloudOrderNodes.add(cloudNode);
            }
        }
        return cloudOrderNodes;
    }

    public Pair<Set<Object>, Set<Object>> getEntityCloudIdList() {
        Set<Object> cloudIdSet = new HashSet(16);
        Set<Object> appIdSet = new HashSet(16);
        Object[] objects = BusinessDataServiceHelper.load((String)"hies_entry_tpl", (String)BIZOBJECT, (QFilter[])new QFilter[0]);
        if (!ArrayUtils.isEmpty((Object[])objects)) {
            Set entityIdSet = Arrays.stream(objects).filter(o -> Objects.nonNull(o.getDynamicObject(BIZOBJECT))).map(o -> o.getDynamicObject(BIZOBJECT).getPkValue()).collect(Collectors.toSet());
            DynamicObject[] appObjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid", (QFilter[])new QFilter[]{new QFilter("id", "in", entityIdSet)});
            appIdSet = Arrays.stream(appObjects).filter(o -> Objects.nonNull(o.getDynamicObject("bizappid"))).map(o -> o.getDynamicObject("bizappid").getPkValue()).collect(Collectors.toSet());
            DynamicObject[] cloudObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])new QFilter[]{new QFilter("id", "in", appIdSet)});
            cloudIdSet = Arrays.stream(cloudObjects).map(o -> o.getDynamicObject("bizcloud").getPkValue()).collect(Collectors.toSet());
        }
        return Pair.of(cloudIdSet, appIdSet);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.addCustomQFilter(new QFilter(BIZOBJECT, "in", this.getBillNumbers()));
        e.addCustomQFilter(new QFilter("source", "in", Arrays.asList("normal", "external", "")));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IFormView view = this.getView();
        if (this.isLookup((IListView)view)) {
            return;
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn column : commonFilterColumns) {
            String fieldName = column.getFieldName();
            if (!"enable".equals(fieldName)) continue;
            column.setDefaultValue("1");
        }
    }

    private boolean isLookup(IListView view) {
        boolean isLookup = false;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(nodeId, 20);
        List<TreeNode> childNodes = this.getChildNodes(root, parent);
        e.setChildNodes(childNodes);
        if (parent != null) {
            this.getTreeListView().getTreeView().expand(nodeId);
        }
    }

    private List<TreeNode> getChildNodes(TreeNode root, TreeNode parent) {
        String key;
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)parent.getId(), (CharSequence)root.getId())) {
            return this.getCloudNodes();
        }
        switch (key = (String)parent.getData()) {
            case "cloud": {
                return this.getAppNodesBy(parent.getId());
            }
            case "app": {
                return this.getBillNodesBy(this.getAppIdsBy(parent.getId()));
            }
        }
        return new ArrayList<TreeNode>();
    }

    protected List<TreeNode> getBillNodesBy(List<String> appIds) {
        String fields = "id, number, name, bizappid";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter appIdFilter = new QFilter("bizappid", "in", appIds);
        QFilter entityIdFilter = null;
        Object[] diaeTplObjects = BusinessDataServiceHelper.load((String)"hies_entry_tpl", (String)BIZOBJECT, (QFilter[])new QFilter[0]);
        if (!ArrayUtils.isEmpty((Object[])diaeTplObjects)) {
            Set entityIdSet = Arrays.stream(diaeTplObjects).filter(o -> Objects.nonNull(o.getDynamicObject(BIZOBJECT))).map(o -> o.getDynamicObject(BIZOBJECT).getPkValue()).collect(Collectors.toSet());
            entityIdFilter = new QFilter("id", "in", entityIdSet);
        }
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, appIdFilter, entityIdFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)fields, (QFilter[])filters);
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(objects.length);
        for (DynamicObject object : objects) {
            String nodeId = object.getString("id");
            String name = object.getLocaleString("name").toString();
            String parentId = object.getString("bizappid_id");
            String data = object.getString("number");
            TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
            billNodes.add(node);
        }
        return billNodes;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }

    public List<TreeNode> getAppNodesBy(String cloudNodeId) {
        Pair<Set<Object>, Set<Object>> entityCloudIdList = this.getEntityCloudIdList();
        Set appIds = (Set)entityCloudIdList.getRight();
        TreeNode root = AppUtils.getSubsysTree((String[])new String[]{cloudNodeId}, (String[])appIds.toArray(new String[0]), null, (String)"app", (boolean)true, (boolean)false, (boolean)true);
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null || clouds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        List currCloud = clouds.stream().filter(cloud -> cloud.getId().equals(cloudNodeId)).collect(Collectors.toList());
        List apps = ((TreeNode)currCloud.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode app : apps) {
            if (app == null) continue;
            app.setChildren(new ArrayList(0));
        }
        return apps;
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            return StringUtils.equals((CharSequence)"0", (CharSequence)tType) ? app.getString("id") : app.getString("masterid");
        }).orElse("");
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)masterId) ? new ArrayList<String>() : allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    private QFilter getFilter(TreeNode node) {
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInApp(nodeId));
            }
        }
        return new QFilter(BIZOBJECT, "=", (Object)nodeId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillOperationStatus billStatus = e.getParameter().getBillStatus();
        if (!OperationStatus.ADDNEW.name().equals(billStatus.name())) {
            e.getParameter().setStatus(OperationStatus.VIEW);
            e.getParameter().setBillStatus(BillOperationStatus.VIEW);
        }
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains("cloud_") || currentNodeId.contains("app_") || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(BIZOBJECT, (Object)currentNodeId);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        String nodeId = treenodeevent.getNodeId().toString();
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 10);
        this.getPageCache().remove("_IMPORTTEMPLATETREELIST_BIZOBJID_");
        if (node != null && node.getData() != null) {
            String nodeData = (String)node.getData();
            if (node.getChildren() != null || "app".equals(nodeData) || "cloud".equals(nodeData)) {
                nodeData = null;
            }
            this.getPageCache().put("_IMPORTTEMPLATETREELIST_BIZOBJID_", nodeData);
        }
        super.treeNodeClick(treenodeevent);
    }

    public static boolean checkPagePermission(String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)"bas_manageprinttpl", (String)permissionItemId);
        return flag == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBillNumbers() {
        String fields = "number";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[3];
        filters[0] = modelTypeFilter;
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderby);){
            for (Row row : ds) {
                billNumbers.add(row.getString("number"));
            }
        }
        return billNumbers;
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getQueryValues()) {
            String bizObjectId = data.getString("bizobject_id");
            try {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bizObjectId)) continue;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
                Map properties = mainEntityType.getAllFields();
                Map entities = mainEntityType.getAllEntities();
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)properties.get("treeentryentity");
                if (dataEntityProperty == null) continue;
                DynamicObjectCollection arr = data.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject row : arr) {
                    String exportprop;
                    String fieldKey = row.getString("entitynumber");
                    IDataEntityProperty prop = (IDataEntityProperty)properties.get(fieldKey);
                    if (row.getDynamicObjectType().getProperty("entityname") != null) {
                        this.setEntityName(row, entities, prop, fieldKey);
                    }
                    if (row.getDynamicObjectType().getProperty("exportprop") == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(exportprop = row.getString("exportprop")))) continue;
                    this.setExportPropName(row, entities, prop, exportprop);
                }
            }
            catch (Throwable ex) {
                String errMsg = ex instanceof KDBizException || !SystemParamServiceHelper.isShowStackTrace() ? ex.getMessage() : ListExporter.formatException((Throwable)ex);
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"(\u5bf9\u8c61\u6807\u8bc6\uff1a%s) ", (String)HiesEntryRes.TemplateTreeListEdit_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), bizObjectId) + errMsg);
            }
        }
    }

    private void setExportPropName(DynamicObject row, Map<String, EntityType> entities, IDataEntityProperty prop, String exportpropStr) {
        ArrayList<String> propNames = new ArrayList<String>();
        if (!(prop instanceof IBasedataField)) {
            row.set("exportprop", null);
            return;
        }
        if (prop instanceof ItemClassProp || prop instanceof FlexProp) {
            if (exportpropStr.contains("name")) {
                propNames.add(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)HiesEntryRes.TemplateTreeListEdit_4.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0])).toString());
            }
            if (exportpropStr.contains("number")) {
                propNames.add(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)HiesEntryRes.TemplateTreeListEdit_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0])).toString());
            }
        } else {
            BasedataEntityType type = (BasedataEntityType)((IBasedataField)prop).getComplexType();
            HashSet<String> exportProps = new HashSet<String>(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)exportpropStr, (char)',')));
            DataEntityPropertyCollection properties = type.getProperties();
            for (IDataEntityProperty refProp : properties) {
                if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable() || !exportProps.remove(refProp.getName())) continue;
                LocaleString disp = refProp.getDisplayName();
                propNames.add(disp != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)disp.toString()) ? disp.toString() : refProp.getName());
            }
            if (exportProps.contains("name")) {
                String displayProp = type.getNameProperty();
                propNames.add(0, this.getPropDisplayName(properties, displayProp, new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)HiesEntryRes.TemplateTreeListEdit_4.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]))).toString());
            }
            if (exportProps.contains("number")) {
                String numberProp = type.getNumberProperty();
                propNames.add(0, this.getPropDisplayName(properties, numberProp, new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)HiesEntryRes.TemplateTreeListEdit_5.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]))).toString());
            }
        }
        if (propNames.isEmpty()) {
            row.set("exportprop", null);
        }
        if (row.getDynamicObjectType().getProperty("exportpropname") != null) {
            row.set("exportpropname", (Object)String.join((CharSequence)",", propNames));
        }
    }

    private Object getPropDisplayName(DataEntityPropertyCollection properties, String propKey, LocaleString defaultDisplay) {
        if (propKey == null) {
            return defaultDisplay;
        }
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)propKey);
        if (prop != null) {
            return this.getPropDisplayName(prop);
        }
        return defaultDisplay;
    }

    private void setEntityName(DynamicObject row, Map<String, EntityType> entities, IDataEntityProperty prop, String fieldKey) {
        if (prop != null) {
            row.set("entityname", this.getPropDisplayName(prop));
        } else {
            EntityType entityType = entities.get(fieldKey);
            if (entityType != null) {
                row.set("entityname", this.getEntityDisplayName(entityType));
            } else if ("billhead".equals(fieldKey)) {
                row.set("entityname", (Object)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)HiesEntryRes.TemplateTreeListEdit_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            } else if ("id".equals(fieldKey) || fieldKey.endsWith(".id")) {
                row.set("entityname", (Object)ResManager.loadKDString((String)"\u5185\u7801", (String)HiesEntryRes.TemplateTreeListEdit_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            } else if (fieldKey.endsWith(".pid")) {
                row.set("entityname", (Object)ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)HiesEntryRes.TemplateTreeListEdit_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
            }
        }
    }

    private Object getEntityDisplayName(EntityType entityType) {
        LocaleString display = entityType.getDisplayName();
        if (display == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)display.toString())) {
            return entityType.getName();
        }
        return display.toString();
    }

    private Object getPropDisplayName(IDataEntityProperty prop) {
        LocaleString display = prop.getDisplayName();
        if (display == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)display.toString())) {
            return prop.getName();
        }
        return display.toString();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSECALLBACK_SAVE.equals(actionId)) {
            this.getView().invokeOperation(OP_REFRESH);
        } else if (CLOSECALLBACK_IMPORT_TYPE.equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            String tempType = (String)returnData.get("temptype");
            String isImport = (String)returnData.get(IS_IMPORT);
            if (TEMPTYPE_SYS_GEN.equals(tempType)) {
                this.openNewTempTab("sysgen", isImport);
            } else if (TEMPTYPE_LOC_GEN.equals(tempType)) {
                this.openNewTempTab("localupload", isImport);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (formOperate instanceof Delete && org.apache.commons.lang3.StringUtils.equals((CharSequence)"delete", (CharSequence)operateKey) && args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            int selectedSize = selectedRows.size();
            if (selectedSize == 1) {
                return;
            }
            HashSet errorPkIds = args.getOperationResult().getValidateResult().getErrorPkIds();
            int errRowSize = errorPkIds.size();
            if (selectedSize == errRowSize) {
                return;
            }
            List sortSelectedRowKeys = selectedRows.stream().sorted(Comparator.comparing(ListSelectedRow::getRowKey)).collect(Collectors.toList());
            ArrayList<Integer> finalRowKey = new ArrayList<Integer>(8);
            int sucessNum = 0;
            for (ListSelectedRow selectedRow : sortSelectedRowKeys) {
                int rowKey = selectedRow.getRowKey();
                if (errorPkIds.contains(selectedRow.getPrimaryKeyValue())) {
                    finalRowKey.add(rowKey - sucessNum);
                    continue;
                }
                ++sucessNum;
            }
            int[] errRowKeys = finalRowKey.stream().mapToInt(Integer::intValue).toArray();
            billList.selectRows(errRowKeys);
        }
    }
}

