/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.constant.HIESConstant;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class CheckPwdHelper {
    private static final Pattern NUMBER_PATTERN = Pattern.compile(".*\\d+.*");
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile(".*[A-Z]+.*");
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile(".*[a-z]+.*");
    private static final Pattern COMPOSE_PWD_PATTERN = Pattern.compile("^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])[a-zA-Z0-9]{6}$");
    private static final Pattern COMPOSE_PWD_PATTERN2 = Pattern.compile(".*[`~!@#$%^&*()_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]+.*");
    public static final Pattern COMPOSE_PWD_PATTERN3 = Pattern.compile("^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{6}$");
    private static final Set<Pattern> SIMPLE_PATTERNS = Sets.newHashSet((Object[])new Pattern[]{NUMBER_PATTERN, UPPERCASE_PATTERN, LOWERCASE_PATTERN});

    private CheckPwdHelper() {
    }

    public static boolean checkPwdLegal(String pwd) {
        String pattern = "\\s+";
        String[] split = pwd.split(pattern);
        if (split.length <= 1 && pwd.equals(pwd.trim())) {
            pattern = "[^\\x00-\\xff]+";
            return !Pattern.matches(pattern, pwd);
        }
        return false;
    }

    public static boolean checkPwdRule(String pwd, int fixLen) {
        return CheckPwdHelper.checkPwdRule(pwd, fixLen, fixLen);
    }

    public static boolean checkPwdRule(String pwd, int minLen, int maxLen) {
        boolean checkLenCond;
        assert (StringUtils.isBlank((CharSequence)pwd)) : "pwd cannot be empty";
        assert (minLen < 1) : "minLen must be greater than 1";
        assert (maxLen < 1) : "Method must be greater than 1";
        assert (maxLen < minLen) : "maxLen must be greater than maxLen";
        int textLen = pwd.length();
        if (minLen == maxLen) {
            checkLenCond = textLen == minLen;
        } else {
            boolean bl = checkLenCond = textLen >= minLen && textLen <= maxLen;
        }
        if (checkLenCond) {
            int matchCount = 0;
            for (Pattern pattern : SIMPLE_PATTERNS) {
                if (!pattern.matcher(pwd).matches()) continue;
                ++matchCount;
            }
            return matchCount == SIMPLE_PATTERNS.size();
        }
        return false;
    }

    public static boolean checkPwdRule(String pwd) {
        return COMPOSE_PWD_PATTERN.matcher(pwd).matches();
    }

    public static boolean check6BitPwdRule(String pwd) {
        return COMPOSE_PWD_PATTERN3.matcher(pwd).matches();
    }

    public static boolean isContainChinese(String pwd) {
        return HIESConstant.CHINESE_PATTERN.matcher(pwd).find();
    }
}

