/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TimeProp;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.FourFunction;
import kd.hr.hies.common.util.HIESUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

@ExcludeFromJacocoGeneratedReport
public class DataTypeHelper {
    private final RuntimeException checkFailComException;
    public DecimalFormat longFormat;
    public DecimalFormat bigDecimalFormat;
    private final Map<String, Map<String, LocaleString>> comboPropMap = new HashMap<String, Map<String, LocaleString>>(8);
    private final Map<Function<IDataEntityProperty, Boolean>, FourFunction<String, String, String, IDataEntityProperty, String>> instanceofMap = Maps.newLinkedHashMapWithExpectedSize((int)16);

    public DataTypeHelper() {
        this.checkFailComException = new RuntimeException();
        this.longFormat = new DecimalFormat();
        this.longFormat.setParseIntegerOnly(true);
        this.bigDecimalFormat = new DecimalFormat();
        this.bigDecimalFormat.setParseBigDecimal(true);
        this.instanceofMap.put(prop -> prop instanceof BooleanProp, (fieldId, value, dataFormat, prop) -> {
            if (HIESUtil.getBoolMap(String.valueOf(value)).booleanValue()) {
                return ResManager.loadKDString((String)"\u662f", (String)HiesCommonRes.DataTypeHelper_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
            }
            if (HIESUtil.getBooleanOfFalse(String.valueOf(value)).booleanValue()) {
                return ResManager.loadKDString((String)"\u5426", (String)HiesCommonRes.DataTypeHelper_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
            }
            throw this.checkFailComException;
        });
        this.instanceofMap.put(prop -> prop instanceof LongProp, (fieldId, value, dataFormat, prop) -> DataTypeHelper.numberToStr(this.parse((String)value, this.longFormat)));
        this.instanceofMap.put(prop -> prop instanceof BigIntProp, (fieldId, value, dataFormat, prop) -> DataTypeHelper.numberToStr(this.parse((String)value, this.longFormat)));
        this.instanceofMap.put(prop -> prop instanceof IntegerProp, (fieldId, value, dataFormat, prop) -> DataTypeHelper.numberToStr(this.parse((String)value, this.longFormat)));
        this.instanceofMap.put(prop -> prop instanceof DecimalProp, (fieldId, value, dataFormat, prop) -> DataTypeHelper.numberToStr(this.parse((String)value, this.bigDecimalFormat)));
        this.instanceofMap.put(prop -> prop instanceof DateTimeProp, (fieldId, value, dataFormat, prop) -> {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)dataFormat);
                simpleDateFormat.setLenient(false);
                return HRDateTimeUtils.format((Date)simpleDateFormat.parse((String)value), (String)dataFormat);
            }
            catch (ParseException parseException) {
                throw this.checkFailComException;
            }
        });
        this.instanceofMap.put(prop -> prop instanceof TimeProp, (fieldId, value, dataFormat, prop) -> {
            try {
                dataFormat = StringUtils.isBlank((CharSequence)dataFormat) ? "HH:mm:ss" : dataFormat;
                return String.valueOf(new SimpleDateFormat((String)dataFormat).parse((String)value).toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
            }
            catch (ParseException parseException) {
                throw this.checkFailComException;
            }
        });
    }

    private Number parse(String val, DecimalFormat decimalFormat) {
        if (!NumberUtils.isCreatable((String)(val = val.replace(",", "")))) {
            throw this.checkFailComException;
        }
        try {
            return decimalFormat.parse(val);
        }
        catch (Exception ex) {
            throw this.checkFailComException;
        }
    }

    public String formatValidate(String fieldId, String originalVal, IDataEntityProperty property, Map<String, String> marksMap) {
        if (StringUtils.isBlank((CharSequence)originalVal)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)property)) {
            return originalVal;
        }
        if (property instanceof ComboProp) {
            try {
                List comboItems;
                Map<String, LocaleString> comboItemMap = this.comboPropMap.get(fieldId);
                if (MapUtils.isEmpty(comboItemMap) && CollectionUtils.isNotEmpty((Collection)(comboItems = ((ComboProp)property).getComboItems()))) {
                    comboItems.removeIf(next -> !next.isItemVisible());
                    if (CollectionUtils.isNotEmpty((Collection)comboItems)) {
                        comboItemMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
                        this.comboPropMap.put(fieldId, comboItemMap);
                    }
                }
                if (MapUtils.isNotEmpty(comboItemMap)) {
                    return comboItemMap.get(originalVal).getLocaleValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return originalVal;
        }
        for (Map.Entry<Function<IDataEntityProperty, Boolean>, FourFunction<String, String, String, IDataEntityProperty, String>> entry : this.instanceofMap.entrySet()) {
            if (!entry.getKey().apply(property).booleanValue()) continue;
            try {
                String mark = marksMap.get(property.getName());
                if (StringUtils.isBlank((CharSequence)mark)) {
                    if (property instanceof DateProp) {
                        mark = ExcelStyleUtil.getDefaultMask("date");
                    } else if (property instanceof DateTimeProp) {
                        mark = ExcelStyleUtil.getDefaultMask("datetime");
                    } else if (property instanceof TimeProp) {
                        mark = ExcelStyleUtil.getDefaultMask("time");
                    }
                }
                return entry.getValue().apply(fieldId, originalVal, mark, property);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }
        return originalVal;
    }

    private static String numberToStr(Number val) {
        if (ObjectUtils.isEmpty((Object)val)) {
            return null;
        }
        return val.toString();
    }
}

