/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.dto.FieldStyle;
import org.apache.commons.lang3.StringUtils;

public class FieldStyleServiceHelper {
    public static final String KEY_SYSTEM_PARAM = "hies_diaesysparam";
    public static final String KEY_TEM_CONF = "hies_diaetplconf";

    public static JSONObject getGlobalFieldStyle() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FieldStyleServiceHelper_getGlobalFieldStyle()", (String)KEY_SYSTEM_PARAM, (String)"globalfieldstyle", (QFilter[])new QFilter[0], null);
        if (dataSet.hasNext()) {
            Row next = dataSet.next();
            if (StringUtils.isBlank((CharSequence)next.getString("globalfieldstyle"))) {
                return FieldStyleServiceHelper.getDefaultStyle();
            }
            return JSONObject.parseObject((String)next.getString("globalfieldstyle")).getJSONObject("globalfieldstyle").getJSONObject("excel");
        }
        return FieldStyleServiceHelper.getDefaultStyle();
    }

    public static JSONObject getCustomFieldStyle(String templateNumber, AtomicBoolean useGlobalSheetStyle) {
        String returnStyle = "";
        Long templateId = 0L;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FieldStyleServiceHelper_getCustomFieldStyle()", (String)KEY_TEM_CONF, (String)"id,fieldstyle", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)templateNumber)}, null);
        if (dataSet.hasNext()) {
            Row next = dataSet.next();
            returnStyle = next.getString("fieldstyle");
            templateId = next.getLong("id");
        }
        if (StringUtils.isBlank((CharSequence)returnStyle)) {
            useGlobalSheetStyle.set(true);
            return FieldStyleServiceHelper.convertGlobalStyleToCustom(FieldStyleServiceHelper.getGlobalFieldStyle(), templateId);
        }
        return JSONObject.parseObject((String)returnStyle);
    }

    public static JSONObject getDefaultStyle() {
        JSONObject fieldStyleMap = new JSONObject();
        FieldStyle headerFieldStyle = new FieldStyle();
        headerFieldStyle.setFontSize("11pt");
        headerFieldStyle.setFontFamily("Calibri");
        headerFieldStyle.setBackgroundColor("#c0c0c0ff");
        fieldStyleMap.put("header", (Object)headerFieldStyle);
        FieldStyle contentFieldStyle = new FieldStyle();
        contentFieldStyle.setFontSize("11pt");
        contentFieldStyle.setFontFamily(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)HiesCommonRes.FieldStyleServiceHelper_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        fieldStyleMap.put("content", (Object)contentFieldStyle);
        return fieldStyleMap;
    }

    public static JSONObject convertGlobalStyleToCustom(JSONObject globalFieldStyle, Long templateId) {
        HashMap<String, Map> returnStyle = new HashMap<String, Map>(16);
        String sql = "select fchildentityid,ffieldnumber from t_hies_diaetplfieldconf where fid = ? and fisimport = '1'";
        DataSet dataSet = DB.queryDataSet((String)"FieldStyleServiceHelper_convertGlobalStyleToCustom()", (DBRoute)new DBRoute("hmp"), (String)sql, (Object[])new Object[]{templateId});
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String entityNum = next.getString(0);
            Map map = returnStyle.getOrDefault(entityNum, new HashMap());
            map.put(next.getString(1), globalFieldStyle);
            returnStyle.put(entityNum, map);
        }
        String jsonString = JSONObject.toJSONString(returnStyle);
        if (StringUtils.isNotBlank((CharSequence)jsonString) && jsonString.contains("\"$ref\"")) {
            return JSONObject.parseObject((String)JSONObject.toJSONString(returnStyle, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
        return JSONObject.parseObject((String)jsonString);
    }

    public static JSONObject getCustomFieldMerge(String templateNumber) {
        String returnMerge = "";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FieldStyleServiceHelper_getCustomFieldMerge", (String)KEY_TEM_CONF, (String)"fieldmerge", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)templateNumber)}, null);
        if (dataSet.hasNext()) {
            Row next = dataSet.next();
            returnMerge = next.getString("fieldmerge");
        }
        return JSONObject.parseObject((String)returnMerge);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Object> getFieldsStyle(Map<String, Object> customParams) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        JSONObject filedJson = JSONObject.parseObject((String)((String)customParams.get("entityFieldMap")));
        JSONObject style = JSONObject.parseObject((String)((String)customParams.get("fieldstyle")));
        JSONObject storedStyle = new JSONObject();
        JSONObject merge = JSONObject.parseObject((String)((String)customParams.get("fieldmerge")));
        JSONObject globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
        Iterator iterator = filedJson.entrySet().iterator();
        while (iterator.hasNext()) {
            JSONObject styleOfEntity;
            Map.Entry entry;
            Map.Entry entryTemp = entry = (Map.Entry)iterator.next();
            String entityNum = ((JSONObject)entryTemp.getKey()).getString("tabPageKey");
            JSONObject value = (JSONObject)entry.getValue();
            List<String> storedFields = FieldStyleServiceHelper.getStoredFields(value);
            if (style == null) {
                styleOfEntity = new JSONObject();
                storedFields.forEach(field -> styleOfEntity.put(field, (Object)globalFieldStyle));
            } else {
                styleOfEntity = style.getJSONObject(entityNum);
                storedFields.forEach(field -> {
                    JSONObject temp = styleOfEntity.getJSONObject(field);
                    if (temp == null) {
                        styleOfEntity.put(field, (Object)globalFieldStyle);
                    }
                });
            }
            storedStyle.put(entityNum, (Object)styleOfEntity);
            result.put("fieldstyle", storedStyle);
            if (merge != null && merge.getJSONObject(entityNum) != null) {
                JSONObject mergeFieldToGroupName = merge.getJSONObject(entityNum);
                List<String> cancelMergeField = mergeFieldToGroupName.keySet().stream().filter(fieldsTemp -> Arrays.stream(fieldsTemp.split(",")).anyMatch(filed -> !storedFields.contains(filed))).collect(Collectors.toList());
                cancelMergeField.forEach(arg_0 -> ((JSONObject)mergeFieldToGroupName).remove(arg_0));
            }
            result.put("fieldmerge", merge);
        }
        return result;
    }

    public static List<String> getStoredFields(JSONObject fields) {
        return fields.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((JSONObject)entry.getValue()).getIntValue("seq"))).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

