/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import org.apache.commons.collections4.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class HRBizAppHelper {
    private static final Log logger = LogFactory.getLog(HRBizAppHelper.class);
    private static final List<String> supportDomainModelTypes = Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel");
    private static final String BIZCLOUD = "bizcloud";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String MASTERID = "masterid";
    private static final String BIZCLOUD_ID = "bizcloud_id";
    private static final String NUMBER = "number";
    private static final String ORDERBY = "sequence asc";
    private static final String SEQUENCE = "sequence";
    private static final String likeCondFormat = "%%%s%%";

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, String> wildcardSearchApp(String searchText, QFilter ... otherFilters) {
        List<DynamicObject> dynObjs = HRBizAppHelper.wildcardSearchRuntimeApps(searchText, otherFilters);
        HashMap<String, String> apps = new HashMap<String, String>(dynObjs != null ? dynObjs.size() : 0);
        for (DynamicObject obj : dynObjs) {
            apps.put(obj.getString("id"), obj.getString(BIZCLOUD_ID));
        }
        return apps;
    }

    public static List<String> wildcardSearchBillApp(String searchText, QFilter ... otherFilters) {
        int otherFilterLength = otherFilters.length;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4 + otherFilterLength);
        filterList.add(new QFilter("modeltype", "in", supportDomainModelTypes));
        filterList.add(new QFilter("istemplate", "=", (Object)Boolean.FALSE));
        filterList.add(new QFilter("enableimport", "=", (Object)Boolean.TRUE));
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String likeExp = String.format(likeCondFormat, searchText);
            QFilter likeFilter = new QFilter(NUMBER, "like", (Object)likeExp).or("name", "like", (Object)likeExp);
            filterList.add(likeFilter);
        }
        if (otherFilterLength > 0) {
            filterList.addAll(Arrays.stream(otherFilters).collect(Collectors.toCollection(ArrayList::new)));
        }
        QFilter[] filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filterList.toArray(new QFilter[0]), (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid", (QFilter[])filters);
        HashSet<String> apps = new HashSet<String>(objects.length);
        for (DynamicObject object : objects) {
            apps.add(object.getString("bizappid_id"));
        }
        return new ArrayList<String>(apps);
    }

    public static List<DynamicObject> wildcardSearchRuntimeApps(String searchText, QFilter ... otherFilters) {
        return HRBizAppHelper.wildcardSearchVisibleApps(searchText, true, otherFilters);
    }

    public static List<DynamicObject> wildcardSearchVisibleApps(String searchText, boolean isRuntime, QFilter ... otherFilters) {
        return HRBizAppHelper.wildcardSearchVisibleApps(searchText, ORDERBY, isRuntime, otherFilters);
    }

    public static List<DynamicObject> wildcardSearchVisibleApps(String searchText, String orderBy, boolean isRuntime, QFilter ... otherFilters) {
        return HRBizAppHelper.wildcardSearchApps(searchText, orderBy, isRuntime, true, otherFilters);
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<DynamicObject> wildcardSearchApps(String searchText, String orderBy, boolean isRuntime, boolean onlyVisible, QFilter ... otherFilters) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstFilters;
        Map appExtends;
        QFilter[] filters;
        String likeExp;
        List<String> billApps = HRBizAppHelper.wildcardSearchBillApp(searchText, otherFilters);
        QFilter hrCloudFilter = null;
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
        Object[] hrClouds = cloudHelper.queryOriginalArray("cloud", new QFilter[0], "index");
        if (ArrayUtils.isNotEmpty((Object[])hrClouds)) {
            Object[] hrCloudIds = Arrays.stream(hrClouds).map(el -> el.getString("cloud")).toArray();
            hrCloudFilter = new QFilter(BIZCLOUD, "in", (Object)hrCloudIds);
        }
        if (CollectionUtils.isNotEmpty(billApps)) {
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                likeExp = String.format(likeCondFormat, searchText);
                filters = new QFilter[]{new QFilter("name", "like", (Object)likeExp).or(NUMBER, "like", (Object)likeExp).or("id", "in", billApps), hrCloudFilter};
            } else {
                filters = new QFilter[]{new QFilter("id", "in", billApps), hrCloudFilter};
            }
        } else if (StringUtils.isNotBlank((CharSequence)searchText)) {
            likeExp = String.format(likeCondFormat, searchText);
            filters = new QFilter[]{new QFilter("name", "like", (Object)likeExp).or(NUMBER, "like", (Object)likeExp), hrCloudFilter};
        } else {
            filters = new QFilter[]{new QFilter("1", "=", (Object)1), hrCloudFilter};
        }
        filters = RunModeServiceHelper.getAppAndCloudBlacklistFilters((QFilter[])filters, (String)"id", (String)BIZCLOUD);
        Map appsMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number,type,industry,bizcloud,sequence,visible", (QFilter[])filters, (String)orderBy);
        HashSet<String> extendedAppIds = new HashSet<String>();
        if (isRuntime && onlyVisible && (appExtends = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"masterid,visible", (QFilter[])(mstFilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                extendedAppIds.add(obj.getString(MASTERID));
            }
        }
        ArrayList<DynamicObject> apps = new ArrayList<DynamicObject>();
        if (appsMap != null) {
            for (DynamicObject obj : appsMap.values()) {
                String appId = obj.getString("id");
                String appNum = obj.getString(NUMBER);
                if (isRuntime && onlyVisible) {
                    if ("portal".equals(appNum)) continue;
                    if (CollectionUtils.isNotEmpty(extendedAppIds) && extendedAppIds.contains(appId)) {
                        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
                        if (!appInfo.isRealRuntime()) continue;
                        obj.set("name", (Object)appInfo.getName());
                    } else {
                        boolean visible = obj.getBoolean("visible");
                        if (!visible) continue;
                    }
                }
                apps.add(obj);
            }
        }
        Map<Object, DynamicObject> cloudsMap = HRBizAppHelper.getClouds(null);
        try {
            apps.sort((o1, o2) -> {
                String bizCloudId2;
                String bizCloudId = o1.getString(BIZCLOUD_ID);
                if (bizCloudId.equals(bizCloudId2 = o2.getString(BIZCLOUD_ID))) {
                    return 0;
                }
                DynamicObject obj1 = (DynamicObject)cloudsMap.get(bizCloudId);
                DynamicObject obj2 = (DynamicObject)cloudsMap.get(bizCloudId2);
                if (obj1 != null && obj2 != null && StringUtils.isNotBlank((Object)obj1.getInt(SEQUENCE)) && StringUtils.isNotBlank((Object)obj2.getInt(SEQUENCE))) {
                    return obj1.getInt(SEQUENCE) - obj2.getInt(SEQUENCE);
                }
                return 0;
            });
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u6392\u5e8f\u5931\u8d25,errMsg={}", (Object)e.getMessage(), (Object)e);
        }
        return apps;
    }

    private static Map<Object, DynamicObject> getClouds(QFilter[] filters) {
        String fields = "id,name,number,sequence";
        filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id");
        return BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])filters, (String)ORDERBY);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<String> searchCloud(TreeNode root, String searchText) {
        HashSet<String> cloud = new HashSet<String>();
        for (TreeNode node : root.getChildren()) {
            if (!node.getText().contains(searchText)) continue;
            cloud.add(node.getId());
        }
        return cloud;
    }
}

