/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.hies.HRHiesVersionResp;
import kd.hr.hbp.common.util.HRQFilterHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

@ExcludeFromJacocoGeneratedReport
public class HiesVersionServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HiesVersionServiceHelper.class);

    public static Map<String, Boolean> getVersionByApps(Set<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            LOGGER.info("param[appIds] is null");
            return new HashMap<String, Boolean>(0);
        }
        HRBaseServiceHelper schemeSwitchSerRegService = new HRBaseServiceHelper("hies_schemeswitchserreg");
        Object[] schemeSwitchSerRegDyns = schemeSwitchSerRegService.loadDynamicObjectArray("hies_schemeswitchserreg", new QFilter[]{HRQFilterHelper.buildIn((String)"mserviceapp", appIds)});
        if (ArrayUtils.isEmpty((Object[])schemeSwitchSerRegDyns)) {
            LOGGER.error("\u5e94\u7528{}\u672a\u6ce8\u518cIHRHiesVersionService\u76f8\u5173\u5fae\u670d\u52a1\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0d\u505a\u5904\u7406", appIds);
            return new HashMap<String, Boolean>(0);
        }
        HashMap<String, Boolean> sucInvokeResult = new HashMap<String, Boolean>(8);
        ArrayList<Object> targetDyns = new ArrayList<Object>(8);
        for (Object schemeSwitchSerRegDyn : schemeSwitchSerRegDyns) {
            boolean bl = Boolean.TRUE.equals(schemeSwitchSerRegDyn.getBoolean("sucinvokeflag"));
            boolean oldVersionFlag = Boolean.TRUE.equals(schemeSwitchSerRegDyn.getBoolean("oldversionflag"));
            if (bl && oldVersionFlag) {
                sucInvokeResult.put(schemeSwitchSerRegDyn.getDynamicObject("mserviceapp").getString("id"), oldVersionFlag);
                continue;
            }
            targetDyns.add(schemeSwitchSerRegDyn);
        }
        if (CollectionUtils.isEmpty(targetDyns)) {
            return sucInvokeResult;
        }
        int dynSize = targetDyns.size();
        ArrayList<DynamicObject> sucDyns = new ArrayList<DynamicObject>(dynSize);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(dynSize);
        for (DynamicObject dynamicObject : targetDyns) {
            String appId = dynamicObject.getDynamicObject("mserviceapp").getString("id");
            String appNumber = dynamicObject.getDynamicObject("mserviceapp").getString("number");
            String mserviceClass = dynamicObject.getString("mserviceclass");
            boolean oldVersionFlag = Boolean.TRUE.equals(dynamicObject.getBoolean("oldversionflag"));
            boolean sucInvokeFlag = Boolean.TRUE.equals(dynamicObject.getBoolean("sucinvokeflag"));
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
                String cloudId = appInfo.getCloudNum().toLowerCase(Locale.ROOT);
                LOGGER.info("invokeBizService cloudId={} appNumber={} mserviceClass={}", new Object[]{cloudId, appNumber, mserviceClass});
                HRHiesVersionResp resp = (HRHiesVersionResp)HRMServiceHelper.invokeBizService((String)cloudId, (String)appNumber, (String)mserviceClass, (String)"getVersion", (Object[])new Object[0]);
                if (resp.isSucess()) {
                    boolean oldVersionFlagCur = resp.isOldVersionFlag();
                    result.put(appId, oldVersionFlagCur);
                    if (!sucInvokeFlag || oldVersionFlag != oldVersionFlagCur) {
                        dynamicObject.set("sucinvokeflag", (Object)true);
                        dynamicObject.set("oldversionflag", (Object)oldVersionFlagCur);
                        sucDyns.add(dynamicObject);
                    }
                    LOGGER.info("invokeBizService is sucess appId:{} appNumber:{} service:{} oldVersionFlagCur:{}", new Object[]{appId, appNumber, mserviceClass, oldVersionFlagCur});
                    continue;
                }
                LOGGER.warn("invokeBizService is fail appId:{} appNumber:{} service:{}", new Object[]{appId, appNumber, mserviceClass});
            }
            catch (Exception ex) {
                LOGGER.warn("invokeBizService is fail appId:{} appNumber:{} service:{}", new Object[]{appId, appNumber, mserviceClass, ex});
            }
        }
        if (CollectionUtils.isNotEmpty(sucDyns)) {
            schemeSwitchSerRegService.update(sucDyns.toArray(sucDyns.toArray(new DynamicObject[0])));
        }
        result.putAll(sucInvokeResult);
        return result;
    }
}

