/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hies.business.HiesVersionServiceHelper;
import kd.hr.hies.business.SwitchRegistryServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

public class HiesVersionServiceTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(HiesVersionServiceTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("HiesVersionServiceTask is start");
        HiesVersionServiceTask.deal();
        logger.info("HiesVersionServiceTask is sucess");
    }

    public static void deal() {
        HRBaseServiceHelper switchRegistryService = new HRBaseServiceHelper("hies_switchregistry");
        Object[] switchRegistryDyns = switchRegistryService.queryOriginalArray("bizapp", new QFilter[]{HRQFilterHelper.buildEql((String)"enablestatus", (Object)"0"), HRQFilterHelper.buildEql((String)"oristatus", (Object)"0"), HRQFilterHelper.buildEql((String)"apistatus", (Object)"0")});
        logger.info("switchRegistryDyns.size={}", (Object)switchRegistryDyns.length);
        if (ArrayUtils.isEmpty((Object[])switchRegistryDyns)) {
            logger.info("HiesVersionServiceTask no match data with enablestatus=0 oristatus=0 apistatus=0");
            return;
        }
        Set<String> appIds = Arrays.stream(switchRegistryDyns).map(item -> item.getString("bizapp")).collect(Collectors.toSet());
        Map<String, Boolean> versionByApps = HiesVersionServiceHelper.getVersionByApps(appIds);
        if (MapUtils.isEmpty(versionByApps)) {
            logger.info("HiesVersionServiceTask versionByApps is null ,param={}", appIds);
            return;
        }
        try {
            SwitchRegistryServiceHelper.refreshSwitchRegistry(versionByApps);
        }
        catch (Exception ex) {
            logger.warn("HiesVersionServiceHelper#refreshSwitchRegistry is fail, versionByApps={} errmsg={}", new Object[]{versionByApps, ex.getMessage(), ex});
        }
    }
}

