/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.business.upgrade.UpdateTplDataService;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.util.MethodUtil;

@ExcludeFromJacocoGeneratedReport
public class ScheduleTaskService
extends AbstractTask {
    private static Log log = LogFactory.getLog(ScheduleTaskService.class);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        try {
            DynamicObjectCollection allWaitingTask = TaskService.getAllWaitingTask();
            for (DynamicObject item : allWaitingTask) {
                try {
                    long id = item.getLong("id");
                    log.info("ScheduleTaskService_taskHasDealed.taskPkid=" + id);
                    String oprtype = item.getString("oprtype");
                    String oprpage = item.getString("oprpage");
                    Map map = (Map)JSONObject.parseObject((String)oprpage, Map.class);
                    String serviceAppId = (String)map.get("serviceAppId");
                    if (StringUtils.isEmpty((String)serviceAppId)) {
                        JSONObject reqparam = JSONObject.parseObject((String)item.getString("reqparam"));
                        serviceAppId = reqparam.getString("ServiceAppId");
                    }
                    String routeAppId = MethodUtil.getRouteAppId(serviceAppId);
                    log.info("ScheduleTaskService_routeAppId=" + routeAppId);
                    if ("import".equalsIgnoreCase(oprtype)) {
                        Result result = TaskService.invokeImportRecoveryTaskService(routeAppId, id);
                        continue;
                    }
                    Result result = TaskService.invokeExportRecoveryTaskService(routeAppId, id);
                }
                catch (Throwable e) {
                    log.error("ScheduleTaskService_execute_item exception.", e);
                }
            }
            UpdateTplDataService.updateAll();
        }
        catch (Throwable e) {
            log.error("ScheduleTaskService_execute exception.", e);
            throw e;
        }
    }
}

