/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class SwitchRegistryServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SwitchRegistryServiceHelper.class);

    public static Map<String, List<Map<String, Object>>> refreshSwitchRegistry(Map<String, Boolean> registryMap) {
        LOGGER.info("SwitchRegistryServiceHelper reqParam={}", registryMap);
        HashMap<String, List<Map<String, Object>>> returnData = new HashMap<String, List<Map<String, Object>>>(16);
        try {
            HRBaseServiceHelper registryHelper = new HRBaseServiceHelper("hies_switchregistry");
            ArrayList dynamicObjectList = Lists.newArrayListWithCapacity((int)16);
            for (Map.Entry<String, Boolean> registryEntry : registryMap.entrySet()) {
                String appId = registryEntry.getKey();
                Boolean enableOld = registryEntry.getValue();
                DynamicObject[] registry = registryHelper.query("apistatus,enablestatus,entity,oldop,newop", new QFilter[]{new QFilter("bizapp", "=", (Object)appId), new QFilter("oristatus", "=", (Object)"0"), new QFilter("apistatus", "=", (Object)"0"), new QFilter("enablestatus", "=", (Object)"0")});
                ArrayList data = Lists.newArrayListWithCapacity((int)registry.length);
                for (DynamicObject item : registry) {
                    item.set("apistatus", (Object)"1");
                    HashMap<String, Object> registryData = new HashMap<String, Object>(16);
                    registryData.put("entity", item.get("entity"));
                    registryData.put("oldop", item.get("oldop"));
                    registryData.put("newop", item.get("newop"));
                    if (enableOld.booleanValue()) {
                        item.set("enablestatus", (Object)"1");
                        registryData.put("enableStatus", "1");
                    } else {
                        registryData.put("enableStatus", "0");
                    }
                    data.add(registryData);
                    dynamicObjectList.add(item);
                }
                returnData.put(appId, data);
            }
            DynamicObject[] dataList = new DynamicObject[dynamicObjectList.size()];
            for (int i = 0; i < dynamicObjectList.size(); ++i) {
                dataList[i] = (DynamicObject)dynamicObjectList.get(i);
            }
            registryHelper.update(dataList);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("500", "refreshSwitchRegistry error"), new Object[0]);
        }
        return returnData;
    }
}

