/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TemplateConfService;
import kd.hr.hies.common.dto.Result;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.enu.EntityType;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.enu.TaskResult;
import kd.hr.hies.common.enu.TaskState;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.collections4.MapUtils;

public class TaskService {
    private static final Log logger = LogFactory.getLog(TaskService.class);

    @ExcludeFromJacocoGeneratedReport
    public static int getTaskProcess(String taskPkId, String importType) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        Map data = (Map)cache.get(MethodUtil.getTaskCachePath(taskPkId, importType, "processing"), Map.class);
        if (data == null) {
            return -1;
        }
        Integer progress = (Integer)data.get("progress");
        if (progress == null) {
            return -1;
        }
        return progress;
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject getSomeAttrsById(Long taskPkid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hies_taskinfo");
        return helper.queryOriginalOne("reqparam,extparam,retrynum", (Object)taskPkid);
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObjectCollection getAllWaitingTask() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hies_taskinfo");
        QFilter filter = new QFilter("schedulestatus", "=", (Object)"waiting");
        return helper.queryOriginalCollection("id,oprpage,oprtype,reqparam", new QFilter[]{filter});
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean terminatorTask(String taskId, String importType) {
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String status = (String)cache.get(MethodUtil.getTaskCachePath(taskId, importType, "status"), String.class);
        if ("run".equalsIgnoreCase(status) || "stop".equalsIgnoreCase(status)) {
            cache.put(MethodUtil.getTaskCachePath(taskId, importType, "status"), (Object)"stop");
            return true;
        }
        return false;
    }

    public static long saveTaskParams(Map<String, Object> params) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setAppid((String)params.get("appId"));
        taskInfo.setServiceAppId((String)params.get("ServiceAppId"));
        String oprtype = (String)params.get("oprtype");
        if (OprType.isExport(oprtype)) {
            taskInfo.setEntityid((String)params.get("oprFormId"));
        } else {
            taskInfo.setEntityid((String)params.get("formId"));
        }
        taskInfo.setOprtype(OprType.tranEnum(oprtype));
        String oprCategory = MapUtils.getString(params, (Object)"OprCategory");
        taskInfo.setOprcategory(OprCategory.tranEnum(oprCategory));
        String tplPkId = (String)params.get("tplpkid");
        taskInfo.setUsetpl(StringUtils.isBlank((CharSequence)tplPkId) ? null : Long.valueOf(Long.parseLong(tplPkId)));
        String exportModule = MapUtils.getString(params, (Object)"exportModle");
        if ((exportModule == null || "Tpl".equals(exportModule)) && StringUtils.isNotBlank((CharSequence)tplPkId)) {
            DynamicObject tpl = TemplateConfService.load(tplPkId);
            taskInfo.setEntitytype(EntityType.tranEnum(tpl.getString("entitytype")));
        }
        taskInfo.setStatus(TaskState.UNINITIATED);
        taskInfo.setUploadfileurl((String)params.get("fileuploadid"));
        taskInfo.setStime(new Date((Long)params.get("userStartTime")));
        taskInfo.setFilesize((Long)params.get("fileSize"));
        taskInfo.setReqparam(JSONObject.toJSONString(params));
        taskInfo.setPerformancelog(RequestContext.get().getTraceId());
        long id = RequestContext.get().getCurrUserId();
        Date now = new Date();
        taskInfo.setCreator(id);
        taskInfo.setCreatetime(now);
        taskInfo.setModifier(id);
        taskInfo.setModifytime(now);
        return TaskInfoHelper.doInsert(taskInfo);
    }

    public static void updateTaskAFOOTStatus(Long taskPkid) {
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setStatus(TaskState.AFOOT);
        TaskInfoHelper.doUpdate(info);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updateTaskScheduleStatus(Long taskPkid, String scheduleStatus) {
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setSchedulestatus(scheduleStatus);
        TaskInfoHelper.doUpdate(info);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updateTaskRetryInfo(Long taskPkid, int currentRetryTimes) {
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setLastretrytime(new Date());
        info.setRetrynum(currentRetryTimes);
        TaskInfoHelper.doUpdate(info);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updateTaskExceptionFinished(Long taskPkid, int currentRetryTimes, String reason) {
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setLastretrytime(new Date());
        info.setRetrynum(currentRetryTimes);
        info.setSchedulestatus("started");
        info.setStatus(TaskState.TERMINATED);
        info.setResult(TaskResult.FAIL);
        info.setIntreason(reason);
        TaskInfoHelper.doUpdate(info);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updateTaskPerformance(Long taskPkid, String performance) {
        TaskInfo info = new TaskInfo();
        info.setId(taskPkid);
        info.setModifytime(new Date());
        info.setPerformancelog(performance);
        TaskInfoHelper.doUpdate(info);
    }

    @ExcludeFromJacocoGeneratedReport
    public static Result invokeImportRecoveryTaskService(String routeAppId, long id) {
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.impt.servicehelper", (String)routeAppId, (String)"IImportService", (String)"recoveryTask", (Object[])new Object[]{id});
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Result invokeExportRecoveryTaskService(String routeAppId, long id) {
        Result result = (Result)DispatchServiceHelper.invokeService((String)"kd.hr.expt.servicehelper", (String)routeAppId, (String)"IExportService", (String)"recoveryTask", (Object[])new Object[]{id});
        return result;
    }
}

