/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.dto.DiaeTemplateInfo;
import kd.hr.hies.common.enu.BaseInfoFormatEnum;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.TemplateTreeEntityUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class TemplateServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TemplateServiceHelper.class);
    private static final String META_VERSION = "version";
    protected static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static HRBaseServiceHelper diaeTplConfHelper = new HRBaseServiceHelper("hies_diaetplconf");

    public static DynamicObject getFullTemplate(String entityNumber, String uniqueVal, String tplType) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)tplType)) {
            throw new KDBizException("parameter error");
        }
        return TemplateServiceHelper.generateFullTemplate(entityNumber, uniqueVal, tplType);
    }

    public static DynamicObject getFullTemplate(String entityNumber, String tplType) {
        HRBaseServiceHelper baseDataListHelper = new HRBaseServiceHelper("hies_diaetplconf");
        QFilter fullTplFilter = new QFilter("source", "=", (Object)"full");
        QFilter tplTypeFilter = new QFilter("tmpltype", "=", (Object)tplType);
        QFilter numberFilter = new QFilter("entity", "=", (Object)entityNumber);
        QFilter[] fullTplFilterArray = new QFilter[]{fullTplFilter, numberFilter, tplTypeFilter};
        Object[] dynamicObjects = baseDataListHelper.loadDynamicObjectArray(fullTplFilterArray);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            return dynamicObjects[0];
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private static DynamicObject generateFullTemplate(String entityNumber, String uniqueVal, String tplType) {
        try {
            DynamicObject fullTemplate = TemplateServiceHelper.getFullTemplate(entityNumber, tplType);
            if (TemplateServiceHelper.needGenerate(fullTemplate, entityNumber, uniqueVal)) {
                if (ObjectUtils.isNotEmpty((Object)fullTemplate)) {
                    TemplateServiceHelper.deleteFullTemplate(entityNumber, tplType);
                }
                LOGGER.info("\u5f00\u59cb\u751f\u6210\u5168\u91cf\u6a21\u677f entityNumber\uff1a{} tplType:{}", (Object)entityNumber, (Object)tplType);
                OperationResult result = TemplateTreeEntityUtil.getInstance().createTemplate(TemplateServiceHelper.buildTemplateInfo(entityNumber, uniqueVal, tplType));
                if (!result.isSuccess()) {
                    LOGGER.error("buildFullTemplate error result:{}", (Object)result);
                    throw new KDBizException("buildFullTemplate error");
                }
                LOGGER.info("\u751f\u6210\u5168\u91cf\u6a21\u677f\u6210\u529f entityNumber\uff1a{} tplType:{}", (Object)entityNumber, (Object)tplType);
                return TemplateServiceHelper.getFullTemplate(entityNumber, tplType);
            }
            return fullTemplate;
        }
        catch (Exception e) {
            LOGGER.error("TemplateServiceHelper_getCurrentUserTemplate_error", (Throwable)e);
            return null;
        }
    }

    private static DiaeTemplateInfo buildTemplateInfo(String entityNumber, String uniqueVal, String tplType) {
        Map<String, Object> bdMainProp = MethodUtil.getBdMainProp(entityNumber);
        DiaeTemplateInfo diaeTemplateInfo = new DiaeTemplateInfo();
        diaeTemplateInfo.setMetaVersion(TemplateServiceHelper.getMetaVersion(entityNumber));
        diaeTemplateInfo.setSource("full");
        diaeTemplateInfo.setTplGenMode("sysgen");
        diaeTemplateInfo.setNumber(entityNumber + "_" + DBServiceHelper.genLongIds((String)"tpltreeentryentity", (int)1)[0]);
        diaeTemplateInfo.setName(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5168\u91cf\u6a21\u677f_%s", (String)HiesCommonRes.TemplateServiceHelper_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), DBServiceHelper.genLongIds((String)"tpltreeentryentity", (int)1)[0]));
        diaeTemplateInfo.setTmpltype(tplType);
        diaeTemplateInfo.setEntitytype("SE");
        diaeTemplateInfo.setEntity(entityNumber);
        diaeTemplateInfo.setInstruction("");
        String entityUniqueVal = StringUtils.isBlank((CharSequence)uniqueVal) ? (String)bdMainProp.get("number") : uniqueVal;
        diaeTemplateInfo.setImporttype("updateandnew");
        diaeTemplateInfo.setBaseinfoformat(BaseInfoFormatEnum.NUMBER.getCode());
        diaeTemplateInfo.setMainentityuniqueval(entityUniqueVal);
        diaeTemplateInfo.setPlugin("");
        diaeTemplateInfo.setAllocationpolicy("0");
        return diaeTemplateInfo;
    }

    private static boolean needGenerate(DynamicObject fullTemplate, String entityNumber, String uniqueVal) {
        boolean needGenerate = false;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType instanceof QueryEntityType) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)fullTemplate)) {
            needGenerate = true;
        } else {
            String dbVersion = fullTemplate.getString("metaversion");
            String metaVersion = TemplateServiceHelper.getMetaVersion(entityNumber);
            if (!HRStringUtils.equals((String)metaVersion, (String)dbVersion)) {
                needGenerate = true;
                LOGGER.info("entityNumber:{} \u5143\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u5c06\u5220\u9664\u5f53\u524d\u5168\u91cf\u6a21\u677f\uff0c\u91cd\u65b0\u751f\u6210\u5168\u91cf\u6a21\u677f", (Object)entityNumber);
            }
        }
        return needGenerate;
    }

    private static String getMetaVersion(String entityNumber) {
        Map<String, String> bizAppMap = TemplateServiceHelper.getBizAppMap(entityNumber);
        String parentId = bizAppMap.get("parentid");
        String version = bizAppMap.get(META_VERSION);
        String metaVersion = version + "_" + TemplateServiceHelper.getMetaVersion(version, parentId);
        try {
            metaVersion = TemplateServiceHelper.md5Str(metaVersion);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return metaVersion;
    }

    public static String md5Str(String sourceStr) throws Exception {
        byte[] bytes;
        StringBuilder result = new StringBuilder();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(sourceStr.getBytes(StandardCharsets.UTF_8));
        for (byte byte0 : bytes = sha256.digest()) {
            result.append(hex[byte0 >>> 4 & 0xF]);
            result.append(hex[byte0 & 0xF]);
        }
        return result.toString();
    }

    @ExcludeFromJacocoGeneratedReport
    private static void deleteFullTemplate(String entityNumber, String tplType) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hies_diaetplconf");
        QFilter fullTplFilter = new QFilter("source", "=", (Object)"full");
        QFilter tplTypeFilter = new QFilter("tmpltype", "=", (Object)tplType);
        QFilter numberFilter = new QFilter("entity", "=", (Object)entityNumber);
        QFilter[] fullTplFilterArray = new QFilter[]{fullTplFilter, numberFilter, tplTypeFilter};
        Object[] dynamicObjects = baseServiceHelper.loadDynamicObjectArray(fullTplFilterArray);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            Object[] pks = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getPkValue()).toArray();
            baseServiceHelper.delete(pks);
            LOGGER.info("deleteFullTemplate entityNumber:{} TemplateId:{}", (Object)entityNumber, (Object)pks);
        }
    }

    private static String getMetaVersion(String metaVersion, String id) {
        Map<String, String> bizAppIdMap = TemplateServiceHelper.getBizAppIdMap(id);
        String parentId = bizAppIdMap.get("parentid");
        String version = bizAppIdMap.get(META_VERSION);
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return version;
        }
        return metaVersion + "_" + TemplateServiceHelper.getMetaVersion(version, parentId);
    }

    private static Map<String, String> getBizAppMap(String entityNumber) {
        String sql = "SELECT FNUMBER,FVERSION,FPARENTID FROM T_META_FORMDESIGN WHERE FNUMBER = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)entityNumber)};
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> bizUnitMap = new HashMap<String, String>(3);
            try {
                if (rs.next()) {
                    bizUnitMap.put("number", rs.getString(1));
                    bizUnitMap.put(META_VERSION, rs.getString(2));
                    bizUnitMap.put("parentid", rs.getString(3));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
            }
            return bizUnitMap;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private static Map<String, String> getBizAppIdMap(String id) {
        String sql = "SELECT FID,FVERSION,FPARENTID FROM T_META_FORMDESIGN WHERE FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)id)};
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> bizUnitMap = new HashMap<String, String>(3);
            try {
                if (rs.next()) {
                    bizUnitMap.put("id", rs.getString(1));
                    bizUnitMap.put(META_VERSION, rs.getString(2));
                    bizUnitMap.put("parentid", rs.getString(3));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
            }
            return bizUnitMap;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    public static DynamicObject getTemplateByPkId(long pkId) {
        QFilter pkIdFilter = new QFilter("id", "=", (Object)pkId);
        QFilter[] fullTplFilterArray = new QFilter[]{pkIdFilter};
        Object[] dynamicObjects = diaeTplConfHelper.loadDynamicObjectArray(fullTplFilterArray);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            return dynamicObjects[0];
        }
        return null;
    }

    public static DynamicObject[] getTemplateByPkIds(Set<Long> pkIds) {
        QFilter pkIdFilter = new QFilter("id", "in", pkIds);
        QFilter[] fullTplFilterArray = new QFilter[]{pkIdFilter};
        return diaeTplConfHelper.loadDynamicObjectArray(fullTplFilterArray);
    }

    public static Set<String> getRelationEntitys(Long tplPkId) {
        QFilter numberFilter = new QFilter("id", "=", (Object)tplPkId);
        QFilter[] fullTplFilterArray = new QFilter[]{numberFilter};
        Object[] dynamicObjects = diaeTplConfHelper.loadDynamicObjectArray(fullTplFilterArray);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            DynamicObjectCollection relationEntitys = dynamicObjects[0].getDynamicObjectCollection("entityrelation");
            return relationEntitys.stream().map(item -> item.getString("rentity.id")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }
}

