/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business.excel;

import kd.hr.hbp.common.util.HRAssert;
import kd.sdk.annotation.SdkPublic;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

@SdkPublic(scriptName="sheet\u6837\u5f0f\u5904\u7406\u7c7b")
public class SheetStyle {
    private SXSSFWorkbook wb;

    private SheetStyle(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    public CellStyle createCellStyle() {
        return this.wb.createCellStyle();
    }

    public CellStyle buildNewStyle(CellStyle oriStyle, boolean isClone) {
        if (isClone) {
            HRAssert.notNull((Object)oriStyle, (String)"parameter[oriStyle] is not allowed to be empty", (Object[])new Object[0]);
            return this.cloneStyle(oriStyle);
        }
        return this.wb.createCellStyle();
    }

    public CellStyle buildNewStyle4Format(CellStyle oriStyle, boolean isClone, String format) {
        HRAssert.notEmpty((String)format, (String)"parameter[format] is not allowed to be empty", (Object[])new Object[0]);
        CellStyle newCellStyle = this.buildNewStyle(oriStyle, isClone);
        this.setFormat(newCellStyle, format);
        return newCellStyle;
    }

    public CellStyle buildNewStyle4DecimalFormat(CellStyle oriStyle, boolean isClone, int scale) {
        CellStyle newCellStyle = isClone ? this.cloneStyle(oriStyle) : this.wb.createCellStyle();
        this.setDecimalFormat(newCellStyle, scale);
        return newCellStyle;
    }

    private CellStyle cloneStyle(CellStyle oriStyle) {
        CellStyle cellStyleTemp = this.wb.createCellStyle();
        cellStyleTemp.cloneStyleFrom(oriStyle);
        return cellStyleTemp;
    }

    public void setFormat(CellStyle style, String format) {
        style.setDataFormat(this.wb.createDataFormat().getFormat(format));
    }

    public void setDecimalFormat(CellStyle style, int scale) {
        String dataFormatString = style.getDataFormatString();
        int dotInx = dataFormatString.indexOf(".");
        if (dotInx >= 0) {
            dataFormatString = dataFormatString.substring(0, dotInx);
        }
        if ("General".equalsIgnoreCase(dataFormatString)) {
            dataFormatString = "0";
        }
        String format = dataFormatString.concat(".00").replaceAll("\\.00", scale > 0 ? String.format(".%0" + scale + "d", 0) : "");
        style.setDataFormat(this.wb.createDataFormat().getFormat(format));
    }
}

