/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.constant;

import java.util.HashMap;
import java.util.Map;

public interface MCConfigConstant {
    public static final int MONITOR_TIMEOUT = 10;
    public static final int PUT_QUEUE_TIMEOUT = 10;
    public static final int VALIDATE_BATCH_SIZE = 1000;
    public static final int WORKER_BATCH_SIZE = 1000;
    public static final int DB_TRAN_BATCH_SIZE = 50;
    public static final int MIN_OP_SUGGEST_BATCH_SIZE = 100;
    public static final int MIN_OP_SUGGEST_THREADS = 1;
    public static final int RUN_TASK_TIME_OUT = 20;
    public static final int MAX_PUT_QUEUE_RETRY_TIMES = 100;
    public static final int SPLIT_EXCEL_MAX_ROW_COUNT = 0x100000;
    public static final int PROGRESSER_INTERVAL = 1000;
    public static final int TERMINATOR_INTERVAL = 2000;
    public static final int MONITOR_INTERVAL = 2000;
    public static final int TIME_REMAININGANALYSER_INTERVAL = 1000;
    public static final int ALGO_MIN_REMAIN_MEMORY_SIZE = 3024;
    public static final int ALGO_JOIN_MIN_REMAIN_MEMORY_SIZE = 1048;
    public static final int ALGO_RELATE_TEMP_DATA_NEST_LOOP_MODEL_THRESHOLD = 200000;
    public static final int ALGO_RELATE_TEMP_DATA_NEST_LOOP_MODEL_BATCH_SIZE = 1000;
    public static final int EXCEL_ROW_ACCESS_WINDOW_SIZE = 5000;
    public static final int F7BD_QUERY_MAX_COUNT = 100000;
    public static final int F7BD_RELQUERY_MAX_COUNT = 10000;
    public static final int EHCACHE_DISK_CACHE_SIZE = 300;
    public static final String KEY_HR_HIES_DEBUGOFFLINETASK = "hr.hies.debugOffLineTask";
    public static final String KEY_HR_HIES_DISABLETASKQUEUE = "hr.hies.disableTaskQueue";
    public static final String KEY_HR_HIES_TASKDISPATCHER_MAXTHREAD = "hr.hies.taskDispatcher.maxThread";
    public static final String KEY_HR_HIES_ISPRINTMONITORLOG = "hr.hies.isPrintMonitorLog";
    public static final String KEY_HR_HIES_WORKER_MAXTHREAD = "hr.hies.worker.maxThread";
    public static final String KEY_HR_HIES_STAND_EXPENSE = "hr.hies.standExpense";
    public static final String KEY_HR_HIES_CALLOP_MAXBATCHSIZE = "hr.hies.callOpMaxBatchSize";
    public static final String KEY_HR_HIES_QUEUE_SIZE = "hr.hies.queueSize";
    public static final String KEY_HR_HIES_F7_CACHEMAXCOUNT = "hr.hies.cacheMaxCount";
    public static final String KEY_HR_HIES_F7_OUTJVMHEAP_SIZE = "hr.hies.outJVMHeapSize";

    public static Map<String, Object> getAllConfigInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(KEY_HR_HIES_DEBUGOFFLINETASK, MCConfigConstant.debugOffLineTask());
        map.put(KEY_HR_HIES_DISABLETASKQUEUE, MCConfigConstant.isDisableTaskQueue());
        map.put(KEY_HR_HIES_TASKDISPATCHER_MAXTHREAD, MCConfigConstant.getTaskDispatcherMaxThread());
        map.put(KEY_HR_HIES_ISPRINTMONITORLOG, MCConfigConstant.isPrintMonitorLog());
        map.put(KEY_HR_HIES_WORKER_MAXTHREAD, MCConfigConstant.getWorkerMaxThread());
        map.put(KEY_HR_HIES_STAND_EXPENSE, MCConfigConstant.getStandExpense());
        map.put(KEY_HR_HIES_CALLOP_MAXBATCHSIZE, MCConfigConstant.getCallOpMaxBatchSize());
        map.put(KEY_HR_HIES_QUEUE_SIZE, MCConfigConstant.getQueueSize());
        map.put(KEY_HR_HIES_F7_CACHEMAXCOUNT, MCConfigConstant.getF7CacheMaxCount());
        map.put(KEY_HR_HIES_F7_OUTJVMHEAP_SIZE, MCConfigConstant.getOutJVMHeapSize());
        return map;
    }

    public static boolean debugOffLineTask() {
        return Boolean.parseBoolean(System.getProperty(KEY_HR_HIES_DEBUGOFFLINETASK, "false"));
    }

    public static boolean isDisableTaskQueue() {
        return Boolean.parseBoolean(System.getProperty(KEY_HR_HIES_DISABLETASKQUEUE, "false"));
    }

    public static int getTaskDispatcherMaxThread() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_TASKDISPATCHER_MAXTHREAD, "8"));
        }
        catch (Throwable e) {
            return 8;
        }
    }

    public static String isPrintMonitorLog() {
        return System.getProperty(KEY_HR_HIES_ISPRINTMONITORLOG, "true");
    }

    public static int getWorkerMaxThread() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_WORKER_MAXTHREAD, "4"));
        }
        catch (Throwable e) {
            return 4;
        }
    }

    public static int getStandExpense() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_STAND_EXPENSE, "3000"));
        }
        catch (Throwable e) {
            return 3000;
        }
    }

    public static int getCallOpMaxBatchSize() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_CALLOP_MAXBATCHSIZE, "1000"));
        }
        catch (Throwable e) {
            return 1000;
        }
    }

    public static int getQueueSize() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_QUEUE_SIZE, "3000"));
        }
        catch (Throwable e) {
            return 3000;
        }
    }

    public static int getF7CacheMaxCount() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_F7_CACHEMAXCOUNT, "1000"));
        }
        catch (Throwable e) {
            return 1000;
        }
    }

    public static int getOutJVMHeapSize() {
        try {
            return Integer.parseInt(System.getProperty(KEY_HR_HIES_F7_CACHEMAXCOUNT, "50"));
        }
        catch (Throwable e) {
            return 50;
        }
    }
}

