/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.enu;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.enu.TaskResult;
import kd.hr.hies.common.enu.TaskState;

public enum Operate {
    DOWN_SOURCEFILE("down_sourcefile", false, true),
    DOWN_ALLDATAFILE("down_alldatafile", false, true),
    DOWN_ERRDATAFILE("down_errdatafile", false, true),
    DOWN_EXPORTFILE("down_exportfile", false, true),
    OPR_TERMINATE("opr_terminate", false, false);

    private final String type;
    private final boolean showFlag;
    private final boolean checkDownLoadPerm;
    private static final Map<Operate, Boolean> opMappingShowS;

    private Operate(String type, boolean showFlag, boolean checkDownLoadPerm) {
        this.type = type;
        this.showFlag = showFlag;
        this.checkDownLoadPerm = checkDownLoadPerm;
    }

    public boolean isShowFlag() {
        return this.showFlag;
    }

    public String getType() {
        return this.type;
    }

    public boolean isCheckDownLoadPerm() {
        return this.checkDownLoadPerm;
    }

    public static Map<Operate, Boolean> showOprStrategy(TaskResult taskResult, TaskState state, OprType oprType) {
        Map opMappingShow = (Map)HRObjectUtils.clone(opMappingShowS);
        switch (state) {
            case UNINITIATED: 
            case AFOOT: {
                if (OprType.IMPORT == oprType) {
                    opMappingShow.put(DOWN_SOURCEFILE, true);
                }
                opMappingShow.put(OPR_TERMINATE, true);
                break;
            }
            case FINISHED: {
                if (OprType.IMPORT == oprType) {
                    opMappingShow.put(DOWN_SOURCEFILE, true);
                    if (TaskResult.FAIL == taskResult) {
                        opMappingShow.put(DOWN_ERRDATAFILE, true);
                        opMappingShow.put(DOWN_ALLDATAFILE, true);
                    }
                    opMappingShow.put(OPR_TERMINATE, false);
                    break;
                }
                if (OprType.EXPORT != oprType) break;
                opMappingShow.put(DOWN_SOURCEFILE, false);
                opMappingShow.put(DOWN_EXPORTFILE, true);
                opMappingShow.put(OPR_TERMINATE, false);
                break;
            }
            case TERMINATED: {
                if (OprType.IMPORT != oprType) break;
                opMappingShow.put(DOWN_SOURCEFILE, true);
            }
        }
        return opMappingShow;
    }

    public static Operate tranEnumForce(String operate) {
        Operate op = Operate.tranEnum(operate);
        if (op == null) {
            throw new IllegalArgumentException(String.format("operate[%s] is err, please check!for details, please see kd.hr.impt.common.enu.Operate", operate));
        }
        return op;
    }

    public static Operate tranEnum(String operate) {
        if (DOWN_SOURCEFILE.getType().equals(operate)) {
            return DOWN_SOURCEFILE;
        }
        if (DOWN_ALLDATAFILE.getType().equals(operate)) {
            return DOWN_ALLDATAFILE;
        }
        if (DOWN_ERRDATAFILE.getType().equals(operate)) {
            return DOWN_ERRDATAFILE;
        }
        if (DOWN_EXPORTFILE.getType().equals(operate)) {
            return DOWN_EXPORTFILE;
        }
        if (OPR_TERMINATE.getType().equals(operate)) {
            return OPR_TERMINATE;
        }
        return null;
    }

    public static boolean isDownExportFile(String operate) {
        return DOWN_EXPORTFILE.getType().equals(operate);
    }

    public static boolean isDownAllDataFile(String operate) {
        return DOWN_ALLDATAFILE.getType().equals(operate);
    }

    public static String pageFieldKey() {
        return "operate";
    }

    static {
        opMappingShowS = Arrays.stream(Operate.values()).collect(Collectors.toMap(Function.identity(), Operate::isShowFlag));
    }
}

