/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.enu;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hies.common.constant.PageFieldKey;

public enum TaskState implements PageFieldKey
{
    UNINITIATED("uninitiated"),
    AFOOT("afoot"),
    FINISHED("finished"),
    TERMINATED("terminated");

    private static final Map<String, TaskState> cache;
    private final String value;

    private TaskState(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static String pageFieldKey() {
        return "status";
    }

    public static TaskState tranEnum(String state) {
        TaskState taskState = cache.get(state);
        HRAssert.notNull((Object)taskState, (String)String.format("state[%s] is err, please check!for details, please see kd.hr.impt.common.enu.TaskState", state), (Object[])new Object[0]);
        return taskState;
    }

    public static boolean isAfoot(String state) {
        return AFOOT.getValue().equals(state);
    }

    public static boolean isTerminated(String state) {
        return TERMINATED.getValue().equals(state);
    }

    public static boolean isUninitiated(String state) {
        return UNINITIATED.getValue().equals(state);
    }

    static {
        cache = Arrays.stream(TaskState.values()).collect(Collectors.toMap(TaskState::getValue, Function.identity()));
    }
}

