/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.ext.bos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.ext.bos.DefaultFilterValueSetter;
import kd.hr.hies.common.ext.bos.FilterBuilderParameter;
import kd.hr.hies.common.ext.bos.IFilterValueSetter;
import kd.hr.hies.common.ext.bos.ModelTypeFilterValueSetter;
import kd.sdk.annotation.SdkInternal;

@ExcludeFromJacocoGeneratedReport
public class FilterBuilder {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final String LEFT = "Left";
    private static final String RIGHT = "Right";
    private static final String LOGIC = "Logic";
    MainEntityType dataType;
    Map<String, MainEntityType> cachedDataTypes = new HashMap<String, MainEntityType>();
    List<Map<String, List<Object>>> fieldList = new ArrayList<Map<String, List<Object>>>();
    List<Map<String, List<Object>>> addedFieldList = new ArrayList<Map<String, List<Object>>>();
    FilterObject filterObject;
    FilterCondition filterCondition;
    ITimeService timeService;
    IUserService userService = IUserService.getDefInstance();
    IFilterValueSetter filterValueSetter;
    QFilter qFilter;
    List<QFilter> qFilters = new ArrayList<QFilter>();
    String filterString;
    String filterStringDesc;
    boolean isContainMainOrg;
    boolean isMainOrgNoLimit;
    boolean isContainBillStatus;
    boolean isContainUsedStatus;
    private Map<String, List<CompareType>> fieldCompareTypeMap = new HashMap<String, List<CompareType>>(16);
    private boolean hasSetSchemeSetting = false;
    private boolean isNeedParse = true;
    List<Long> selectedMainOrgIds = new ArrayList<Long>();

    @SdkInternal
    public Map<String, List<CompareType>> getFieldCompareTypeMap() {
        return this.fieldCompareTypeMap;
    }

    @SdkInternal
    public void setFieldCompareTypeMap(Map<String, List<CompareType>> fieldCompareTypeMap) {
        this.fieldCompareTypeMap = fieldCompareTypeMap;
    }

    public void addCustomCompareTypes(String fieldName, List<CompareType> compareTypes) {
        List<CompareType> compareTypes1 = this.fieldCompareTypeMap.get(fieldName);
        if (compareTypes1 == null) {
            compareTypes1 = new ArrayList<CompareType>(10);
        }
        compareTypes1.addAll(compareTypes);
        this.fieldCompareTypeMap.put(fieldName, compareTypes1);
    }

    public boolean isContainMainOrg() {
        return this.isContainMainOrg;
    }

    public boolean isMainOrgNoLimit() {
        return this.isMainOrgNoLimit;
    }

    public boolean isContainBillStatus() {
        return this.isContainBillStatus;
    }

    @SdkInternal
    @Deprecated
    public void setContainBillStatus(boolean isContainBillStatus) {
        this.isContainBillStatus = isContainBillStatus;
    }

    public boolean isContainUsedStatus() {
        return this.isContainUsedStatus;
    }

    @SdkInternal
    @Deprecated
    public void setContainUsedStatus(boolean isContainUsedStatus) {
        this.isContainUsedStatus = isContainUsedStatus;
    }

    public QFilter getQFilter() {
        return this.qFilter;
    }

    @SdkInternal
    public void setQFilter(QFilter qFilter) {
        this.qFilter = qFilter;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public String getFilterStringDesc() {
        return this.filterStringDesc;
    }

    @Deprecated
    @SdkInternal
    public void setTimeService(ITimeService timeService) {
        this.timeService = timeService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public FilterObject getFilterObject() {
        return this.filterObject;
    }

    public void setFilterObject(FilterObject filterObject) {
        this.filterObject = filterObject;
    }

    public FilterBuilder(MainEntityType dataType) {
        this(dataType, true);
    }

    public FilterBuilder(MainEntityType dataType, FilterObject filterObject) {
        this(dataType, true);
        this.filterObject = filterObject;
        this.filterObject.setCheckInput(true);
    }

    public FilterBuilder(MainEntityType dataType, boolean isCheckInput) {
        this.filterObject = new FilterObject(dataType, isCheckInput);
        this.filterObject.setFilterMetaData(FilterMetadata.get());
        this.filterObject.setCheckInput(isCheckInput);
        this.dataType = dataType;
        this.cachedDataTypes.put(dataType.getName(), dataType);
    }

    public FilterBuilder(MainEntityType dataType, FilterCondition filterCondition) {
        this(dataType, filterCondition, true, null);
    }

    public FilterBuilder(MainEntityType dataType, FilterCondition filterCondition, boolean isCheckInput) {
        this(new FilterBuilderParameter(dataType, filterCondition).setCheckInput(isCheckInput));
    }

    public FilterBuilder(MainEntityType dataType, FilterCondition filterCondition, boolean isCheckInput, List<FilterField> filterFields) {
        this(new FilterBuilderParameter(dataType, filterCondition).setCheckInput(isCheckInput).setFilterFields(filterFields));
    }

    public FilterBuilder(MainEntityType dataType, FilterCondition filterCondition, IDataModel model) {
        this(new FilterBuilderParameter(dataType, filterCondition).setFilterValueSetter(new ModelTypeFilterValueSetter(model)));
        this.timeService = (ITimeService)model.getService(ITimeService.class);
        this.userService = (IUserService)model.getService(IUserService.class);
    }

    public FilterBuilder(MainEntityType dataType, FilterCondition filterCondition, IFilterValueSetter filterValueSetter, boolean isCheckInput, List<FilterField> filterFields) {
        this(new FilterBuilderParameter(dataType, filterCondition).setFilterValueSetter(filterValueSetter).setCheckInput(isCheckInput).setFilterFields(filterFields));
    }

    public FilterBuilder(FilterBuilderParameter filterBuilderParameter) {
        this.filterCondition = filterBuilderParameter.getFilterCondition();
        this.filterValueSetter = filterBuilderParameter.getFilterValueSetter();
        this.filterObject = new FilterObject(filterBuilderParameter.getDataType(), filterBuilderParameter.isCheckInput());
        this.filterObject.setFilterMetaData(FilterMetadata.get());
        this.filterObject.setCheckInput(filterBuilderParameter.isCheckInput());
        this.dataType = filterBuilderParameter.getDataType();
        this.cachedDataTypes.put(filterBuilderParameter.getDataType().getName(), filterBuilderParameter.getDataType());
        this.isNeedParse = filterBuilderParameter.isNeedParse();
        if (filterBuilderParameter.getFilterFields() != null) {
            this.filterObject.addFields(filterBuilderParameter.getFilterFields());
        }
        this.initFilterField(filterBuilderParameter);
        this.setSchemeSetting(this.fieldList, false);
        this.hasSetSchemeSetting = true;
    }

    public static FilterField getFilterField(FilterObject filterObject, String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        return (FilterField)filterObject.getAllFilterFields().get(fieldName);
    }

    @SdkInternal
    public static LogicOperate getFiledLogic(Object value) {
        int index;
        if (value == null) {
            return LogicOperate.AND;
        }
        LogicOperate logicOperate = !StringUtils.isNumeric((CharSequence)value.toString()) ? (value.equals(LogicOperate.AND.toString()) ? LogicOperate.AND : (value.equals(LogicOperate.OR.toString()) ? LogicOperate.OR : LogicOperate.AND)) : ((index = Integer.parseInt(value.toString())) == 0 ? LogicOperate.AND : (index == 1 ? LogicOperate.OR : LogicOperate.AND));
        return logicOperate;
    }

    @SdkInternal
    public static CompareType getCompareType(String fieldName, FilterField filterField, String compare, Map<String, List<CompareType>> fieldCompareTypeMap) {
        List<CompareType> compareTypes;
        CompareType compareType = filterField.getCompareType(compare);
        if (compareType == null && fieldCompareTypeMap != null && filterField.getFieldProp() instanceof FieldProp && (compareTypes = fieldCompareTypeMap.get(fieldName)) != null) {
            for (CompareType compareType2 : compareTypes) {
                if (!compareType2.getId().equals(compare)) continue;
                compareType = compareType2;
                break;
            }
        }
        if (compareType == null) {
            for (CompareType compareType2 : filterField.getCustomCompareTypes()) {
                if (!compareType2.getId().equals(compare)) continue;
                compareType = compareType2;
                break;
            }
        }
        if (compareType == null && filterField.getFieldProp() instanceof PKFieldProp) {
            for (CompareType type : FilterMetadata.get().getCompareTypes("2")) {
                if (!compare.equals(type.getId()) || type.isNeedInput() || !StringUtils.isNotBlank((CharSequence)type.getClassName())) continue;
                compareType = type;
                break;
            }
        }
        if (compareType == null) {
            compareType = filterField.getCompareType(filterField.getDefaultCompareTypeId());
        }
        if (compareType == null) {
            compareType = (CompareType)filterField.getCompareTypes().get(0);
        }
        return compareType;
    }

    private FilterRow appendFilterRow(Map<String, List<Object>> dct, FilterField filterField, List<String> newValueList, CompareType compareType) {
        String right;
        String left;
        String string = dct.get(LEFT) == null ? "" : (left = dct.get(LEFT).get(0) == null ? "" : dct.get(LEFT).get(0).toString());
        String string2 = dct.get(RIGHT) == null ? "" : (right = dct.get(RIGHT).get(0) == null ? "" : dct.get(RIGHT).get(0).toString());
        String logic = dct.get(LOGIC) == null ? "0" : (dct.get(LOGIC).get(0) == null ? "0" : dct.get(LOGIC).get(0).toString());
        FilterRow filterRow = new FilterRow(filterField.getMainType(), this.filterObject, filterField, left, compareType, newValueList, right, FilterBuilder.getFiledLogic(logic));
        filterRow.setNeedParse(this.isNeedParse);
        this.filterObject.getFilterRows().add(filterRow);
        return filterRow;
    }

    @Deprecated
    @SdkInternal
    public List<Long> getSelectedMainOrgIds() {
        return this.selectedMainOrgIds;
    }

    @Deprecated
    @SdkInternal
    public void setSelectedMainOrgIds(List<Long> selectedMainOrgIds) {
        this.selectedMainOrgIds = selectedMainOrgIds;
    }

    private void parseMainOrgFilter(MainOrgProp mainOrgProp, FilterField filterField, List<String> newValueList) {
        boolean isUseDimField;
        String dimFldKey = this.dataType.getPermissionControlType().getDataDimensionField();
        boolean isControlFuction = this.dataType.getPermissionControlType().isControlFunction();
        boolean bl = isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
        if (!isUseDimField) {
            if (mainOrgProp != null && filterField.getSrcFieldProp().getName().equals(mainOrgProp.getName())) {
                this.isContainMainOrg = true;
                if (newValueList.isEmpty()) {
                    this.isMainOrgNoLimit = true;
                }
            }
        } else if (filterField.getSrcFieldProp().getName().equals(dimFldKey)) {
            this.isContainMainOrg = true;
            if (newValueList.isEmpty()) {
                this.isMainOrgNoLimit = true;
            }
        }
    }

    private void parseSchemeSettingRow(Map<String, List<Object>> dct, MainOrgProp mainOrgProp, BillStatusProp billStatusProp, boolean isList) {
        String fieldName = dct.get("FieldName").get(0).toString();
        FilterField filterField = FilterBuilder.getFilterField(this.filterObject, fieldName);
        if (filterField == null) {
            return;
        }
        if (dct.get("Compare") == null) {
            dct.put("Compare", Collections.singletonList("59"));
        }
        CompareType compareType = FilterBuilder.getCompareType(fieldName, filterField, dct.get("Compare").get(0).toString(), this.fieldCompareTypeMap);
        List<Object> valueList = dct.get("Id");
        if (valueList == null) {
            valueList = dct.get("id");
        }
        if (valueList != null && ("=".equals(compareType.getOperate()) || "<>".equals(compareType.getOperate()) || "IN".equals(compareType.getOperate()) || "Not IN".equals(compareType.getOperate())) || valueList == null && isList && filterField.getSrcFieldProp() instanceof IBasedataField && ("number".equals(filterField.getFieldProp().getName()) || "name".equals(filterField.getFieldProp().getName())) && ("ISNULL".equals(compareType.getValue()) || "ISNOTNULL".equals(compareType.getValue()))) {
            filterField = filterField.convertToId();
        } else {
            valueList = dct.get("Value");
        }
        List newValueList = FilterUtil.getValidValues(valueList);
        this.parseMainOrgFilter(mainOrgProp, filterField, newValueList);
        if (isList && this.isContainMainOrg) {
            this.isMainOrgNoLimit = true;
        }
        if (billStatusProp != null && StringUtils.isNotBlank((Object)filterField.getSrcFieldProp()) && filterField.getSrcFieldProp().getName().equals(billStatusProp.getName())) {
            this.isContainBillStatus = true;
        }
        if (this.dataType instanceof BillEntityType && StringUtils.isNotBlank((Object)filterField.getSrcFieldProp()) && "enable".equalsIgnoreCase(filterField.getSrcFieldProp().getName())) {
            this.isContainUsedStatus = true;
        }
        if (compareType.isNeedInput() && newValueList.isEmpty()) {
            return;
        }
        if (compareType.isBetween() && newValueList.size() != 2) {
            return;
        }
        this.appendFilterRow(dct, filterField, newValueList, compareType);
    }

    @SdkInternal
    public final void setSchemeSetting(List<Map<String, List<Object>>> filterList, boolean isList) {
        this.filterObject.getFilterRows().clear();
        if (filterList != null && !filterList.isEmpty()) {
            MainOrgProp mainOrgProp = null;
            BillStatusProp billStatusProp = null;
            if (this.dataType instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)this.dataType;
                mainOrgProp = billEntityType.getMainOrgProperty();
                if (StringUtils.isNotBlank((CharSequence)billEntityType.getBillStatus())) {
                    billStatusProp = (BillStatusProp)billEntityType.findProperty(billEntityType.getBillStatus());
                }
            }
            for (Map<String, List<Object>> dct : filterList) {
                this.parseSchemeSettingRow(dct, mainOrgProp, billStatusProp, isList);
            }
        }
    }

    private void initFilterField(FilterBuilderParameter filterBuilderParameter) {
        List filterRows = this.filterCondition.getFilterRow();
        for (SimpleFilterRow simpleFilterRow : filterRows) {
            Map<String, List<Object>> fMap;
            FilterField filterField = (FilterField)this.filterObject.getAllFilterFields().get(simpleFilterRow.getFieldName());
            if (filterField == null) {
                filterField = FilterField.create((MainEntityType)filterBuilderParameter.getDataType(), (String)simpleFilterRow.getFieldName());
            }
            List<Object> fieldValue = this.filterValueSetter.getFieldValue(simpleFilterRow);
            if (filterBuilderParameter.isNeedParseBaseDataIds() && filterField != null && filterField.getLatestParent() instanceof IBasedataField && filterField.getFieldProp() instanceof PKFieldProp) {
                fieldValue = this.filterValueSetter.getBaseDataFieldIds(simpleFilterRow);
            }
            if ((fMap = this.buildFieldRow(simpleFilterRow.getFieldName(), String.valueOf(simpleFilterRow.getCompareType()), simpleFilterRow.getLeftBracket(), simpleFilterRow.getRightBracket(), fieldValue, simpleFilterRow.getLogic(), simpleFilterRow.getEntityNumber())) == null) continue;
            this.fieldList.add(fMap);
        }
    }

    @SdkInternal
    public static List<FilterRow> convertIsNullFilterRow(FilterRow filterRow, FilterObject filterObject, FilterField filterField) {
        ArrayList<FilterRow> filterRows = new ArrayList<FilterRow>();
        if (!filterRow.getCompareType().isNeedInput() && "ISNULL".equalsIgnoreCase(filterRow.getCompareType().getValue()) && filterField.getSrcFieldProp() instanceof BasedataProp) {
            CompareType equalCompareType = null;
            for (CompareType compareType : filterField.getCompareTypes()) {
                if (!"=".equals(compareType.getOperate()) || "ISNULL".equals(compareType.getValue())) continue;
                equalCompareType = compareType;
                break;
            }
            if (equalCompareType == null) {
                return filterRows;
            }
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add("0");
            FilterField filterField2 = new FilterField(filterField.getMainType(), filterField.getSrcFieldProp(), null, null, null);
            filterRows.add(new FilterRow(filterField2.getMainType(), filterObject, filterField2, filterRow.getLeftBracket(), equalCompareType, valueList, filterRow.getRightBracket(), filterRow.getLogic()));
        }
        return filterRows;
    }

    public static FilterField getFilterField(MainEntityType dataType, String fieldName) {
        return FilterField.create((MainEntityType)dataType, (String)fieldName);
    }

    public void addFilterField(String fieldName, String compare, String left, String right, List<Object> value, String logic) {
        this.addFilterField(fieldName, compare, left, right, value, logic, null);
    }

    public void addFilterField(String fieldName, String compare, String left, String right, List<Object> value, String logic, String entityNumber) {
        Map<String, List<Object>> fMap = this.buildFieldRow(fieldName, compare, left, right, value, logic, entityNumber);
        if (fMap == null) {
            return;
        }
        if (this.hasSetSchemeSetting) {
            this.addedFieldList.add(fMap);
        } else {
            this.fieldList.add(fMap);
        }
    }

    private MainOrgProp getMainOrgProp() {
        MainOrgProp mainOrgProp = null;
        if (this.dataType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)this.dataType;
            mainOrgProp = billEntityType.getMainOrgProperty();
        }
        return mainOrgProp;
    }

    private Map<String, List<Object>> buildFieldRow(String fieldName, String compare, String left, String right, List<Object> value, String logic, String entityNumber) {
        boolean isUseDimField;
        HashMap<String, List<Object>> fMap = new HashMap<String, List<Object>>();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<String> leftList = new ArrayList<String>();
        ArrayList<String> rightList = new ArrayList<String>();
        ArrayList<String> logicList = new ArrayList<String>();
        ArrayList<String> compareList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)fieldName) || StringUtils.isBlank((CharSequence)compare)) {
            return null;
        }
        List newValueList = null;
        FilterField filterField = FilterBuilder.getFilterField(this.filterObject, fieldName);
        if (filterField == null) {
            MainEntityType fieldEntityType = this.dataType;
            if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
                if (this.cachedDataTypes.get(entityNumber) == null) {
                    fieldEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    this.cachedDataTypes.put(entityNumber, fieldEntityType);
                } else {
                    fieldEntityType = this.cachedDataTypes.get(entityNumber);
                }
            }
            if ((filterField = FilterBuilder.getFilterField(fieldEntityType, fieldName)) == null) {
                KDBizException e = new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.dataType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s\u3002", (String)HiesCommonRes.FilterBuilder_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), fieldName, "FIELDNOTEXISTS000001")});
                HashMap<String, Object> tags = new HashMap<String, Object>(8);
                tags.put("left", left);
                tags.put("entityNumber", entityNumber);
                tags.put("fieldName", fieldName);
                tags.put("compare", compare);
                tags.put("right", right);
                tags.put("value", value);
                tags.put("logic", logic);
                tags.put("mainEntityType", fieldEntityType);
                EntityTracer.throwException((String)this.getClass().getSimpleName(), (String)"buildFieldRow", null, (Throwable)e, tags);
                throw e;
            }
            this.filterObject.addField(filterField);
            List compareTypes = EntityTypeUtil.setCompareTypes((List)filterField.getCompareTypes(), (boolean)(this.filterValueSetter instanceof DefaultFilterValueSetter));
            filterField.getCompareTypes().clear();
            filterField.getCompareTypes().addAll(compareTypes);
        }
        newValueList = FilterUtil.getValidValues(value);
        CompareType compareType = filterField.getCompareType(compare);
        if (compareType != null && compareType.isNeedInput() && newValueList.isEmpty()) {
            fMap = null;
        }
        MainOrgProp mainOrgProp = this.getMainOrgProp();
        String dimFldKey = this.dataType.getPermissionControlType().getDataDimensionField();
        boolean isControlFuction = this.dataType.getPermissionControlType().isControlFunction();
        boolean bl = isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
        if (!isUseDimField) {
            if (mainOrgProp != null && filterField.getSrcFieldKey().equals(mainOrgProp.getName())) {
                this.isContainMainOrg = true;
                if (fMap == null) {
                    this.isMainOrgNoLimit = true;
                }
            }
        } else if (filterField.getSrcFieldProp().getName().equals(dimFldKey)) {
            this.isContainMainOrg = true;
            if (fMap == null) {
                this.isMainOrgNoLimit = true;
            }
        }
        if (fMap != null) {
            fieldNameList.add(fieldName);
            leftList.add(left);
            rightList.add(right);
            logicList.add(logic);
            compareList.add(compare);
            fMap.put("FieldName", fieldNameList);
            fMap.put("Value", newValueList);
            fMap.put("Compare", compareList);
            fMap.put(LEFT, leftList);
            fMap.put(RIGHT, rightList);
            fMap.put(LOGIC, logicList);
        }
        return fMap;
    }

    public void buildFilter() {
        this.buildFilter(true);
    }

    public void buildFilter(boolean returnSql) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create((String)"FilterBuilder", (String)"buildFilter");
            if (!this.fieldList.isEmpty() && !this.hasSetSchemeSetting) {
                this.setSchemeSetting(this.fieldList, false);
            }
            if (!this.addedFieldList.isEmpty() && this.hasSetSchemeSetting) {
                this.setSchemeSetting(this.addedFieldList, false);
            }
            this.filterObject.setUserService(this.userService);
            this.filterObject.buildFilter(returnSql);
            this.qFilter = this.filterObject.getFilterResult().getQFilter();
            this.filterString = this.filterObject.getFilterResult().getFilterGroup()[0];
            this.filterStringDesc = this.filterObject.getFilterResult().getFilterGroup()[1];
            this.qFilters = this.filterObject.getFilterResult().getQFilters();
        }
    }

    public String[] buildFilterScript() {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create((String)"FilterBuilder", (String)"buildFilterScript");
            this.filterObject.setUserService(this.userService);
            String[] stringArray = this.filterObject.buildFilterScript();
            return stringArray;
        }
    }

    @SdkInternal
    @Deprecated
    public static CompareType getCustomCompareType(String fieldName, CompareType compareType, String compare, IDataEntityProperty fieldProp, Map<String, List<CompareType>> fieldCompareTypeMap) {
        List<CompareType> compareTypes;
        if (fieldProp instanceof FieldProp && (compareTypes = fieldCompareTypeMap.get(fieldName)) != null) {
            for (CompareType compareType2 : compareTypes) {
                if (!compareType2.getId().equals(compare)) continue;
                return compareType2;
            }
        }
        return compareType;
    }
}

