/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.business.export.MergeColBO;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

@ExcludeFromJacocoGeneratedReport
public class ExcelUtil {
    private static final Log LOGGER = LogFactory.getLog(ExcelUtil.class);

    public static void doMerge(SXSSFSheet sheet, ExportSheetStyle styles, int titleEndCol, Map<String, MergeColBO> mergeFirstColMap, SXSSFRow titleRow, int titleStartCol, boolean existMergeCol) {
        if (!existMergeCol) {
            return;
        }
        Set<Integer> mergeColeds = MapUtils.isNotEmpty(mergeFirstColMap) ? ExcelUtil.mergeCol(sheet, styles, mergeFirstColMap) : new HashSet<Integer>(8);
        int mergeEndRow = titleRow.getRowNum();
        int mergeStartRow = mergeEndRow - 1;
        while (titleStartCol <= titleEndCol) {
            if (mergeColeds.add(titleStartCol)) {
                SXSSFCell cell = titleRow.getCell(titleStartCol);
                String val = cell.getStringCellValue();
                CellStyle cellStyle = cell.getCellStyle();
                CellRangeAddress cellAddresses = new CellRangeAddress(mergeStartRow, mergeEndRow, titleStartCol, titleStartCol);
                sheet.addMergedRegion(cellAddresses);
                SXSSFRow row = ExcelUtil.getRow(sheet, mergeStartRow);
                cell = row.createCell(titleStartCol);
                cell.setCellValue(val);
                cell.setCellStyle(cellStyle);
            }
            ++titleStartCol;
        }
    }

    public static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        try {
            SXSSFRow row = sheet.getRow(r);
            if (row == null) {
                row = sheet.createRow(r);
            }
            return row;
        }
        catch (Exception e) {
            LOGGER.info("writeExcel_getRow_exception,r=" + r);
            throw e;
        }
    }

    private static Set<Integer> mergeCol(SXSSFSheet sheet, ExportSheetStyle styles, Map<String, MergeColBO> mergeFirstColMap) {
        HashSet<Integer> mergeColeds = new HashSet<Integer>(8);
        mergeFirstColMap.entrySet().forEach(item -> {
            MergeColBO mergeColBO = (MergeColBO)item.getValue();
            if (mergeColBO.getLastCol() > 0) {
                try {
                    int firstCol = mergeColBO.getFirstCol();
                    int lastCol = mergeColBO.getLastCol();
                    int tempCol = firstCol;
                    mergeColeds.add(firstCol);
                    mergeColeds.add(lastCol);
                    while (tempCol < lastCol) {
                        mergeColeds.add(++tempCol);
                    }
                    int firstRow = mergeColBO.getFirstRow();
                    CellRangeAddress cellAddresses = new CellRangeAddress(firstRow, mergeColBO.getLastRow(), firstCol, lastCol);
                    sheet.addMergedRegion(cellAddresses);
                    SXSSFRow row = ExcelUtil.getRow(sheet, firstRow);
                    SXSSFCell cell = row.createCell(firstCol);
                    cell.setCellValue(mergeColBO.getValue());
                    cell.setCellStyle(styles.getHeadTextStyle("CENTER"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return mergeColeds;
    }

    public static void buildMergeInfo(int splitStartColumn, int column, boolean needMerge, Map<String, MergeColBO> mergeFirstColMap, Map<String, MergeColBO> mergeLastColMap, String fieldName) {
        if (needMerge) {
            MergeColBO mergeColBO = mergeFirstColMap.get(fieldName);
            if (ObjectUtils.isNotEmpty((Object)mergeColBO)) {
                mergeColBO.setFirstCol(splitStartColumn);
            } else {
                mergeColBO = mergeLastColMap.get(fieldName);
                if (ObjectUtils.isNotEmpty((Object)mergeColBO)) {
                    mergeColBO.setLastCol(column);
                }
            }
        }
    }

    public static SXSSFCell createCell(SXSSFWorkbook wb, SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    public static int calcColumnWidth(String caption, int designatedColWidth) {
        if (null == caption) {
            caption = "";
        }
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        int colWidth = 0;
        try {
            colWidth = 256 * (caption.getBytes("GBK").length + 8);
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    public static String getFinalSplitFieldDisplayName(String itemKey, int j, Map<String, Object> property, boolean isImportTpl, List<String> splitColDisplayNames) {
        String inputType = (String)property.get("InputType");
        String displayName = splitColDisplayNames.get(j);
        String desjson = HIESUtil.trimTplFieldEntitydescription((String)property.get("EntityDescription"));
        try {
            if ("basedata".equals(inputType) && StringUtils.isNotBlank((CharSequence)desjson)) {
                LocaleString lang;
                String lastKey = MethodUtil.getLastKey(itemKey);
                Map map = (Map)SerializationUtils.fromJsonString((String)desjson, Map.class);
                if (!itemKey.contains(".")) {
                    lastKey = isImportTpl ? lastKey : "number_name";
                }
                return StringUtils.isEmpty((CharSequence)(lang = (LocaleString)SerializationUtils.fromJsonString((String)((String)map.get(lastKey)), LocaleString.class)).getLocaleValue()) ? displayName : lang.getLocaleValue();
            }
            if ("multilang".equals(inputType) && StringUtils.isNotBlank((CharSequence)desjson)) {
                String firstKey = MethodUtil.getLevelOneKey(itemKey);
                Map map = (Map)SerializationUtils.fromJsonString((String)desjson, Map.class);
                LocaleString lang = (LocaleString)SerializationUtils.fromJsonString((String)((String)map.get(firstKey)), LocaleString.class);
                if (StringUtils.isNotEmpty((CharSequence)lang.getLocaleValue())) {
                    String sourceDisplayName = (String)property.get("DisplayName");
                    return displayName.replace(sourceDisplayName, lang.getLocaleValue());
                }
                return displayName;
            }
            return displayName;
        }
        catch (Throwable e) {
            LOGGER.warn(e);
            return displayName;
        }
    }

    public static List<String> getEnabledLangList() {
        List enabledLang = InteServiceHelper.getMultiLangEnabledLang();
        ArrayList<String> langList = new ArrayList<String>(enabledLang.size());
        for (EnabledLang lang : enabledLang) {
            langList.add(lang.getNumber());
        }
        return langList;
    }

    public static Boolean multipleColumnsField(Object inputType) {
        return "basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType);
    }

    public static String getFinalFieldDisplayName(Map<String, Object> property) {
        String displayName = (String)property.get("DisplayName");
        String json = HIESUtil.trimTplFieldEntitydescription((String)property.get("EntityDescription"));
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                LocaleString lang = (LocaleString)SerializationUtils.fromJsonString((String)((String)map.get(property.get("propName"))), LocaleString.class);
                return lang.getLocaleValue();
            }
            catch (Throwable e) {
                LOGGER.warn(e);
                return displayName;
            }
        }
        return displayName;
    }

    public static String getDownloadUrl(String surl, String entityId, String permId) {
        DisposableUrlParam param = new DisposableUrlParam();
        param.setEntityNum(entityId);
        param.setPath(surl);
        param.setPermItem(permId);
        param.setPkId((Object)0L);
        return AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)param);
    }
}

