/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.SelectFieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceAppBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceCloudBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceEntityBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.bo.ObjJoinEntity;
import kd.hr.hies.common.bo.ObjQueryField;

@ExcludeFromJacocoGeneratedReport
public class FieldDefineService {
    private static final Log LOGGER = LogFactory.getLog(FieldDefineService.class);
    private static final String HBSS_CLOUD = "hbss_cloud";
    private static final String CLOUD_ID = "cloud.id";
    private static final String CLOUD_NAME = "cloud.name";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_ENTITYOBJECT = "bos_entityobject";
    private static final String BIZCLOUD_ID = "bizcloud.id";
    private static final String BIZAPPID_ID = "bizappid.id";
    private final Map<String, String> baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
    private boolean setComplexType = true;

    public List<FieldTreeNode> getEntityAllFields(List<ObjJoinEntity> joinEntities, List<ObjQueryField> queryFields, Set<String> refByReportFieldAliasList) {
        ArrayList fieldTreeNodeList = Lists.newArrayListWithCapacity((int)10);
        for (ObjJoinEntity joinEntity : joinEntities) {
            boolean isMainEntity = HRStringUtils.equals((String)joinEntity.getType(), (String)"main");
            FieldTreeNode entityFiledBo = this.getEntityFiledBo(joinEntity.getEntityNumber(), joinEntity.getEntityAlias(), isMainEntity, queryFields, false, refByReportFieldAliasList);
            this.replaceTitle(joinEntity, entityFiledBo);
            fieldTreeNodeList.add(entityFiledBo);
        }
        return fieldTreeNodeList;
    }

    public FieldTreeNode getEntityFiledBo(String entityNum, String entityAlias, boolean isMainEntity, List<ObjQueryField> queryFields, boolean lockSelectedField, Set<String> refByReportFieldAliasList) {
        EntityType entityType;
        Map<String, ObjQueryField> fieldMap = Collections.emptyMap();
        if (queryFields != null && !queryFields.isEmpty()) {
            fieldMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String entityName = dataEntityType.getDisplayName().getLocaleValue();
        String[] split = entityAlias.split("\u03b4");
        String suffix = "";
        if (split.length > 1) {
            suffix = split[1];
            entityName = entityName + suffix;
        }
        FieldTreeNode fieldTreeNode = new FieldTreeNode(dataEntityType.getDisplayName(), suffix, entityAlias, false, false);
        Map allEntities = dataEntityType.getAllEntities();
        EntityType mainEntityType = (EntityType)allEntities.get(entityNum);
        this.collectPropBo(mainEntityType, fieldTreeNode.getChildren(), entityName, entityNum, entityAlias, isMainEntity, fieldMap, lockSelectedField, refByReportFieldAliasList, false, false, null);
        HashMap entryProps = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            entityType = (EntityType)entityTypeEntry.getValue();
            if (!HRStringUtils.isNotEmpty((String)entityType.getAlias()) || !(entityType instanceof EntryType) || entityType instanceof SubEntryType) continue;
            FieldTreeNode entryBo = new FieldTreeNode(entityType.getDisplayName(), "", entityAlias + "@" + entityType.getName(), true, false);
            this.collectPropBo(entityType, entryBo.getChildren(), entityName, entityNum, entityAlias, isMainEntity, fieldMap, lockSelectedField, refByReportFieldAliasList, true, false, entryBo.getNumber());
            entryProps.putIfAbsent(entityType.getName(), entryBo);
            fieldTreeNode.getChildren().add(entryBo);
        }
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            entityType = (EntityType)entityTypeEntry.getValue();
            if (!HRStringUtils.isNotEmpty((String)entityType.getAlias()) || !(entityType instanceof SubEntryType)) continue;
            IDataEntityType parent = entityType.getParent();
            FieldTreeNode parentBo = (FieldTreeNode)entryProps.get(parent.getName());
            FieldTreeNode subEntryBo = new FieldTreeNode(entityType.getDisplayName(), "", entityAlias + "@" + entityType.getName(), false, true);
            this.collectPropBo(entityType, subEntryBo.getChildren(), entityName, entityNum, entityAlias, isMainEntity, fieldMap, lockSelectedField, refByReportFieldAliasList, false, true, subEntryBo.getNumber());
            parentBo.getChildren().add(subEntryBo);
        }
        return fieldTreeNode;
    }

    private boolean fieldIsLock(ObjQueryField field, boolean lockSelectedField, Set<String> refByReportFieldAliasList) {
        if (field == null) {
            return false;
        }
        if (lockSelectedField) {
            return true;
        }
        if (Boolean.TRUE.equals(field.getSysPresetFlag())) {
            return true;
        }
        return refByReportFieldAliasList != null && (refByReportFieldAliasList.contains(field.getFieldAlias()) || refByReportFieldAliasList.contains(field.getHRFilterParam()));
    }

    private void collectPropBo(EntityType entityType, List<FieldTreeNode> children, String entityName, String entityNum, String entityAlias, boolean isMainEntity, Map<String, ObjQueryField> fieldMap, boolean lockSelectedField, Set<String> refByReportFieldAliasList, Boolean isEntryField, Boolean isSubEntryField, String entryAlias) {
        for (Map.Entry propertyEntry : entityType.getFields().entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)propertyEntry.getValue();
            if (property instanceof MulBasedataProp || HRStringUtils.isEmpty((String)property.getAlias())) continue;
            String fieldPath = AnalyseObjectUtil.getFiledPath((String)entityNum, (boolean)isMainEntity, (IDataEntityProperty)property);
            String fieldAlias = AnalyseObjectUtil.getFiledPath((String)entityAlias, (boolean)isMainEntity, (IDataEntityProperty)property);
            FieldTreeNode propBo = this.getPropBo(entityName, entityNum, fieldAlias, fieldPath, property, fieldMap, lockSelectedField, refByReportFieldAliasList, null, isEntryField, isSubEntryField, entryAlias, 0);
            children.add(propBo);
        }
    }

    private FieldTreeNode getPropBo(String entityName, String entityNum, String fieldAlias, String fieldPath, IDataEntityProperty property, Map<String, ObjQueryField> fieldMap, boolean lockSelectedField, Set<String> refByReportFieldAliasList, LocaleString parentName, Boolean isEntryField, Boolean isSubEntryField, String entryAlias, int baseDataLayer) {
        FieldTreeNode propBo;
        if (property instanceof BasedataProp) {
            propBo = this.getBaseDataPropBo(entityName, entityNum, fieldAlias, fieldPath, (BasedataProp)property, fieldMap, lockSelectedField, refByReportFieldAliasList, parentName, isEntryField, isSubEntryField, entryAlias, ++baseDataLayer);
        } else {
            String valueType = AnalyseObjectUtil.getFieldValueType((IDataEntityProperty)property);
            LocaleString displayName = property.getDisplayName();
            displayName = this.concatFieldDisplayName(parentName, displayName);
            propBo = new FieldTreeNode(entityName, entityNum, displayName, property.getName(), fieldAlias, fieldPath, valueType, isEntryField, isSubEntryField, entryAlias);
            propBo.setComplexType(FieldComplexType.NORMAL.getValue());
            ObjQueryField field = fieldMap.get(fieldAlias);
            if (field != null) {
                propBo.setName(field.getFieldName());
                propBo.setSelected(Boolean.valueOf(field.getSelectedField() == null || field.getSelectedField() != false));
                if (this.fieldIsLock(field, lockSelectedField, refByReportFieldAliasList)) {
                    propBo.setDisabled(Boolean.valueOf(true));
                }
            }
            if (property instanceof ComboProp) {
                String enumEntityNum = property.getParent() instanceof EntryType ? property.getParent().getParent().getName() : property.getParent().getName();
                propBo.setEnumEntityNum(enumEntityNum);
            }
            if (property instanceof PictureProp) {
                propBo.setLabelIgnore(Boolean.valueOf(true));
            }
            propBo.setControlProp(property.getClass().getName());
        }
        return propBo;
    }

    private FieldTreeNode getBaseDataPropBo(String entityName, String entityNum, String fieldAlias, String fieldPath, BasedataProp property, Map<String, ObjQueryField> fieldMap, boolean lockSelectedField, Set<String> refByReportFieldAliasList, LocaleString parentName, Boolean isEntryField, Boolean isSubEntryField, String entryAlias, int baseDataLayer) {
        String fieldNum = property.getName() + ".id";
        ObjQueryField field = fieldMap.get(fieldAlias + ".id");
        String baseDataAlias = fieldAlias + ".id";
        String baseDataPath = fieldPath + ".id";
        String valueType = AnalyseObjectUtil.getFieldValueType((IDataEntityProperty)property);
        LocaleString displayName = property.getDisplayName();
        displayName = this.concatFieldDisplayName(parentName, displayName);
        FieldTreeNode propBo = new FieldTreeNode(entityName, entityNum, displayName, fieldNum, baseDataAlias, baseDataPath, valueType, isEntryField, isSubEntryField, entryAlias);
        if (field != null) {
            propBo.setName(field.getFieldName());
            propBo.setSelected(Boolean.valueOf(field.getSelectedField() == null || field.getSelectedField() != false));
            if (this.fieldIsLock(field, lockSelectedField, refByReportFieldAliasList)) {
                propBo.setDisabled(Boolean.valueOf(true));
            }
        }
        if (field == null || HRStringUtils.isEmpty((String)field.getComplexType())) {
            if (this.setComplexType) {
                propBo.setComplexType(AnalyseObjectUtil.getFieldComplexType((IDataEntityProperty)property, this.baseDataMap));
            } else {
                propBo.setComplexType(AnalyseObjectUtil.getFieldComplexTypeForNormal((IDataEntityProperty)property));
            }
        } else {
            propBo.setComplexType(field.getComplexType());
        }
        propBo.setBaseDataNum(property.getBaseEntityId());
        String baseDataIdType = property.getRefIdProp() instanceof LongProp ? "long" : "string";
        propBo.setBaseDataIdType(baseDataIdType);
        propBo.setControlProp(property.getClass().getName());
        if (baseDataLayer == 3) {
            return propBo;
        }
        DataEntityPropertyCollection relProps = property.getComplexType().getProperties();
        ArrayList childrenProps = Lists.newArrayListWithCapacity((int)relProps.size());
        for (IDataEntityProperty relProp : relProps) {
            ObjQueryField refQueryFieldBo;
            String propNum = relProp.getName();
            if (HRStringUtils.isEmpty((String)propNum) || HRStringUtils.equals((String)"id", (String)propNum) || HRStringUtils.equals((String)"masterid", (String)propNum) || HRStringUtils.equals((String)"multilanguagetext", (String)propNum) || propNum.endsWith("_id") || relProp instanceof EntryProp || relProp instanceof MulBasedataProp || HRStringUtils.isEmpty((String)relProp.getAlias())) continue;
            String relPropPath = fieldPath + "." + propNum;
            String relPropAlias = fieldAlias + "." + propNum;
            FieldTreeNode refPropBo = this.getPropBo(entityName, entityNum, relPropAlias, relPropPath, relProp, fieldMap, lockSelectedField, refByReportFieldAliasList, propBo.getName(), isEntryField, isSubEntryField, entryAlias, baseDataLayer);
            if (relProp instanceof PictureProp) {
                refPropBo.setLabelIgnore(Boolean.valueOf(true));
            }
            if ((refQueryFieldBo = fieldMap.get(refPropBo.getFieldAlias())) == null || HRStringUtils.isEmpty((String)refQueryFieldBo.getComplexType())) {
                if (this.setComplexType) {
                    refPropBo.setComplexType(AnalyseObjectUtil.getFieldComplexType((IDataEntityProperty)relProp, this.baseDataMap));
                } else {
                    refPropBo.setComplexType(AnalyseObjectUtil.getFieldComplexTypeForNormal((IDataEntityProperty)relProp));
                }
            } else {
                refPropBo.setComplexType(refQueryFieldBo.getComplexType());
            }
            refPropBo.setBaseDataNum(property.getBaseEntityId());
            baseDataIdType = property.getRefIdProp() instanceof LongProp ? "long" : "string";
            refPropBo.setBaseDataIdType(baseDataIdType);
            refPropBo.setControlProp(relProp.getClass().getName());
            childrenProps.add(refPropBo);
        }
        propBo.setChildren((List)childrenProps);
        return propBo;
    }

    private LocaleString concatFieldDisplayName(LocaleString parentName, LocaleString displayName) {
        if (displayName == null || displayName.getLocaleValue() == null) {
            return new LocaleString("null");
        }
        if (parentName != null && !displayName.getLocaleValue().startsWith(parentName.getLocaleValue())) {
            displayName = (LocaleString)HRObjectUtils.clone((Object)displayName);
            displayName.setLocaleValue_zh_CN(parentName.getLocaleValue_zh_CN() + displayName.getLocaleValue_zh_CN());
            if (parentName.getLocaleValue_en() != null && displayName.getLocaleValue_en() != null) {
                displayName.setLocaleValue_en(parentName.getLocaleValue_en() + displayName.getLocaleValue_en());
            }
            if (parentName.getLocaleValue_zh_TW() != null && displayName.getLocaleValue_zh_TW() != null) {
                displayName.setLocaleValue_zh_TW(parentName.getLocaleValue_zh_TW() + displayName.getLocaleValue_zh_TW());
            }
        }
        return displayName;
    }

    public List<DataSourceCloudBo> getDataSourceTree() {
        long startTime = System.currentTimeMillis();
        HRBaseServiceHelper hrCloudServiceHelper = new HRBaseServiceHelper(HBSS_CLOUD);
        DynamicObject[] cloudDys = hrCloudServiceHelper.query("cloud.id,cloud.name", new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])}, "index asc");
        Set cloudIds = Arrays.stream(cloudDys).map(cloudDy -> cloudDy.getString(CLOUD_ID)).collect(Collectors.toSet());
        HRBaseServiceHelper hrCloudAppServiceHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        DynamicObject[] cloudToAppsDys = hrCloudAppServiceHelper.query("bizcloud.id, bizcloud.name, id, name, type, inheritpath", new QFilter[]{new QFilter(BIZCLOUD_ID, "in", cloudIds)});
        Map<String, List<DynamicObject>> cloudToOriginalAppsMap = Arrays.stream(cloudToAppsDys).filter(cloudToAppsDy -> HRStringUtils.equals((String)"0", (String)cloudToAppsDy.getString("type"))).collect(Collectors.groupingBy(cloudToAppsDy -> cloudToAppsDy.getString(BIZCLOUD_ID)));
        Map<String, List<DynamicObject>> cloudToAllAppsMap = Arrays.stream(cloudToAppsDys).filter(cloudToAppsDy -> HRStringUtils.isNotEmpty((String)cloudToAppsDy.getString(BIZCLOUD_ID))).collect(Collectors.groupingBy(cloudToAppsDy -> cloudToAppsDy.getString(BIZCLOUD_ID)));
        HashMap cloudToFinalNewExtendedAppsMap = new HashMap(cloudToAllAppsMap.size());
        cloudToAllAppsMap.forEach((cloudId, allAppDys) -> {
            ArrayList finalNewExtendedAppIds = new ArrayList();
            List originalAppidDys = (List)cloudToOriginalAppsMap.get(cloudId);
            originalAppidDys.forEach(originalAppidDy -> {
                List extendedAppDys = allAppDys.stream().filter(allAppDy -> HRStringUtils.equals((String)"2", (String)allAppDy.getString("type")) && allAppDy.getString("inheritpath").contains(originalAppidDy.getString("id"))).sorted(Comparator.comparing(allAppDy -> allAppDy.getString("inheritpath").length())).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(extendedAppDys)) {
                    DynamicObject finalNewExtendedAppDy = (DynamicObject)extendedAppDys.get(extendedAppDys.size() - 1);
                    finalNewExtendedAppIds.add(finalNewExtendedAppDy);
                } else {
                    finalNewExtendedAppIds.add(originalAppidDy);
                }
            });
            cloudToFinalNewExtendedAppsMap.put(cloudId, finalNewExtendedAppIds);
        });
        Set appIds = Arrays.stream(cloudToAppsDys).map(dy -> dy.getString("id")).collect(Collectors.toSet());
        HRBaseServiceHelper entityServiceHelper = new HRBaseServiceHelper(BOS_ENTITYOBJECT);
        QFilter appidFilter = new QFilter(BIZAPPID_ID, "in", appIds);
        QFilter modelTypeFilter = new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"});
        QFilter tableNameFilter = new QFilter("tablename", "!=", (Object)" ");
        DynamicObject[] entityDys = entityServiceHelper.query("id, name, bizappid.id, tablename", new QFilter[]{appidFilter, modelTypeFilter, tableNameFilter});
        Map<String, List<DynamicObject>> appToEntitiesMaps = Arrays.stream(entityDys).collect(Collectors.groupingBy(dy -> dy.getString(BIZAPPID_ID)));
        ArrayList<DataSourceCloudBo> dataSourceClouds = new ArrayList<DataSourceCloudBo>(4);
        Arrays.stream(cloudDys).forEach(cloudDy -> {
            DataSourceCloudBo dataSourceCloudBo = new DataSourceCloudBo();
            dataSourceCloudBo.setKey(cloudDy.getString(CLOUD_ID));
            dataSourceCloudBo.setTitle(cloudDy.getString(CLOUD_NAME));
            List appDys = (List)cloudToFinalNewExtendedAppsMap.get(cloudDy.getString(CLOUD_ID));
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)appDys)) {
                dataSourceClouds.add(dataSourceCloudBo);
                return;
            }
            ArrayList apps = new ArrayList(16);
            appDys.forEach(appDy -> {
                ArrayList<String> allAppids = new ArrayList<String>();
                if (HRStringUtils.equals((String)"2", (String)appDy.getString("type"))) {
                    String inheritpath = appDy.getString("inheritpath");
                    String[] inheritpaths = inheritpath.split(",");
                    allAppids.addAll(Arrays.asList(inheritpaths));
                }
                allAppids.add(appDy.getString("id"));
                DataSourceAppBo dataSourceAppBo = new DataSourceAppBo();
                dataSourceAppBo.setKey(appDy.getString("id"));
                dataSourceAppBo.setTitle(appDy.getString("name"));
                allAppids.forEach(appid -> {
                    List appToEntityDys = (List)appToEntitiesMaps.get(appid);
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)appToEntityDys)) {
                        return;
                    }
                    ArrayList entities = dataSourceAppBo.getChildren();
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entities)) {
                        entities = new ArrayList(16);
                    }
                    ArrayList finalEntities = entities;
                    appToEntityDys.forEach(appToEntityDy -> {
                        DataSourceEntityBo dataSourceEntityBo = new DataSourceEntityBo();
                        dataSourceEntityBo.setKey(appToEntityDy.getString("id"));
                        dataSourceEntityBo.setTitle(appToEntityDy.getString("name"));
                        finalEntities.add(dataSourceEntityBo);
                    });
                    dataSourceAppBo.setChildren(finalEntities);
                });
                apps.add(dataSourceAppBo);
            });
            dataSourceCloudBo.setChildren(apps);
            dataSourceClouds.add(dataSourceCloudBo);
        });
        String result = SerializationUtils.toJsonString(dataSourceClouds);
        long endTime = System.currentTimeMillis();
        LOGGER.info(String.format("getAllDataSource-consume-time:%s", endTime - startTime));
        LOGGER.info(String.format("getAllDataSource-result:%s", result));
        return dataSourceClouds;
    }

    public List<String> getAllEntitiesForVirtual(List<DataSourceAppBo> dataSourceAppBos) {
        ArrayList<String> entities = new ArrayList<String>(16);
        if (CollectionUtils.isEmpty(dataSourceAppBos)) {
            return entities;
        }
        dataSourceAppBos.forEach(dataSourceAppBo -> {
            List dataSourceEntityBos = dataSourceAppBo.getChildren();
            if (CollectionUtils.isEmpty((Collection)dataSourceEntityBos)) {
                return;
            }
            dataSourceEntityBos.forEach(dataSourceEntityBo -> entities.add(dataSourceEntityBo.getKey()));
        });
        return entities;
    }

    public List<String> getAllEntities(List<DataSourceCloudBo> dataSourceCloudBos) {
        ArrayList<String> entities = new ArrayList<String>(16);
        dataSourceCloudBos.forEach(dataSourceCloudBo -> {
            List dataSourceAppBos = dataSourceCloudBo.getChildren();
            if (CollectionUtils.isEmpty((Collection)dataSourceAppBos)) {
                return;
            }
            dataSourceAppBos.forEach(dataSourceAppBo -> {
                List dataSourceEntityBos = dataSourceAppBo.getChildren();
                if (CollectionUtils.isEmpty((Collection)dataSourceEntityBos)) {
                    return;
                }
                dataSourceEntityBos.forEach(dataSourceEntityBo -> entities.add(dataSourceEntityBo.getKey()));
            });
        });
        return entities;
    }

    public boolean isSetComplexType() {
        return this.setComplexType;
    }

    public void setSetComplexType(boolean setComplexType) {
        this.setComplexType = setComplexType;
    }

    public void replaceTitle(ObjJoinEntity joinEntity, FieldTreeNode entityFiledBo) {
        EntityRelationCommonBo entityRelation = joinEntity.getEntityRelation();
        if (entityRelation != null) {
            LocaleString displayName = entityRelation.getDisplayName();
            if ("2".equals(entityRelation.getRelationType()) && displayName != null && !displayName.isEmpty()) {
                entityFiledBo.setTitle(displayName.getLocaleValue());
                this.setEntityName(entityFiledBo, displayName.getLocaleValue());
            }
        }
    }

    private void setEntityName(FieldTreeNode entityFiledBo, String name) {
        entityFiledBo.setEntityName(name);
        List children = entityFiledBo.getChildren();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)children)) {
            for (FieldTreeNode child : children) {
                this.setEntityName(child, name);
            }
        }
    }

    public static SelectFieldTreeNode getEntityFields(String entityNum, String entityAlias, boolean isMainEntity) {
        return FieldDefineService.getEntityFields(entityNum, entityAlias, isMainEntity, false, false);
    }

    public static SelectFieldTreeNode getEntityFields(String entityNum, String entityAlias, boolean isMainEntity, boolean isHideEntryField, boolean isOnlyShowHRBDField) {
        SelectFieldTreeNode fieldTreeNode = new SelectFieldTreeNode();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String entityName = dataEntityType.getDisplayName().getLocaleValue();
        if (entityAlias.contains("\u03b4")) {
            String numStr = entityAlias.substring(entityAlias.indexOf("\u03b4") + 1);
            entityName = entityName + numStr;
        }
        fieldTreeNode.setName(entityName);
        fieldTreeNode.setNumber(entityNum);
        fieldTreeNode.setField(Boolean.valueOf(false));
        ArrayList children = Lists.newArrayListWithCapacity((int)10);
        fieldTreeNode.setChildren((List)children);
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(entityNum);
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
        FieldDefineService.collectPropBo(entityName, entityType, fieldTreeNode.getChildren(), entityAlias, isMainEntity, "", false, baseDataMap, isOnlyShowHRBDField);
        if (isHideEntryField) {
            return fieldTreeNode;
        }
        String finalEntityName = entityName;
        allEntities.forEach((entryEntityNum, entryEntityType) -> {
            if (HRStringUtils.equals((String)entityNum, (String)entryEntityNum)) {
                return;
            }
            if (HRStringUtils.isEmpty((String)entryEntityType.getAlias())) {
                return;
            }
            SelectFieldTreeNode entryEntityNode = new SelectFieldTreeNode();
            entryEntityNode.setName(entryEntityType.getDisplayName().getLocaleValue());
            entryEntityNode.setLongName(finalEntityName + "." + entryEntityNode.getName());
            entryEntityNode.setNumber(entryEntityNum);
            entryEntityNode.setFieldAlias(entityAlias + "." + entryEntityNum);
            entryEntityNode.setField(Boolean.valueOf(false));
            ArrayList entryChildren = Lists.newArrayListWithCapacity((int)10);
            String entrySuffix = null;
            if (entryEntityType instanceof SubEntryType) {
                entrySuffix = entryEntityType.getParent().getName() + "." + entryEntityNum;
            } else if (entryEntityType instanceof EntryType) {
                entrySuffix = entryEntityNum;
            }
            FieldDefineService.collectPropBo(entryEntityNode.getLongName(), entryEntityType, entryChildren, entityAlias, isMainEntity, entrySuffix, true, baseDataMap, isOnlyShowHRBDField);
            entryEntityNode.setChildren((List)entryChildren);
            fieldTreeNode.getChildren().add(entryEntityNode);
        });
        return fieldTreeNode;
    }

    private static void collectPropBo(String parentNodeLongName, EntityType entityType, List<SelectFieldTreeNode> children, String entityAlias, boolean isMainEntity, String entrySuffix, boolean isEntry, Map<String, String> baseDataMap, boolean isOnlyShowHRBDField) {
        IDataEntityProperty property;
        if (!isEntry && !isOnlyShowHRBDField) {
            IDataEntityProperty idProp = (IDataEntityProperty)entityType.getProperties().get((Object)"id");
            String idAlias = idProp.getName();
            if (!isMainEntity) {
                idAlias = entityAlias + "." + idAlias;
            }
            SelectFieldTreeNode idPropNode = new SelectFieldTreeNode("id", parentNodeLongName + "." + "id", "id", entityAlias, idAlias, Boolean.valueOf(true), null);
            idPropNode.setValueType(AnalyseObjectUtil.getFieldValueType((IDataEntityProperty)idProp));
            idPropNode.setComplexType(AnalyseObjectUtil.getFieldComplexType((IDataEntityProperty)idProp, baseDataMap));
            children.add(idPropNode);
        }
        if (isOnlyShowHRBDField) {
            for (Map.Entry propertyEntry : entityType.getFields().entrySet()) {
                property = (IDataEntityProperty)propertyEntry.getValue();
                if (property instanceof MulBasedataProp || HRStringUtils.isEmpty((String)property.getAlias()) || !(property instanceof BasedataProp)) continue;
                String filedAlias = FieldDefineService.getFiledPath(entityAlias, isMainEntity, property, entrySuffix);
                SelectFieldTreeNode propNode = FieldDefineService.getPropBo(parentNodeLongName, filedAlias, property, entityAlias, baseDataMap);
                children.add(propNode);
            }
        } else {
            for (Map.Entry propertyEntry : entityType.getFields().entrySet()) {
                property = (IDataEntityProperty)propertyEntry.getValue();
                if (property instanceof MulBasedataProp || HRStringUtils.isEmpty((String)property.getAlias())) continue;
                String filedAlias = FieldDefineService.getFiledPath(entityAlias, isMainEntity, property, entrySuffix);
                SelectFieldTreeNode propNode = FieldDefineService.getPropBo(parentNodeLongName, filedAlias, property, entityAlias, baseDataMap);
                children.add(propNode);
            }
        }
    }

    private static SelectFieldTreeNode getPropBo(String parentNodeLongName, String fieldAlias, IDataEntityProperty property, String entityAlias, Map<String, String> baseDataMap) {
        SelectFieldTreeNode propBo;
        if (property instanceof BasedataProp) {
            propBo = FieldDefineService.getBaseDataPropBo(parentNodeLongName, fieldAlias, (BasedataProp)property, entityAlias, baseDataMap);
        } else {
            String displayName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().getLocaleValue();
            propBo = new SelectFieldTreeNode(displayName, parentNodeLongName + "." + displayName, property.getName(), entityAlias, fieldAlias, Boolean.valueOf(true), null);
            propBo.setValueType(AnalyseObjectUtil.getFieldValueType((IDataEntityProperty)property));
            propBo.setComplexType(AnalyseObjectUtil.getFieldComplexType((IDataEntityProperty)property, baseDataMap));
        }
        return propBo;
    }

    private static SelectFieldTreeNode getBaseDataPropBo(String parentNodeLongName, String fieldAlias, BasedataProp property, String entityAlias, Map<String, String> baseDataMap) {
        SelectFieldTreeNode propBo = new SelectFieldTreeNode();
        String fieldNum = property.getName() + ".id";
        String fieldName = property.getDisplayName().getLocaleValue();
        String fieldLongName = parentNodeLongName + "." + fieldName;
        propBo.setName(fieldName);
        propBo.setLongName(fieldLongName);
        propBo.setNumber(fieldNum);
        propBo.setEntityAlias(entityAlias);
        propBo.setFieldAlias(fieldAlias + ".id");
        propBo.setValueType(AnalyseObjectUtil.getFieldValueType((IDataEntityProperty)property));
        propBo.setComplexType(AnalyseObjectUtil.getFieldComplexType((IDataEntityProperty)property, baseDataMap));
        propBo.setField(Boolean.valueOf(true));
        DataEntityPropertyCollection relProps = property.getComplexType().getProperties();
        ArrayList childrenProps = Lists.newArrayListWithCapacity((int)relProps.size());
        for (IDataEntityProperty relProp : relProps) {
            String propNum = relProp.getName();
            if (HRStringUtils.isEmpty((String)propNum) || HRStringUtils.equals((String)"id", (String)propNum) || HRStringUtils.equals((String)"masterid", (String)propNum) || HRStringUtils.equals((String)"multilanguagetext", (String)propNum) || propNum.endsWith("_id") || relProp instanceof EntryProp || relProp instanceof MulBasedataProp || HRStringUtils.isEmpty((String)relProp.getAlias())) continue;
            SelectFieldTreeNode subProp = FieldDefineService.getPropBo(fieldLongName, fieldAlias + "." + propNum, relProp, entityAlias, baseDataMap);
            childrenProps.add(subProp);
        }
        propBo.setChildren((List)childrenProps);
        return propBo;
    }

    private static String getFiledPath(String entityAlias, boolean isMainEntity, IDataEntityProperty property, String entrySuffix) {
        String fieldNum = property.getName();
        String fieldPath = "";
        if (!isMainEntity) {
            fieldPath = entityAlias + '.';
        }
        if (HRStringUtils.isNotEmpty((String)entrySuffix)) {
            fieldPath = fieldPath + entrySuffix + ".";
        }
        fieldPath = fieldPath + fieldNum;
        return fieldPath;
    }
}

