/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.util.MethodUtil;

@ExcludeFromJacocoGeneratedReport
public class TemplateExportAttrUtil {
    private static final String BOS_POPCOMBO_MAXSELECT = "maxselect";
    private static final String BOS_POPCOMBO_ITEMS = "items";
    private static final String BOS_POPCOMBO_VALUES = "values";
    private static final String CALLBACK_SELECTREFPROPS = "selectrefprops";

    public static void showSelectExportPropForm(IFormView view, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)HiesCommonRes.TemplateExportAttrUtil_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("hies_popcombo");
        showParameter.setCustomParam(BOS_POPCOMBO_MAXSELECT, (Object)20);
        int entryCurrentRowIndex = view.getModel().getEntryCurrentRowIndex("treeentryentity");
        String propName = String.valueOf(view.getModel().getValue("fieldnumber", entryCurrentRowIndex));
        String entityNumber = (String)view.getModel().getEntryRowEntity("treeentryentity", 0).get("childentity");
        List<ComboItem> comboItems = TemplateExportAttrUtil.getRefProps(entityNumber, propName, view.getParentView());
        if (comboItems == null) {
            return;
        }
        showParameter.setCustomParam(BOS_POPCOMBO_ITEMS, comboItems);
        String valStr = (String)view.getModel().getValue("exptattrtemp");
        if (StringUtils.isNotBlank((CharSequence)valStr)) {
            showParameter.setCustomParam(BOS_POPCOMBO_VALUES, Arrays.asList(valStr.split(",")));
        }
        String templatetype = (String)view.getParentView().getModel().getValue("tmpltype");
        showParameter.setCustomParam("tmpltype", (Object)templatetype);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, CALLBACK_SELECTREFPROPS));
        view.showForm(showParameter);
    }

    public static void cacheRefProps(IDataModel model, String entityId, IDataEntityProperty fldProperty, IFormView view) {
        if (!(fldProperty instanceof IBasedataField)) {
            return;
        }
        String templateType = (String)view.getModel().getValue("tmpltype");
        if ("IMPT".equals(templateType)) {
            return;
        }
        List<ComboItem> refItems = TemplateExportAttrUtil.getF7ReferAttrs(fldProperty);
        view.getPageCache().put("refprops_" + entityId + "." + fldProperty.getName(), SerializationUtils.toJsonString(refItems));
    }

    public static List<ComboItem> getF7ReferAttrs(IDataEntityProperty fldProperty) {
        LinkedList<ComboItem> refItems = new LinkedList<ComboItem>();
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
        if (fldProperty instanceof ItemClassProp || fldProperty instanceof FlexProp) {
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)HiesCommonRes.TemplateExportAttrUtil_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])), "name"));
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)HiesCommonRes.TemplateExportAttrUtil_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])), "number"));
        } else if (fldProperty instanceof IQueryProp) {
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5de5\u53f7", (String)HiesCommonRes.TemplateExportAttrUtil_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])), "number"));
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u59d3\u540d", (String)HiesCommonRes.TemplateExportAttrUtil_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])), "name"));
        } else {
            for (IDataEntityProperty refProp : type.getProperties()) {
                if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable() || ((IFieldHandle)refProp).isSysField()) continue;
                LocaleString disp = refProp.getDisplayName();
                ComboItem temp = new ComboItem(StringUtils.isNotBlank((Object)disp) ? disp : new LocaleString(refProp.getName()), refProp.getName());
                refItems.add(temp);
                if (!(fldProperty instanceof MaterielProp) || type.getMasteridType() != 2 || !StringUtils.equals((CharSequence)type.getMasteridPropName(), (CharSequence)refProp.getName())) continue;
                refItems.addAll(TemplateExportAttrUtil.handleMaterielProp(refProp));
            }
        }
        Map<String, Object> bdMainProp = MethodUtil.getBdMainProp(type.getName());
        if (!ObjectUtils.isEmpty((Object)bdMainProp.get("name")) && !ObjectUtils.isEmpty((Object)bdMainProp.get("number"))) {
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801##\u540d\u79f0", (String)HiesCommonRes.TemplateExportAttrUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])), "number_name"));
        }
        if (ObjectUtils.isEmpty((Object)bdMainProp.get("name")) && ObjectUtils.isEmpty((Object)bdMainProp.get("number"))) {
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)HiesCommonRes.TemplateExportAttrUtil_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])), "id"));
        }
        return refItems;
    }

    public static Map<String, IDataEntityProperty> getF7ReferAttrsProp(IDataEntityProperty fldProperty) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
        for (IDataEntityProperty refProp : type.getProperties()) {
            if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable()) continue;
            map.put(refProp.getName(), refProp);
        }
        return map;
    }

    public static void setExportProps(String entityId, IFormView view, List<String> exportprops, int i) {
        String captions = TemplateExportAttrUtil.getExportPropsDisplayName(entityId, view, exportprops, i);
        String join = String.join((CharSequence)",", exportprops);
        view.getModel().setValue("exptattrtemp", (Object)(exportprops == null ? null : join), i);
        view.getModel().setValue("exptattr", (Object)String.join((CharSequence)",", captions), i);
    }

    public static String getExportPropsDisplayName(String entityId, IFormView view, List<String> exportprops, int i) {
        ArrayList<String> captions = new ArrayList<String>();
        if (exportprops != null && !exportprops.isEmpty()) {
            String propName = String.valueOf(view.getModel().getValue("fieldnumber", i));
            List<ComboItem> refProps = TemplateExportAttrUtil.getRefProps(entityId, propName, view.getParentView());
            for (ComboItem item : refProps) {
                if (!exportprops.contains(item.getValue())) continue;
                LocaleString disp = item.getCaption();
                captions.add(StringUtils.isNotBlank((Object)disp) ? disp.toString() : item.getValue());
            }
        }
        return String.join((CharSequence)",", captions);
    }

    private static List<ComboItem> handleMaterielProp(IDataEntityProperty materielProp) {
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)materielProp).getComplexType();
        ArrayList<ComboItem> materielItems = new ArrayList<ComboItem>();
        String materielName = materielProp.getName();
        LocaleString displayName = materielProp.getDisplayName();
        for (IDataEntityProperty refProp : type.getProperties()) {
            if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable()) continue;
            LocaleString name = refProp.getDisplayName();
            String appendName = materielName + "." + refProp.getName();
            if (StringUtils.isNotBlank((Object)displayName) && StringUtils.isNotBlank((Object)name)) {
                appendName = displayName.toString() + "." + name.toString();
            }
            ComboItem temp = new ComboItem(new LocaleString(appendName), materielName + "." + refProp.getName());
            materielItems.add(temp);
        }
        return materielItems;
    }

    public static List<ComboItem> getRefProps(String entityId, String propName, IFormView view) {
        String refpropStr = view.getPageCache().get("refprops_" + entityId + "." + propName);
        if (refpropStr == null) {
            return new ArrayList<ComboItem>(0);
        }
        List refItems = SerializationUtils.fromJsonStringToList((String)refpropStr, ComboItem.class);
        return refItems;
    }
}

