/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.dto.CustomTabPage;
import kd.hr.hies.common.dto.CustomTabPageId;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.util.EntityTreeServiceHelper;
import kd.hr.hies.common.util.TemplateEntityFieldUtil;
import kd.hr.hies.common.util.TemplateExportAttrUtil;
import kd.hr.hies.common.util.TemplateUtil;
import org.apache.commons.lang3.SerializationUtils;

@ExcludeFromJacocoGeneratedReport
public class TemplateFormCommonUtil {
    private static final String KEY_PANEL_SUFFIX = "panel";

    public static Set<String> getAllListIdSet(IDataModel iDataModel, String listKey, String idPropertyName) {
        HashSet<String> idSet = new HashSet<String>();
        int listRowCount = iDataModel.getEntryRowCount(listKey);
        String id = null;
        DynamicObjectCollection entryEntity = iDataModel.getEntryEntity(listKey);
        for (int index = 0; index < listRowCount; ++index) {
            Object value = ((DynamicObject)entryEntity.get(index)).get(idPropertyName);
            if (value instanceof String) {
                id = (String)value;
            } else if (value instanceof DynamicObject) {
                id = ((DynamicObject)value).getPkValue().toString();
            } else if (value instanceof Long) {
                id = value.toString();
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public static Map<String, String> getAllListPropSet(IDataModel iDataModel, String listKey, String propertyName) {
        LinkedHashMap idSet = Maps.newLinkedHashMapWithExpectedSize((int)16);
        int listRowCount = iDataModel.getEntryRowCount(listKey);
        DynamicObjectCollection entryEntity = iDataModel.getEntryEntity(listKey);
        for (int index = 0; index < listRowCount; ++index) {
            String key = (String)((DynamicObject)entryEntity.get(index)).get("number");
            OrmLocaleValue display = (OrmLocaleValue)((DynamicObject)entryEntity.get(index)).get(propertyName);
            idSet.put(key, kd.bos.portal.util.SerializationUtils.toJsonString((Object)display));
        }
        return idSet;
    }

    public static void addTabPage(IFormView formView, CustomTabPage tabPage, String number, String queryEntityNumber, boolean isImport, boolean isDownloadCond, Boolean isOpen, Boolean isClear, Boolean canEdit, Boolean baseCanEdit, String uniqueval, OperationStatus operationStatus, boolean isShowVirEntity) {
        TemplateFormCommonUtil.addTabPage(formView, tabPage, number, queryEntityNumber, isImport, isDownloadCond, isOpen, isClear, canEdit, baseCanEdit, uniqueval, null, operationStatus, isShowVirEntity);
    }

    public static void addTabPage(IFormView formView, CustomTabPage tabPage, String number, String queryEntityNumber, boolean isImport, boolean isDownloadCond, Boolean isOpen, Boolean isClear, Boolean canEdit, Boolean baseCanEdit, String uniqueval, Map<String, LinkedHashMap<String, Object>> dataMap, OperationStatus operationStatus, boolean isShowVirEntity) {
        Container container = (Container)formView.getControl("objtabap");
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setId(tabPage.getTabPageKey());
        tabPageAp.setKey(tabPage.getTabPageKey());
        tabPageAp.setName(new LocaleString(tabPage.getTabPageName()));
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(tabPage.getTabPageKey() + KEY_PANEL_SUFFIX);
        flexPanelAp.setId(tabPage.getTabPageKey() + KEY_PANEL_SUFFIX);
        flexPanelAp.createControl();
        tabPageAp.getItems().add(flexPanelAp);
        container.addControls((List)Lists.newArrayList((Object[])new Map[]{tabPageAp.createControl()}));
        formView.updateView("objtabap");
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)10);
        customParams.put("entityId", number);
        customParams.put("queryentityId", queryEntityNumber);
        customParams.put("isImport", isImport);
        customParams.put("isOpen", isOpen);
        customParams.put("isClear", isClear);
        customParams.put("canEdit", canEdit);
        customParams.put("baseCanEdit", baseCanEdit);
        customParams.put("isDownloadCond", isDownloadCond);
        customParams.put("mainentityuniqueval", uniqueval);
        customParams.put("datamap", JSON.toJSONString(dataMap));
        customParams.put("operationStatus", operationStatus);
        customParams.put("isShowVirEntity", isShowVirEntity);
        TemplateFormCommonUtil.putTabPageToCache(formView, tabPage);
        TemplateFormCommonUtil.showFormInContainer(formView, "hies_tplfieldconf_new", tabPage.getTabPageKey(), customParams);
    }

    public static void refreshTabPage(IFormView parentView, String tabPageKey, String mustInputField, String cancelUnique, Boolean isEnable) {
        CustomTabPageId customTabPageId = TemplateFormCommonUtil.getTabPageIdCache(parentView, tabPageKey);
        IDataModel parentModel = parentView.getModel();
        String value = (String)parentModel.getValue("tmpltype");
        boolean isImport = "IMPT".equalsIgnoreCase(value);
        String importType = (String)parentModel.getValue("importtype");
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customTabPageId)) {
            IFormView childView = parentView.getView(customTabPageId.getTabPageId());
            IDataModel childModel = childView.getModel();
            DynamicObjectCollection dynColl = childModel.getEntryEntity("treeentryentity");
            boolean isUpdateType = OprCategory.isUpdate(importType);
            childModel.beginInit();
            for (int row = 0; row < dynColl.size(); ++row) {
                DynamicObject dyn = (DynamicObject)dynColl.get(row);
                String fieldNumber = (String)dyn.get("fieldnumber");
                String fieldName = dyn.getString("fieldname");
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fieldName)) {
                    childView.setEnable(Boolean.FALSE, row, new String[]{"entitydescription", "displayname", "fieldimportdesc", "imptattr", "exptattr", "issheet", "sheetbdfieldnames"});
                }
                if (!dyn.getBoolean("isfield") || !isImport) continue;
                if (TemplateFormCommonUtil.isUniqueval(mustInputField, fieldNumber)) {
                    TemplateUtil.setIsMustInputTrue(childModel, row);
                    if (isUpdateType) {
                        childView.setEnable(Boolean.FALSE, row, new String[]{"ismustinput"});
                    }
                }
                if (!TemplateFormCommonUtil.isCancelUnique(cancelUnique, fieldNumber)) continue;
                TemplateUtil.setIsMustInputFalse(childModel, row);
                TemplateUtil.setIsImportFalse(childModel, row);
                childView.setEnable(Boolean.TRUE, row, new String[]{"ismustinput"});
            }
            TemplateFormCommonUtil.refreshChildEntryFieldDisplay(childView);
            childModel.endInit();
            childView.updateView("treeentryentity");
            parentView.sendFormAction(childView);
        }
    }

    public static void refreshTabPage4UniqueVal(IFormView parentView, String tabPageKey, String checkUniqueVal, String cancelUniqueVal) {
        CustomTabPageId customTabPageId = TemplateFormCommonUtil.getTabPageIdCache(parentView, tabPageKey);
        IDataModel parentModel = parentView.getModel();
        String importType = (String)parentModel.getValue("importtype");
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customTabPageId)) {
            IFormView childView = parentView.getView(customTabPageId.getTabPageId());
            IDataModel childModel = childView.getModel();
            DynamicObjectCollection dynColl = childModel.getEntryEntity("treeentryentity");
            boolean isUpdateType = OprCategory.isUpdate(importType);
            List checkFields = Arrays.stream(checkUniqueVal.split(",")).collect(Collectors.toList());
            List cancelFields = Arrays.stream(cancelUniqueVal.split(",")).collect(Collectors.toList());
            childModel.beginInit();
            for (int row = 0; row < dynColl.size(); ++row) {
                DynamicObject dyn = (DynamicObject)dynColl.get(row);
                String fieldNumber = (String)dyn.get("fieldnumber");
                String fieldName = dyn.getString("fieldname");
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fieldName)) {
                    childView.setEnable(Boolean.FALSE, row, new String[]{"entitydescription", "displayname", "fieldimportdesc", "imptattr", "exptattr", "issheet", "sheetbdfieldnames"});
                }
                if (!dyn.getBoolean("isfield")) continue;
                if (checkFields.contains(fieldNumber)) {
                    TemplateUtil.setIsMustInputTrue(childModel, row);
                    if (isUpdateType) {
                        childView.setEnable(Boolean.FALSE, row, new String[]{"ismustinput"});
                    }
                }
                if (!cancelFields.contains(fieldNumber)) continue;
                childView.setEnable(Boolean.TRUE, row, new String[]{"ismustinput"});
            }
            TemplateFormCommonUtil.refreshChildEntryFieldDisplay(childView);
            childModel.endInit();
            childView.updateView("treeentryentity");
            parentView.sendFormAction(childView);
        }
    }

    public static void clearDisplayName(IFormView parentView, String tabPageKey) {
        CustomTabPageId customTabPageId = TemplateFormCommonUtil.getTabPageIdCache(parentView, tabPageKey);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customTabPageId)) {
            IFormView childView = parentView.getView(customTabPageId.getTabPageId());
            IDataModel model = childView.getModel();
            DynamicObjectCollection dynColl = model.getEntryEntity("treeentryentity");
            model.beginInit();
            for (int i = 0; i < dynColl.size(); ++i) {
                model.setValue("entitydescription", (Object)"", i);
                model.setValue("displayname", (Object)"", i);
            }
            model.endInit();
            childView.updateView("treeentryentity");
            parentView.sendFormAction(childView);
        }
    }

    private static boolean isUniqueval(String mainentityuniqueval, String fieldNumber) {
        String[] split;
        List<String> uniquevalList;
        boolean isUniqueval = false;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)mainentityuniqueval) && (uniquevalList = Arrays.asList(split = mainentityuniqueval.split(","))).contains(fieldNumber)) {
            isUniqueval = true;
        }
        return isUniqueval;
    }

    private static boolean isCancelUnique(String cancelUnique, String fieldNumber) {
        String[] split;
        List<String> uniquevalList;
        boolean isCancelUnique = false;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cancelUnique) && (uniquevalList = Arrays.asList(split = cancelUnique.split(","))).contains(fieldNumber)) {
            isCancelUnique = true;
        }
        return isCancelUnique;
    }

    public static void showFormInContainer(IFormView formView, String formId, String containerKey, Map<String, Object> customParams) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        param.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
        if (!CollectionUtils.isEmpty(customParams)) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(containerKey);
        formView.showForm(showParameter);
        TemplateFormCommonUtil.putTabPageIdToCache(formView, new CustomTabPageId(containerKey, showParameter.getPageId()));
    }

    public static void removeTabPage(IFormView view, String tabPageKey) {
        Tab tab = (Tab)view.getControl("objtabap");
        tab.deleteControls(new String[]{tabPageKey});
        TemplateFormCommonUtil.removeTabPageCache(view, tabPageKey);
        TemplateFormCommonUtil.activeMainEntityTabPage(view);
    }

    public static void removeTabPageAndEntry(IFormView view, String tabPageKey) {
        Tab tab = (Tab)view.getControl("objtabap");
        tab.deleteControls(new String[]{tabPageKey});
        TemplateFormCommonUtil.removeTabPageCache(view, tabPageKey);
        TemplateFormCommonUtil.activeMainEntityTabPage(view);
        IDataModel model = view.getModel();
        int rows = model.getEntryRowCount("tpltreeentryentity");
        for (int i = rows - 1; i >= 0; --i) {
            String id = model.getValue("childentity", i).toString();
            if (!id.equals(tabPageKey)) continue;
            model.deleteEntryRow("tpltreeentryentity", i);
        }
    }

    public static void removeAllTabPage(IFormView formView) {
        IDataModel model = formView.getModel();
        LinkedHashMap<String, CustomTabPage> tabPageCache = TemplateFormCommonUtil.getTabPageCache(formView);
        for (Map.Entry<String, CustomTabPage> customTabPageEntry : tabPageCache.entrySet()) {
            String key = customTabPageEntry.getKey();
            TemplateFormCommonUtil.removeTabPage(formView, key);
        }
        model.beginInit();
        model.deleteEntryData("tpltreeentryentity");
        model.deleteEntryData("entityrelation");
        formView.updateView("entityrelation");
        model.endInit();
    }

    public static void removeAllTabPageExEntity(IFormView formView) {
        LinkedHashMap<String, CustomTabPage> tabPageCache = TemplateFormCommonUtil.getTabPageCache(formView);
        for (Map.Entry<String, CustomTabPage> customTabPageEntry : tabPageCache.entrySet()) {
            String key = customTabPageEntry.getKey();
            TemplateFormCommonUtil.removeTabPage(formView, key);
        }
    }

    public static void removeTabPage(IFormView formView) {
        LinkedHashMap<String, CustomTabPage> tabPageCache = TemplateFormCommonUtil.getTabPageCache(formView);
        for (Map.Entry<String, CustomTabPage> customTabPageEntry : tabPageCache.entrySet()) {
            String key = customTabPageEntry.getKey();
            TemplateFormCommonUtil.removeTabPage(formView, key);
        }
    }

    public static LinkedHashMap<String, String> getAllEntity(IFormView formView) {
        DynamicObjectCollection subEntityCollection;
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>(16);
        DynamicObject mainDyObj = (DynamicObject)formView.getModel().getValue("entity");
        if (Objects.nonNull(mainDyObj)) {
            String entityNumber = mainDyObj.getString("number");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (mainType instanceof QueryEntityType) {
                MainEntityType mainEntityType = ((QueryEntityType)mainType).getMainEntityType();
                String mainEntityNum = mainEntityType.getName();
                String mainEntityName = mainEntityType.getDisplayName().getLocaleValue();
                objectMap.put(mainEntityNum + ":" + mainEntityNum, mainEntityName);
            } else {
                objectMap.put(mainDyObj.getString("id") + ":" + mainDyObj.getString("number"), mainDyObj.getString("name"));
            }
        }
        if ((subEntityCollection = formView.getModel().getEntryEntity("entityrelation")).size() > 0) {
            subEntityCollection.stream().filter(entityDynamicObject -> Objects.nonNull(entityDynamicObject.get("rentity"))).forEach(entityDynamicObject -> objectMap.put(((DynamicObject)entityDynamicObject.get("rentity")).getString("id") + ":" + ((DynamicObject)entityDynamicObject.get("rentity")).getString("number"), ((DynamicObject)entityDynamicObject.get("rentity")).getString("name")));
        }
        return objectMap;
    }

    public static void putTabPageToCache(IFormView formView, CustomTabPage tabPage) {
        LinkedHashMap tabPageMap;
        String cacheTabPage = formView.getPageCache().get("tabPage");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheTabPage)) {
            tabPageMap = new LinkedHashMap();
            tabPageMap.put(tabPage.getTabPageKey(), tabPage);
        } else {
            tabPageMap = (LinkedHashMap)JSON.parseObject((String)cacheTabPage, (TypeReference)new TypeReference<LinkedHashMap<String, CustomTabPage>>(){}, (Feature[])new Feature[0]);
            tabPageMap.put(tabPage.getTabPageKey(), tabPage);
        }
        formView.getPageCache().put("tabPage", JSON.toJSONString((Object)tabPageMap));
    }

    public static void putTabPageIdToCache(IFormView formView, CustomTabPageId tabPageId) {
        LinkedHashMap tabPageMap;
        String cacheTabPage = formView.getPageCache().get("tabPageId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheTabPage)) {
            tabPageMap = new LinkedHashMap();
            tabPageMap.put(tabPageId.getTabPageKey(), tabPageId);
        } else {
            tabPageMap = (LinkedHashMap)JSON.parseObject((String)cacheTabPage, (TypeReference)new TypeReference<LinkedHashMap<String, CustomTabPageId>>(){}, (Feature[])new Feature[0]);
            tabPageMap.put(tabPageId.getTabPageKey(), tabPageId);
        }
        formView.getPageCache().put("tabPageId", JSON.toJSONString((Object)tabPageMap));
    }

    public static LinkedHashMap<String, CustomTabPage> getTabPageCache(IFormView formView) {
        String cacheTabPage = formView.getPageCache().get("tabPage");
        LinkedHashMap tabPageMap = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheTabPage) ? new LinkedHashMap() : (LinkedHashMap)JSON.parseObject((String)cacheTabPage, (TypeReference)new TypeReference<LinkedHashMap<String, CustomTabPage>>(){}, (Feature[])new Feature[0]);
        return tabPageMap;
    }

    public static LinkedHashMap<String, CustomTabPageId> getTabPageIdCache(IFormView formView) {
        String cacheTabPage = formView.getPageCache().get("tabPageId");
        LinkedHashMap tabPageMap = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheTabPage) ? new LinkedHashMap() : (LinkedHashMap)JSON.parseObject((String)cacheTabPage, (TypeReference)new TypeReference<LinkedHashMap<String, CustomTabPageId>>(){}, (Feature[])new Feature[0]);
        return tabPageMap;
    }

    public static CustomTabPageId getTabPageIdCache(IFormView formView, String tabPageIdKey) {
        String cacheTabPage = formView.getPageCache().get("tabPageId");
        LinkedHashMap tabPageMap = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheTabPage) ? new LinkedHashMap() : (LinkedHashMap)JSON.parseObject((String)cacheTabPage, (TypeReference)new TypeReference<LinkedHashMap<String, CustomTabPageId>>(){}, (Feature[])new Feature[0]);
        return (CustomTabPageId)tabPageMap.get(tabPageIdKey);
    }

    public static void removeTabPageCache(IFormView formView, String tabPageKey) {
        LinkedHashMap tabPageMap;
        String cacheTabPage = formView.getPageCache().get("tabPage");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheTabPage)) {
            tabPageMap = new LinkedHashMap();
        } else {
            tabPageMap = (LinkedHashMap)JSON.parseObject((String)cacheTabPage, (TypeReference)new TypeReference<LinkedHashMap<String, CustomTabPage>>(){}, (Feature[])new Feature[0]);
            tabPageMap.remove(tabPageKey);
        }
        formView.getPageCache().put("tabPage", JSON.toJSONString((Object)tabPageMap));
    }

    public static void activeTabPage(IFormView formView, String tabPageKey) {
        Tab tab = (Tab)formView.getControl("objtabap");
        tab.activeTab(tabPageKey);
    }

    public static void activeMainEntityTabPage(IFormView formView) {
        Tab tab = (Tab)formView.getControl("objtabap");
        IDataModel model = formView.getModel();
        DynamicObject mainDyObj = (DynamicObject)model.getValue("entity");
        if (Objects.nonNull(mainDyObj)) {
            tab.activeTab(mainDyObj.getPkValue().toString());
        }
    }

    public static String getEntityMustInputField(IDataModel model, String entityNumber) {
        Map<String, Map<String, Object>> uniqueMap = TemplateFormCommonUtil.getAllEntityUnique(model);
        Map<String, Object> uniqueDataMap = uniqueMap.get(entityNumber);
        String uniqueVal = org.apache.commons.lang3.ObjectUtils.isEmpty(uniqueMap) ? "" : (String)uniqueDataMap.get("uniqueVal");
        Map<String, Map<String, Object>> relationFieldMap = TemplateFormCommonUtil.getAllEntityRelationField(model);
        Map<String, Object> relationFieldDataMap = relationFieldMap.get(entityNumber);
        String relationField = org.apache.commons.lang3.ObjectUtils.isEmpty(relationFieldDataMap) ? "" : (String)relationFieldDataMap.get("uniqueVal");
        return uniqueVal + "," + relationField;
    }

    public static String getEntityMetaMustInputField(IDataModel model, String entityNumber) {
        DynamicObjectCollection dynColl = model.getEntryEntity("tpltreeentryentity");
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dyn : dynColl) {
            boolean isMustInput;
            String fieldNumber = (String)dyn.get("fieldnumber");
            String fieldName = dyn.getString("fieldname");
            String childEntityNumber = (String)dyn.get("childentity");
            if (!HRStringUtils.equals((String)childEntityNumber, (String)entityNumber) || !(isMustInput = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fieldNumber) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fieldName) && fieldName.contains("*"))) continue;
            sb.append(fieldNumber).append(",");
        }
        return sb.toString();
    }

    public static Map<String, Map<String, Object>> getAllEntityUnique(IDataModel model) {
        DynamicObjectCollection subEntityCollection;
        LinkedHashMap<String, Map<String, Object>> uniqueMap = new LinkedHashMap<String, Map<String, Object>>(16);
        DynamicObject mainDyObj = (DynamicObject)model.getValue("entity");
        if (Objects.nonNull(mainDyObj)) {
            String entityNumber = mainDyObj.getString("number");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (mainType instanceof QueryEntityType) {
                MainEntityType mainEntityType = ((QueryEntityType)mainType).getMainEntityType();
                String mainEntityNum = mainEntityType.getName();
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                String value = (String)model.getValue("mainentityuniqueval");
                data.put("uniqueVal", value);
                data.put("cancelUnique", new ArrayList());
                uniqueMap.put(mainEntityNum, data);
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                String value = (String)model.getValue("mainentityuniqueval");
                data.put("uniqueVal", value);
                data.put("cancelUnique", new ArrayList());
                uniqueMap.put(entityNumber, data);
            }
        }
        if ((subEntityCollection = model.getEntryEntity("entityrelation")).size() > 0) {
            subEntityCollection.stream().filter(entityDynamicObject -> Objects.nonNull(entityDynamicObject.get("rentity"))).forEach(entityDynamicObject -> {
                String entityNumber = ((DynamicObject)entityDynamicObject.get("rentity")).getString("number");
                String uniqueVal = entityDynamicObject.getString("entityuniqueval");
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                data.put("uniqueVal", uniqueVal);
                data.put("cancelUnique", new ArrayList());
                uniqueMap.put(entityNumber, data);
            });
        }
        return uniqueMap;
    }

    public static Map<String, Map<String, Object>> getAllEntityRelationField(IDataModel model) {
        LinkedHashMap<String, Map<String, Object>> relationFieldMap = new LinkedHashMap<String, Map<String, Object>>(16);
        DynamicObjectCollection subEntityCollection = model.getEntryEntity("entityrelation");
        DynamicObject mainDyObj = (DynamicObject)model.getValue("entity");
        if (Objects.nonNull(mainDyObj)) {
            String mainEntityNumber = mainDyObj.getString("number");
            if (subEntityCollection.size() > 0) {
                StringBuilder sb = new StringBuilder();
                subEntityCollection.stream().filter(entityDynamicObject -> Objects.nonNull(entityDynamicObject.get("rentity"))).forEach(entityDynamicObject -> {
                    String rightPropVal = entityDynamicObject.getString("relationrightprop");
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rightPropVal)) {
                        String[] split = rightPropVal.split("\\.");
                        String propVal = "";
                        if (split.length == 3) {
                            propVal = split[1];
                        } else if (split.length == 2) {
                            propVal = split[split.length - 1];
                        }
                        sb.append(propVal).append(",");
                    }
                });
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                data.put("uniqueVal", sb.toString());
                data.put("cancelUnique", new ArrayList());
                relationFieldMap.put(mainEntityNumber, data);
            }
        }
        if (subEntityCollection.size() > 0) {
            subEntityCollection.stream().filter(entityDynamicObject -> Objects.nonNull(entityDynamicObject.get("rentity"))).forEach(entityDynamicObject -> {
                String entityNumber = ((DynamicObject)entityDynamicObject.get("rentity")).getString("number");
                String leftPropVal = entityDynamicObject.getString("relationleftprop");
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                String propVal = "";
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)leftPropVal)) {
                    String[] split = leftPropVal.split("\\.");
                    if (split.length == 3) {
                        propVal = split[1];
                    } else if (split.length == 2) {
                        propVal = split[split.length - 1];
                    }
                }
                data.put("uniqueVal", "," + propVal + ",");
                data.put("cancelUnique", new ArrayList());
                relationFieldMap.put(entityNumber, data);
            });
        }
        return relationFieldMap;
    }

    public static void updateParentEntry(IFormView view, int rowIndex, String propertyName, Object newValue) {
        DynamicObject rowEntity = view.getModel().getEntryRowEntity("treeentryentity", rowIndex);
        String fieldNumber = rowEntity.getString("fieldnumber");
        String entityId = rowEntity.getString("childentity");
        IFormView parentView = view.getParentView();
        IDataModel parentDataModel = parentView.getModel();
        DynamicObjectCollection collection = parentDataModel.getEntryEntity("tpltreeentryentity");
        for (int rowNum = 0; rowNum < collection.size(); ++rowNum) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(rowNum);
            boolean isEntityId = entityId.equals(dynamicObject.getString("childentity"));
            boolean isFieldNumber = fieldNumber.equals(dynamicObject.getString("fieldnumber"));
            if (!isEntityId || !isFieldNumber) continue;
            Object obj = dynamicObject.get(propertyName);
            parentDataModel.beginInit();
            if (obj instanceof OrmLocaleValue) {
                ILocaleString localeString = rowEntity.getLocaleString(propertyName);
                dynamicObject.set(propertyName, (Object)localeString);
            } else {
                dynamicObject.set(propertyName, newValue);
            }
            parentDataModel.endInit();
            parentView.updateView("tpltreeentryentity", rowNum);
            view.sendFormAction(parentView);
            break;
        }
    }

    public static void updateParentEntry4UniqueVal(IFormView parentView, String tabPageKey, String newAddUniqueVal) {
        IDataModel parentModel = parentView.getModel();
        List checkFields = Arrays.stream(newAddUniqueVal.split(",")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(checkFields)) {
            return;
        }
        DynamicObjectCollection collection = parentModel.getEntryEntity("tpltreeentryentity");
        parentModel.beginInit();
        for (DynamicObject dynamicObject : collection) {
            String fieldNumber = dynamicObject.getString("fieldnumber");
            if (!checkFields.contains(fieldNumber)) continue;
            dynamicObject.set("ismustinput", (Object)true);
            dynamicObject.set("isimport", (Object)true);
        }
        parentModel.endInit();
        parentView.updateView("tpltreeentryentity");
    }

    public static void lockShowField4UniqueVal(IFormView parentView, String tabPageKey, String mustInputField) {
        CustomTabPageId customTabPageId = TemplateFormCommonUtil.getTabPageIdCache(parentView, tabPageKey);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)customTabPageId)) {
            return;
        }
        IFormView childView = parentView.getView(customTabPageId.getTabPageId());
        IDataModel childModel = childView.getModel();
        DynamicObjectCollection dynColl = childModel.getEntryEntity("treeentryentity");
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dynColl)) {
            return;
        }
        String importType = (String)parentView.getModel().getValue("importtype");
        boolean isUpdateType = OprCategory.isUpdate(importType);
        if (!isUpdateType) {
            return;
        }
        List checkFields = Arrays.stream(mustInputField.split(",")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(checkFields)) {
            return;
        }
        for (int rowNum = 0; rowNum < dynColl.size(); ++rowNum) {
            DynamicObject dyn = (DynamicObject)dynColl.get(rowNum);
            String fieldNumber = (String)dyn.get("fieldnumber");
            if (!checkFields.contains(fieldNumber)) continue;
            childView.setEnable(Boolean.FALSE, rowNum, new String[]{"ismustinput"});
        }
        parentView.sendFormAction(childView);
    }

    public static void updateEntryField(Set<TreeNode> checkedNode, TreeNode treeNode, IFormView view, String entityId, String fieldNumber, Boolean checked) {
        Object dynamicObject;
        IDataModel model = view.getModel();
        String tmpltype = (String)view.getParentView().getModel().getValue("tmpltype");
        DynamicObjectCollection collection = model.getEntryEntity("treeentryentity");
        Iterator iterator = collection.iterator();
        int i = 0;
        int targetIndex = 0;
        while (iterator.hasNext()) {
            dynamicObject = (DynamicObject)iterator.next();
            boolean isEntityId = entityId.equals(dynamicObject.getString("childentity"));
            boolean isFieldNumber = fieldNumber.equals(dynamicObject.getString("fieldnumber"));
            if (isEntityId && isFieldNumber) {
                targetIndex = i;
                dynamicObject.set("ischecked", (Object)checked);
                dynamicObject.set("isimport", (Object)checked);
                TemplateFormCommonUtil.updateParentEntry(view, entityId, fieldNumber, "ischecked", checked);
                TemplateFormCommonUtil.updateParentEntry(view, entityId, fieldNumber, "isimport", checked);
                break;
            }
            ++i;
        }
        if (checked.booleanValue()) {
            for (TreeNode node : checkedNode) {
                if (!Objects.nonNull(node) || !node.getId().equals(treeNode.getId())) continue;
                return;
            }
            dynamicObject = TemplateFormCommonUtil.getEntryFromCache(view, treeNode.getId());
            Integer curRow = TemplateUtil.computeRealRowNum(view.getModel(), (DynamicObject)dynamicObject);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)curRow)) {
                TemplateFormCommonUtil.creteNode(view, (DynamicObject)dynamicObject, curRow);
            } else {
                TemplateFormCommonUtil.createParentNode(view, (DynamicObject)dynamicObject);
                TemplateFormCommonUtil.creteNode(view, (DynamicObject)dynamicObject, null);
            }
            checkedNode.add(treeNode);
            if ("HR_VIRENTITY".equals(treeNode.getParentid())) {
                String virFieldName = ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f", (String)HiesCommonRes.TemplateFormCommonUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
                dynamicObject.set("tplentityname", (Object)virFieldName);
                dynamicObject.set("isvirfield", (Object)true);
                TemplateFormCommonUtil.updateParentEntry(view, entityId, fieldNumber, "isvirfield", true);
            }
            EntityTreeServiceHelper.putCheckedNodeToCache(view, checkedNode);
            TemplateFormCommonUtil.updateParentEntry(view, entityId, fieldNumber, "ischecked", true);
            TemplateFormCommonUtil.updateParentEntry(view, entityId, fieldNumber, "isimport", true);
        } else if (targetIndex != 0) {
            TemplateFormCommonUtil.unchecked(checkedNode, treeNode.getId(), view, treeNode.getId(), targetIndex);
        }
        view.getModel().updateEntryCache(model.getEntryEntity("treeentryentity"));
        view.updateView("treeentryentity");
    }

    private static void creteNode(IFormView view, DynamicObject dynamicObject, Integer row) {
        String fieldNumber = dynamicObject.getString("fieldnumber");
        Object entitydescription = dynamicObject.get("entitydescription");
        Object displayname = dynamicObject.get("displayname");
        Object defvalprop = dynamicObject.get("defvalprop");
        Object defvalname = dynamicObject.get("defvalname");
        Boolean isimport = true;
        Object ismustinput = dynamicObject.get("ismustinput");
        Boolean ischecked = true;
        Object isfield = dynamicObject.get("isfield");
        Object isdownloadcond = dynamicObject.get("isdownloadcond");
        Object imptAttr = dynamicObject.get("imptattr");
        Object exptAttr = dynamicObject.get("exptattr");
        Object iscondgetdata = dynamicObject.get("iscondgetdata");
        Object fieldimportdesc = dynamicObject.get("fieldimportdesc");
        boolean isCusField = dynamicObject.getBoolean("iscusfield");
        int newEntryRow = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fieldNumber) ? view.getModel().createNewEntryRow("treeentryentity", 1, dynamicObject) : (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)row) ? view.getModel().createNewEntryRow("treeentryentity", row.intValue(), dynamicObject) : view.getModel().createNewEntryRow("treeentryentity", dynamicObject));
        DynamicObject newObject = (DynamicObject)view.getModel().getEntryEntity("treeentryentity").get(newEntryRow);
        newObject.set("entitydescription", entitydescription);
        newObject.set("displayname", displayname);
        newObject.set("defvalprop", defvalprop);
        newObject.set("defvalname", defvalname);
        newObject.set("isimport", (Object)isimport);
        newObject.set("ischecked", (Object)ischecked);
        newObject.set("isfield", isfield);
        newObject.set("ismustinput", ismustinput);
        newObject.set("isdownloadcond", isdownloadcond);
        newObject.set("iscondgetdata", iscondgetdata);
        newObject.set("fieldimportdesc", fieldimportdesc);
        newObject.set("iscusfield", (Object)isCusField);
        newObject.set("imptattr", imptAttr);
        newObject.set("exptattr", exptAttr);
    }

    private static void createParentNode(IFormView view, DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("treeentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            DynamicObject rootEntry = TemplateFormCommonUtil.getEntryFromCache(view, "0");
            TemplateFormCommonUtil.creteNode(view, rootEntry, null);
            TreeEntryGrid entryGrid = (TreeEntryGrid)view.getControl("treeentryentity");
            entryGrid.setCollapse(false);
        }
        if (Objects.isNull(TemplateFormCommonUtil.getParentNode(view, dynamicObject))) {
            Long pid = dynamicObject.getLong("pid");
            DynamicObject entryFromCache = TemplateFormCommonUtil.getEntryFromCache(view, String.valueOf(pid));
            TemplateFormCommonUtil.creteNode(view, entryFromCache, null);
            TreeEntryGrid entryGrid = (TreeEntryGrid)view.getControl("treeentryentity");
            entryGrid.setCollapse(false);
        }
    }

    private static DynamicObject getParentNode(IFormView view, DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("treeentryentity");
        DynamicObject parentObj = null;
        long pid = dynamicObject.getLong("pid");
        for (DynamicObject dyn : entryEntity) {
            long id = dyn.getLong("id");
            if (pid != id) continue;
            parentObj = dyn;
        }
        return parentObj;
    }

    private static void dealBDDisplay(IFormView fieldView, boolean isimport, int row, boolean isImportTpl, String isSheet) {
        IDataModel model = fieldView.getModel();
        if (isimport) {
            String fieldnumber = (String)model.getValue("fieldnumber", row);
            String entityNumber = (String)model.getEntryRowEntity("treeentryentity", 0).get("childentity");
            if (isImportTpl) {
                Map<String, Map<String, Object>> importF7BdFormatConfig = TemplateEntityFieldUtil.getImportF7BdFormatConfig(entityNumber);
                Map<String, Object> formatConfigI = importF7BdFormatConfig.get(fieldnumber);
                if (formatConfigI != null) {
                    fieldView.setEnable(Boolean.TRUE, row, new String[]{"issheet"});
                    if ("1".equals(isSheet)) {
                        fieldView.setEnable(Boolean.TRUE, row, new String[]{"sheetbdfieldnames"});
                    }
                    if (formatConfigI.get("canEdit") == Boolean.TRUE) {
                        fieldView.setEnable(Boolean.TRUE, row, new String[]{"imptattr"});
                    } else {
                        fieldView.setEnable(Boolean.FALSE, row, new String[]{"imptattr"});
                    }
                }
            } else {
                Map<String, Map<String, Object>> exportF7BdFormatConfig = TemplateEntityFieldUtil.getExportF7BdFormatConfig(entityNumber);
                List<ComboItem> refProps = TemplateExportAttrUtil.getRefProps(entityNumber, fieldnumber, fieldView.getParentView());
                Map<String, Object> formatConfigI = exportF7BdFormatConfig.get(fieldnumber);
                if (formatConfigI != null && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)formatConfigI.get("val"))) {
                    if (!CollectionUtils.isEmpty(refProps) && refProps.size() > 1) {
                        fieldView.setEnable(Boolean.TRUE, row, new String[]{"exptattr"});
                    } else {
                        fieldView.setEnable(Boolean.FALSE, row, new String[]{"exptattr"});
                    }
                }
            }
        }
    }

    private static void changeImportBtn(IFormView view, boolean val, int row, String tmpltype, String oldVal, String isSheet) {
        String type = "IMPT".equalsIgnoreCase(tmpltype) ? "imptattr" : "exptattr";
        String typeTemp = "IMPT".equalsIgnoreCase(tmpltype) ? "imptattrtemp" : "exptattrtemp";
        IDataModel model = view.getModel();
        if (val) {
            String fieldnumber = (String)model.getValue("fieldnumber", row);
            String entityNumber = (String)model.getEntryRowEntity("treeentryentity", 0).get("childentity");
            if ("IMPT".equalsIgnoreCase(tmpltype)) {
                Map<String, Map<String, Object>> importF7BdFormatConfig = TemplateEntityFieldUtil.getImportF7BdFormatConfig(entityNumber);
                TemplateFormCommonUtil.updateImptExptAttr(view, type, typeTemp, row, importF7BdFormatConfig, fieldnumber, oldVal, isSheet);
            } else {
                Map<String, Map<String, Object>> exportF7BdFormatConfig = TemplateEntityFieldUtil.getExportF7BdFormatConfig(entityNumber);
                TemplateFormCommonUtil.updateExptExptAttr(view, entityNumber, type, typeTemp, row, exportF7BdFormatConfig, fieldnumber);
            }
        }
    }

    private static void updateImptExptAttr(IFormView view, String type, String typeTemp, int row, Map<String, Map<String, Object>> f7BdFormatConfig, String fieldnumber, String oldVal, String isSheet) {
        IDataModel model = view.getModel();
        Map<String, Object> formatConfigI = f7BdFormatConfig.get(fieldnumber);
        if (formatConfigI != null) {
            String oldValue = oldVal;
            String newVal = (String)formatConfigI.get("val");
            String val = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)oldValue) ? oldValue : newVal;
            String newIsSheet = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isSheet) ? isSheet : "0";
            model.setValue(type, (Object)val, row);
            model.setValue("issheet", (Object)newIsSheet, row);
            if ("1".equals(newIsSheet)) {
                view.setEnable(Boolean.TRUE, row, new String[]{"sheetbdfieldnames"});
            }
            view.updateView("treeentryentity", row);
            if (formatConfigI.get("canEdit") == Boolean.TRUE) {
                view.setEnable(Boolean.TRUE, row, new String[]{type});
            } else {
                view.setEnable(Boolean.FALSE, row, new String[]{type});
            }
            TemplateFormCommonUtil.updateParentEntry(view, row, type, val);
            view.setEnable(Boolean.TRUE, row, new String[]{"issheet"});
        }
    }

    private static void updateExptExptAttr(IFormView view, String entityId, String type, String typeTemp, int row, Map<String, Map<String, Object>> f7BdFormatConfig, String fieldnumber) {
        IDataModel model = view.getModel();
        IDataModel parentModel = view.getParentView().getModel();
        DynamicObjectCollection entryEntity = parentModel.getEntryEntity("tpltreeentryentity");
        Iterator iterator = entryEntity.iterator();
        String exptAttr = "";
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            String entityNumber = next.getString("childentity");
            String field = next.getString("fieldnumber");
            if (!HRStringUtils.equals((String)entityNumber, (String)entityId) || !HRStringUtils.equals((String)field, (String)fieldnumber)) continue;
            exptAttr = next.getString("exptattr");
            break;
        }
        List<ComboItem> refProps = TemplateExportAttrUtil.getRefProps(entityId, fieldnumber, view.getParentView());
        Map<String, Object> formatConfigI = f7BdFormatConfig.get(fieldnumber);
        if (formatConfigI != null && !ObjectUtils.isEmpty((Object)formatConfigI.get("val"))) {
            String oldValue = exptAttr;
            String newVal = (String)formatConfigI.get("val");
            String val = StringUtils.isNotEmpty((CharSequence)oldValue) ? oldValue : newVal;
            List<String> lists = Arrays.asList(StringUtils.split((String)val, (String)","));
            String displayName = TemplateExportAttrUtil.getExportPropsDisplayName(entityId, view, lists, row);
            model.setValue(type, (Object)displayName, row);
            model.setValue("exptattrtemp", (Object)val, row);
            view.updateView("treeentryentity", row);
            if (!CollectionUtils.isEmpty(refProps) && refProps.size() > 1) {
                view.setEnable(Boolean.TRUE, row, new String[]{type});
            } else {
                view.setEnable(Boolean.FALSE, row, new String[]{type});
            }
            TemplateFormCommonUtil.updateParentEntry(view, row, type, val);
        }
    }

    private static void unchecked(Set<TreeNode> checkedNode, String nodeId, IFormView view, String fieldNumber, int targetIndex) {
        TemplateFormCommonUtil.cacheDisableEntry(view, fieldNumber, targetIndex);
        view.getModel().deleteEntryRow("treeentryentity", targetIndex);
        checkedNode.removeIf(e -> Objects.nonNull(e) && e.getId().equals(nodeId));
    }

    private static DynamicObject getEntryFromCache(IFormView view, String fieldNumber) {
        String jsonStr = view.getPageCache().get("disableEntry");
        HashMap disableEntryMap = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jsonStr) ? (HashMap)kd.bos.portal.util.SerializationUtils.fromJsonString((String)jsonStr, Map.class) : new HashMap(16);
        DynamicObjectType dynamicObjectType = view.getModel().getEntryEntity("treeentryentity").getDynamicObjectType();
        Object[] cacheObject = DynamicObjectSerializeUtil.deserialize((String)((String)disableEntryMap.get(fieldNumber)), (DynamicObjectType)dynamicObjectType);
        return (DynamicObject)cacheObject[0];
    }

    public static void cacheDisableEntry(IFormView view, String fieldNumber, int targetIndex) {
        DynamicObjectType dynamicObjectType = view.getModel().getEntryEntity("treeentryentity").getDynamicObjectType();
        DynamicObject dynamicObject = (DynamicObject)view.getModel().getEntryEntity("treeentryentity").get(targetIndex);
        String jsonStr = view.getPageCache().get("disableEntry");
        HashMap<String, String> disableEntryMap = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jsonStr) ? (HashMap<String, String>)kd.bos.portal.util.SerializationUtils.fromJsonString((String)jsonStr, Map.class) : new HashMap<String, String>(16);
        String objectSerialization = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dynamicObject}, (DynamicObjectType)dynamicObjectType);
        disableEntryMap.put(fieldNumber, objectSerialization);
        view.getPageCache().put("disableEntry", kd.bos.portal.util.SerializationUtils.toJsonString(disableEntryMap));
    }

    public static void updateParentEntry(IFormView view, String entityNumber, String fieldNumber, String propertyName, Object newValue) {
        IFormView parentView = view.getParentView();
        IDataModel parentDataModel = parentView.getModel();
        DynamicObjectCollection collection = parentDataModel.getEntryEntity("tpltreeentryentity");
        for (int rowNum = 0; rowNum < collection.size(); ++rowNum) {
            boolean isFieldNumber;
            DynamicObject dynamicObject = (DynamicObject)collection.get(rowNum);
            boolean isEntityId = entityNumber.equals(dynamicObject.getString("childentity"));
            if (!isEntityId || !(isFieldNumber = fieldNumber.equals(dynamicObject.getString("fieldnumber")))) continue;
            parentDataModel.beginInit();
            dynamicObject.set(propertyName, newValue);
            parentDataModel.endInit();
            parentView.updateView("tpltreeentryentity", rowNum);
            view.sendFormAction(parentView);
            break;
        }
    }

    public static void refreshChildEntryFieldDisplay(IFormView fieldView, boolean isRowUpd) {
        IDataModel fieldModel = fieldView.getModel();
        DynamicObjectCollection dynColl = fieldModel.getEntryEntity("treeentryentity");
        if (CollectionUtils.isEmpty((Collection)dynColl)) {
            return;
        }
        String tmpltype = (String)fieldView.getParentView().getModel().getValue("tmpltype");
        boolean isImport = "IMPT".equals(tmpltype);
        AbstractGrid entryGrid = (AbstractGrid)fieldView.getControl("treeentryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(8);
        CellStyle cs = new CellStyle();
        cs.setForeColor("#1BA854");
        cs.setFieldKey("tplentityname");
        for (int rowNum = 0; rowNum < dynColl.size(); ++rowNum) {
            DynamicObject dy = (DynamicObject)dynColl.get(rowNum);
            String fieldName = dy.getString("fieldname");
            String imptAttr = dy.getString("imptattr");
            String isSheet = dy.getString("issheet");
            boolean isCusField = dy.getBoolean("iscusfield");
            boolean isfield = dy.getBoolean("isfield");
            fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"imptattr", "exptattr", "issheet", "sheetbdfieldnames"});
            boolean isimport = dy.getBoolean("isimport");
            TemplateFormCommonUtil.changeImportBtn(fieldView, isimport, rowNum, tmpltype, imptAttr, isSheet);
            if (!isfield && !isCusField) {
                fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"entitydescription", "displayname", "fieldimportdesc", "imptattr", "exptattr"});
                entryGrid.hideOperateItems("operationcolumnap", rowNum, (List)Lists.newArrayList((Object[])new String[]{"delete"}));
                if (isRowUpd) {
                    fieldModel.beginInit();
                    fieldModel.setValue("ismustinput", (Object)true, rowNum);
                    fieldModel.endInit();
                }
            }
            if (isCusField) {
                fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"displayname", "issheet", "sheetbdfieldnames", "imptattr", "exptattr"});
                CellStyle csClone = (CellStyle)SerializationUtils.clone((Serializable)cs);
                csClone.setRow(rowNum);
                csList.add(csClone);
                entryGrid.setCellStyle(csList);
            } else {
                fieldView.setEnable(Boolean.valueOf(isfield), rowNum, new String[]{"displayname", "fieldimportdesc"});
            }
            fieldView.setEnable(Boolean.valueOf(isCusField), rowNum, new String[]{"fieldnumber", "fieldname"});
            TemplateFormCommonUtil.setChildEntryRootInput(fieldView, dynColl, dy, isRowUpd);
        }
    }

    public static void refreshChildEntryFieldDisplay(IFormView fieldView) {
        IDataModel fieldModel = fieldView.getModel();
        DynamicObjectCollection dynColl = fieldModel.getEntryEntity("treeentryentity");
        if (CollectionUtils.isEmpty((Collection)dynColl)) {
            return;
        }
        String tmpltype = (String)fieldView.getParentView().getModel().getValue("tmpltype");
        boolean isImportTpl = "IMPT".equals(tmpltype);
        AbstractGrid entryGrid = (AbstractGrid)fieldView.getControl("treeentryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(8);
        CellStyle cs = new CellStyle();
        cs.setForeColor("#1BA854");
        cs.setFieldKey("tplentityname");
        for (int rowNum = 0; rowNum < dynColl.size(); ++rowNum) {
            DynamicObject dy = (DynamicObject)dynColl.get(rowNum);
            String isSheet = dy.getString("issheet");
            boolean isCusField = dy.getBoolean("iscusfield");
            boolean isfield = dy.getBoolean("isfield");
            boolean isVirField = dy.getBoolean("isvirfield");
            fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"imptattr", "exptattr", "issheet", "sheetbdfieldnames"});
            boolean isimport = dy.getBoolean("isimport");
            TemplateFormCommonUtil.dealBDDisplay(fieldView, isimport, rowNum, isImportTpl, isSheet);
            if (!isfield && !isCusField) {
                fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"entitydescription", "displayname", "fieldimportdesc", "imptattr", "exptattr"});
                entryGrid.hideOperateItems("operationcolumnap", rowNum, (List)Lists.newArrayList((Object[])new String[]{"delete"}));
            }
            if (isVirField) {
                fieldView.setEnable(Boolean.valueOf(isCusField), rowNum, new String[]{"ismustinput"});
                fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"entitydescription", "displayname", "fieldimportdesc", "imptattr", "exptattr"});
            }
            if (isCusField || isVirField) {
                fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"displayname", "issheet", "sheetbdfieldnames", "imptattr", "exptattr"});
                if (isVirField) {
                    fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"ismustinput"});
                    fieldView.setEnable(Boolean.TRUE, rowNum, new String[]{"displayname", "fieldimportdesc"});
                }
                CellStyle csClone = (CellStyle)SerializationUtils.clone((Serializable)cs);
                csClone.setRow(rowNum);
                csList.add(csClone);
                entryGrid.setCellStyle(csList);
            } else {
                fieldView.setEnable(Boolean.valueOf(isfield), rowNum, new String[]{"displayname", "fieldimportdesc"});
            }
            fieldView.setEnable(Boolean.valueOf(isCusField), rowNum, new String[]{"fieldnumber", "fieldname"});
        }
    }

    public static DynamicObject setChildEntryRootInput(IFormView fieldView, DynamicObjectCollection collection, DynamicObject dynamicObject, boolean isRowUpd) {
        boolean isMustInput;
        DynamicObject targetObj = null;
        int targetIndex = 0;
        long pId = dynamicObject.getLong("pid");
        for (int rowNum = 0; rowNum < collection.size(); ++rowNum) {
            DynamicObject dyn = (DynamicObject)collection.get(rowNum);
            long id = dyn.getLong("id");
            if (pId != id) continue;
            targetObj = dyn;
            targetIndex = rowNum;
            break;
        }
        if (!(isMustInput = dynamicObject.getBoolean("ismustinput")) && targetObj != null) {
            IDataModel fieldModel = fieldView.getModel();
            if (isRowUpd) {
                fieldModel.beginInit();
                fieldModel.setValue("ismustinput", (Object)false, targetIndex);
                fieldModel.setValue("ismustinput", (Object)false, 0);
                fieldModel.endInit();
            } else {
                fieldModel.setValue("ismustinput", (Object)false, targetIndex);
                fieldModel.setValue("ismustinput", (Object)false, 0);
            }
        }
        return null;
    }

    public static String getDisplayName(String entityNumber, String prop) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainEntityType.getAllFields();
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)allFields.get(prop);
        if (Objects.nonNull(dataEntityProperty)) {
            return dataEntityProperty.getDisplayName().toString();
        }
        return "";
    }

    public static String getDisplayName(String rightProp) {
        String mainEntityNumber = "";
        String propName = "";
        String baseData = "";
        String subData = "";
        String[] split = rightProp.split("\\.");
        if (split.length == 1) {
            mainEntityNumber = rightProp;
            return "";
        }
        if (split.length == 2) {
            mainEntityNumber = split[0];
            propName = split[1];
        } else if (split.length == 3) {
            mainEntityNumber = split[0];
            baseData = split[1];
            propName = split[2];
        } else if (split.length == 4) {
            mainEntityNumber = split[0];
            baseData = split[1];
            subData = split[2];
            propName = split[3];
        }
        if ("billhead".equals(propName)) {
            return "";
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        DataEntityPropertyCollection mainEntityProperties = mainEntityType.getProperties();
        String displayName = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)subData)) {
            DataEntityPropertyCollection baseProperties = ((BasedataProp)mainEntityProperties.get((Object)baseData)).getComplexType().getProperties();
            BasedataProp subEntityProperty = (BasedataProp)baseProperties.get((Object)subData);
            String name = subEntityProperty.getBaseEntityId();
            DataEntityPropertyCollection properties = subEntityProperty.getComplexType().getProperties();
            propName = ((IDataEntityProperty)properties.get((Object)propName)).getDisplayName() == null ? ((IDataEntityProperty)properties.get((Object)propName)).getName() : ((IDataEntityProperty)properties.get((Object)propName)).getDisplayName().getLocaleValue();
            baseData = ((IDataEntityProperty)mainEntityProperties.get((Object)baseData)).getDisplayName() == null ? ((IDataEntityProperty)mainEntityProperties.get((Object)baseData)).getName() : ((IDataEntityProperty)mainEntityProperties.get((Object)baseData)).getDisplayName().getLocaleValue();
            subData = ((IDataEntityProperty)baseProperties.get((Object)subData)).getDisplayName() == null ? ((IDataEntityProperty)baseProperties.get((Object)subData)).getName() : ((IDataEntityProperty)baseProperties.get((Object)subData)).getDisplayName().getLocaleValue();
            displayName = baseData + "." + subData + "." + propName;
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)baseData)) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)mainEntityProperties.get((Object)baseData);
            if (dataEntityProperty instanceof BasedataProp) {
                DataEntityPropertyCollection baseProperties = ((BasedataProp)mainEntityProperties.get((Object)baseData)).getComplexType().getProperties();
                propName = ((IDataEntityProperty)baseProperties.get((Object)propName)).getDisplayName() == null ? ((IDataEntityProperty)baseProperties.get((Object)propName)).getName() : ((IDataEntityProperty)baseProperties.get((Object)propName)).getDisplayName().getLocaleValue();
                baseData = ((IDataEntityProperty)mainEntityProperties.get((Object)baseData)).getDisplayName() == null ? ((IDataEntityProperty)mainEntityProperties.get((Object)baseData)).getName() : ((IDataEntityProperty)mainEntityProperties.get((Object)baseData)).getDisplayName().getLocaleValue();
                displayName = baseData + "." + propName;
            } else if (dataEntityProperty instanceof EntryProp) {
                Map allFields = mainEntityType.getAllFields();
                displayName = propName = ((IDataEntityProperty)allFields.get(propName)).getDisplayName() == null ? ((IDataEntityProperty)allFields.get(propName)).getName() : ((IDataEntityProperty)allFields.get(propName)).getDisplayName().getLocaleValue();
            }
        } else {
            displayName = propName = ((IDataEntityProperty)mainEntityProperties.get((Object)propName)).getDisplayName() == null ? ((IDataEntityProperty)mainEntityProperties.get((Object)propName)).getName() : ((IDataEntityProperty)mainEntityProperties.get((Object)propName)).getDisplayName().getLocaleValue();
        }
        return displayName;
    }

    public static String getFieldNumber(String prop) {
        String mainEntityNumber = "";
        String propName = "";
        String baseData = "";
        String subData = "";
        String[] split = prop.split("\\.");
        if (split.length == 1) {
            mainEntityNumber = prop;
            return "";
        }
        if (split.length == 2) {
            mainEntityNumber = split[0];
            propName = split[1];
        } else if (split.length == 3) {
            mainEntityNumber = split[0];
            baseData = split[1];
            propName = split[2];
        } else if (split.length == 4) {
            mainEntityNumber = split[0];
            baseData = split[1];
            subData = split[2];
            propName = split[3];
        }
        if ("billhead".equals(propName)) {
            return "";
        }
        return propName;
    }

    public static void refreshTree(IFormView parentView, String mainEntityNumber, String mustInputField, String cancelUniqueVal) {
        CustomTabPageId customTabPageId = TemplateFormCommonUtil.getTabPageIdCache(parentView, mainEntityNumber);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customTabPageId)) {
            IFormView view = parentView.getView(customTabPageId.getTabPageId());
            List<String> checkFields = Arrays.stream(mustInputField.split(",")).collect(Collectors.toList());
            List<String> uncheckFields = Arrays.stream(cancelUniqueVal.split(",")).collect(Collectors.toList());
            TreeView treeView = (TreeView)view.getControl("treeviewap");
            String rootNodeStr = view.getPageCache().get("rootNode");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rootNodeStr)) {
                return;
            }
            TreeNode rootNode = (TreeNode)kd.bos.portal.util.SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            LinkedHashSet checkedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
            LinkedHashSet unCheckedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
            List children = rootNode.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                EntityTreeServiceHelper.checkNodes(children, checkFields, checkedTreeNode);
            }
            if (!CollectionUtils.isEmpty((Collection)children)) {
                EntityTreeServiceHelper.checkNodes(children, uncheckFields, unCheckedTreeNode);
            }
            for (TreeNode treeNode : checkedTreeNode) {
                treeView.checkNode(treeNode);
                treeView.treeNodeCheck(treeNode.getParentid(), treeNode.getId(), Boolean.valueOf(true));
                treeNode.setDisabled(true);
                treeView.updateNode(treeNode);
            }
            for (TreeNode treeNode : unCheckedTreeNode) {
                treeView.uncheckNode(treeNode.getId());
                treeNode.setDisabled(false);
                treeView.treeNodeCheck(treeNode.getParentid(), treeNode.getId(), Boolean.valueOf(false));
                treeView.updateNode(treeNode);
            }
            view.updateView("treeviewap");
            parentView.sendFormAction(view);
        }
    }

    public static void refreshTree4UniqueVal(IFormView parentView, String mainEntityNumber, String mustInputField, String cancelUniqueVal) {
        CustomTabPageId customTabPageId = TemplateFormCommonUtil.getTabPageIdCache(parentView, mainEntityNumber);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customTabPageId)) {
            IFormView view = parentView.getView(customTabPageId.getTabPageId());
            List<String> checkFields = Arrays.stream(mustInputField.split(",")).collect(Collectors.toList());
            List<String> uncheckFields = Arrays.stream(cancelUniqueVal.split(",")).collect(Collectors.toList());
            TreeView treeView = (TreeView)view.getControl("treeviewap");
            String rootNodeStr = view.getPageCache().get("rootNode");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rootNodeStr)) {
                return;
            }
            TreeNode rootNode = (TreeNode)kd.bos.portal.util.SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            LinkedHashSet checkedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
            LinkedHashSet unCheckedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
            List children = rootNode.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                EntityTreeServiceHelper.checkNodes(children, checkFields, checkedTreeNode);
            }
            if (!CollectionUtils.isEmpty((Collection)children)) {
                EntityTreeServiceHelper.checkNodes(children, uncheckFields, unCheckedTreeNode);
            }
            for (TreeNode treeNode : checkedTreeNode) {
                treeView.checkNode(treeNode);
                treeView.treeNodeCheck(treeNode.getParentid(), treeNode.getId(), Boolean.valueOf(true));
                treeNode.setDisabled(true);
            }
            for (TreeNode treeNode : unCheckedTreeNode) {
                treeNode.setDisabled(false);
            }
            ArrayList updateNodes = new ArrayList(checkedTreeNode.size() + unCheckedTreeNode.size());
            updateNodes.addAll(checkedTreeNode);
            updateNodes.addAll(unCheckedTreeNode);
            treeView.updateNodes(updateNodes);
            parentView.sendFormAction(view);
        }
    }

    public static void deleteParentNode(IFormView view) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("treeentryentity");
        Long rootId = null;
        for (Object dynamicObject : entryEntity) {
            Long pid = dynamicObject.getLong("pid");
            if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)pid) && pid != 0L) continue;
            rootId = dynamicObject.getLong("id");
            break;
        }
        ArrayList entryNodeList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : entryEntity) {
            Long pid = dynamicObject.getLong("pid");
            if (!pid.equals(rootId)) continue;
            entryNodeList.add(dynamicObject);
        }
        for (DynamicObject dynamicObject : entryNodeList) {
            Long id = dynamicObject.getLong("id");
            ArrayList children = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject dy : entryEntity) {
                Long pid = dy.getLong("pid");
                if (!pid.equals(id)) continue;
                children.add(dynamicObject);
            }
            if (!CollectionUtils.isEmpty((Collection)children)) continue;
            int targetIndex = 0;
            int i = 0;
            DynamicObjectCollection collection = view.getModel().getEntryEntity("treeentryentity");
            for (DynamicObject object : collection) {
                boolean isId = id.equals(object.getLong("id"));
                if (isId) {
                    targetIndex = i;
                    break;
                }
                ++i;
            }
            TemplateFormCommonUtil.cacheDisableEntry(view, String.valueOf(id), targetIndex);
            view.getModel().deleteEntryRow("treeentryentity", targetIndex);
        }
        DynamicObjectCollection collection = view.getModel().getEntryEntity("treeentryentity");
        if (collection.size() == 1) {
            DynamicObject dynamicObject;
            dynamicObject = (DynamicObject)collection.get(0);
            TemplateFormCommonUtil.cacheDisableEntry(view, String.valueOf(dynamicObject.getLong("id")), 0);
            TemplateFormCommonUtil.cacheDisableEntry(view, "0", 0);
            view.getModel().deleteEntryRow("treeentryentity", 0);
        }
    }

    public static Map<String, List<String>> getQueryEntityTypeFieldMap(String queryEntityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)queryEntityNumber);
        HashMap queryFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            String mainEntityNumber = queryType.getMainEntityType().getName();
            List selectFields = queryType.getSelectFields();
            List allJoinEntityType = queryType.getAllJoinEntityType();
            allJoinEntityType.add(queryType.getMainEntityType());
            List<String> joinEntityList = TemplateFormCommonUtil.getJoinEntityList(queryType);
            for (MainEntityType mainEntityType : allJoinEntityType) {
                String entityNumber = mainEntityType.getName();
                MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Map allFields = joinEntityType.getAllFields();
                for (Map.Entry entry : allFields.entrySet()) {
                    String fieldNumber;
                    String newFieldNumber = fieldNumber = (String)entry.getKey();
                    IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
                    for (QuerySelectField selectField : selectFields) {
                        List queryFields;
                        String alias = selectField.getAlias();
                        String queryFieldEntity = TemplateFormCommonUtil.getFieldEntity(alias, joinEntityList);
                        if (HRStringUtils.isEmpty((String)queryFieldEntity)) {
                            queryFieldEntity = mainEntityNumber;
                        }
                        if (!entityNumber.equals(queryFieldEntity)) continue;
                        if (prop.getParent() instanceof EntryType || prop.getParent() instanceof TreeEntryType) {
                            newFieldNumber = prop.getParent().getName() + "." + prop.getName();
                        }
                        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)mainEntityNumber, (CharSequence)queryFieldEntity)) {
                            queryFields = queryFieldMap.getOrDefault(queryFieldEntity, new ArrayList(16));
                            if (newFieldNumber.equals(alias)) {
                                queryFields.add(prop.getName());
                            }
                            queryFieldMap.put(queryFieldEntity, queryFields);
                            continue;
                        }
                        queryFields = queryFieldMap.getOrDefault(queryFieldEntity, new ArrayList(16));
                        String replace = alias.replace(queryFieldEntity + ".", "");
                        if (newFieldNumber.equals(replace)) {
                            queryFields.add(prop.getName());
                        }
                        queryFieldMap.put(queryFieldEntity, queryFields);
                    }
                }
            }
        }
        return queryFieldMap;
    }

    private static String getFieldEntity(String queryField, List<String> joinEntityList) {
        String entity = "";
        for (String joinEntity : joinEntityList) {
            if (!queryField.startsWith(joinEntity)) continue;
            entity = joinEntity;
            break;
        }
        return entity;
    }

    private static List<String> getJoinEntityList(QueryEntityType queryEntityTpe) {
        List joinEntityList = queryEntityTpe.getJoinEntitys();
        ArrayList<String> entityList = new ArrayList<String>(joinEntityList.size());
        for (JoinEntity joinEntity : joinEntityList) {
            entityList.add(joinEntity.getEntityName());
        }
        return entityList;
    }
}

