/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.dto.DiaeTemplateInfo;
import kd.hr.hies.common.dto.OrgInfo;
import kd.hr.hies.common.dto.RoleOrgInfo;
import kd.hr.hies.common.dto.SubEntityInfo;
import kd.hr.hies.common.util.TemplateEntityFieldUtil;

@ExcludeFromJacocoGeneratedReport
public class TemplateTreeEntityUtil {
    private final Map<String, DynamicObject> entityIndexMapping = new HashMap<String, DynamicObject>(16);
    private final Map<String, String> dataRangeMap = new HashMap<String, String>(16);
    private final Map<String, IDataEntityProperty> newPropMap = new HashMap<String, IDataEntityProperty>(16);

    public static TemplateTreeEntityUtil getInstance() {
        return new TemplateTreeEntityUtil();
    }

    public OperationResult createTemplate(DiaeTemplateInfo diaeTemplateInfo) {
        this.checkParam(diaeTemplateInfo);
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"hies_diaetplconf");
        this.fillBaseInfo(diaeTemplateInfo, data);
        this.fillSubEntity(diaeTemplateInfo, data);
        this.fillApplyScope(diaeTemplateInfo, data);
        this.buildTreeEntity(diaeTemplateInfo, data);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl("hies_diaetplconf");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = serviceImpl.localInvokeOperation("save", new DynamicObject[]{data}, operateOption);
        return operationResult;
    }

    private LinkedHashMap<String, String> getAllEntity(DynamicObject model) {
        DynamicObjectCollection subEntityCollection;
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>(16);
        String mainDyObj = model.getString("entity_id");
        if (StringUtils.isNotBlank((CharSequence)mainDyObj)) {
            objectMap.put(mainDyObj + ":" + mainDyObj, mainDyObj);
        }
        if ((subEntityCollection = model.getDynamicObjectCollection("entityrelation")).size() > 0) {
            subEntityCollection.stream().filter(entityDynamicObject -> Objects.nonNull(entityDynamicObject.get("rentity"))).forEach(entityDynamicObject -> objectMap.put(((DynamicObject)entityDynamicObject.get("rentity")).getString("id") + ":" + ((DynamicObject)entityDynamicObject.get("rentity")).getString("number"), ((DynamicObject)entityDynamicObject.get("rentity")).getString("name")));
        }
        return objectMap;
    }

    private void checkParam(DiaeTemplateInfo diaeTemplateInfo) {
    }

    private void fillApplyScope(DiaeTemplateInfo diaeTemplateInfo, DynamicObject data) {
        List<RoleOrgInfo> list;
        List<OrgInfo> orgInfoList;
        List<String> roleIds;
        List<Long> userIds = diaeTemplateInfo.getUserIds();
        if (CollectionUtils.isNotEmpty(userIds)) {
            DynamicObjectCollection userEntryEntity = data.getDynamicObjectCollection("userlist");
            for (Long l : diaeTemplateInfo.getUserIds()) {
                DynamicObject dynamicObject = userEntryEntity.addNew();
                dynamicObject.set("user", (Object)l);
            }
        }
        if (CollectionUtils.isNotEmpty(roleIds = diaeTemplateInfo.getRoleIds())) {
            DynamicObjectCollection roleEntryEntity = data.getDynamicObjectCollection("rolelist");
            for (String string : roleIds) {
                DynamicObject dynamicObject = roleEntryEntity.addNew();
                dynamicObject.set("role", (Object)string);
            }
        }
        if (CollectionUtils.isNotEmpty(orgInfoList = diaeTemplateInfo.getOrgInfoList())) {
            DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("orglist");
            for (OrgInfo orgInfo : orgInfoList) {
                DynamicObject dynamicObject = dynamicObjectCollection.addNew();
                dynamicObject.set("org", (Object)orgInfo.getOrgId());
                dynamicObject.set("isincludesuborg", (Object)orgInfo.getIsincludesuborg());
            }
        }
        if (CollectionUtils.isNotEmpty(list = diaeTemplateInfo.getRoleOrgInfoList())) {
            DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("orgrolelist");
            for (RoleOrgInfo roleOrgInfo : list) {
                DynamicObject dynamicObject = dynamicObjectCollection.addNew();
                dynamicObject.set("orgrole", (Object)roleOrgInfo.getRoleId());
                dynamicObject.set("orgrolenumber", (Object)roleOrgInfo.getOrgId());
                dynamicObject.set("isincludesuborgrole", (Object)roleOrgInfo.getIsincludesuborg());
            }
        }
    }

    private void fillSubEntity(DiaeTemplateInfo diaeTemplateInfo, DynamicObject data) {
        List<SubEntityInfo> subEntityInfoList = diaeTemplateInfo.getSubEntityInfoList();
        if (CollectionUtils.isNotEmpty(subEntityInfoList)) {
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entityrelation");
            for (SubEntityInfo subEntityInfo : subEntityInfoList) {
                DynamicObject dynamicObject = entryEntity.addNew();
                dynamicObject.set("rentity", (Object)subEntityInfo.getRentity());
                dynamicObject.set("entityuniqueval", (Object)subEntityInfo.getEntityuniqueval());
                dynamicObject.set("relationleftprop", (Object)subEntityInfo.getRelationleftprop());
                dynamicObject.set("relationrightprop", (Object)subEntityInfo.getRelationrightprop());
            }
        }
    }

    private void fillBaseInfo(DiaeTemplateInfo diaeTemplateInfo, DynamicObject data) {
        data.set("number", (Object)diaeTemplateInfo.getNumber());
        data.set("name", (Object)new LocaleString(diaeTemplateInfo.getName()));
        data.set("tmpltype", (Object)diaeTemplateInfo.getTmpltype());
        data.set("entitytype", (Object)diaeTemplateInfo.getEntitytype());
        data.set("entity_id", (Object)diaeTemplateInfo.getEntity());
        data.set("queryentity_id", (Object)diaeTemplateInfo.getEntity());
        data.set("instruction", (Object)diaeTemplateInfo.getInstruction());
        data.set("importtype", (Object)diaeTemplateInfo.getImporttype());
        data.set("enabledowncond", (Object)diaeTemplateInfo.getEnabledowncond());
        data.set("mainentityuniqueval", (Object)diaeTemplateInfo.getMainentityuniqueval());
        data.set("plugin", (Object)diaeTemplateInfo.getPlugin());
        data.set("allocationpolicy", (Object)diaeTemplateInfo.getAllocationpolicy());
        data.set("applyscope", (Object)diaeTemplateInfo.getApplyscope());
        data.set("source", (Object)diaeTemplateInfo.getSource());
        data.set("tplgenmode", (Object)diaeTemplateInfo.getTplGenMode());
        data.set("metaversion", (Object)diaeTemplateInfo.getMetaVersion());
        data.set("creator", (Object)RequestContext.get().getCurrUserId());
        data.set("orgfield", (Object)RequestContext.get().getOrgId());
        data.set("enable", (Object)"1");
    }

    public DynamicObjectCollection buildTreeEntity(DiaeTemplateInfo diaeTemplateInfo, DynamicObject data) {
        DynamicObjectCollection treeEntryEntity = data.getDynamicObjectCollection("tpltreeentryentity");
        LinkedHashMap<String, String> allEntity = this.getAllEntity(data);
        for (Map.Entry entityEntry : allEntity.entrySet()) {
            String[] split = ((String)entityEntry.getKey()).split(":");
            String entityNumber = split[1];
            this.addTreeEntryRow(treeEntryEntity, entityNumber, Boolean.TRUE, Boolean.TRUE, null);
        }
        return treeEntryEntity;
    }

    public void addTreeEntryRow(DynamicObjectCollection treeEntryEntity, String entityNumber, Boolean isImport, Boolean isOpen, Map<String, Map<String, Object>> dataMap) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        boolean isQueryEntity = false;
        int[] seq = new int[]{1};
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
            isQueryEntity = true;
        } else {
            entityTypes.add(mainType);
        }
        for (MainEntityType mainEntityType : entityTypes) {
            this.buildFldTreeRowExt(seq, treeEntryEntity, entityNumber, mainEntityType, isImport, isOpen, dataMap);
        }
    }

    private void buildFldTreeRowExt(int[] seq, DynamicObjectCollection treeEntryEntity, String entityNumber, MainEntityType mainType, Boolean isImport, Boolean isOpen, Map<String, Map<String, Object>> dataMap) {
        List<EntityItem<?>> newItems = this.filterEntityItems(mainType, isImport);
        List<ControlAp<?>> aps = this.getFormMetadata(mainType.getName());
        DynamicObject entityTreeEntry = new DynamicObject(treeEntryEntity.getDynamicObjectType());
        Long id = DBServiceHelper.genLongIds((String)"tpltreeentryentity", (int)1)[0];
        entityTreeEntry.set("id", (Object)id);
        entityTreeEntry.set("pid", (Object)0);
        int n = seq[0];
        seq[0] = n + 1;
        entityTreeEntry.set("seq", (Object)n);
        treeEntryEntity.add((Object)entityTreeEntry);
        this.fillExistingRowIdAndPid(entityTreeEntry, mainType.getName(), dataMap);
        this.entityIndexMapping.put(mainType.getName(), entityTreeEntry);
        this.fillPartialFieldsInfo(entityTreeEntry, mainType.getDisplayName().toString(), entityNumber, mainType.getName());
        this.buildEntryTreeRow(seq, entityNumber, treeEntryEntity, entityTreeEntry, mainType, dataMap, newItems, aps, isImport, isOpen);
    }

    private void buildEntryTreeRow(int[] seq, String entityNumber, DynamicObjectCollection treeEntryEntity, DynamicObject entityTreeEntry, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, List<EntityItem<?>> newItems, List<ControlAp<?>> aps, Boolean isImport, Boolean isOpen) {
        boolean[] isAllCheck = new boolean[]{false};
        int[] row = new int[]{-1};
        for (Map.Entry<String, EntityType> entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (entityType instanceof SubEntryType) continue;
            this.entitySortAndBulid(seq, entityNumber, treeEntryEntity, entityTreeEntry, mainType, dataMap, newItems, aps, row, isAllCheck, entry, isImport, isOpen);
        }
        if (row[0] > 0) {
            treeEntryEntity.remove((Object)entityTreeEntry);
        }
        if (isAllCheck[0]) {
            entityTreeEntry.set("ismustinput", (Object)Boolean.TRUE);
            entityTreeEntry.set("isimport", (Object)Boolean.TRUE);
        }
    }

    private void entitySortAndBulid(int[] seq, String entityNumber, DynamicObjectCollection treeEntryEntity, DynamicObject parentTreeEntry, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, List<EntityItem<?>> newItems, List<ControlAp<?>> aps, int[] row, boolean[] isAllCheck, Map.Entry<String, EntityType> entry, Boolean isImport, Boolean isOpen) {
        IDataEntityType parentType;
        EntityType entityType = entry.getValue();
        if (entityType instanceof LinkEntryType || entityType instanceof NameVersionEntryType) {
            return;
        }
        String entityNodeId = entityType.getName();
        String entityNodeName = "";
        if (entityType.getDisplayName() != null) {
            entityNodeName = entityType.getDisplayName().toString();
        }
        if (entityType instanceof MainEntityType) {
            entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)HiesCommonRes.TemplateTreeEntityUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
            entityNodeId = "";
        }
        parentTreeEntry = this.entityIndexMapping.get((parentType = entityType.getParent()) != null ? parentType.getName() : entityType.getName());
        DynamicObject pEntry = null;
        if (row[0] < 0) {
            pEntry = new DynamicObject(treeEntryEntity.getDynamicObjectType());
            pEntry.set("id", (Object)DBServiceHelper.genLongIds((String)"tpltreeentryentity", (int)1)[0]);
            pEntry.set("pid", parentTreeEntry.getPkValue());
            int n = seq[0];
            seq[0] = n + 1;
            pEntry.set("seq", (Object)n);
            treeEntryEntity.add((Object)pEntry);
        }
        List<IDataEntityProperty> properties = entityType.getFields().values().stream().filter(prop -> entityType instanceof QueryEntityType && !(prop instanceof JoinProperty) || this.isPropertyImport(newItems, (IDataEntityProperty)prop)).collect(Collectors.toList());
        this.getSortProperties(mainType, properties, aps, dataMap != null ? dataMap.keySet() : null, entityType, isImport);
        boolean isAllChildrenCheck = true;
        if (!properties.isEmpty()) {
            isAllChildrenCheck = this.buildEntryFieldTreeRow(seq, entityNumber, treeEntryEntity, pEntry, mainType, dataMap, entry.getKey(), entityNodeId, entityNodeName, properties, isImport, isOpen);
            if (!isAllChildrenCheck) {
                isAllCheck[0] = Boolean.FALSE;
            }
            row[0] = -1;
        }
    }

    private boolean buildEntryFieldTreeRow(int[] seq, String entityNumber, DynamicObjectCollection treeEntryEntity, DynamicObject billheadEntry, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, String entryKey, String entityNodeId, String entityNodeName, List<IDataEntityProperty> properties, Boolean isImport, Boolean isOpen) {
        boolean isAllChildrenCheck = true;
        int i = 0;
        for (IDataEntityProperty property : properties) {
            DynamicObject fieldEntry = new DynamicObject(treeEntryEntity.getDynamicObjectType());
            fieldEntry.set("pid", billheadEntry.getPkValue());
            fieldEntry.set("id", (Object)DBServiceHelper.genLongIds((String)"tpltreeentryentity", (int)1)[0]);
            int n = seq[0];
            seq[0] = n + 1;
            fieldEntry.set("seq", (Object)n);
            if (!this.buildFldTreeNode(entityNumber, fieldEntry, property, mainType, dataMap, isImport, isOpen)) {
                isAllChildrenCheck = false;
            }
            treeEntryEntity.add((Object)fieldEntry);
            ++i;
        }
        this.fillPartialFieldsInfo(billheadEntry, entityNodeName, entityNumber, entityNodeId);
        billheadEntry.set("ismustinput", (Object)isAllChildrenCheck);
        billheadEntry.set("isimport", (Object)isAllChildrenCheck);
        if (!this.entityIndexMapping.containsKey(entryKey)) {
            this.entityIndexMapping.put(entryKey, billheadEntry);
        }
        return isAllChildrenCheck;
    }

    private boolean buildFldTreeNode(String entityNumber, DynamicObject fieldEntry, IDataEntityProperty fldProperty, MainEntityType mainType, Map<String, Map<String, Object>> dataMap, Boolean isImport, Boolean isOpen) {
        boolean isValidMulBaseData;
        boolean isFullTemplate = true;
        DynamicProperty prop = (DynamicProperty)fldProperty;
        String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        String fieldNumber = prop.getName();
        fieldEntry.set("childentity", (Object)entityNumber);
        if (prop == prop.getParent().getPrimaryKey()) {
            fldNodeName = ResManager.loadKDString((String)"\u5185\u7801", (String)HiesCommonRes.TemplateTreeEntityUtil_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
            if (prop.getParent() instanceof EntryType) {
                fieldNumber = prop.getParent().getName() + "." + prop.getName();
            }
        } else if (prop.getName().equals("pid") && prop.getParent() instanceof TreeEntryType) {
            fldNodeName = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)HiesCommonRes.TemplateTreeEntityUtil_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
            fieldNumber = prop.getParent().getName() + "." + prop.getName();
        }
        boolean isValidField = fldProperty instanceof FieldProp && ((FieldProp)fldProperty).isMustInput();
        boolean isValidBaseData = fldProperty instanceof BasedataProp && ((BasedataProp)fldProperty).isMustInput();
        boolean bl = isValidMulBaseData = fldProperty instanceof MulBasedataProp && ((MulBasedataProp)fldProperty).isMustInput();
        if (isValidField || isValidBaseData || isValidMulBaseData) {
            fldNodeName = fldNodeName + "*";
        }
        fieldEntry.set("fieldname", (Object)fldNodeName);
        boolean ismustinput = fldNodeName.endsWith("*");
        String propFullName = this.setPropFullName((EntityType)mainType, (IDataEntityProperty)prop);
        boolean isNewProp = this.newPropMap.containsKey(propFullName);
        if (ismustinput && !isNewProp && isImport.booleanValue() && isOpen.booleanValue()) {
            fieldEntry.set("ismustinput", (Object)Boolean.TRUE);
            fieldEntry.set("isimport", (Object)Boolean.TRUE);
        }
        if (isFullTemplate && StringUtils.isNotBlank((CharSequence)fieldNumber) && !"id".equals(fieldNumber) && !fieldNumber.endsWith(".id")) {
            fieldEntry.set("isimport", (Object)Boolean.TRUE);
        }
        fieldEntry.set("fieldnumber", (Object)fieldNumber);
        fieldEntry.set("isfield", (Object)Boolean.TRUE);
        TemplateTreeEntityUtil.initBdFormatConfig(fieldEntry, fldProperty);
        return ismustinput;
    }

    private void getSortProperties(MainEntityType mainType, List<IDataEntityProperty> properties, List<ControlAp<?>> aps, Set<String> currSort, EntityType entityType, Boolean isImport) {
        int j = 0;
        block0: for (ControlAp<?> ap : aps) {
            if (!(ap instanceof FieldAp)) continue;
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty prop = properties.get(i);
                if (ap.getKey().equals(prop.getName())) {
                    Collections.swap(properties, i, j++);
                    continue block0;
                }
                IDataEntityType rootEntityType = prop.getParent();
                while (rootEntityType.getParent() != null) {
                    rootEntityType = rootEntityType.getParent();
                }
                String propFullName = rootEntityType.getName() + "." + prop.getName();
                if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(ap.getKey())) continue;
                Collections.swap(properties, i, j++);
            }
        }
        ArrayList<Object> mustInputProps = new ArrayList<Object>();
        ArrayList<IDataEntityProperty> notMustInputProps = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty propertie : properties) {
            if (propertie instanceof FieldProp && ((FieldProp)propertie).isMustInput()) {
                mustInputProps.add(propertie);
                continue;
            }
            notMustInputProps.add(propertie);
        }
        mustInputProps.addAll(notMustInputProps);
        properties.clear();
        properties.addAll(mustInputProps);
        if (entityType != null && isImport.booleanValue()) {
            if (entityType instanceof TreeEntryType) {
                properties.add(0, (IDataEntityProperty)entityType.getProperty("pid"));
            }
            properties.add(0, (IDataEntityProperty)entityType.getPrimaryKey());
        }
    }

    private String setPropFullName(EntityType entityType, IDataEntityProperty prop) {
        String rootEntityNumber = entityType.getName();
        String pkFullName = entityType.getName() + "." + entityType.getPrimaryKey().getName();
        if (!(entityType instanceof MainEntityType)) {
            pkFullName = rootEntityNumber + "." + pkFullName;
        }
        String propFullName = prop.getName().equals(entityType.getPrimaryKey().getName()) ? pkFullName : rootEntityNumber + "." + prop.getName();
        return propFullName;
    }

    private boolean isPropertyImport(List<EntityItem<?>> newItems, IDataEntityProperty prop) {
        if (prop instanceof AttachmentProp || prop instanceof AttachmentCountProp || "id".equalsIgnoreCase(prop.getName()) || "seq".equalsIgnoreCase(prop.getName())) {
            return false;
        }
        String controlKey = null;
        if (prop instanceof FlexProp) {
            controlKey = ((FlexProp)prop).getBasePropertyKey();
        } else if (prop instanceof ItemClassProp) {
            controlKey = ((ItemClassProp)prop).getTypePropName();
        }
        boolean existControlField = false;
        boolean existProp = false;
        for (EntityItem<?> item : newItems) {
            DateRangeField field;
            if (item instanceof DateRangeField) {
                field = (DateRangeField)item;
                if (field.getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName())) {
                    this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                    existProp = true;
                    break;
                }
            } else if (item instanceof TimeRangeField && ((field = (TimeRangeField)item).getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName()))) {
                this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                existProp = true;
                break;
            }
            if (controlKey != null && controlKey.equals(item.getKey())) {
                existControlField = true;
            }
            if (!prop.getName().equals(item.getKey())) continue;
            existProp = true;
            if (controlKey != null && !existControlField) continue;
            break;
        }
        return existProp && (controlKey == null || existControlField);
    }

    private void fillExistingRowIdAndPid(DynamicObject rowObj, String nodeName, Map<String, Map<String, Object>> dataMap) {
        Map<String, Object> rootData;
        if (dataMap != null && !dataMap.isEmpty() && (rootData = dataMap.get(nodeName)) != null) {
            rowObj.set("id", rootData.get("id"));
            rowObj.set("pid", rootData.get("pid"));
        }
    }

    private void fillPartialFieldsInfo(DynamicObject rowObj, String entityName, String entityNumber, String childNumber) {
        rowObj.set("childentity", (Object)entityNumber);
        rowObj.set("tplentityname", (Object)entityName);
        rowObj.set("fieldnumber", (Object)childNumber);
        rowObj.set("isfield", (Object)Boolean.FALSE);
    }

    private List<EntityItem<?>> filterEntityItems(MainEntityType mainType, Boolean isImport) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        return entityItems.stream().filter(item -> item instanceof Field && (isImport != false ? ((Field)item).getFeatures().isImportable() : ((Field)item).getFeatures().isExportable())).collect(Collectors.toList());
    }

    private List<ControlAp<?>> getFormMetadata(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        Collections.sort(aps, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return aps;
    }

    private static void initBdFormatConfig(DynamicObject fieldEntry, IDataEntityProperty fldProperty) {
        Map<String, Object> imptFormatConfig = TemplateEntityFieldUtil.getImptInitF7BdFormatConfig(fldProperty);
        Map<String, Object> exptFormatConfig = TemplateEntityFieldUtil.getExptInitF7BdFormatConfig(fldProperty);
        if (imptFormatConfig != null) {
            fieldEntry.set("imptattr", imptFormatConfig.get("val"));
        }
        if (exptFormatConfig != null) {
            fieldEntry.set("exptattr", exptFormatConfig.get("val"));
        }
    }
}

