/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class TreeViewSearchTool {
    private static final String KEY_PARAM_SEARCH_TEXT = "searchText";
    private static final String KEY_PARAM_SEARCH_NODE = "searchNode";
    private static final String KEY_PARAM_SEARCH_NODE_INDEX = "searchNodeIndex";

    private TreeViewSearchTool() {
    }

    public static boolean search(String searchText, TreeView tv, IPageCache pageCache) {
        return TreeViewSearchTool.search(searchText, tv, pageCache, true);
    }

    public static boolean search(String searchText, TreeView tv, IPageCache pageCache, boolean containNodeId) {
        ArrayList<String> searchNodeList = new ArrayList(16);
        String treeFlag = tv.getKey();
        String rootNodeStr = pageCache.get(treeFlag);
        if (StringUtils.isBlank((CharSequence)rootNodeStr)) {
            return false;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        if (!StringUtils.equals((CharSequence)searchText, (CharSequence)pageCache.get(treeFlag + KEY_PARAM_SEARCH_TEXT))) {
            pageCache.put(treeFlag + KEY_PARAM_SEARCH_TEXT, searchText);
            pageCache.remove(treeFlag + KEY_PARAM_SEARCH_NODE_INDEX);
            TreeViewSearchTool.searchParamByText(searchText, rootNode, searchNodeList, containNodeId);
            pageCache.put(treeFlag + KEY_PARAM_SEARCH_NODE, SerializationUtils.toJsonString(searchNodeList));
        } else {
            String paramSearchNodes = pageCache.get(treeFlag + KEY_PARAM_SEARCH_NODE);
            if (HRStringUtils.isEmpty((String)paramSearchNodes)) {
                return false;
            }
            searchNodeList = (List)SerializationUtils.fromJsonString((String)paramSearchNodes, List.class);
        }
        if (CollectionUtils.isEmpty(searchNodeList)) {
            return false;
        }
        String index = pageCache.get(treeFlag + KEY_PARAM_SEARCH_NODE_INDEX);
        int nodeIndex = HRStringUtils.isEmpty((String)index) ? 0 : Integer.parseInt(index);
        String currentSearchNodeId = (String)searchNodeList.get(nodeIndex);
        TreeNode currentSearchNode = rootNode.getTreeNode(currentSearchNodeId, 4);
        tv.showNode(currentSearchNodeId);
        tv.focusNode(currentSearchNode);
        nodeIndex = nodeIndex + 1 >= searchNodeList.size() ? 0 : nodeIndex + 1;
        pageCache.put(treeFlag + KEY_PARAM_SEARCH_NODE_INDEX, String.valueOf(nodeIndex));
        return true;
    }

    private static void searchParamByText(String text, TreeNode node, List<String> searchNodeList, boolean containNodeId) {
        List children;
        boolean isHit;
        String nodeId = node.getId();
        boolean bl = isHit = node.getText().contains(text) || containNodeId && nodeId.contains(text);
        if (isHit) {
            searchNodeList.add(nodeId);
        }
        if (CollectionUtils.isEmpty((Collection)(children = node.getChildren()))) {
            return;
        }
        for (TreeNode childTreeNode : children) {
            TreeViewSearchTool.searchParamByText(text, childTreeNode, searchNodeList, containNodeId);
        }
    }
}

