/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.bo.ObjEntityRelation;
import kd.hr.hies.common.bo.ObjJoinEntity;
import kd.hr.hies.common.bo.ObjQueryField;
import kd.hr.hies.common.constant.VirEntityCfgConstants;

@ExcludeFromJacocoGeneratedReport
public class VirEntityCfgService
implements VirEntityCfgConstants {
    private static final Log LOGGER = LogFactory.getLog(VirEntityCfgService.class);
    private static volatile VirEntityCfgService service = null;
    private final HRBaseServiceHelper searchObjectHelper = new HRBaseServiceHelper("hies_virentitycfg");
    private final HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hies_virobjjoinentity");
    private final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hies_virobjqueryfield");
    private final HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hies_virobjentityrel");

    private VirEntityCfgService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirEntityCfgService getInstance() {
        if (service != null) return service;
        Class<VirEntityCfgService> clazz = VirEntityCfgService.class;
        synchronized (VirEntityCfgService.class) {
            if (service != null) return service;
            service = new VirEntityCfgService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public DynamicObject loadSearchObject(Long searchObjId) {
        return this.searchObjectHelper.loadSingle((Object)searchObjId);
    }

    public boolean isExistsSearchObj(Long searchObjId) {
        return this.searchObjectHelper.isExists((Object)searchObjId);
    }

    public DynamicObject[] loadJoinEntities(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("virentitycfg", "=", (Object)searchObjId)};
        return this.joinEntityHelper.loadDynamicObjectArray(qFilters);
    }

    public Map<Long, String> queryAllSearchObjNumMap() {
        DynamicObject[] dynamicObjects = this.searchObjectHelper.queryOriginalArray("id,number", new QFilter[0]);
        HashMap<Long, String> sobjIdNumberMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            sobjIdNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return sobjIdNumberMap;
    }

    public DynamicObject[] loadQueryFields(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("virentitycfg", "=", (Object)searchObjId)};
        return this.queryFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] queryFieldInfo(Long searchObjId, QFilter qFilter) {
        if (qFilter == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("virentitycfg", "=", (Object)searchObjId), qFilter};
        return this.queryFieldHelper.query("id,entitynumber,fieldalias,valuetype,complextype,controltype,fieldname", qFilters);
    }

    public DynamicObject[] loadEntityRelations(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("virentitycfg", "=", (Object)searchObjId)};
        return this.entityRelationHelper.loadDynamicObjectArray(qFilters);
    }

    public List<ObjJoinEntity> queryAndAssembleJoinEntities(Long searchObjId) {
        DynamicObject[] joinEntityCol = this.loadJoinEntities(searchObjId);
        ArrayList joinEntities = Lists.newArrayListWithCapacity((int)joinEntityCol.length);
        for (DynamicObject joinEntityDy : joinEntityCol) {
            ObjJoinEntity joinEntity = new ObjJoinEntity();
            joinEntity.setId(joinEntityDy.getString("id"));
            joinEntity.setVirEntityCfgId(joinEntityDy.getDynamicObject("virentitycfg").getString("id"));
            joinEntity.setType(joinEntityDy.getString("type"));
            String longNumber = joinEntityDy.getString("longnumber");
            joinEntity.setLongNumber(joinEntityDy.getString("longnumber"));
            if (longNumber.contains("!")) {
                joinEntity.setParentLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!")));
            } else {
                joinEntity.setParentLongNumber(null);
            }
            if (HRStringUtils.equals((String)longNumber, (String)"0")) {
                joinEntity.setLevel(0);
            } else {
                String[] longNumberSp = longNumber.split("!");
                joinEntity.setLevel(longNumberSp.length - 1);
            }
            joinEntity.setEntityNumber(joinEntityDy.getString("entitynumber"));
            joinEntity.setEntityAlias(joinEntityDy.getString("entityalias"));
            joinEntity.setEntityName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)joinEntityDy.getLocaleString("entityname"))));
            String[] split = joinEntity.getEntityAlias().split("\u03b4");
            if (split.length > 1) {
                joinEntity.setDisplayName(joinEntity.getEntityName().getLocaleValue() + split[1]);
            } else {
                joinEntity.setDisplayName(joinEntity.getEntityName().getLocaleValue());
            }
            joinEntities.add(joinEntity);
        }
        return joinEntities.stream().sorted(Comparator.comparing(JoinEntityCommonBo::getLongNumber)).collect(Collectors.toList());
    }

    public List<ObjQueryField> queryAndAssembleQueryFields(Long searchObjId) {
        DynamicObject[] queryFieldCol = this.loadQueryFields(searchObjId);
        return this.assembleQueryFields(queryFieldCol);
    }

    public List<ObjQueryField> assembleQueryFields(DynamicObject[] queryFieldCol) {
        ArrayList queryFields = Lists.newArrayListWithCapacity((int)queryFieldCol.length);
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        Set entityNums = Arrays.stream(queryFieldCol).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject queryFieldDy : queryFieldCol) {
            ObjQueryField queryField = new ObjQueryField();
            queryField.setId(queryFieldDy.getString("id"));
            queryField.setVirEntityCfgId(queryFieldDy.getDynamicObject("virentitycfg").getString("id"));
            String entityNumber = queryFieldDy.getString("entitynumber");
            queryField.setEntityNumber(entityNumber);
            String fieldAlias = queryFieldDy.getString("fieldalias");
            if (!queryField.isVirtualEntityField()) {
                String nameSuffix = "";
                if (fieldAlias.contains("\u03b4")) {
                    nameSuffix = fieldAlias.substring(fieldAlias.indexOf(948), fieldAlias.indexOf(46));
                }
                String entityName = entityNumMap.get(entityNumber);
                entityName = entityName + nameSuffix;
                queryField.setEntityName(entityName);
            }
            OrmLocaleValue fieldName = (OrmLocaleValue)queryFieldDy.getLocaleString("fieldname");
            queryField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)fieldName));
            queryField.setFieldAlias(fieldAlias);
            queryField.setFieldPath(queryFieldDy.getString("fieldpath"));
            String complexType = queryFieldDy.getString("complextype");
            queryField.setComplexType(complexType);
            queryField.setFieldNumber(queryFieldDy.getString("fieldnumber"));
            if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                Map baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
                queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
            }
            queryField.setValueType(queryFieldDy.getString("valuetype"));
            queryField.setControlType(queryFieldDy.getString("controltype"));
            queryField.setSysPresetFlag(queryFieldDy.getBoolean("issyspreset"));
            queryField.setEntityId(queryFieldDy.getString("entity"));
            OrmLocaleValue OriFieldName = (OrmLocaleValue)queryFieldDy.get("orifieldname");
            queryField.setOriFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)OriFieldName));
            queryFields.add(queryField);
        }
        return queryFields.stream().sorted(Comparator.comparing(QueryFieldCommonBo::getFieldAlias)).collect(Collectors.toList());
    }

    private String getFieldShortNumber(String entityNumber, String fieldAlias, String fieldComplexType) {
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType) && fieldAlias.contains(".")) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String[] aliasArr = fieldAlias.split("\\.");
            if (aliasArr.length > 2) {
                String parentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (parentProp instanceof BasedataProp) {
                    return aliasArr[aliasArr.length - 3] + "." + aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
                }
            }
            return aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
        }
        return fieldAlias.substring(fieldAlias.lastIndexOf(46) + 1);
    }

    public List<ObjEntityRelation> queryAndAssembleEntityRelations(Long searchObjId) {
        DynamicObject[] entityRelationCol = this.loadEntityRelations(searchObjId);
        ArrayList entityRelations = Lists.newArrayListWithCapacity((int)entityRelationCol.length);
        for (DynamicObject entityRelationDy : entityRelationCol) {
            ObjEntityRelation entityRelation = new ObjEntityRelation();
            DynamicObject entityDy = entityRelationDy.getDynamicObject("entityid");
            DynamicObject joinEntityDy = entityRelationDy.getDynamicObject("joinentityid");
            entityRelation.setId(entityRelationDy.getString("id"));
            entityRelation.setVirEntityCfgId(entityRelationDy.getDynamicObject("virentitycfg").getString("id"));
            entityRelation.setEntityId(entityDy.getString("id"));
            entityRelation.setEntityNumber(entityDy.getString("entitynumber"));
            entityRelation.setEntityAlias(entityDy.getString("entityalias"));
            entityRelation.setJoinType(entityRelationDy.getString("jointype"));
            entityRelation.setJoinEntityId(joinEntityDy.getString("id"));
            entityRelation.setJoinEntityNumber(joinEntityDy.getString("entitynumber"));
            entityRelation.setJoinEntityAlias(joinEntityDy.getString("entityalias"));
            DynamicObjectCollection joinConditionCol = entityRelationDy.getDynamicObjectCollection("joinconditions");
            if (joinConditionCol.isEmpty()) {
                throw new KDBizException("search object join conditions is empty.");
            }
            ArrayList joinConditions = Lists.newArrayListWithCapacity((int)joinConditionCol.size());
            for (DynamicObject joinConditionDy : joinConditionCol) {
                JoinConditionBo joinCondition = new JoinConditionBo();
                joinCondition.setId(joinConditionDy.getString("id"));
                joinCondition.setLeftProp(joinConditionDy.getString("leftprop"));
                joinCondition.setCompareType(joinConditionDy.getString("comparetype"));
                String rightPropType = joinConditionDy.getString("rightproptype");
                joinCondition.setRightPropType(rightPropType);
                if (HRStringUtils.equals((String)rightPropType, (String)"field")) {
                    joinCondition.setRightProp(joinConditionDy.getString("rightprop"));
                } else {
                    joinCondition.setRightPropVal(joinConditionDy.getString("rightpropval"));
                }
                joinCondition.setLogicType(joinConditionDy.getString("logictype"));
                joinConditions.add(joinCondition);
            }
            entityRelation.setConditions(joinConditions);
            entityRelations.add(entityRelation);
        }
        return entityRelations;
    }

    public DynamicObject[] getSearchFieldByIds(Object[] pkValues) {
        return this.queryFieldHelper.query("entitynumber,fieldname,fieldpath", new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
    }

    public boolean isTargetMainObject(String entityNumber) {
        HRBaseServiceHelper targetObjHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        DynamicObject targetObjDy = targetObjHelper.queryOriginalOne("entitynumber, type", new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber)});
        if (targetObjDy != null) {
            return HRStringUtils.equals((String)targetObjDy.getString("type"), (String)"main");
        }
        return false;
    }

    public Long getSearchObjId(String searchObjNumber) {
        DynamicObject dynamicObject = this.searchObjectHelper.queryOriginalOne(new QFilter("number", "=", (Object)searchObjNumber));
        return dynamicObject.getLong("id");
    }

    public String querySearchObjMainEntity(Long searchObjPk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_ObjJoinEntity");
        QFilter qFilter = new QFilter("searchobj", "=", (Object)searchObjPk);
        QFilter typeFilter = new QFilter("type", "=", (Object)"main");
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("entitynumber", new QFilter[]{qFilter, typeFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("entitynumber");
    }

    public String querySearchObjMainEntity(String searchObjNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_ObjJoinEntity");
        QFilter qFilter = new QFilter("searchobj.number", "=", (Object)searchObjNumber);
        QFilter typeFilter = new QFilter("type", "=", (Object)"main");
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("entitynumber", new QFilter[]{qFilter, typeFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("entitynumber");
    }

    public DynamicObject getSearchJoinEntityById(Long pkvalue) {
        return this.joinEntityHelper.queryOne((Object)pkvalue);
    }

    private static Map<Long, String> queryLabelInfo(String entityNumber, boolean onlyModleLabel) {
        Map labelObjRstMap = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{entityNumber});
        boolean success = (Boolean)labelObjRstMap.get("success");
        if (!success) {
            throw new KDBizException((String)labelObjRstMap.get("msg"));
        }
        ArrayList resultList = (ArrayList)labelObjRstMap.get("resultList");
        LOGGER.info("queryLabelObjectsByEntityNumber resultList={}", (Object)resultList);
        HashMap<Long, String> labelInfoMap = new HashMap<Long, String>(16);
        for (Map resultMap : resultList) {
            Object labels = resultMap.get("labels");
            if (labels == null) continue;
            ArrayList labelList = (ArrayList)labels;
            for (Map objectMap : labelList) {
                String labelType = (String)objectMap.get("labelType");
                if (onlyModleLabel && !HRStringUtils.equals((String)"10", (String)labelType)) continue;
                Long labelId = (Long)objectMap.get("labelId");
                Map labelNameMap = (Map)objectMap.get("labelName");
                String labelName = (String)labelNameMap.get("GLang");
                labelInfoMap.put(labelId, labelName);
            }
        }
        return labelInfoMap;
    }

    public static void putPageCache(IFormView view, List<ObjQueryField> queryFields) {
        view.getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFields));
    }

    public static String getPageCache(IFormView view) {
        return view.getPageCache().get("queryFields");
    }

    public static void setFieldControlType(List<ObjQueryField> queryFieldBoList) {
        HashMap entityMetadataMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap metadataNumberToIdMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (ObjQueryField queryFieldBo : queryFieldBoList) {
            if (HRStringUtils.isNotEmpty((String)queryFieldBo.getControlType())) continue;
            String entityNumber = queryFieldBo.getEntityNumber();
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
            VirEntityCfgService.getEntityMetadata(entityNumber, entityMetadataMap, metadataNumberToIdMap);
            String fieldControlType = AnalyseObjectUtil.getFieldControlType((MainEntityType)mainEntityType, (Map)entityMetadataMap, (Map)metadataNumberToIdMap, (String)queryFieldBo.getFieldAlias(), (String)queryFieldBo.getComplexType(), (MainEntityTypeUtil)mainEntityTypeUtil);
            queryFieldBo.setControlType(fieldControlType);
        }
    }

    private static EntityMetadata getEntityMetadata(String entityNum, Map<String, EntityMetadata> entityMetadataMap, Map<String, String> metadataNumberToIdMap) {
        EntityMetadata entityMetadata = entityMetadataMap.get(entityNum);
        if (entityMetadata == null) {
            String metadataId = metadataNumberToIdMap.get(entityNum);
            if (metadataId == null) {
                metadataId = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
                metadataNumberToIdMap.put(entityNum, metadataId);
            }
            entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)metadataId, (MetaCategory)MetaCategory.Entity);
            entityMetadataMap.put(entityNum, entityMetadata);
        }
        return entityMetadata;
    }
}

