/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hies.common.dto.ConditionField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class ConditionFieldPlugin
extends HRDynamicFormBasePlugin {
    private static final String LIST_FIELD = "entryentity";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_ISDOWNLOADCOND = "isdownloadcond";
    private static final String FIELD_NAME = "name";
    public static final String KEY_BTN_OK = "btnok";
    public static final String KEY_BTN_CANCEL = "btncancel";
    public static final String CONDFIELDNUMBER = "condFieldNumber";
    public static final String CONDFIELDNAME = "condFieldName";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().returnDataToParent(this.getCondField(this.getModel(), LIST_FIELD, FIELD_ISDOWNLOADCOND));
            this.getView().close();
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private Map<String, String> getCondField(IDataModel dataModel, String listKey, String propertyName) {
        Pair<List<String>, List<String>> conditionFields = this.getAllCondField(dataModel, listKey, propertyName);
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)2);
        returnData.put(CONDFIELDNUMBER, ConditionFieldPlugin.getStringField((List)conditionFields.getKey()));
        returnData.put(CONDFIELDNAME, ConditionFieldPlugin.getStringField((List)conditionFields.getValue()));
        return returnData;
    }

    private static String getStringField(List<String> conditionFields) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < conditionFields.size(); ++i) {
            String s = conditionFields.get(i);
            if (StringUtils.isBlank((CharSequence)s)) {
                if (i == conditionFields.size() - 1) continue;
                sb.append(",");
                continue;
            }
            if (i != conditionFields.size() - 1) {
                sb.append(s).append(",");
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private Pair<List<String>, List<String>> getAllCondField(IDataModel iDataModel, String listKey, String condPropertyName) {
        int listRowCount = iDataModel.getEntryRowCount(listKey);
        ArrayList<String> condFieldNumbers = new ArrayList<String>(listRowCount);
        ArrayList<String> condFieldNames = new ArrayList<String>(listRowCount);
        DynamicObjectCollection entryEntity = iDataModel.getEntryEntity(listKey);
        for (int index = 0; index < listRowCount; ++index) {
            boolean isCondField = ((DynamicObject)entryEntity.get(index)).getBoolean(condPropertyName);
            if (!isCondField) continue;
            condFieldNumbers.add(((DynamicObject)entryEntity.get(index)).getString(FIELD_NUMBER));
            condFieldNames.add(((DynamicObject)entryEntity.get(index)).getString(FIELD_NAME));
        }
        return Pair.of(condFieldNumbers, condFieldNames);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String fieldJson = (String)this.getView().getFormShowParameter().getCustomParam("condfieldJson");
        List fieldList = (List)JSON.parseObject((String)fieldJson, (TypeReference)new TypeReference<List<ConditionField>>(){}, (Feature[])new Feature[0]);
        this.fillFieldList(fieldList);
    }

    private void fillFieldList(List<ConditionField> fieldList) {
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_NUMBER, new Object[0]);
        vs.addField(FIELD_NAME, new Object[0]);
        vs.addField(FIELD_ISDOWNLOADCOND, new Object[0]);
        for (ConditionField conditionField : fieldList) {
            vs.addRow(new Object[]{conditionField.getNumber(), conditionField.getName(), conditionField.getDownloadCond()});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(LIST_FIELD, vs);
        this.getModel().endInit();
        this.getView().updateView(LIST_FIELD);
    }
}

