/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hies.common.dto.DisplayField;
import kd.hr.hies.common.util.TemplateFormCommonUtil;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class DisplayFieldPlugin
extends HRDynamicFormBasePlugin {
    private static final String LIST_FIELD = "entryentity";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    public static final String KEY_BTN_OK = "btnok";
    public static final String KEY_BTN_CANCEL = "btncancel";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            Map<String, String> displayNames = TemplateFormCommonUtil.getAllListPropSet(this.getModel(), LIST_FIELD, "displayname");
            if (!CollectionUtils.isEmpty(displayNames)) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(displayNames));
            }
            this.getView().close();
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String fieldJson = (String)this.getView().getFormShowParameter().getCustomParam("fieldJson");
        List fieldList = (List)JSON.parseObject((String)fieldJson, (TypeReference)new TypeReference<List<DisplayField>>(){}, (Feature[])new Feature[0]);
        this.fillFieldList(fieldList);
    }

    private void fillFieldList(List<DisplayField> fieldList) {
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_NUMBER, new Object[0]);
        vs.addField(FIELD_NAME, new Object[0]);
        vs.addField("displayname", new Object[0]);
        for (DisplayField displayField : fieldList) {
            if (StringUtils.isNotEmpty((CharSequence)displayField.getDisplayName())) {
                LocaleString lang = (LocaleString)SerializationUtils.fromJsonString((String)displayField.getDisplayName(), LocaleString.class);
                vs.addRow(new Object[]{displayField.getNumber(), displayField.getName(), lang});
                continue;
            }
            vs.addRow(new Object[]{displayField.getNumber(), displayField.getName(), null});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(LIST_FIELD, vs);
        this.getModel().endInit();
        this.getView().updateView(LIST_FIELD);
    }
}

