/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;

@ExcludeFromJacocoGeneratedReport
public class EntityObjectFieldList
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String TREE_NODES = "treenodes";
    public static final String KEY_BTN_OK = "btnok";
    public static final String KEY_BTN_CANCEL = "btncancel";
    public static final String KEY_TREEVIEW = "tv_fields";
    private static final String SELECT_FIELD_VALUE = "selectfieldvalue";
    private static final String SELECT_FIELD_NAME = "selectfieldname";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String json = (String)formShowParameter.getCustomParam(TREE_NODES);
        String oldSelectFieldValue = (String)formShowParameter.getCustomParam(SELECT_FIELD_VALUE);
        String oldSelectFieldName = (String)formShowParameter.getCustomParam(SELECT_FIELD_NAME);
        this.getModel().setValue(SELECT_FIELD_VALUE, (Object)oldSelectFieldValue);
        this.getModel().setValue(SELECT_FIELD_NAME, (Object)oldSelectFieldName);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_FIELD_VALUE, SELECT_FIELD_NAME});
        this.getView().updateView(SELECT_FIELD_VALUE);
        this.getView().updateView(SELECT_FIELD_NAME);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeIds = (String)this.getModel().getValue(SELECT_FIELD_VALUE);
            String currNodeNames = (String)this.getModel().getValue(SELECT_FIELD_NAME);
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
            if (StringUtils.isNotBlank((CharSequence)currNodeIds)) {
                returnMap.put("currNodeIds", currNodeIds);
                returnMap.put("currNodeNames", currNodeNames);
            }
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        String rootNodeId = (String)this.getView().getFormShowParameter().getCustomParam("rootNodeId");
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        this.getModel().setValue(SELECT_FIELD_VALUE, (Object)checkedNodeIds.stream().filter(nodeId -> !nodeId.equals(rootNodeId)).collect(Collectors.joining(",")));
        this.getModel().setValue(SELECT_FIELD_NAME, (Object)Joiner.on((String)"\uff1b").join((Iterable)treeView.getTreeState().getCheckedNodes().stream().filter(node -> !rootNodeId.equals(node.get("id"))).map(temp -> temp.get("text")).collect(Collectors.toList())));
    }

    private void fillTreeNodes(String strJson) {
        String uniqueName = (String)this.getModel().getValue(SELECT_FIELD_NAME);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        ArrayList checkedTreeNode = Lists.newArrayListWithCapacity((int)16);
        List children = rootNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            children.stream().filter(treeNode -> uniqueName.contains(treeNode.getText())).forEach(checkedTreeNode::add);
        }
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(rootNode);
        tree.checkNodes((List)checkedTreeNode);
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)HiesCommonRes.EntityObjectFieldList_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(root);
    }
}

