/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.HRBizAppHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class HRTreeListBizAppsPlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ItemClickListener {
    protected static final String BTN_NEW = "btnnew";
    protected static final String BTN_EDIT = "btnedit";
    protected static final String BTN_DELETE = "btndel";
    private static final String NUMBER = "number";

    protected QFilter getEntityFilter() {
        return new QFilter("1", "=", (Object)1);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        root.setIsOpened(true);
        root.setChildren(this.getCloudNodes());
        this.setBarItemEnable(false, true);
    }

    public void afterBindData(EventObject e) {
        Map currNodeMap = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        TreeNode currNode = currNodeMap == null ? this.getTreeModel().getRoot() : (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)currNodeMap), TreeNode.class);
        this.getTreeListView().getTreeView().focusNode(currNode);
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(nodeId, 20);
        List<TreeNode> childNodes = this.getChildNodes(root, parent);
        e.setChildNodes(childNodes);
        if (parent != null) {
            this.getTreeListView().getTreeView().expand(nodeId);
        }
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        super.treeNodeClick(treenodeevent);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode root = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String pageId = this.getView().getPageId();
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            Map<String, String> apps = this.searchApp(searchText);
            Set<String> clouds = HRBizAppHelper.searchCloud(root, searchText);
            clouds.addAll(apps.values());
            String showLevelCache = pageCache.get(pageId + "_SHOWLEVEL");
            int showLevel = StringUtils.isNotBlank((CharSequence)showLevelCache) ? Integer.parseInt(showLevelCache) : 2;
            root.iterate(showLevel, node -> {
                List currChildren;
                if (!(node.getChildren() != null && node.getChildren().size() != 0 || !clouds.contains(node.getId()) && !apps.containsKey(node.getId()) || (currChildren = node.getChildren()) != null && currChildren.size() != 0)) {
                    List<TreeNode> children = this.getChildNodes(root, (TreeNode)node);
                    this.getTreeModel().addNodes((Object)node.getId(), children);
                }
            });
        }
        super.search(evt);
    }

    protected Map<String, String> searchApp(String searchText) {
        return HRBizAppHelper.wildcardSearchApp(searchText, new QFilter[0]);
    }

    protected List<TreeNode> getChildNodes(TreeNode root, TreeNode parent) {
        String parentId = parent.getId();
        if (StringUtils.equals((CharSequence)parentId, (CharSequence)root.getId())) {
            return this.getCloudNodes();
        }
        switch ((String)parent.getData()) {
            case "cloud": {
                return this.getAppNodesBy(parentId, true);
            }
            case "app": {
                return new ArrayList<TreeNode>();
            }
        }
        return new ArrayList<TreeNode>();
    }

    protected boolean isTopNode(String currNodeId) {
        String rootId = this.getTreeModel().getRoot().getId();
        return StringUtils.equals((CharSequence)rootId, (CharSequence)currNodeId);
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    protected List<String> getBillIdInApp(String appNodeId) {
        List<String> appIds = this.getAppIdsBy(appNodeId);
        if (appIds.isEmpty()) {
            return appIds;
        }
        List<TreeNode> billNodes = this.getBillNodesBy(appIds);
        return billNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
    }

    protected List<String> getBillIdInCloud(String cloudId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT C.FID ").append("FROM t_meta_bizcloud A LEFT JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID ").append("LEFT JOIN t_meta_mainentityinfo C  ON C.FBIZAPPID = B.FID ").append("WHERE A.FID = ? AND C.fenableimport = '1' ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(rs.getFetchSize());
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, (ResultSetHandler)action);
    }

    protected List<TreeNode> getCloudNodes() {
        Pair<Set<Object>, Set<Object>> pair = this.getEntityCloudIdList();
        Set cloudIds = (Set)pair.getLeft();
        if (CollectionUtils.isEmpty((Collection)cloudIds)) {
            return new ArrayList<TreeNode>(0);
        }
        Set appIds = (Set)pair.getRight();
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            return new ArrayList<TreeNode>(0);
        }
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] hrClouds = cloudHelper.queryOriginalArray("cloud", new QFilter[0], "index");
        Object[] hrCloudIds = Arrays.stream(hrClouds).filter(el -> {
            String pkValue = el.getString("cloud");
            return cloudIds.contains(pkValue);
        }).map(el -> el.getString("cloud")).toArray();
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])((String[])Arrays.copyOf(hrCloudIds, hrCloudIds.length, String[].class)), (String[])appIds.toArray(new String[0]), null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<TreeNode> cloudOrderNodes = new ArrayList<TreeNode>(0);
        for (Object cloudId : hrCloudIds) {
            for (TreeNode cloudNode : clouds) {
                if (!cloudId.equals(cloudNode.getId())) continue;
                cloudOrderNodes.add(cloudNode);
            }
        }
        return cloudOrderNodes;
    }

    protected Pair<Set<Object>, Set<Object>> getEntityCloudIdList() {
        Set<Object> cloudIdSet = new HashSet(16);
        Set<Object> appIdSet = new HashSet(16);
        QFilter entityFilter = this.getEntityFilter();
        if (entityFilter != null) {
            DynamicObject[] appObjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid", (QFilter[])new QFilter[]{entityFilter});
            appIdSet = Arrays.stream(appObjects).filter(o -> o.getDynamicObject("bizappid") != null).map(o -> o.getDynamicObject("bizappid").getPkValue()).collect(Collectors.toSet());
            DynamicObject[] cloudObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])new QFilter[]{new QFilter("id", "in", appIdSet)});
            cloudIdSet = Arrays.stream(cloudObjects).filter(o -> o.getDynamicObject("bizcloud") != null).map(o -> o.getDynamicObject("bizcloud").getPkValue()).collect(Collectors.toSet());
        }
        return Pair.of(cloudIdSet, appIdSet);
    }

    protected List<TreeNode> getAppNodesBy(String cloudNodeId, boolean isShowEntity) {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])new String[]{cloudNodeId}, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null || clouds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        List apps = ((TreeNode)clouds.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        if (isShowEntity) {
            for (TreeNode app : apps) {
                if (app == null) continue;
                app.setChildren(new ArrayList(0));
            }
        }
        return apps;
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    protected List<TreeNode> getBillNodesBy(List<String> appIds) {
        String fields = "id, number, name, bizappid";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter appIdFilter = new QFilter("bizappid", "in", appIds);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, appIdFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)fields, (QFilter[])filters);
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(objects.length);
        for (DynamicObject object : objects) {
            String nodeId = object.getString("id");
            String name = object.getLocaleString("name").toString();
            String parentId = object.getString("bizappid_id");
            String data = object.getString(NUMBER);
            TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
            billNodes.add(node);
        }
        return billNodes;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }
}

