/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.operate.Save;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.HRBizAppHelper;
import kd.hr.hies.formplugin.HRTreeListBizAppsPlugin;
import org.apache.commons.collections4.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class HRVirEntityRegTreeListEdit
extends HRTreeListBizAppsPlugin
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(HRVirEntityRegTreeListEdit.class);
    private static final String NEW = "tblnew";
    private static final String DEL = "tbldel";
    private static final String BIZOBJECT = "entity";
    private static final String CLOSECALLBACK_SAVE = "closeCallBack_save";
    private static final String PAGE_CODE = "hies_hrvirentityreg";
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_cloud");
    private Map<Long, DynamicObject> currentDataMap = new HashMap<Long, DynamicObject>(16);

    @Override
    protected QFilter getEntityFilter() {
        return HRVirEntityRegTreeListEdit.getEntityEncryptIdFilter();
    }

    public static QFilter getEntityEncryptIdFilter() {
        Object[] entityEncryptObjects = BusinessDataServiceHelper.load((String)PAGE_CODE, (String)BIZOBJECT, (QFilter[])new QFilter[0]);
        if (ArrayUtils.isNotEmpty((Object[])entityEncryptObjects)) {
            Set entityIdSet = Arrays.stream(entityEncryptObjects).map(o -> o.getDynamicObject(BIZOBJECT).getPkValue()).collect(Collectors.toSet());
            return new QFilter("id", "in", entityIdSet);
        }
        return null;
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.addClickListeners(new String[]{"btnnew"});
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "tblnew": {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(PAGE_CODE);
                OpenStyle openStyle = parameter.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_SAVE));
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("issyspreset DESC, entity.number");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if ("entity.id".equals(fieldName) || "entity.number".equals(fieldName) || "entity.name".equals(fieldName)) {
            QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
            QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
            QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
            args.addCustomQFilter(modelTypeFilter);
            args.addCustomQFilter(isTemplateFilter);
            args.addCustomQFilter(enableImport);
        } else if ("entity.bizappid.id".equals(fieldName) || "entity.bizappid.number".equals(fieldName) || "entity.bizappid.name".equals(fieldName)) {
            List<DynamicObject> dynRuntimeApps = HRBizAppHelper.wildcardSearchRuntimeApps("", new QFilter[0]);
            if (CollectionUtils.isNotEmpty(dynRuntimeApps)) {
                HashSet<String> apps = new HashSet<String>(dynRuntimeApps.size());
                for (DynamicObject object : dynRuntimeApps) {
                    apps.add(object.getString("id"));
                }
                QFilter hrAppIdsFilter = new QFilter("id", "in", apps);
                args.addCustomQFilter(hrAppIdsFilter);
            }
            QFilter deployStatusFilter = new QFilter("deploystatus", "=", (Object)"2");
            args.addCustomQFilter(deployStatusFilter);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 2);
        if (!Objects.isNull(node)) {
            e.addQFilter(this.getFilter(node));
        }
        e.setCancel(true);
    }

    @Override
    public void refreshNode(RefreshNodeEvent event) {
        TreeNode parent;
        String nodeId = event.getNodeId().toString();
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        List<TreeNode> childNodes = this.getChildNodes(root, parent = root.getTreeNode(nodeId, 2));
        if (CollectionUtils.isNotEmpty(childNodes)) {
            parent.setIsOpened(true);
            event.setChildNodes(childNodes);
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            String rootId = root.getId();
            TreeNode treeNode = treeModel.refreshNode((Object)rootId);
            if (treeNode != null) {
                treeView.updateNode(treeNode);
                treeView.focusNode(treeNode);
                treeView.treeNodeClick(treeNode.getParentid(), rootId);
            }
        }
    }

    private void focusNode(TreeView treeView, TreeNode searchTreeNode) {
        treeView.showNode(searchTreeNode.getId());
        treeView.treeNodeClick(searchTreeNode.getParentid(), searchTreeNode.getId());
        treeView.checkNode(searchTreeNode);
        treeView.focusNode(searchTreeNode);
    }

    @Override
    protected List<TreeNode> getBillNodesBy(List<String> appIds) {
        String fields = "id, number, name, bizappid";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter appIdFilter = new QFilter("bizappid", "in", appIds);
        QFilter entityIdFilter = null;
        Object[] entityEncryptObjects = BusinessDataServiceHelper.load((String)PAGE_CODE, (String)BIZOBJECT, (QFilter[])new QFilter[0]);
        if (ArrayUtils.isNotEmpty((Object[])entityEncryptObjects)) {
            Set entityIdSet = Arrays.stream(entityEncryptObjects).map(o -> o.getDynamicObject(BIZOBJECT).getPkValue()).collect(Collectors.toSet());
            entityIdFilter = new QFilter("id", "in", entityIdSet);
        }
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, appIdFilter, entityIdFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)fields, (QFilter[])filters);
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(objects.length);
        for (DynamicObject object : objects) {
            String nodeId = object.getString("id");
            String name = object.getLocaleString("name").toString();
            String parentId = object.getString("bizappid_id");
            String data = object.getString("number");
            TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
            billNodes.add(node);
        }
        return billNodes;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }

    @Override
    public List<TreeNode> getAppNodesBy(String cloudNodeId, boolean isShowEntity) {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        List currCloud = cloudNodes.stream().filter(cloud -> cloud.getId().equals(cloudNodeId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currCloud)) {
            return new ArrayList<TreeNode>(0);
        }
        List apps = ((TreeNode)currCloud.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>(0);
        }
        return apps;
    }

    private QFilter getFilter(TreeNode node) {
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter(BIZOBJECT, "in", this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter(BIZOBJECT, "in", this.getBillIdInApp(nodeId));
            }
        }
        return null;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains("cloud_") || currentNodeId.contains("app_") || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(BIZOBJECT, (Object)currentNodeId);
    }

    @Override
    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        super.treeNodeClick(treenodeevent);
        this.getTreeModel().setNodeClickExpand(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    @Override
    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode root = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String pageId = this.getView().getPageId();
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            pageCache.put(pageId + "_SHOWLEVEL", "1");
            Map<String, String> apps = this.searchApp(searchText);
            Set<String> clouds = HRBizAppHelper.searchCloud(root, searchText);
            clouds.addAll(apps.values());
        }
        super.search(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSECALLBACK_SAVE.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "delete": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof Save && StringUtils.equals((CharSequence)"OPKEY_SAVE", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            OpBizRuleSetServiceHelper.clearCache();
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        Set<String> hrCloud;
        if ("app.bizcloud.name".equals(evt.getFieldName()) && CollectionUtils.isNotEmpty(hrCloud = this.getHrCloud())) {
            evt.getQfilters().add(new QFilter("id", "in", hrCloud));
        }
    }

    private Set<String> getHrCloud() {
        Object[] dyns = serviceHelper.query("id,cloud,cloud.id,cloud.name,index", new QFilter[0]);
        if (ArrayUtils.isNotEmpty((Object[])dyns)) {
            return Arrays.stream(dyns).map(item -> item.getString("cloud.id")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_CODE);
        List pkIds = event.getPageData().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter[] pkIdsFilter = new QFilter[]{new QFilter("id", "in", pkIds)};
        Object[] datas = serviceHelper.queryOriginalArray("id, entryentity.entityfield, entryentity.condition, entryentity.relentityfield", pkIdsFilter);
        if (ArrayUtils.isEmpty((Object[])datas)) {
            return;
        }
        this.currentDataMap = Arrays.stream(datas).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        Object source = event.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            String key = columnDesc.getKey();
            DynamicObject rowData = event.getRowData();
            switch (key) {
                case "dtextentityrel": {
                    DynamicObject dyn = this.currentRowData(rowData);
                    String entityField = dyn.getString("entryentity.entityfield");
                    String condition = dyn.getString("entryentity.condition");
                    String relEntityField = dyn.getString("entryentity.relentityfield");
                    event.setFormatValue((Object)(entityField + " " + condition + " " + relEntityField));
                }
            }
        }
    }

    private DynamicObject currentRowData(DynamicObject rowData) {
        return this.currentDataMap.get(rowData.getLong("id"));
    }
}

