/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.business.TemplateServiceHelper;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.bo.MetaMenuBO;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.enu.Operate;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.enu.TaskResult;
import kd.hr.hies.common.enu.TaskState;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.MetaMenuUtil;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class TaskInfoListPlugin
extends HRDataBaseList
implements BeforeFilterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(TaskInfoListPlugin.class);
    private static final HRBaseServiceHelper dbHelper = HRBaseServiceHelper.create((String)"hies_taskinfo");
    private Map<Long, DynamicObject> currentDataMap = new HashMap<Long, DynamicObject>(16);
    private boolean hasDownLoadPermission = true;
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_cloud");

    private Set<String> getHrCloud() {
        Object[] dyns = serviceHelper.query("id,cloud,cloud.id,cloud.name,index", new QFilter[0]);
        if (ArrayUtils.isNotEmpty((Object[])dyns)) {
            return Arrays.stream(dyns).map(item -> item.getString("cloud.id")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        Set<String> hrCloud;
        if ("app.bizcloud.name".equals(evt.getFieldName()) && CollectionUtils.isNotEmpty(hrCloud = this.getHrCloud())) {
            evt.getQfilters().add(new QFilter("id", "in", hrCloud));
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        List pkIds = event.getPageData().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter[] pkIdsFilter = new QFilter[]{new QFilter("id", "in", pkIds)};
        Object[] datas = dbHelper.query("id, taskid, serialno, creator, createtime, inttor, stime, etime, result, totalcost, failamount, totalamount, alldatafileurl, extparam", pkIdsFilter);
        if (org.apache.commons.lang3.ArrayUtils.isEmpty((Object[])datas)) {
            return;
        }
        this.currentDataMap = Arrays.stream(datas).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        if (this.isManager()) {
            this.hasDownLoadPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"hies_taskinfo_mgr", (String)"2NJ5XVVCMBCL");
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        Object source = event.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            String key = columnDesc.getKey();
            DynamicObject rowData = event.getRowData();
            switch (key) {
                case "operator": {
                    DynamicObject taskInfo = this.currentRowData(rowData);
                    DynamicObject creator = taskInfo.getDynamicObject("creator");
                    DynamicObject intTor = taskInfo.getDynamicObject("inttor");
                    if (ObjectUtils.isEmpty((Object)creator)) break;
                    String creatorName = creator.getLocaleString("name").toString();
                    if (ObjectUtils.isNotEmpty((Object)intTor)) {
                        String intTorName = intTor.getLocaleString("name").toString();
                        if (creatorName.equals(intTorName)) {
                            event.setFormatValue((Object)creatorName);
                            break;
                        }
                        event.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u53d1\u8d77\u4eba\uff1a%1$s /\u7ec8\u6b62\u4eba\uff1a%2$s", (String)HiesCommonRes.TaskInfoListPlugin_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), creatorName, intTorName));
                        break;
                    }
                    event.setFormatValue((Object)creatorName);
                    break;
                }
                case "costtimedesc": {
                    DynamicObject taskInfo2 = this.currentRowData(rowData);
                    Date endTime = taskInfo2.getDate("etime");
                    if (endTime == null) break;
                    event.setFormatValue((Object)TaskInfoHelper.costTimeIgnoreMs(endTime.getTime(), taskInfo2.getDate("stime").getTime()));
                }
            }
        } else {
            ColumnDesc columnDesc = (ColumnDesc)source;
            String key = columnDesc.getKey();
            if (columnDesc instanceof TextColumnDesc) {
                if ("oprpage".equals(key)) {
                    try {
                        MetaMenuBO metaMenuBO = (MetaMenuBO)SerializationUtils.fromJsonString((String)event.getFormatValue().toString(), MetaMenuBO.class);
                        LocaleString formName = FormMetadataCache.getFormConfig((String)metaMenuBO.getFormId()).getCaption();
                        event.setFormatValue((Object)formName.getLocaleValue());
                    }
                    catch (Exception e) {
                        event.setFormatValue((Object)"");
                    }
                }
            } else if (columnDesc instanceof ListOperationColumnDesc && Operate.pageFieldKey().equals(key)) {
                DynamicObject rowData = event.getRowData();
                List operationColItems = (List)event.getFormatValue();
                String status = rowData.getString(TaskState.pageFieldKey());
                String oprType = rowData.getString(OprType.pageFieldKey());
                String result = rowData.getString(TaskResult.pageFieldKey());
                Map<Operate, Boolean> operateBooleanMap = Operate.showOprStrategy(TaskResult.tranEnum(result), TaskState.tranEnum(status), OprType.tranEnum(oprType));
                for (OperationColItem opItem : operationColItems) {
                    JSONObject reqParamJsonObject;
                    Long successedValidateBillCount;
                    String reqParam;
                    long failAmount;
                    long totalAmount;
                    DynamicObject taskInfo;
                    String allDataFileUrl;
                    boolean checkDownLoadPerm;
                    String operationKey = opItem.getOperationKey();
                    Operate operateObj = Operate.tranEnumForce(operationKey);
                    if (!Boolean.TRUE.equals(operateBooleanMap.get((Object)operateObj)) || (checkDownLoadPerm = operateObj.isCheckDownLoadPerm()) && !this.hasDownLoadPermission) continue;
                    if (Operate.isDownExportFile(operationKey)) {
                        opItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u6e90\u6587\u4ef6", (String)HiesCommonRes.TaskInfoListPlugin_16.resId(), (String)"hrmp-hies-common", (Object[])new Object[0])));
                    } else if (Operate.isDownAllDataFile(operationKey) && StringUtils.isBlank((CharSequence)(allDataFileUrl = (taskInfo = this.currentRowData(rowData)).getString("alldatafileurl"))) && (totalAmount = taskInfo.getLong("totalamount")) == (failAmount = taskInfo.getLong("failamount")) && StringUtils.isNotBlank((CharSequence)(reqParam = taskInfo.getString("extparam"))) && (ObjectUtils.isEmpty((Object)(successedValidateBillCount = (reqParamJsonObject = JSONObject.parseObject((String)reqParam)).getLong("successedValidateBillCount"))) || totalAmount == (long)successedValidateBillCount.intValue() || 0 == successedValidateBillCount.intValue())) continue;
                    opItem.setVisible(true);
                }
            }
        }
    }

    private DynamicObject currentRowData(DynamicObject rowData) {
        return this.currentDataMap.get(rowData.getLong("id"));
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Object oprType;
        String oprFormId;
        FormShowParameter formShowParameter;
        Object queryStartDate;
        super.setFilter(setFilterEvent);
        List qFilters = setFilterEvent.getQFilters();
        if (!this.isManager()) {
            qFilters.add(new QFilter("creator", "=", (Object)RequestContext.getOrCreate().getCurrUserId()));
        }
        if (!Objects.isNull(queryStartDate = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("queryStartDate"))) {
            qFilters.add(new QFilter("stime", ">=", SerializationUtils.fromJsonString((String)((String)queryStartDate), Date.class)));
            qFilters.add(new QFilter("stime", "<", SerializationUtils.fromJsonString((String)((String)formShowParameter.getCustomParam("queryEndDate")), Date.class)));
        }
        if (!Objects.isNull(formShowParameter.getCustomParam("errdata"))) {
            qFilters.add(new QFilter("systemerrlog", "!=", (Object)"[]"));
        }
        if (StringUtils.isNotBlank((CharSequence)(oprFormId = (String)formShowParameter.getCustomParam("oprFormId")))) {
            qFilters.add(new QFilter("oprpage", "like", (Object)"%\"".concat(oprFormId).concat("\"%")));
        }
        if (!Objects.isNull(oprType = formShowParameter.getCustomParam("oprtype"))) {
            qFilters.add(HRQFilterHelper.buildEql((String)"oprtype", (Object)oprType));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IFormView view = this.getView();
        if (this.isLookup((IListView)view)) {
            return;
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        Iterator commonItr = commonFilterColumns.iterator();
        while (commonItr.hasNext()) {
            Object status;
            FilterColumn column = (FilterColumn)commonItr.next();
            String fieldName = column.getFieldName();
            if ("oprtype".equals(fieldName)) {
                String oprFormId = (String)this.getView().getFormShowParameter().getCustomParam("oprFormId");
                if (StringUtils.isNotBlank((CharSequence)oprFormId)) {
                    commonItr.remove();
                    continue;
                }
                Object oprType = view.getFormShowParameter().getCustomParam("oprtype");
                if (Objects.isNull(oprType)) continue;
                column.setDefaultValue((String)oprType);
                continue;
            }
            if (!"status".equals(fieldName) || Objects.isNull(status = view.getFormShowParameter().getCustomParam("status"))) continue;
            column.setDefaultValue((String)status);
        }
        List schemeFilterColumns = args.getSchemeFilterColumns();
        Iterator schemeItr = schemeFilterColumns.iterator();
        while (schemeItr.hasNext()) {
            String oprFormId;
            FilterColumn column = (FilterColumn)schemeItr.next();
            String fieldName = column.getFieldName();
            if (!"oprtype".equals(fieldName) || !StringUtils.isNotBlank((CharSequence)(oprFormId = (String)this.getView().getFormShowParameter().getCustomParam("oprFormId")))) continue;
            schemeItr.remove();
        }
    }

    private boolean isLookup(IListView view) {
        boolean isLookup = false;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        if ("oprpage".equals(args.getFieldName())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            this.openPage(primaryKeyValue);
        }
    }

    protected void openPage(Object primaryKeyValue) {
        IFormView view = this.getView();
        QFilter[] pkIdsFilter = new QFilter[]{new QFilter("id", "=", primaryKeyValue)};
        DynamicObject taskInfo = dbHelper.queryOriginalOne("oprpage", pkIdsFilter);
        String oprPage = (String)taskInfo.get("oprpage");
        MetaMenuBO metaMenuBO = (MetaMenuBO)SerializationUtils.fromJsonString((String)oprPage, MetaMenuBO.class);
        String appId = metaMenuBO.getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            LOGGER.warn("appId is null, metaMenuBO:{}", (Object)SerializationUtils.toJsonString((Object)metaMenuBO));
            view.showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u672a\u6302\u83dc\u5355\uff0c\u65e0\u6cd5\u8df3\u8f6c\u5230\u76f8\u5e94\u9875\u9762\u3002", (String)HiesCommonRes.TaskInfoListPlugin_17.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return;
        }
        String formId = metaMenuBO.getFormId();
        String idByNumber = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)idByNumber)) {
            LOGGER.warn("\u9875\u9762ID\u53d1\u751f\u53d8\u5316\uff0c\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u9875\u9762, formId:{} metaMenuBO:{}", (Object)formId, (Object)SerializationUtils.toJsonString((Object)metaMenuBO));
            view.showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762id\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u6cd5\u8df3\u8f6c\u5230\u76f8\u5e94\u9875\u9762\u3002", (String)HiesCommonRes.TaskInfoListPlugin_11.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return;
        }
        List<MetaMenuBO> metaMenuBOs = MetaMenuUtil.getMetaMenuBOs(formId);
        if (CollectionUtils.isEmpty(metaMenuBOs)) {
            LOGGER.warn("metaMenuBOs is null, formId:{} metaMenuBO:{}", (Object)formId, (Object)SerializationUtils.toJsonString((Object)metaMenuBO));
            view.showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u672a\u6302\u83dc\u5355\uff0c\u65e0\u6cd5\u8df3\u8f6c\u5230\u76f8\u5e94\u9875\u9762\u3002", (String)HiesCommonRes.TaskInfoListPlugin_17.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return;
        }
        String menuItemId = metaMenuBO.getMenuItemId();
        int menuSize = metaMenuBOs.size();
        if (menuSize == 1) {
            MetaMenuBO menuBO = metaMenuBOs.get(0);
            menuItemId = menuBO.getMenuItemId();
            appId = menuBO.getAppId();
        } else {
            boolean matchMenuFlag = false;
            for (MetaMenuBO menuBO : metaMenuBOs) {
                if (!menuBO.getAppId().equals(appId) || !menuBO.getMenuItemId().equals(menuItemId)) continue;
                matchMenuFlag = true;
                break;
            }
            if (!matchMenuFlag) {
                LOGGER.warn("\u9875\u9762\u88ab\u79fb\u52a8\uff0c\u65e0\u6cd5\u8df3\u8f6c\u5230\u76f8\u5e94\u9875\u9762, formId:{} metaMenuBO:{}", (Object)formId, (Object)SerializationUtils.toJsonString((Object)metaMenuBO));
                view.showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u88ab\u79fb\u52a8\uff0c\u65e0\u6cd5\u8df3\u8f6c\u5230\u76f8\u5e94\u9875\u9762\u3002", (String)HiesCommonRes.TaskInfoListPlugin_12.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                return;
            }
        }
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            LOGGER.warn("\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528, appId:{} metaMenuBO:{}", (Object)appId, (Object)SerializationUtils.toJsonString((Object)metaMenuBO));
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u5e94\u7528\u3002", (String)HiesCommonRes.TaskInfoListPlugin_13.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return;
        }
        AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuItemId);
        if (appMenuInfo == null) {
            LOGGER.warn("\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355, appId:{} menuItemId\uff1a{} metaMenuBO:{}", new Object[]{appId, menuItemId, SerializationUtils.toJsonString((Object)metaMenuBO)});
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u83dc\u5355\u3002", (String)HiesCommonRes.TaskInfoListPlugin_14.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return;
        }
        String parameters = appMenuInfo.getParams();
        Map parameterMap = HRStringUtils.isNotEmpty((String)parameters) ? (Map)SerializationUtils.fromJsonString((String)parameters, HashMap.class) : new HashMap(1);
        OpenPageUtils.openMenu((IFormView)this.getView(), (String)menuItemId, (String)app.getId(), parameterMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Operate operate = Operate.tranEnum(operateKey);
        if (operate == null) {
            return;
        }
        long pkId = (Long)listSelectedData.get(0).getPrimaryKeyValue();
        QFilter[] pkIdsFilter = new QFilter[]{new QFilter("id", "=", (Object)pkId)};
        DynamicObject taskInfo = dbHelper.queryOriginalOne("id, serialno, taskid, oprtype, oprpage, uploadfileurl, alldatafileurl, errdatafileurl, downloadfileurl, result, status", pkIdsFilter);
        String oprPage = taskInfo.getString("oprpage");
        MetaMenuBO metaMenuBO = (MetaMenuBO)SerializationUtils.fromJsonString((String)oprPage, MetaMenuBO.class);
        String oprFormId = metaMenuBO.getFormId();
        String fileGenNotice = ResManager.loadKDString((String)"\u6587\u4ef6\u6b63\u5728\u751f\u6210\uff0c\u751f\u6210\u6210\u529f\u540e\u5c06\u4f1a\u81ea\u52a8\u4e0b\u8f7d\u3002", (String)HiesCommonRes.TaskInfoListPlugin_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        IFormView view = this.getView();
        switch (operate) {
            case DOWN_SOURCEFILE: {
                String uploadFileUrl = taskInfo.getString("uploadfileurl");
                if (StringUtils.isBlank((CharSequence)uploadFileUrl)) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u635f\u574f\uff0c\u65e0\u6cd5\u4e0b\u8f7d\uff0c\u5982\u9700\u67e5\u770b\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u3002", (String)HiesCommonRes.TaskInfoListPlugin_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                    return;
                }
                this.downLoad(uploadFileUrl, oprFormId, true, false);
                break;
            }
            case DOWN_ALLDATAFILE: {
                String allDataFileUrl = taskInfo.getString("alldatafileurl");
                if (StringUtils.isBlank((CharSequence)allDataFileUrl)) {
                    view.showTipNotification(fileGenNotice);
                    return;
                }
                this.downLoad(allDataFileUrl, oprFormId, true, false);
                break;
            }
            case DOWN_ERRDATAFILE: {
                String errDataFileUrl = taskInfo.getString("errdatafileurl");
                if (StringUtils.isBlank((CharSequence)errDataFileUrl)) {
                    view.showTipNotification(fileGenNotice);
                    return;
                }
                this.downLoad(errDataFileUrl, oprFormId, true, false);
                break;
            }
            case DOWN_EXPORTFILE: {
                String downloadFileUrl = taskInfo.getString("downloadfileurl");
                if (StringUtils.isBlank((CharSequence)downloadFileUrl)) {
                    view.showTipNotification(fileGenNotice);
                    return;
                }
                this.downLoad(downloadFileUrl, oprFormId, true, true);
                break;
            }
            case OPR_TERMINATE: {
                long taskPkId = taskInfo.getLong("id");
                String result = taskInfo.getString("result");
                String status = taskInfo.getString("status");
                LOGGER.info("\u7ec8\u6b62\u4efb\u52a1\u4fe1\u606f taskPkId:{} result\uff1a{} status\uff1a{}", new Object[]{taskPkId, result, status});
                String oprType = taskInfo.getString("oprtype");
                if (this.isManager()) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("hies_taskint");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.getCustomParams().put("oprtype", oprType);
                    CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "save_intreason");
                    showParameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(showParameter);
                    return;
                }
                this.doTerminate(taskPkId, oprType, view);
                this.refreshList();
            }
        }
    }

    private void downLoad(String filePatch, String oprFormId, boolean isTempFileModel, boolean isExport) {
        if (isTempFileModel) {
            String permItem = "4730fc9f000003ae";
            if (this.isManager()) {
                oprFormId = this.getView().getEntityId();
                permItem = "2NJ5XVVCMBCL";
            } else if (isExport) {
                permItem = "4730fc9f000004ae";
            }
            String url = ExcelUtil.getDownloadUrl(filePatch, oprFormId, permItem);
            this.getView().download(url);
        } else {
            this.getView().download(UrlService.getAttachmentFullUrl((String)filePatch));
        }
    }

    private void refreshList() {
        ListView listView = (ListView)this.getView();
        listView.refresh();
        listView.clearSelection();
    }

    private boolean doTerminate(long taskPkId, String oprType, IFormView view) {
        boolean terminatorFlag = TaskService.terminatorTask(String.valueOf(taskPkId), oprType);
        if (terminatorFlag) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)HiesCommonRes.TaskInfoListPlugin_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return true;
        }
        view.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u5931\u8d25\u3002", (String)HiesCommonRes.TaskInfoListPlugin_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        return false;
    }

    private boolean checkTask(long taskPkId, IFormView view, String result, String status) {
        if (StringUtils.isNotBlank((CharSequence)result)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u7ec8\u6b62\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u67e5\u770b\u6700\u65b0\u6570\u636e\u3002", (String)HiesCommonRes.TaskInfoListPlugin_7.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            return true;
        }
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String taskStatus = (String)cache.get(MethodUtil.getTaskCachePath(String.valueOf(taskPkId), OprType.EXPORT.getValue(), "status"), String.class);
        if ("stop".equals(taskStatus)) {
            if (TaskState.isTerminated(status)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u7ec8\u6b62\u3002", (String)HiesCommonRes.TaskInfoListPlugin_10.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u7ec8\u6b62\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u7ec8\u6b62\u3002", (String)HiesCommonRes.TaskInfoListPlugin_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = event.getActionId();
        if ("save_intreason".equals(actionId)) {
            IFormView view = this.getView();
            IListView listView = (IListView)view;
            ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            Object taskPkId = listSelectedRow.getPrimaryKeyValue();
            Map returnDataMap = (Map)returnData;
            boolean isTerminate = this.doTerminate((Long)taskPkId, (String)returnDataMap.get("oprtype"), view);
            if (isTerminate) {
                TaskInfo taskInfo = new TaskInfo();
                taskInfo.setId((Long)taskPkId);
                taskInfo.setIntreason(((OrmLocaleValue)returnDataMap.get("intreason")).getLocaleValue());
                TaskInfoHelper.doUpdate(taskInfo);
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        Object oprtypeHyperlinkDisabled = this.getView().getFormShowParameter().getCustomParam("isHyperlink4Oprtype");
        for (IListColumn iListColumn : columns) {
            String listFieldKey = iListColumn.getListFieldKey();
            if (!"oprpage".equals(listFieldKey)) continue;
            iListColumn.setHyperlink(Boolean.FALSE.booleanValue());
        }
    }

    public boolean isManager() {
        return "hies_taskinfo_mgr".equals(((ListView)this.getView()).getBillFormId());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CurListDataProvider(this.isManager()));
    }

    static class CurListDataProvider
    extends ListDataProvider {
        boolean isManager;

        private CurListDataProvider(boolean isManager) {
            this.isManager = isManager;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            DynamicObjectType dynamicObjectType = rows.getDynamicObjectType();
            dynamicObjectType.registerProperty("progressdesc", String.class, (Object)"", false);
            for (DynamicObject row : rows) {
                DynamicObject dyn;
                String state = (String)row.get("status");
                boolean isTerminated = TaskState.isTerminated(state);
                if (StringUtils.isNotBlank((CharSequence)row.getString("result")) || isTerminated) {
                    row.set("progressdesc", (Object)"100%");
                } else {
                    Date etime;
                    Date startTime;
                    String importType = OprType.isExport(row.getString("oprtype")) ? OprType.EXPORT.getValue() : OprType.IMPORT.getValue();
                    int progressDesc = TaskService.getTaskProcess(String.valueOf(row.getLong("id")), importType);
                    if (progressDesc >= 0) {
                        row.set("progressdesc", (Object)(progressDesc + "%"));
                    } else if (TaskState.isAfoot(state) && (startTime = row.getDate("stime")) != null && ((etime = new Date()).getTime() - startTime.getTime()) / 60000L > 5L) {
                        TaskInfo info = new TaskInfo();
                        info.setId(row.getLong("id"));
                        info.setSchedulestatus(" ");
                        info.setStatus(TaskState.TERMINATED);
                        info.setResult(TaskResult.FAIL);
                        info.setEtime(etime);
                        info.setInttime(etime);
                        TaskInfoHelper.doUpdate(info);
                        LOGGER.info("\u4efb\u52a1\u53d1\u751f\u5f02\u5e38,\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u7ec8\u6b62 pkid:{}", (Object)info.getId());
                    }
                }
                if (!isTerminated && this.isManager) {
                    row.set("intreason", (Object)"");
                }
                String resFullTemplate = ResManager.loadKDString((String)"\u5168\u91cf\u6a21\u677f", (String)HiesCommonRes.TaskInfoListPlugin_15.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
                OrmLocaleValue tplNameOrmLocaleValue = (OrmLocaleValue)row.get("usetpl.name");
                if (!ObjectUtils.isNotEmpty((Object)tplNameOrmLocaleValue)) continue;
                String tplName = tplNameOrmLocaleValue.getLocaleValue();
                boolean isFUllTpl = false;
                if (StringUtils.isBlank((CharSequence)tplName)) {
                    try {
                        isFUllTpl = tplNameOrmLocaleValue.getLocaleValue_zh_CN().startsWith(ResManager.getLocaleString((String)"\u5168\u91cf\u6a21\u677f", (String)HiesCommonRes.TaskInfoListPlugin_15.resId(), (String)"hrmp-hies-common").getLocaleValue_zh_CN());
                    }
                    catch (Exception ex) {
                        for (Map.Entry tplNameOrmLocaleEntry : tplNameOrmLocaleValue.entrySet()) {
                            LOGGER.info("tplName key:{} value:{}", tplNameOrmLocaleEntry.getKey(), tplNameOrmLocaleEntry.getValue());
                        }
                        String gLangStr = tplNameOrmLocaleValue.get((Object)"GLang");
                        if (StringUtils.isNotBlank((CharSequence)gLangStr)) {
                            isFUllTpl = gLangStr.startsWith(ResManager.getLocaleString((String)"\u5168\u91cf\u6a21\u677f", (String)HiesCommonRes.TaskInfoListPlugin_15.resId(), (String)"hrmp-hies-common").getLocaleValue_zh_CN());
                        }
                    }
                } else {
                    isFUllTpl = tplName.startsWith(resFullTemplate);
                }
                if (!isFUllTpl || !ObjectUtils.isNotEmpty((Object)(dyn = TemplateServiceHelper.getTemplateByPkId(row.getLong("usetpl.id")))) || !"full".equals(dyn.getString("source"))) continue;
                row.set("usetpl.name", (Object)resFullTemplate);
            }
            return rows;
        }
    }
}

